/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.impl;

import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.function.EffectAction;
import com.vaadin.flow.signals.function.SignalComputation;
import com.vaadin.flow.signals.function.SignalMapper;
import com.vaadin.flow.signals.function.TransactionTask;
import com.vaadin.flow.signals.impl.Transaction;
import com.vaadin.flow.signals.shared.AbstractSignal;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ComputedSignalTest
extends SignalTestBase {
    @Test
    void value_constantCallback_runOnceAndConstantSignalValue() {
        AtomicInteger count = new AtomicInteger();
        Signal signal = Signal.computed((SignalComputation & Serializable)() -> {
            count.incrementAndGet();
            return null;
        });
        Assertions.assertNull((Object)signal.value());
        Assertions.assertEquals((int)1, (int)count.intValue());
        signal.value();
        Assertions.assertEquals((int)1, (int)count.intValue());
    }

    @Test
    void value_readSignal_runLazily() {
        SharedValueSignal source = new SharedValueSignal((Object)"value");
        ArrayList invocations = new ArrayList();
        Signal signal = Signal.computed((SignalComputation & Serializable)() -> {
            String value = (String)source.value();
            invocations.add(value);
            return value;
        });
        Assertions.assertEquals(List.of(), invocations);
        Assertions.assertEquals((Object)"value", (Object)signal.value());
        Assertions.assertEquals(List.of("value"), invocations);
        source.value((Object)"update");
        Assertions.assertEquals(List.of("value"), invocations);
        Assertions.assertEquals((Object)"update", (Object)signal.value());
        Assertions.assertEquals(List.of("value", "update"), invocations);
    }

    @Test
    void value_noOpChange_notRunAgain() {
        SharedValueSignal source = new SharedValueSignal((Object)"value");
        AtomicInteger count = new AtomicInteger();
        Signal signal = Signal.computed((SignalComputation & Serializable)() -> {
            count.incrementAndGet();
            return (String)source.value();
        });
        signal.value();
        Assertions.assertEquals((int)1, (int)count.intValue());
        source.value((Object)((String)source.value()));
        signal.value();
        Assertions.assertEquals((int)1, (int)count.intValue());
    }

    @Test
    void map_mapComputedSignal_valueIsMapped() {
        SharedValueSignal source = new SharedValueSignal((Object)"value");
        Signal computed = Signal.computed((SignalComputation & Serializable)() -> ((String)source.value()).length());
        Signal doubled = computed.map((SignalMapper & Serializable)l -> l * 2);
        Assertions.assertEquals((int)10, (Integer)((Integer)doubled.value()));
    }

    @Test
    void map_mapMappedSignal_valueIsMapped() {
        SharedValueSignal source = new SharedValueSignal((Object)"value");
        Signal computed = source.map(String::length);
        Signal doubled = computed.map((SignalMapper & Serializable)l -> l * 2);
        Assertions.assertEquals((int)10, (Integer)((Integer)doubled.value()));
    }

    @Test
    void map_countCallbackInvocations_invocationsAreNotCached() {
        SharedValueSignal source = new SharedValueSignal((Object)"value");
        AtomicInteger count = new AtomicInteger();
        Signal computed = source.map((SignalMapper & Serializable)value -> {
            count.incrementAndGet();
            return value.length();
        });
        Assertions.assertEquals((int)0, (int)count.get());
        computed.value();
        Assertions.assertEquals((int)1, (int)count.get());
        computed.value();
        Assertions.assertEquals((int)2, (int)count.get());
    }

    @Test
    void not_booleanInputs_negatedOutputs() {
        SharedValueSignal signal = new SharedValueSignal((Object)Boolean.TRUE);
        Signal negated = Signal.not((Signal)signal);
        Assertions.assertFalse((boolean)((Boolean)negated.value()));
        signal.value((Object)false);
        Assertions.assertTrue((boolean)((Boolean)negated.value()));
        signal.value(null);
        Assertions.assertNull((Object)negated.value());
    }

    @Test
    void callback_updateOtherSignal_signalUpdated() {
        SharedValueSignal other = new SharedValueSignal((Object)"value");
        Signal signal = Signal.computed((SignalComputation & Serializable)() -> {
            other.value((Object)"update");
            return null;
        });
        signal.value();
        Assertions.assertEquals((Object)"update", (Object)other.value());
    }

    @Test
    void effect_changeComputedDependency_effectRunAgain() {
        SharedValueSignal source = new SharedValueSignal((Object)"value");
        AtomicInteger count = new AtomicInteger();
        Signal signal = Signal.computed((SignalComputation & Serializable)() -> {
            count.incrementAndGet();
            return (String)source.value();
        });
        ArrayList invocations = new ArrayList();
        Signal.effect((EffectAction & Serializable)() -> invocations.add((String)signal.value()));
        Assertions.assertEquals((int)1, (int)count.get());
        Assertions.assertEquals(List.of("value"), invocations);
        source.value((Object)"update");
        Assertions.assertEquals((int)2, (int)count.get());
        Assertions.assertEquals(List.of("value", "update"), invocations);
    }

    @Test
    void effect_noOpChangeInComputedDependency_effectNotRunAgainButRemainsActive() {
        SharedValueSignal source = new SharedValueSignal((Object)"value1");
        AtomicInteger count = new AtomicInteger();
        Signal signal = Signal.computed((SignalComputation & Serializable)() -> {
            count.incrementAndGet();
            return ((String)source.value()).length();
        });
        ArrayList invocations = new ArrayList();
        Signal.effect((EffectAction & Serializable)() -> invocations.add((Integer)signal.value()));
        Assertions.assertEquals((int)1, (int)count.get());
        Assertions.assertEquals(List.of(Integer.valueOf(6)), invocations);
        source.value((Object)"value2");
        Assertions.assertEquals((int)2, (int)count.get());
        Assertions.assertEquals(List.of(Integer.valueOf(6)), invocations);
        source.value((Object)"value");
        Assertions.assertEquals((int)3, (int)count.get());
        Assertions.assertEquals(List.of(Integer.valueOf(6), Integer.valueOf(5)), invocations);
    }

    @Test
    void effect_signalUpdatedInTransaction_effectIsUpdated() {
        SharedValueSignal source = new SharedValueSignal((Object)"value");
        AtomicInteger computeCount = new AtomicInteger();
        Signal signal = Signal.computed((SignalComputation & Serializable)() -> {
            computeCount.incrementAndGet();
            return (String)source.value();
        });
        ArrayList invocations = new ArrayList();
        Signal.effect((EffectAction & Serializable)() -> invocations.add((String)signal.value()));
        Signal.runInTransaction((TransactionTask & Serializable)() -> source.value((Object)"update"));
        Assertions.assertEquals((int)2, (int)computeCount.intValue());
        Assertions.assertEquals(List.of("value", "update"), invocations);
    }

    @Test
    void effect_closedEffect_computedGarbageCollected() {
        SharedValueSignal source = new SharedValueSignal((Object)"value");
        Signal signal = Signal.computed((SignalComputation & Serializable)() -> (String)source.value());
        final ArrayList invocations = new ArrayList();
        class CapturingRunnable
        implements EffectAction {
            private final Signal<String> signal;

            CapturingRunnable(Signal<String> signal) {
                this.signal = signal;
            }

            public void execute() {
                invocations.add((String)this.signal.value());
            }
        }
        Signal.effect((EffectAction)new CapturingRunnable(signal)).cleanup();
        Assertions.assertEquals(List.of("value"), invocations);
        WeakReference<Signal> ref = new WeakReference<Signal>(signal);
        signal = null;
        Assertions.assertTrue((boolean)ComputedSignalTest.waitForGarbageCollection(ref));
    }

    @Test
    void transaction_readInCommittedTransaction_notCoumptedAgainAfterTransaction() {
        SharedValueSignal source = new SharedValueSignal((Object)"value");
        AtomicInteger count = new AtomicInteger();
        Signal signal = Signal.computed((SignalComputation & Serializable)() -> {
            count.incrementAndGet();
            return (String)source.value();
        });
        signal.value();
        Assertions.assertEquals((int)1, (int)count.get());
        Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            source.value((Object)"update");
            signal.value();
            Assertions.assertEquals((int)2, (int)count.get());
        });
        signal.value();
        Assertions.assertEquals((int)2, (int)count.get());
    }

    @Test
    void transaction_readInAbortedTransaction_notCoumptedAgainAfterTransaction() {
        SharedValueSignal source = new SharedValueSignal((Object)"value");
        AtomicInteger count = new AtomicInteger();
        Signal signal = Signal.computed((SignalComputation & Serializable)() -> {
            count.incrementAndGet();
            return (String)source.value();
        });
        signal.value();
        Assertions.assertEquals((int)1, (int)count.get());
        Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            source.value((Object)"update");
            signal.value();
            Assertions.assertEquals((int)2, (int)count.get());
            source.verifyValue((Object)"other");
        });
        signal.value();
        Assertions.assertEquals((int)2, (int)count.get());
    }

    @Test
    void unsuppotedOperations_runOperations_throws() {
        AbstractSignal signal = (AbstractSignal)Signal.computed((SignalComputation & Serializable)() -> null);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> signal.peek());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> signal.peekConfirmed());
    }

    @Test
    void lambda_computesValue_computedNotCached() {
        SharedValueSignal signal = new SharedValueSignal((Object)1);
        AtomicInteger count = new AtomicInteger();
        Signal & Serializable doubled = (Signal & Serializable)() -> {
            count.incrementAndGet();
            return (Integer)signal.value() * 2;
        };
        Assertions.assertEquals((int)2, (Integer)((Integer)doubled.value()));
        Assertions.assertEquals((int)1, (int)count.intValue());
        Assertions.assertEquals((int)2, (Integer)((Integer)doubled.value()));
        Assertions.assertEquals((int)2, (int)count.intValue());
        signal.value((Object)3);
        Assertions.assertEquals((int)2, (int)count.intValue());
        Assertions.assertEquals((int)6, (Integer)((Integer)doubled.value()));
        Assertions.assertEquals((int)3, (int)count.intValue());
    }

    @Test
    void exceptionHandling_callbackThrows_rethrowWhenReading() {
        SharedValueSignal shouldThrow = new SharedValueSignal((Object)false);
        AtomicInteger count = new AtomicInteger();
        Signal computed = Signal.computed((SignalComputation & Serializable)() -> {
            count.incrementAndGet();
            if (((Boolean)shouldThrow.value()).booleanValue()) {
                throw new RuntimeException("Expected exception");
            }
            return (Boolean)shouldThrow.value();
        });
        Assertions.assertFalse((boolean)((Boolean)computed.value()));
        Assertions.assertEquals((int)1, (int)count.get());
        shouldThrow.value((Object)true);
        Assertions.assertThrows(RuntimeException.class, () -> computed.value());
        Assertions.assertEquals((int)2, (int)count.get());
        Assertions.assertThrows(RuntimeException.class, () -> computed.value());
        Assertions.assertEquals((int)2, (int)count.get(), (String)"Exception should be cached");
        shouldThrow.value((Object)false);
        Assertions.assertFalse((boolean)((Boolean)computed.value()));
        Assertions.assertEquals((int)3, (int)count.get());
    }

    private static boolean waitForGarbageCollection(WeakReference<?> ref) {
        long deadline = System.nanoTime() + Duration.ofMillis(100L).toNanos();
        while (System.nanoTime() < deadline) {
            System.gc();
            if (ref.get() == null) {
                return true;
            }
            LockSupport.parkNanos(Duration.ofMillis(10L).toNanos());
        }
        return false;
    }
}

