/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals;

import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.Node;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.shared.SharedListSignal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.node.StringNode;

public class SignalCommandTest {
    private final ObjectMapper mapper = new ObjectMapper();
    private Set<Class<?>> assertedTypes = new HashSet();

    @Test
    void json_serializeDeserializeCommands_commandsSerializable() {
        Id id = Id.random();
        SharedListSignal.ListPosition pos = new SharedListSignal.ListPosition(id, id);
        StringNode value = new StringNode("value");
        String key = "key";
        this.assertSerializable((SignalCommand)new SignalCommand.AdoptAsCommand(id, id, id, key));
        this.assertSerializable((SignalCommand)new SignalCommand.AdoptAtCommand(id, id, id, pos));
        this.assertSerializable((SignalCommand)new SignalCommand.ClearCommand(id, id));
        this.assertSerializable((SignalCommand)new SignalCommand.ClearOwnerCommand(id, id));
        this.assertSerializable((SignalCommand)new SignalCommand.IncrementCommand(id, id, 0.0));
        this.assertSerializable((SignalCommand)new SignalCommand.InsertCommand(id, id, id, (JsonNode)value, pos));
        this.assertSerializable((SignalCommand)new SignalCommand.KeyCondition(id, id, key, id));
        this.assertSerializable((SignalCommand)new SignalCommand.LastUpdateCondition(id, id, id));
        this.assertSerializable((SignalCommand)new SignalCommand.PositionCondition(id, id, id, pos));
        this.assertSerializable((SignalCommand)new SignalCommand.PutCommand(id, id, key, (JsonNode)value));
        this.assertSerializable((SignalCommand)new SignalCommand.PutIfAbsentCommand(id, id, id, key, (JsonNode)value));
        this.assertSerializable((SignalCommand)new SignalCommand.RemoveByKeyCommand(id, id, key));
        this.assertSerializable((SignalCommand)new SignalCommand.RemoveCommand(id, id, id));
        this.assertSerializable((SignalCommand)new SignalCommand.SetCommand(id, id, (JsonNode)value));
        this.assertSerializable((SignalCommand)new SignalCommand.SnapshotCommand(id, Map.of(Id.random(), new Node.Data(id, id, id, (JsonNode)value, List.of(), Map.of()), Id.random(), new Node.Alias(id))));
        this.assertSerializable((SignalCommand)new SignalCommand.TransactionCommand(id, List.of()));
        Stream.of(SignalCommand.class.getPermittedSubclasses()).filter(type -> !type.isInterface()).filter(type -> !this.assertedTypes.contains(type)).forEach(type -> Assertions.fail((String)("Should test serialization for " + String.valueOf(type))));
    }

    private void assertSerializable(SignalCommand command) {
        try {
            String json = this.mapper.writeValueAsString((Object)command);
            SignalCommand deserialized = (SignalCommand)this.mapper.readValue(json, SignalCommand.class);
            Assertions.assertEquals((Object)command, (Object)deserialized);
            this.assertedTypes.add(command.getClass());
        }
        catch (JacksonException e) {
            Assertions.fail((Throwable)e);
        }
    }
}

