/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webcomponent;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.component.webcomponent.WebComponent;
import com.vaadin.flow.server.webcomponent.WebComponentGenerator;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.StringContains;
import org.hamcrest.core.StringStartsWith;
import org.junit.Assert;
import org.junit.Test;

public class WebComponentGeneratorTest {
    @Test
    public void generatedReplacementMapContainsExpectedEntriesIncludingUi() {
        this.assertGeneratedReplacementMapContainsExpectedEntries(true);
    }

    @Test
    public void generatedReplacementMapContainsExpectedEntriesExcludingUi() {
        this.assertGeneratedReplacementMapContainsExpectedEntries(false);
    }

    public void assertGeneratedReplacementMapContainsExpectedEntries(boolean generateUi) {
        MyComponentExporter exporter = new MyComponentExporter();
        Map replacementsMap = WebComponentGenerator.getReplacementsMap((String)"my-component", (Set)new WebComponentExporter.WebComponentConfigurationFactory().create((WebComponentExporter)exporter).getPropertyDataSet(), (String)"/foo", (boolean)generateUi, null);
        Assert.assertTrue((String)"Missing dashed tag name", (boolean)replacementsMap.containsKey("TagDash"));
        Assert.assertTrue((String)"Missing camel cased tag name", (boolean)replacementsMap.containsKey("TagCamel"));
        Assert.assertTrue((String)"Missing 'AttributeChange'", (boolean)replacementsMap.containsKey("AttributeChange"));
        Assert.assertTrue((String)"Missing 'PropertyDefaults'", (boolean)replacementsMap.containsKey("PropertyDefaults"));
        Assert.assertTrue((String)"Missing 'PropertyMethods'", (boolean)replacementsMap.containsKey("PropertyMethods"));
        Assert.assertTrue((String)"Missing 'PropertyValues'", (boolean)replacementsMap.containsKey("PropertyValues"));
        Assert.assertTrue((String)"Missing frontend resources path", (boolean)replacementsMap.containsKey("frontend_resources"));
        Assert.assertTrue((String)"Missing ui import", (boolean)replacementsMap.containsKey("ui_import"));
        Assert.assertEquals((Object)"my-component", replacementsMap.get("TagDash"));
        Assert.assertEquals((Object)"MyComponent", replacementsMap.get("TagCamel"));
        Assert.assertEquals((Object)"/foo", replacementsMap.get("frontend_resources"));
        if (generateUi) {
            Assert.assertEquals((Object)"<link rel='import' href='web-component-ui.html'>", replacementsMap.get("ui_import"));
        } else {
            Assert.assertEquals((Object)"", replacementsMap.get("ui_import"));
        }
        String attributeChange = (String)replacementsMap.get("AttributeChange");
        MatcherAssert.assertThat((Object)attributeChange, (Matcher)StringContains.containsString((String)String.format("if (attribute === 'message') {%n  this['message'] = this._deserializeValue(value, String);", new Object[0])));
        MatcherAssert.assertThat((Object)attributeChange, (Matcher)StringContains.containsString((String)String.format("if (attribute === 'integer-value') {%n  this['integer-value'] = this._deserializeValue(value, Number);", new Object[0])));
        MatcherAssert.assertThat((Object)attributeChange, (Matcher)StringContains.containsString((String)String.format("if (attribute === 'camel-case-value') {%n  this['camelCaseValue'] = this._deserializeValue(value, Number);", new Object[0])));
        MatcherAssert.assertThat((Object)attributeChange, (Matcher)StringContains.containsString((String)String.format("if (attribute === 'response') {%n  this['response'] = this._deserializeValue(value, String);", new Object[0])));
        String propertyMethods = (String)replacementsMap.get("PropertyMethods");
        MatcherAssert.assertThat((Object)propertyMethods, (Matcher)StringContains.containsString((String)"get ['message']() {"));
        MatcherAssert.assertThat((Object)propertyMethods, (Matcher)StringContains.containsString((String)"set ['message'](value) {"));
        MatcherAssert.assertThat((Object)propertyMethods, (Matcher)StringContains.containsString((String)"this._sync('message',"));
        MatcherAssert.assertThat((Object)propertyMethods, (Matcher)StringContains.containsString((String)"set ['integer-value'](value) {"));
        MatcherAssert.assertThat((Object)propertyMethods, (Matcher)StringContains.containsString((String)"this._sync('integer-value',"));
        MatcherAssert.assertThat((Object)propertyMethods, (Matcher)StringContains.containsString((String)"set ['response'](value) {"));
        MatcherAssert.assertThat((Object)propertyMethods, (Matcher)StringContains.containsString((String)"this._sync('response',"));
        String propertyValues = (String)replacementsMap.get("PropertyValues");
        MatcherAssert.assertThat((Object)propertyValues, (Matcher)StringContains.containsString((String)"'message': this['message']"));
        MatcherAssert.assertThat((Object)propertyValues, (Matcher)StringContains.containsString((String)"'integer-value': this['integer-value']"));
        MatcherAssert.assertThat((Object)propertyValues, (Matcher)StringContains.containsString((String)"'response': this['response']"));
        String propertyDefaults = (String)replacementsMap.get("PropertyDefaults");
        MatcherAssert.assertThat((Object)propertyDefaults, (Matcher)StringContains.containsString((String)"this['_message'] = ''"));
        MatcherAssert.assertThat((Object)propertyDefaults, (Matcher)StringContains.containsString((String)"this['_integer-value'] = 0"));
        MatcherAssert.assertThat((Object)propertyDefaults, (Matcher)StringContains.containsString((String)"this['_response'] = 'hello'"));
    }

    @Test
    public void providesJSModulesInNpmMode() {
        String module = WebComponentGenerator.generateModule((WebComponentExporterFactory)new WebComponentExporterFactory.DefaultWebComponentExporterFactory(MyComponentExporter.class), (String)"", null);
        module = module.replace("\r", "");
        MatcherAssert.assertThat((Object)module, (Matcher)StringStartsWith.startsWith((String)"import {applyCss} from 'Frontend/generated/css.generated.js';\n\nclass Tag extends HTMLElement {"));
        MatcherAssert.assertThat((Object)module, (Matcher)StringContains.containsString((String)"style.innerHTML = `\n      :host {\n        position: relative;\n        display: inline-block;\n      }\n    `;\n"));
        MatcherAssert.assertThat((Object)module, (Matcher)StringContains.containsString((String)"customElements.define('tag', Tag);\n"));
    }

    @Test
    public void providedJSModuleContainsCorrectThemeReplacements() {
        String module = WebComponentGenerator.generateModule((WebComponentExporterFactory)new WebComponentExporterFactory.DefaultWebComponentExporterFactory(MyComponentExporter.class), (String)"", (String)"my-theme");
        module = module.replace("\r", "");
        MatcherAssert.assertThat((Object)module, (Matcher)StringStartsWith.startsWith((String)"import {applyTheme} from 'Frontend/generated/theme.js';\n\nclass Tag extends HTMLElement {"));
        MatcherAssert.assertThat((Object)module, (Matcher)StringContains.containsString((String)"style.innerHTML = `\n      :host {\n        position: relative;\n        display: inline-block;\n      }\n    `;\n"));
        MatcherAssert.assertThat((Object)module, (Matcher)StringContains.containsString((String)"applyTheme(shadow);\n    shadow.appendChild(style);"));
        MatcherAssert.assertThat((Object)module, (Matcher)StringContains.containsString((String)"customElements.define('tag', Tag);\n"));
    }

    public static class MyComponentExporter
    extends WebComponentExporter<MyComponent> {
        public MyComponentExporter() {
            super("tag");
            this.addProperty("response", "hello").onChange(MyComponent::setMessage);
            this.addProperty("integer-value", 0).onChange(MyComponent::setIntegerValue);
            this.addProperty("message", "").onChange(MyComponent::setMessage);
            this.addProperty("camelCaseValue", 0);
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    public static class MyComponent
    extends Component {
        private String response;
        private int integerValue;
        private String message;

        public void setResponse(String response) {
            this.response = response;
        }

        public void setIntegerValue(int integerValue) {
            this.integerValue = integerValue;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

