/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.menu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.di.DefaultInstantiator;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.Menu;
import com.vaadin.flow.router.OptionalParameter;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.server.MockServletContext;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.menu.MenuConfiguration;
import com.vaadin.flow.server.menu.MenuEntry;
import com.vaadin.flow.server.menu.MenuRegistryTest;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.jcip.annotations.NotThreadSafe;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@NotThreadSafe
public class MenuConfigurationTest {
    @Rule
    public TemporaryFolder tmpDir = new TemporaryFolder();
    private ApplicationRouteRegistry registry;
    @Mock
    private MenuRegistryTest.MockService vaadinService;
    private VaadinSession session;
    private ServletContext servletContext;
    private VaadinServletContext vaadinContext;
    @Mock
    private DeploymentConfiguration deploymentConfiguration;
    @Mock
    private VaadinRequest request;
    private AutoCloseable closeable;
    public static String testPageHeaderClientRouteFile = "[\n  {\n    \"route\": \"\",\n    \"params\": {},\n    \"title\": \"Layout\",\n    \"children\": [\n      {\n        \"route\": \"\",\n        \"params\": {},\n        \"title\": \"Public\"\n      },\n      {\n        \"route\": \"about\",\n        \"menu\": { \"exclude\": true },\n        \"title\": \"About\"\n      },\n      {\n        \"route\": \"other\",\n        \"menu\": { \"title\": \"Other\" },\n        \"title\": \"Other\"\n      },\n      {\n        \"route\": \"hilla\",\n        \"title\": \"Hilla\",\n        \"flowLayout\": false\n      }\n    ]\n  },\n  {\n    \"route\": \"flow\",\n    \"params\": {},\n    \"children\": [\n      {\n        \"route\": \"hello\",\n        \"menu\": {\n          \"title\": \"Hello For Flow Layout\"\n        },\n        \"title\": \"Hello\"\n      }\n    ]\n  }\n]\n";

    @Before
    public void init() {
        this.closeable = MockitoAnnotations.openMocks((Object)this);
        this.servletContext = new MockServletContext();
        this.vaadinContext = new MockVaadinContext(this.servletContext);
        this.registry = ApplicationRouteRegistry.getInstance((VaadinContext)this.vaadinContext);
        Mockito.when((Object)this.vaadinService.getRouteRegistry()).thenReturn((Object)this.registry);
        Mockito.when((Object)this.vaadinService.getContext()).thenReturn((Object)this.vaadinContext);
        Mockito.when((Object)this.vaadinService.getInstantiator()).thenReturn((Object)new DefaultInstantiator((VaadinService)this.vaadinService));
        Mockito.when((Object)this.vaadinService.getDeploymentConfiguration()).thenReturn((Object)this.deploymentConfiguration);
        Mockito.when((Object)this.deploymentConfiguration.getFrontendFolder()).thenReturn((Object)this.tmpDir.getRoot());
        Mockito.when((Object)this.deploymentConfiguration.getProjectFolder()).thenReturn((Object)this.tmpDir.getRoot());
        Mockito.when((Object)this.deploymentConfiguration.getBuildFolder()).thenReturn((Object)"build");
        VaadinService.setCurrent((VaadinService)this.vaadinService);
        this.session = new MockVaadinSession((VaadinService)this.vaadinService){

            public VaadinService getService() {
                return MenuConfigurationTest.this.vaadinService;
            }
        };
        VaadinSession.setCurrent((VaadinSession)this.session);
        Mockito.when((Object)this.request.getService()).thenReturn((Object)this.vaadinService);
        CurrentInstance.set(VaadinRequest.class, (Object)this.request);
    }

    @After
    public void cleanup() throws Exception {
        this.closeable.close();
        CurrentInstance.clearAll();
    }

    @Test
    public void testWithLoggedInUser_userHasRoles() throws IOException {
        Mockito.when((Object)this.request.getUserPrincipal()).thenReturn((Object)((Principal)Mockito.mock(Principal.class)));
        Mockito.when((Object)this.request.isUserInRole(Mockito.anyString())).thenReturn((Object)true);
        File generated = this.tmpDir.newFolder("generated/");
        File clientFiles = new File(generated, "file-routes.json");
        Files.writeString(clientFiles.toPath(), (CharSequence)MenuRegistryTest.testClientRouteFile, new OpenOption[0]);
        List menuEntries = MenuConfiguration.getMenuEntries();
        Assert.assertEquals((String)"List of menu items has incorrect size. Excluded menu item like /login is not expected.", (long)7L, (long)menuEntries.size());
        this.assertOrder(menuEntries, new String[]{"/", "/about", "/hilla", "/hilla/sub", "/opt_params", "/params_with_opt_children", "/wc_params"});
    }

    @Test
    public void getMenuItemsList_returnsCorrectPaths() throws IOException {
        File generated = this.tmpDir.newFolder("generated/");
        File clientFiles = new File(generated, "file-routes.json");
        Files.writeString(clientFiles.toPath(), (CharSequence)MenuRegistryTest.testClientRouteFile, new OpenOption[0]);
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.registry);
        Arrays.asList(MenuRegistryTest.MyRoute.class, MenuRegistryTest.MyInfo.class, MenuRegistryTest.MyRequiredParamRoute.class, MenuRegistryTest.MyRequiredAndOptionalParamRoute.class, MenuRegistryTest.MyOptionalParamRoute.class, MenuRegistryTest.MyVarargsParamRoute.class).forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        List menuEntries = MenuConfiguration.getMenuEntries();
        Assert.assertEquals((long)8L, (long)menuEntries.size());
        this.assertOrder(menuEntries, new String[]{"/", "/home", "/info", "/opt_params", "/param", "/param/varargs", "/params_with_opt_children", "/wc_params"});
        Map<String, MenuEntry> mapMenuItems = menuEntries.stream().collect(Collectors.toMap(MenuEntry::path, item -> item));
        this.assertClientRoutes(mapMenuItems, false, false);
        this.assertServerRoutes(mapMenuItems);
        this.assertServerRoutesWithParameters(mapMenuItems, true);
    }

    @Test
    public void getMenuItemsList_assertOrder() {
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.registry);
        Arrays.asList(MenuRegistryTest.TestRouteA.class, MenuRegistryTest.TestRouteB.class, MenuRegistryTest.TestRouteC.class, MenuRegistryTest.TestRouteD.class, MenuRegistryTest.TestRouteDA.class, MenuRegistryTest.TestRouteDB.class).forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        List menuEntries = MenuConfiguration.getMenuEntries();
        Assert.assertEquals((long)4L, (long)menuEntries.size());
        this.assertOrder(menuEntries, new String[]{"/d", "/c", "/a", "/b", "/d/a", "/d/b"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getPageHeader_serverSideRoutes_withContentComponent_pageHeadersFromAnnotationAndName() {
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.registry);
        Arrays.asList(NormalRoute.class, NormalRouteWithPageTitle.class, MandatoryParameterRouteWithPageTitle.class).forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        UI mockUi = (UI)Mockito.mock(UI.class);
        UIInternals uiInternals = (UIInternals)Mockito.mock(UIInternals.class);
        Location location = (Location)Mockito.mock(Location.class);
        Mockito.when((Object)mockUi.getInternals()).thenReturn((Object)uiInternals);
        Mockito.when((Object)uiInternals.getActiveViewLocation()).thenReturn((Object)location);
        Mockito.when((Object)uiInternals.getActiveRouterTargetsChain()).thenReturn(Collections.emptyList());
        UI currentUi = UI.getCurrent();
        try {
            UI.setCurrent((UI)mockUi);
            Mockito.when((Object)location.getPath()).thenReturn((Object)"/normal-route");
            Optional header = MenuConfiguration.getPageHeader((Component)new NormalRoute());
            Assert.assertTrue((boolean)header.isPresent());
            Assert.assertEquals((Object)"NormalRoute", header.get());
            Mockito.when((Object)location.getPath()).thenReturn((Object)"normal-route-with-page-title");
            header = MenuConfiguration.getPageHeader((Component)new NormalRouteWithPageTitle());
            Assert.assertTrue((boolean)header.isPresent());
            Assert.assertEquals((Object)"My Normal Route", header.get());
            Mockito.when((Object)uiInternals.getActiveRouterTargetsChain()).thenReturn(List.of(new RouteOrLayoutWithDynamicTitle()));
            header = MenuConfiguration.getPageHeader((Component)new NormalRoute());
            Assert.assertTrue((boolean)header.isPresent());
            Assert.assertEquals((Object)"My Route with dynamic title", header.get());
            Mockito.when((Object)uiInternals.getActiveRouterTargetsChain()).thenReturn(Collections.emptyList());
            Mockito.when((Object)location.getPath()).thenReturn((Object)"mandatory-parameter-route");
            header = MenuConfiguration.getPageHeader((Component)new MandatoryParameterRouteWithPageTitle());
            Assert.assertTrue((boolean)header.isPresent());
            Assert.assertEquals((Object)"MandatoryParameterRouteWithPageTitle", header.get());
        }
        finally {
            UI.setCurrent((UI)currentUi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getPageHeader_serverSideRoutes_noContentComponent_pageHeadersOnlyForMenuEntries() {
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.registry);
        Arrays.asList(NormalRoute.class, NormalRouteWithPageTitle.class, OptionalParameterRouteWithPageTitle.class, MandatoryParameterRouteWithPageTitle.class).forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        UI mockUi = (UI)Mockito.mock(UI.class);
        UIInternals uiInternals = (UIInternals)Mockito.mock(UIInternals.class);
        Location location = (Location)Mockito.mock(Location.class);
        Mockito.when((Object)mockUi.getInternals()).thenReturn((Object)uiInternals);
        Mockito.when((Object)uiInternals.getActiveViewLocation()).thenReturn((Object)location);
        UI currentUi = UI.getCurrent();
        try {
            UI.setCurrent((UI)mockUi);
            Mockito.when((Object)location.getPath()).thenReturn((Object)"/normal-route");
            Optional header = MenuConfiguration.getPageHeader();
            Assert.assertTrue((boolean)header.isPresent());
            Assert.assertEquals((Object)"NormalRoute", header.get());
            Mockito.when((Object)location.getPath()).thenReturn((Object)"normal-route-with-page-title");
            header = MenuConfiguration.getPageHeader();
            Assert.assertFalse((boolean)header.isPresent());
            Mockito.when((Object)location.getPath()).thenReturn((Object)"mandatory-parameter-route");
            header = MenuConfiguration.getPageHeader();
            Assert.assertFalse((boolean)header.isPresent());
            Mockito.when((Object)location.getPath()).thenReturn((Object)"optional-parameter-route");
            header = MenuConfiguration.getPageHeader();
            Assert.assertTrue((boolean)header.isPresent());
            Assert.assertEquals((Object)"OptionalParameterRouteWithPageTitle", header.get());
        }
        finally {
            UI.setCurrent((UI)currentUi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetPageHeader_clientViews_pageHeaderFromTitle() throws IOException {
        Mockito.when((Object)this.request.getUserPrincipal()).thenReturn((Object)((Principal)Mockito.mock(Principal.class)));
        Mockito.when((Object)this.request.isUserInRole(Mockito.anyString())).thenReturn((Object)true);
        File generated = this.tmpDir.newFolder("generated/");
        File clientFiles = new File(generated, "file-routes.json");
        Files.writeString(clientFiles.toPath(), (CharSequence)testPageHeaderClientRouteFile, new OpenOption[0]);
        UI mockUi = (UI)Mockito.mock(UI.class);
        UIInternals uiInternals = (UIInternals)Mockito.mock(UIInternals.class);
        Location location = (Location)Mockito.mock(Location.class);
        Mockito.when((Object)mockUi.getInternals()).thenReturn((Object)uiInternals);
        Mockito.when((Object)uiInternals.getActiveViewLocation()).thenReturn((Object)location);
        UI currentUi = UI.getCurrent();
        try {
            UI.setCurrent((UI)mockUi);
            Mockito.when((Object)location.getPath()).thenReturn((Object)"/");
            Optional header = MenuConfiguration.getPageHeader();
            Assert.assertTrue((boolean)header.isPresent());
            Assert.assertEquals((Object)"Public", header.get());
            Mockito.when((Object)location.getPath()).thenReturn((Object)"/about");
            header = MenuConfiguration.getPageHeader();
            Assert.assertTrue((boolean)header.isPresent());
            Assert.assertEquals((Object)"About", header.get());
            Mockito.when((Object)location.getPath()).thenReturn((Object)"/other");
            header = MenuConfiguration.getPageHeader();
            Assert.assertTrue((boolean)header.isPresent());
            Assert.assertEquals((Object)"Other", header.get());
            Mockito.when((Object)location.getPath()).thenReturn((Object)"/hilla");
            header = MenuConfiguration.getPageHeader();
            Assert.assertTrue((boolean)header.isPresent());
            Assert.assertEquals((Object)"Hilla", header.get());
            Mockito.when((Object)location.getPath()).thenReturn((Object)"/flow/hello");
            header = MenuConfiguration.getPageHeader();
            Assert.assertTrue((boolean)header.isPresent());
            Assert.assertEquals((Object)"Hello", header.get());
            Mockito.when((Object)uiInternals.getActiveRouterTargetsChain()).thenReturn(List.of(new RouteOrLayoutWithDynamicTitle()));
            header = MenuConfiguration.getPageHeader();
            Assert.assertTrue((boolean)header.isPresent());
            Assert.assertEquals((Object)"My Route with dynamic title", header.get());
            Mockito.when((Object)uiInternals.getActiveRouterTargetsChain()).thenReturn(Collections.emptyList());
        }
        finally {
            UI.setCurrent((UI)currentUi);
        }
    }

    private void assertOrder(List<MenuEntry> menuEntries, String[] expectedOrder) {
        for (int i = 0; i < menuEntries.size(); ++i) {
            Assert.assertEquals((Object)expectedOrder[i], (Object)menuEntries.get(i).path());
        }
    }

    private void assertClientRoutes(Map<String, MenuEntry> menuOptions, boolean authenticated, boolean hasRole) {
        Assert.assertTrue((String)"Client route '' missing", (boolean)menuOptions.containsKey("/"));
        Assert.assertEquals((Object)"Public", (Object)menuOptions.get("/").title());
        if (authenticated) {
            Assert.assertTrue((String)"Client route 'about' missing", (boolean)menuOptions.containsKey("/about"));
            Assert.assertEquals((Object)"About", (Object)menuOptions.get("/about").title());
            if (hasRole) {
                Assert.assertTrue((String)"Client route 'hilla' missing", (boolean)menuOptions.containsKey("/hilla"));
                Assert.assertEquals((Object)"Hilla", (Object)menuOptions.get("/hilla").title());
                Assert.assertTrue((String)"Client child route 'hilla/sub' missing", (boolean)menuOptions.containsKey("/hilla/sub"));
                Assert.assertEquals((Object)"Hilla Sub", (Object)menuOptions.get("/hilla/sub").title());
            } else {
                Assert.assertFalse((String)"Roles do not match no hilla should be available", (boolean)menuOptions.containsKey("/hilla"));
            }
        } else {
            Assert.assertFalse((String)"Not authenticated about view should not be available", (boolean)menuOptions.containsKey("/about"));
            Assert.assertFalse((String)"Not authenticated hilla view should not be available", (boolean)menuOptions.containsKey("/hilla"));
        }
        Assert.assertFalse((String)"Client route 'login' should be excluded", (boolean)menuOptions.containsKey("/login"));
    }

    private void assertServerRoutes(Map<String, MenuEntry> menuItems) {
        Assert.assertTrue((String)"Server route 'home' missing", (boolean)menuItems.containsKey("/home"));
        Assert.assertEquals((Object)"Home", (Object)menuItems.get("/home").title());
        Assert.assertEquals(MenuRegistryTest.MyRoute.class, (Object)menuItems.get("/home").menuClass());
        Assert.assertTrue((String)"Server route 'info' missing", (boolean)menuItems.containsKey("/info"));
        Assert.assertEquals((Object)"MyInfo", (Object)menuItems.get("/info").title());
        Assert.assertEquals(MenuRegistryTest.MyInfo.class, (Object)menuItems.get("/info").menuClass());
    }

    private void assertServerRoutesWithParameters(Map<String, MenuEntry> menuItems, boolean excludeExpected) {
        if (excludeExpected) {
            Assert.assertFalse((String)"Server route '/param/:param' should be excluded", (boolean)menuItems.containsKey("/param/:param"));
            Assert.assertFalse((String)"Server route '/param/:param1' should be excluded", (boolean)menuItems.containsKey("/param/:param1"));
        }
        Assert.assertTrue((String)"Server route with optional parameters '/param' missing", (boolean)menuItems.containsKey("/param"));
        Assert.assertTrue((String)"Server route with optional parameters '/param/varargs' missing", (boolean)menuItems.containsKey("/param/varargs"));
    }

    @Tag(value="some-tag")
    @Route(value="normal-route")
    @Menu(title="Normal Route")
    public static class NormalRoute
    extends Component {
    }

    @Tag(value="some-tag")
    @PageTitle(value="My Normal Route")
    @Route(value="normal-route-with-page-title")
    public static class NormalRouteWithPageTitle
    extends Component {
    }

    @Tag(value="some-tag")
    @Route(value="mandatory-parameter-route")
    @Menu(title="Mandatory Param route")
    public static class MandatoryParameterRouteWithPageTitle
    extends Component
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    public static class RouteOrLayoutWithDynamicTitle
    implements HasDynamicTitle,
    HasElement {
        public String getPageTitle() {
            return "My Route with dynamic title";
        }

        public Element getElement() {
            return null;
        }
    }

    @Tag(value="some-tag")
    @Route(value="optional-parameter-route")
    @Menu(title="Optional Param route")
    public static class OptionalParameterRouteWithPageTitle
    extends Component
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, @OptionalParameter String parameter) {
        }
    }
}

