/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.HeartbeatHandler;
import java.io.IOException;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HeartbeatHandlerTest {
    @Test
    public void synchronizedHandleRequest_uiPresent_setLastHeartbeatTimestampIsCalledOnce() throws IOException {
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        VaadinResponse response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        UI ui = (UI)Mockito.mock(UI.class);
        UIInternals uiInternals = (UIInternals)Mockito.mock(UIInternals.class);
        Mockito.when((Object)ui.getInternals()).thenReturn((Object)uiInternals);
        Mockito.when((Object)session.getService()).thenReturn((Object)service);
        Mockito.when((Object)service.findUI(request)).thenReturn((Object)ui);
        HeartbeatHandler handler = new HeartbeatHandler();
        handler.synchronizedHandleRequest(session, request, response);
        ((UIInternals)Mockito.verify((Object)ui.getInternals(), (VerificationMode)Mockito.times((int)1))).setLastHeartbeatTimestamp(ArgumentMatchers.anyLong());
    }

    @Test
    public void synchronizedHandleRequest_uiPresent_noCacheHeaderSetAndContentTypeNotSet() throws IOException {
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        VaadinResponse response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        UI ui = (UI)Mockito.mock(UI.class);
        UIInternals uiInternals = (UIInternals)Mockito.mock(UIInternals.class);
        Mockito.when((Object)ui.getInternals()).thenReturn((Object)uiInternals);
        Mockito.when((Object)session.getService()).thenReturn((Object)service);
        Mockito.when((Object)service.findUI(request)).thenReturn((Object)ui);
        HeartbeatHandler handler = new HeartbeatHandler();
        handler.synchronizedHandleRequest(session, request, response);
        ((VaadinResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setHeader((String)ArgumentMatchers.eq((Object)"Cache-Control"), (String)ArgumentMatchers.eq((Object)"no-cache"));
        ((VaadinResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.never())).setHeader((String)ArgumentMatchers.eq((Object)"Content-Type"), Mockito.anyString());
    }
}

