/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.signals.WritableSignal;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class VaadinSessionLocaleSignalTest
extends SignalsUnitTest {
    private VaadinSession getSession() {
        return UI.getCurrent().getSession();
    }

    @Test
    public void localeSignal_initialValue_matchesGetLocale() {
        VaadinSession session = this.getSession();
        WritableSignal signal = session.localeSignal();
        Assert.assertNotNull((String)"localeSignal() should never return null", (Object)signal);
        Assert.assertEquals((String)"Signal value should match getLocale()", (Object)session.getLocale(), (Object)signal.value());
    }

    @Test
    public void localeSignal_setLocale_signalUpdated() {
        Locale newLocale;
        VaadinSession session = this.getSession();
        WritableSignal signal = session.localeSignal();
        Locale initialLocale = session.getLocale();
        if (initialLocale.equals(newLocale = Locale.FRENCH)) {
            newLocale = Locale.GERMAN;
        }
        session.setLocale(newLocale);
        Assert.assertEquals((String)"Signal should reflect the new locale after setLocale()", (Object)newLocale, (Object)signal.value());
        Assert.assertEquals((String)"getLocale() should also return the new locale", (Object)newLocale, (Object)session.getLocale());
    }

    @Test
    public void localeSignal_writeToSignal_updatesGetLocale() {
        Locale newLocale;
        VaadinSession session = this.getSession();
        WritableSignal signal = session.localeSignal();
        Locale initialLocale = session.getLocale();
        if (initialLocale.equals(newLocale = Locale.FRENCH)) {
            newLocale = Locale.GERMAN;
        }
        signal.value((Object)newLocale);
        Assert.assertEquals((String)"getLocale() should reflect the new locale after writing to signal", (Object)newLocale, (Object)session.getLocale());
        Assert.assertEquals((String)"Signal should have the new value", (Object)newLocale, (Object)signal.value());
    }

    @Test
    public void localeSignal_sameInstance_returnedOnMultipleCalls() {
        VaadinSession session = this.getSession();
        WritableSignal signal1 = session.localeSignal();
        WritableSignal signal2 = session.localeSignal();
        Assert.assertSame((String)"localeSignal() should return the same instance on multiple calls", (Object)signal1, (Object)signal2);
    }

    @Test
    public void localeSignal_multipleLocaleChanges_signalFollows() {
        VaadinSession session = this.getSession();
        WritableSignal signal = session.localeSignal();
        session.setLocale(Locale.FRENCH);
        Assert.assertEquals((Object)Locale.FRENCH, (Object)signal.value());
        session.setLocale(Locale.GERMAN);
        Assert.assertEquals((Object)Locale.GERMAN, (Object)signal.value());
        session.setLocale(Locale.JAPANESE);
        Assert.assertEquals((Object)Locale.JAPANESE, (Object)signal.value());
    }

    @Test
    public void localeSignal_multipleSignalWrites_getLocaleFollows() {
        VaadinSession session = this.getSession();
        WritableSignal signal = session.localeSignal();
        signal.value((Object)Locale.FRENCH);
        Assert.assertEquals((Object)Locale.FRENCH, (Object)session.getLocale());
        signal.value((Object)Locale.GERMAN);
        Assert.assertEquals((Object)Locale.GERMAN, (Object)session.getLocale());
        signal.value((Object)Locale.JAPANESE);
        Assert.assertEquals((Object)Locale.JAPANESE, (Object)session.getLocale());
    }
}

