/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.CustomizedSystemMessages;
import org.junit.Assert;
import org.junit.Test;

public class SystemMessagesTest {
    @Test
    public void syncError_defaultValues() {
        CustomizedSystemMessages messages = new CustomizedSystemMessages();
        Assert.assertNull((String)"Default URL should be null", (Object)messages.getSyncErrorURL());
        Assert.assertTrue((String)"Default notification should be enabled", (boolean)messages.isSyncErrorNotificationEnabled());
        Assert.assertEquals((String)"Default caption should match", (Object)"Synchronization Error", (Object)messages.getSyncErrorCaption());
        Assert.assertEquals((String)"Default message should match", (Object)"Your session needs to be refreshed. Click here or press ESC to reload and restore your last saved state.", (Object)messages.getSyncErrorMessage());
    }

    @Test
    public void syncError_notificationEnabled_returnsCaptionAndMessage() {
        CustomizedSystemMessages messages = new CustomizedSystemMessages();
        Assert.assertTrue((boolean)messages.isSyncErrorNotificationEnabled());
        Assert.assertNotNull((Object)messages.getSyncErrorCaption());
        Assert.assertNotNull((Object)messages.getSyncErrorMessage());
    }

    @Test
    public void customizedSyncError_notificationDisabled_returnsNullCaptionAndMessage() {
        CustomizedSystemMessages messages = new CustomizedSystemMessages();
        messages.setSyncErrorNotificationEnabled(false);
        messages.setSyncErrorCaption("Custom Caption");
        messages.setSyncErrorMessage("Custom message text");
        Assert.assertFalse((String)"Notification should be disabled", (boolean)messages.isSyncErrorNotificationEnabled());
        Assert.assertNull((String)"Caption should be null when notification is disabled", (Object)messages.getSyncErrorCaption());
        Assert.assertNull((String)"Message should be null when notification is disabled", (Object)messages.getSyncErrorMessage());
    }

    @Test
    public void customizedSyncError_urlNotAffectedByNotificationEnabled() {
        CustomizedSystemMessages messages = new CustomizedSystemMessages();
        messages.setSyncErrorURL("/redirect-url");
        messages.setSyncErrorNotificationEnabled(false);
        Assert.assertEquals((Object)"/redirect-url", (Object)messages.getSyncErrorURL());
    }
}

