/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.ReflectTools;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ReflectToolsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testCreateInstance() {
        OkToCreate instance = (OkToCreate)ReflectTools.createInstance(OkToCreate.class);
        Assert.assertNotNull((Object)instance);
        Assert.assertSame((String)"Created instance should be of the requested type", OkToCreate.class, instance.getClass());
    }

    @Test
    public void testCreateInstance_varArgsCtor() {
        VarArgsCtor instance = (VarArgsCtor)ReflectTools.createInstance(VarArgsCtor.class);
        Assert.assertNotNull((Object)instance);
        Assert.assertSame((String)"Created instance should be of the requested type", VarArgsCtor.class, instance.getClass());
    }

    @Test
    public void createNonStaticInnerClass() {
        this.assertError("Cannot instantiate '%s'. Make sure the class is static if it is an inner class.", NonStaticInnerClass.class);
    }

    @Test
    public void createPrivateInnerClass() {
        this.assertError("Cannot instantiate '%s'. Make sure the class is static if it is an inner class.", PrivateInnerClass.class);
    }

    @Test
    public void createStaticInnerPrivateConstructorClass() {
        this.assertError("Unable to create an instance of '%s'. Make sure the class has a public no-arg constructor.", StaticInnerPrivateConstructorClass.class);
    }

    @Test
    public void createStaticInnerConstructorNeedsParamsClass() {
        this.assertError("Unable to create an instance of '%s'. Make sure the class has a public no-arg constructor.", StaticInnerConstructorNeedsParamsClass.class);
    }

    @Test
    public void createConstructorThrowsExceptionClass() {
        this.assertError("Unable to create an instance of '%s'. The constructor threw an exception.", ConstructorThrowsExceptionClass.class);
    }

    @Test
    public void localClass() {
        class LocalClass {
            LocalClass(ReflectToolsTest this$0) {
            }
        }
        this.assertError("Cannot instantiate local class '%s'. Move class declaration outside the method.", LocalClass.class);
    }

    @Test
    public void createProxyForNonStaticInnerClass() {
        Class<NonStaticInnerClass> originalClass = NonStaticInnerClass.class;
        Class<?> proxyClass = this.createProxyClass(originalClass);
        this.assertError("Unable to create an instance of '%s'. Make sure the class has a public no-arg constructor.", proxyClass);
        try {
            ReflectTools.createProxyInstance(proxyClass, originalClass);
            Assert.fail((String)"Creation should cause an exception");
        }
        catch (IllegalArgumentException re) {
            Assert.assertEquals((Object)String.format("Cannot instantiate '%s'. Make sure the class is static if it is an inner class.", originalClass.getName()), (Object)re.getMessage());
        }
    }

    @Test
    public void getGenericInterfaceClass() {
        Class genericInterfaceType = ReflectTools.getGenericInterfaceType(HasInterface.class, TestInterface.class);
        Assert.assertEquals(String.class, (Object)genericInterfaceType);
        genericInterfaceType = ReflectTools.getGenericInterfaceType(ChildInterface.class, TestInterface.class);
        Assert.assertEquals(Boolean.class, (Object)genericInterfaceType);
    }

    @Test
    public void getGenericInterfaceClasses() {
        List genericInterfaceTypes = ReflectTools.getGenericInterfaceTypes(HasInterface.class, TestInterface.class);
        Assert.assertArrayEquals((Object[])new Class[]{String.class}, (Object[])genericInterfaceTypes.toArray());
        genericInterfaceTypes = ReflectTools.getGenericInterfaceTypes(ChildInterface.class, TestInterface.class);
        Assert.assertArrayEquals((Object[])new Class[]{Boolean.class}, (Object[])genericInterfaceTypes.toArray());
        genericInterfaceTypes = ReflectTools.getGenericInterfaceTypes(HasInterfaceMulti.class, TestInterfaceMulti.class);
        Assert.assertArrayEquals((Object[])new Class[]{String.class, Integer.class, Double.class}, (Object[])genericInterfaceTypes.toArray());
        genericInterfaceTypes = ReflectTools.getGenericInterfaceTypes(ChildInterfaceMulti.class, TestInterfaceMulti.class);
        Assert.assertArrayEquals((Object[])new Class[]{Boolean.class, Float.class, Long.class}, (Object[])genericInterfaceTypes.toArray());
        genericInterfaceTypes = ReflectTools.getGenericInterfaceTypes(ChildInterfacePartial.class, TestInterfaceMulti.class);
        Assert.assertArrayEquals((Object[])new Class[]{Boolean.class, Short.class, Long.class}, (Object[])genericInterfaceTypes.toArray());
    }

    @Test
    public void findCommonBaseType_sameType() {
        Assert.assertSame(Number.class, (Object)ReflectTools.findCommonBaseType(Number.class, Number.class));
    }

    @Test
    public void findCommonBaseType_aExtendsB() {
        Assert.assertSame(Number.class, (Object)ReflectTools.findCommonBaseType(Integer.class, Number.class));
    }

    @Test
    public void findCommonBaseType_bExtendsA() {
        Assert.assertSame(Number.class, (Object)ReflectTools.findCommonBaseType(Number.class, Integer.class));
    }

    @Test
    public void findCommonBaseType_commonBase() {
        Assert.assertSame(Number.class, (Object)ReflectTools.findCommonBaseType(Double.class, Integer.class));
    }

    @Test
    public void findCommonBaseType_noCommonBase() {
        Assert.assertSame(Object.class, (Object)ReflectTools.findCommonBaseType(String.class, Number.class));
    }

    @Test
    public void findCommonBaseType_interfaceNotSupported() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("a cannot be an interface");
        ReflectTools.findCommonBaseType(Comparable.class, Object.class);
    }

    @Test
    public void findCommonBaseType_primitiveNotSupported() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("a cannot be a primitive type");
        ReflectTools.findCommonBaseType(Integer.TYPE, Object.class);
    }

    @Test
    public void getSetters_classIsGeneric_syntheticMethodsAreFilteredOut() {
        List setters = ReflectTools.getSetterMethods(Category.class).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)setters.size());
        Method setter = (Method)setters.get(0);
        Assert.assertEquals((Object)"setId", (Object)setter.getName());
        Assert.assertEquals(Long.class, setter.getParameterTypes()[0]);
    }

    @Test
    public void findClosestCommonClassLoaderAncestor_findAncestor_whenBothArgumentsAreTheSame() {
        CustomClassLoader loader = new CustomClassLoader();
        ClassLoader ret = (ClassLoader)ReflectTools.findClosestCommonClassLoaderAncestor((ClassLoader)loader, (ClassLoader)loader).get();
        Assert.assertEquals((Object)loader, (Object)ret);
    }

    public void findClosestCommonClassLoaderAncestor_null_whenNoSharedAncestor() {
        CustomClassLoader loader1 = new CustomClassLoader();
        CustomClassLoader loader2 = new CustomClassLoader();
        Optional ret = ReflectTools.findClosestCommonClassLoaderAncestor((ClassLoader)loader1, (ClassLoader)loader2);
        Assert.assertFalse((boolean)ret.isPresent());
    }

    @Test
    public void findClosestCommonClassLoaderAncestor_findsAncestor_whenOneIsParentOfTheOther() {
        CustomClassLoader parent = new CustomClassLoader();
        CustomClassLoader child = new CustomClassLoader(parent);
        ClassLoader ret = (ClassLoader)ReflectTools.findClosestCommonClassLoaderAncestor((ClassLoader)parent, (ClassLoader)child).get();
        Assert.assertEquals((Object)parent, (Object)ret);
    }

    @Test
    public void findClosestCommonClassLoaderAncestor_findsAncestor_whenLoadersShareParent() {
        CustomClassLoader parent = new CustomClassLoader();
        CustomClassLoader childA = new CustomClassLoader(parent);
        CustomClassLoader childB = new CustomClassLoader(parent);
        ClassLoader ret = (ClassLoader)ReflectTools.findClosestCommonClassLoaderAncestor((ClassLoader)childA, (ClassLoader)childB).get();
        Assert.assertEquals((Object)parent, (Object)ret);
    }

    @Test
    public void findClosestCommonClassLoaderAncestor_findsAncestor_whenAncestorsAreOnDifferentLevels() {
        CustomClassLoader grandParent = new CustomClassLoader();
        CustomClassLoader parent = new CustomClassLoader(grandParent);
        CustomClassLoader childA = new CustomClassLoader(parent);
        CustomClassLoader childB = new CustomClassLoader(grandParent);
        ClassLoader ret = (ClassLoader)ReflectTools.findClosestCommonClassLoaderAncestor((ClassLoader)childA, (ClassLoader)childB).get();
        Assert.assertEquals((Object)grandParent, (Object)ret);
    }

    @Test
    public void findClosestCommonClassLoaderAncestor_empty_whenEitherOrBothNull() {
        CustomClassLoader loader = new CustomClassLoader();
        Optional ret = ReflectTools.findClosestCommonClassLoaderAncestor((ClassLoader)loader, null);
        Assert.assertFalse((boolean)ret.isPresent());
        ret = ReflectTools.findClosestCommonClassLoaderAncestor(null, (ClassLoader)loader);
        Assert.assertFalse((boolean)ret.isPresent());
        ret = ReflectTools.findClosestCommonClassLoaderAncestor(null, null);
        Assert.assertFalse((boolean)ret.isPresent());
    }

    @Test
    public void hasAnnotation_annotationPresents_returnsTrue() {
        Assert.assertTrue((boolean)ReflectTools.hasAnnotation(ClassWithAnnotation.class, (String)TestAnnotation.class.getName()));
    }

    @Test
    public void hasAnnotation_annotationIsAbsent_returnsFalse() {
        Assert.assertFalse((boolean)ReflectTools.hasAnnotation(ClassWithoutAnnotation.class, (String)TestAnnotation.class.getName()));
    }

    @Test
    public void hasAnnotationWithSimpleName_annotationPresents_returnsTrue() {
        Assert.assertTrue((boolean)ReflectTools.hasAnnotationWithSimpleName(ClassWithAnnotation.class, (String)TestAnnotation.class.getSimpleName()));
    }

    @Test
    public void hasAnnotationWithSimpleName_annotationIsAbsent_returnsFalse() {
        Assert.assertFalse((boolean)ReflectTools.hasAnnotationWithSimpleName(ClassWithoutAnnotation.class, (String)TestAnnotation.class.getSimpleName()));
    }

    @Test
    public void getAnnotationMethodValue_annotaitonHasMethod_theValueIsReturned() {
        Assert.assertEquals((Object)"foo", (Object)ReflectTools.getAnnotationMethodValue((Annotation)ClassWithAnnotation.class.getAnnotation(TestAnnotation.class), (String)"value"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getAnnotationMethodValue_annotationHasNoMethod_throws() {
        ReflectTools.getAnnotationMethodValue((Annotation)ClassWithAnnotation.class.getAnnotation(TestAnnotation.class), (String)"foo");
    }

    @Test
    public void getAnnotation_annotationPresents_returnsAnnotation() {
        Optional annotation = ReflectTools.getAnnotation(ClassWithAnnotation.class, (String)TestAnnotation.class.getName());
        Assert.assertTrue((boolean)annotation.isPresent());
        Assert.assertEquals((Object)ClassWithAnnotation.class.getAnnotation(TestAnnotation.class), annotation.get());
    }

    @Test
    public void getAnnotation_annotationIsAbsent_returnsEmpty() {
        Optional annotation = ReflectTools.getAnnotation(ClassWithoutAnnotation.class, (String)TestAnnotation.class.getName());
        Assert.assertFalse((boolean)annotation.isPresent());
    }

    @Test
    public void intefaceShouldNotBeInstantiableService() {
        Assert.assertFalse((boolean)ReflectTools.isInstantiableService(TestInterface.class));
    }

    @Test
    public void abstractClassShouldNotBeInstantiableService() {
        Assert.assertFalse((boolean)ReflectTools.isInstantiableService(TestAbstractClass.class));
    }

    @Test
    public void nonPublicClassShouldNotBeInstantiableService() {
        Assert.assertFalse((boolean)ReflectTools.isInstantiableService(TestProtectedClass.class));
        Assert.assertFalse((boolean)ReflectTools.isInstantiableService(TestPackageProtectedClass.class));
        Assert.assertFalse((boolean)ReflectTools.isInstantiableService(TestPrivateClass.class));
    }

    @Test
    public void ClassWithoutNonArgConstructorShouldNotBeInstantiableService() {
        Assert.assertFalse((boolean)ReflectTools.isInstantiableService(TestNoNonArgConstructorClass.class));
    }

    @Test
    public void nonStaticInnerClassShouldNotBeInstantiableService() {
        Assert.assertFalse((boolean)ReflectTools.isInstantiableService(NonStaticInnerClass.class));
    }

    @Test
    public void privateInnerClassShouldNotBeInstantiableService() {
        Assert.assertFalse((boolean)ReflectTools.isInstantiableService(PrivateInnerClass.class));
    }

    @Test
    public void normalSericieShouldBeInstantiableService() {
        Assert.assertTrue((boolean)ReflectTools.isInstantiableService(NormalService.class));
    }

    private Class<?> createProxyClass(Class<?> originalClass) {
        return new ByteBuddy().subclass(originalClass).make().load(originalClass.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded();
    }

    private void assertError(String expectedError, Class<?> cls) {
        try {
            ReflectTools.createInstance(cls);
            Assert.fail((String)"Creation should cause an exception");
        }
        catch (IllegalArgumentException re) {
            Assert.assertEquals((Object)String.format(expectedError, cls.getName()), (Object)re.getMessage());
        }
    }

    public static class OkToCreate {
    }

    public static class VarArgsCtor {
        public VarArgsCtor(String ... args) {
        }
    }

    public class NonStaticInnerClass {
        public NonStaticInnerClass(ReflectToolsTest this$0) {
        }
    }

    private class PrivateInnerClass {
        private PrivateInnerClass(ReflectToolsTest reflectToolsTest) {
        }
    }

    public static class StaticInnerPrivateConstructorClass {
        private StaticInnerPrivateConstructorClass() {
        }
    }

    public static class StaticInnerConstructorNeedsParamsClass {
        public StaticInnerConstructorNeedsParamsClass(String foo) {
        }
    }

    public static class ConstructorThrowsExceptionClass {
        public ConstructorThrowsExceptionClass() {
            throw new NullPointerException();
        }
    }

    public static class HasInterface
    implements TestInterface<String> {
    }

    public static interface TestInterface<T> {
    }

    public static class ChildInterface
    extends ParentInterface {
    }

    public static class HasInterfaceMulti
    implements TestInterfaceMulti<String, Integer, Double> {
    }

    public static interface TestInterfaceMulti<T, R, S> {
    }

    public static class ChildInterfaceMulti
    extends ParentInterfaceMulti {
    }

    public static class ChildInterfacePartial
    extends ParentInterfacePartial<Short> {
    }

    public class Category
    implements Serializable,
    Entity<Long> {
        @Override
        public Long getId() {
            return null;
        }

        @Override
        public void setId(Long id) {
        }
    }

    public static class CustomClassLoader
    extends ClassLoader {
        protected CustomClassLoader(ClassLoader parent) {
            super(parent);
        }

        protected CustomClassLoader() {
        }
    }

    @TestAnnotation(value="foo")
    public static class ClassWithAnnotation {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface TestAnnotation {
        public String value();
    }

    public static class ClassWithoutAnnotation {
    }

    public static abstract class TestAbstractClass {
    }

    protected static class TestProtectedClass {
        protected TestProtectedClass() {
        }
    }

    protected static class TestPackageProtectedClass {
        protected TestPackageProtectedClass() {
        }
    }

    private static class TestPrivateClass {
        private TestPrivateClass() {
        }
    }

    public static class TestNoNonArgConstructorClass {
        public TestNoNonArgConstructorClass(String foo) {
        }
    }

    public static class NormalService {
    }

    public static class ParentInterfaceMulti
    implements TestInterfaceMulti<Boolean, Float, Long> {
    }

    public static class ParentInterfacePartial<Z>
    implements TestInterfaceMulti<Boolean, Z, Long> {
    }

    public static class ParentInterface
    implements TestInterface<Boolean> {
    }

    public static interface Entity<ID> {
        public ID getId();

        public void setId(ID var1);
    }

    private static class PrivateStaticInnerClassPublicConstructor {
    }
}

