/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.function.SignalMapper;
import com.vaadin.flow.signals.local.ValueSignal;
import java.io.Serializable;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class ThemeListBindTest
extends SignalsUnitTest {
    @Test
    public void bindingMirrorsSignalWhileAttached_toggleAddsRemovesTheme() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)false);
        component.bindThemeName("light", (Signal)signal);
        Assert.assertFalse((boolean)component.hasThemeName("light"));
        signal.value((Object)true);
        Assert.assertTrue((boolean)component.hasThemeName("light"));
        signal.value((Object)false);
        Assert.assertFalse((boolean)component.hasThemeName("light"));
    }

    @Test
    public void bindingInactiveWhenDetached_reactivatedOnAttach_appliesCurrentValue() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)false);
        component.bindThemeName("active", (Signal)signal);
        UI.getCurrent().remove(new Component[]{component});
        signal.value((Object)true);
        Assert.assertFalse((boolean)component.hasThemeName("active"));
        UI.getCurrent().add(new Component[]{component});
        Assert.assertTrue((boolean)component.hasThemeName("active"));
    }

    @Test
    public void manualAddRemoveForBoundName_throwsBindingActiveException() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindThemeName("locked", (Signal)signal);
        Assert.assertThrows(BindingActiveException.class, () -> component.addThemeName("locked"));
        Assert.assertThrows(BindingActiveException.class, () -> component.removeThemeName("locked"));
        Assert.assertThrows(BindingActiveException.class, () -> component.setThemeName("locked", true));
        Assert.assertThrows(BindingActiveException.class, () -> component.setThemeName("locked", false));
        Assert.assertThrows(BindingActiveException.class, () -> component.addThemeNames(new String[]{"locked", "open"}));
        Assert.assertThrows(BindingActiveException.class, () -> component.removeThemeNames(new String[]{"locked", "open"}));
        Assert.assertThrows(BindingActiveException.class, () -> component.getThemeNames().retainAll(Set.of("open")));
        component.addThemeName("open");
        Assert.assertTrue((boolean)component.getThemeNames().retainAll(Set.of("locked")));
    }

    @Test
    public void clear_clearsBindingsSilently_andClearsThemes() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal a = new ValueSignal((Object)true);
        ValueSignal b = new ValueSignal((Object)true);
        component.bindThemeName("a", (Signal)a);
        component.bindThemeName("b", (Signal)b);
        Assert.assertTrue((boolean)component.hasThemeName("a"));
        Assert.assertTrue((boolean)component.hasThemeName("b"));
        component.getThemeNames().clear();
        Assert.assertFalse((boolean)component.hasThemeName("a"));
        Assert.assertFalse((boolean)component.hasThemeName("b"));
        a.value((Object)false);
        b.value((Object)false);
        a.value((Object)true);
        b.value((Object)true);
        Assert.assertFalse((boolean)component.hasThemeName("a"));
        Assert.assertFalse((boolean)component.hasThemeName("b"));
        Assert.assertFalse((boolean)component.getThemeNames().iterator().hasNext());
    }

    @Test
    public void setThemeName_bulkReplacement_clearsBindingsSilently() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal bound = new ValueSignal((Object)true);
        component.bindThemeName("flag", (Signal)bound);
        Assert.assertTrue((boolean)component.hasThemeName("flag"));
        component.setThemeName("foo");
        Assert.assertTrue((boolean)component.hasThemeName("foo"));
        Assert.assertFalse((boolean)component.hasThemeName("flag"));
        bound.value((Object)false);
        bound.value((Object)true);
        Assert.assertFalse((boolean)component.hasThemeName("flag"));
    }

    @Test
    public void bindNull_unbindsAndKeepsLastAppliedPresence() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindThemeName("badge", (Signal)signal);
        Assert.assertTrue((boolean)component.hasThemeName("badge"));
        component.bindThemeName("badge", null);
        Assert.assertTrue((boolean)component.hasThemeName("badge"));
        signal.value((Object)false);
        Assert.assertTrue((boolean)component.hasThemeName("badge"));
    }

    @Test(expected=BindingActiveException.class)
    public void rebinding_alreadyBound_throws() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal s1 = new ValueSignal((Object)true);
        ValueSignal s2 = new ValueSignal((Object)false);
        component.bindThemeName("tag", (Signal)s1);
        Assert.assertTrue((boolean)component.hasThemeName("tag"));
        component.bindThemeName("tag", (Signal)s2);
    }

    @Test
    public void internalUpdatesDoNotThrowOrRecurse() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)false);
        component.bindThemeName("spin", (Signal)signal);
        signal.value((Object)true);
        signal.value((Object)true);
        Assert.assertTrue((boolean)component.hasThemeName("spin"));
        Assert.assertEquals((long)1L, (long)component.getThemeNames().stream().filter("spin"::equals).count());
        signal.value((Object)false);
        signal.value((Object)false);
        Assert.assertFalse((boolean)component.hasThemeName("spin"));
    }

    @Test
    public void bindMultipleSignals() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        static enum DummyEnum {
            ONE,
            TWO,
            THREE;

        }
        ValueSignal signal = new ValueSignal((Object)DummyEnum.ONE);
        Signal a = signal.map((SignalMapper & Serializable)v -> v == DummyEnum.ONE);
        Signal b = signal.map((SignalMapper & Serializable)v -> v == DummyEnum.TWO);
        Signal c = signal.map((SignalMapper & Serializable)v -> v == DummyEnum.THREE);
        component.bindThemeName("a", a);
        component.bindThemeName("b", b);
        component.bindThemeName("c", c);
        Assert.assertTrue((boolean)component.hasThemeName("a"));
        Assert.assertFalse((boolean)component.hasThemeName("b"));
        Assert.assertFalse((boolean)component.hasThemeName("b"));
        signal.value((Object)DummyEnum.TWO);
        Assert.assertFalse((boolean)component.hasThemeName("a"));
        Assert.assertTrue((boolean)component.hasThemeName("b"));
        Assert.assertFalse((boolean)component.hasThemeName("c"));
        signal.value((Object)DummyEnum.THREE);
        Assert.assertFalse((boolean)component.hasThemeName("a"));
        Assert.assertFalse((boolean)component.hasThemeName("b"));
        Assert.assertTrue((boolean)component.hasThemeName("c"));
    }

    @Tag(value="span")
    private static class TestComponent
    extends Component
    implements HasTheme {
        private TestComponent() {
        }
    }
}

