/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.local.ValueSignal;
import com.vaadin.tests.util.MockUI;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class StyleBindTest {
    private static MockVaadinServletService service;

    @BeforeClass
    public static void init() {
        service = new MockVaadinServletService();
    }

    @AfterClass
    public static void clean() {
        VaadinService.setCurrent(null);
        service.destroy();
    }

    @Before
    public void before() {
        this.mockLockedSessionWithErrorHandler();
    }

    @After
    public void after() {
        VaadinService.setCurrent(null);
    }

    @Test
    public void bindingMirrorsSignalWhileAttached_updatesStyleValue() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal color = new ValueSignal((Object)"red");
        element.getStyle().bind("background-color", (Signal)color);
        Assert.assertEquals((Object)"red", (Object)element.getStyle().get("backgroundColor"));
        color.value((Object)"blue");
        Assert.assertEquals((Object)"blue", (Object)element.getStyle().get("backgroundColor"));
        color.value(null);
        Assert.assertNull((Object)element.getStyle().get("backgroundColor"));
    }

    @Test
    public void detached_noUpdates_lastAppliedPreservedOnReattach() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal color = new ValueSignal((Object)"red");
        element.getStyle().bind("background-color", (Signal)color);
        Assert.assertEquals((Object)"red", (Object)element.getStyle().get("backgroundColor"));
        UI.getCurrent().getElement().removeChild(new Element[]{element});
        color.value((Object)"green");
        Assert.assertEquals((Object)"red", (Object)element.getStyle().get("backgroundColor"));
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assert.assertEquals((Object)"green", (Object)element.getStyle().get("backgroundColor"));
    }

    @Test
    public void conflict_setRemoveThrowWhileBoundAndActive() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal color = new ValueSignal((Object)"red");
        element.getStyle().bind("background-color", (Signal)color);
        Assert.assertThrows(BindingActiveException.class, () -> element.getStyle().set("background-color", "black"));
        Assert.assertThrows(BindingActiveException.class, () -> element.getStyle().remove("background-color"));
    }

    @Test
    public void clear_removesBindingsAndStopsUpdates() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal a = new ValueSignal((Object)"1");
        ValueSignal b = new ValueSignal((Object)"2");
        element.getStyle().bind("border-top-width", (Signal)a);
        element.getStyle().bind("border-bottom-width", (Signal)b);
        Assert.assertEquals((Object)"1", (Object)element.getStyle().get("borderTopWidth"));
        Assert.assertEquals((Object)"2", (Object)element.getStyle().get("borderBottomWidth"));
        element.getStyle().clear();
        Assert.assertNull((Object)element.getStyle().get("borderTopWidth"));
        Assert.assertNull((Object)element.getStyle().get("borderBottomWidth"));
        a.value((Object)"3");
        b.value((Object)"4");
        Assert.assertNull((Object)element.getStyle().get("borderTopWidth"));
        Assert.assertNull((Object)element.getStyle().get("borderBottomWidth"));
    }

    @Test
    public void bindNull_unbindsWithoutForcingRemoval() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal color = new ValueSignal((Object)"red");
        element.getStyle().bind("background-color", (Signal)color);
        Assert.assertEquals((Object)"red", (Object)element.getStyle().get("backgroundColor"));
        element.getStyle().bind("background-color", null);
        Assert.assertEquals((Object)"red", (Object)element.getStyle().get("backgroundColor"));
        color.value((Object)"blue");
        Assert.assertEquals((Object)"red", (Object)element.getStyle().get("backgroundColor"));
    }

    @Test
    public void getters_returnLastAppliedAndNamesWithValues() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal a = new ValueSignal((Object)"10px");
        ValueSignal b = new ValueSignal((Object)"initial");
        element.getStyle().bind("margin-top", (Signal)a);
        element.getStyle().bind("margin-bottom", (Signal)b);
        Assert.assertEquals((Object)"10px", (Object)element.getStyle().get("marginTop"));
        b.value(null);
        Assert.assertNull((Object)element.getStyle().get("marginBottom"));
        Set names = element.getStyle().getNames().collect(Collectors.toSet());
        Assert.assertTrue((boolean)names.contains("margin-top"));
        Assert.assertTrue((boolean)names.contains("margin-bottom"));
        ValueSignal c = new ValueSignal((Object)"5px");
        UI.getCurrent().getElement().removeChild(new Element[]{element});
        element.getStyle().bind("padding-top", (Signal)c);
        Assert.assertNull((Object)element.getStyle().get("paddingTop"));
        names = element.getStyle().getNames().collect(Collectors.toSet());
        Assert.assertTrue((boolean)names.contains("padding-top"));
    }

    @Test
    public void nullSignalValue_removesStyleAndHasReturnsFalse() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal color = new ValueSignal((Object)"rgba(255, 0, 0, 1)");
        element.getStyle().bind("background-color", (Signal)color);
        Assert.assertEquals((Object)"rgba(255, 0, 0, 1)", (Object)element.getStyle().get("backgroundColor"));
        color.value(null);
        Assert.assertNull((Object)element.getStyle().get("backgroundColor"));
        Assert.assertFalse((boolean)element.getStyle().has("background-color"));
        Set names = element.getStyle().getNames().collect(Collectors.toSet());
        Assert.assertTrue((boolean)names.contains("background-color"));
        color.value((Object)"rgba(0, 0, 255, 1)");
        Assert.assertEquals((Object)"rgba(0, 0, 255, 1)", (Object)element.getStyle().get("backgroundColor"));
    }

    private void mockLockedSessionWithErrorHandler() {
        VaadinService.setCurrent((VaadinService)service);
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        new MockUI(session);
        LinkedList list = new LinkedList();
        session.setErrorHandler(list::add);
    }
}

