/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.signals.WritableSignal;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class UILocaleSignalTest
extends SignalsUnitTest {
    @Test
    public void localeSignal_initialValue_matchesGetLocale() {
        UI ui = UI.getCurrent();
        WritableSignal signal = ui.localeSignal();
        Assert.assertNotNull((String)"localeSignal() should never return null", (Object)signal);
        Assert.assertEquals((String)"Signal value should match getLocale()", (Object)ui.getLocale(), (Object)signal.value());
    }

    @Test
    public void localeSignal_setLocale_signalUpdated() {
        Locale newLocale;
        UI ui = UI.getCurrent();
        WritableSignal signal = ui.localeSignal();
        Locale initialLocale = ui.getLocale();
        if (initialLocale.equals(newLocale = Locale.FRENCH)) {
            newLocale = Locale.GERMAN;
        }
        ui.setLocale(newLocale);
        Assert.assertEquals((String)"Signal should reflect the new locale after setLocale()", (Object)newLocale, (Object)signal.value());
        Assert.assertEquals((String)"getLocale() should also return the new locale", (Object)newLocale, (Object)ui.getLocale());
    }

    @Test
    public void localeSignal_writeToSignal_updatesGetLocale() {
        Locale newLocale;
        UI ui = UI.getCurrent();
        WritableSignal signal = ui.localeSignal();
        Locale initialLocale = ui.getLocale();
        if (initialLocale.equals(newLocale = Locale.FRENCH)) {
            newLocale = Locale.GERMAN;
        }
        signal.value((Object)newLocale);
        Assert.assertEquals((String)"getLocale() should reflect the new locale after writing to signal", (Object)newLocale, (Object)ui.getLocale());
        Assert.assertEquals((String)"Signal should have the new value", (Object)newLocale, (Object)signal.value());
    }

    @Test
    public void localeSignal_sameInstance_returnedOnMultipleCalls() {
        UI ui = UI.getCurrent();
        WritableSignal signal1 = ui.localeSignal();
        WritableSignal signal2 = ui.localeSignal();
        Assert.assertSame((String)"localeSignal() should return the same instance on multiple calls", (Object)signal1, (Object)signal2);
    }

    @Test
    public void localeSignal_multipleLocaleChanges_signalFollows() {
        UI ui = UI.getCurrent();
        WritableSignal signal = ui.localeSignal();
        ui.setLocale(Locale.FRENCH);
        Assert.assertEquals((Object)Locale.FRENCH, (Object)signal.value());
        ui.setLocale(Locale.GERMAN);
        Assert.assertEquals((Object)Locale.GERMAN, (Object)signal.value());
        ui.setLocale(Locale.JAPANESE);
        Assert.assertEquals((Object)Locale.JAPANESE, (Object)signal.value());
    }

    @Test
    public void localeSignal_multipleSignalWrites_getLocaleFollows() {
        UI ui = UI.getCurrent();
        WritableSignal signal = ui.localeSignal();
        signal.value((Object)Locale.FRENCH);
        Assert.assertEquals((Object)Locale.FRENCH, (Object)ui.getLocale());
        signal.value((Object)Locale.GERMAN);
        Assert.assertEquals((Object)Locale.GERMAN, (Object)ui.getLocale());
        signal.value((Object)Locale.JAPANESE);
        Assert.assertEquals((Object)Locale.JAPANESE, (Object)ui.getLocale());
    }
}

