/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow;

import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.server.AbstractConfiguration;
import java.io.File;
import java.nio.file.Path;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ComponentTrackerLocationTest {
    @Test
    public void findJavaFile_simpleClass() {
        File fakeSrcDir = new File("src");
        AbstractConfiguration configuration = (AbstractConfiguration)Mockito.mock(AbstractConfiguration.class);
        Mockito.when((Object)configuration.getJavaSourceFolder()).thenReturn((Object)fakeSrcDir);
        ComponentTracker.Location location = new ComponentTracker.Location("com.example.app.MyClass", "MyClass.java", "whoCares", 99);
        File expectedFile = fakeSrcDir.toPath().resolve(Path.of("com", "example", "app", "MyClass.java")).toFile();
        File javaFile = location.findSourceFile(configuration);
        Assert.assertEquals((Object)expectedFile, (Object)javaFile);
    }

    @Test
    public void findJavaFile_simpleClass_dollarInPackage() {
        File fakeSrcDir = new File("src");
        AbstractConfiguration configuration = (AbstractConfiguration)Mockito.mock(AbstractConfiguration.class);
        Mockito.when((Object)configuration.getJavaSourceFolder()).thenReturn((Object)fakeSrcDir);
        ComponentTracker.Location location = new ComponentTracker.Location("com.exa$mple.app.MyClass", "MyClass.java", "whoCares", 99);
        File expectedFile = fakeSrcDir.toPath().resolve(Path.of("com", "exa$mple", "app", "MyClass.java")).toFile();
        File javaFile = location.findSourceFile(configuration);
        Assert.assertEquals((Object)expectedFile, (Object)javaFile);
    }

    @Test
    public void findJavaFile_simpleClass_dollarInName() {
        File fakeSrcDir = new File("src");
        AbstractConfiguration configuration = (AbstractConfiguration)Mockito.mock(AbstractConfiguration.class);
        Mockito.when((Object)configuration.getJavaSourceFolder()).thenReturn((Object)fakeSrcDir);
        ComponentTracker.Location location = new ComponentTracker.Location("com.example.app.MyClass$NotInner", "MyClass$NotInner.java", "whoCares", 99);
        File expectedFile = fakeSrcDir.toPath().resolve(Path.of("com", "example", "app", "MyClass$NotInner.java")).toFile();
        File javaFile = location.findSourceFile(configuration);
        Assert.assertEquals((Object)expectedFile, (Object)javaFile);
    }

    @Test
    public void findJavaFile_innerClass() {
        File fakeSrcDir = new File("src");
        AbstractConfiguration configuration = (AbstractConfiguration)Mockito.mock(AbstractConfiguration.class);
        Mockito.when((Object)configuration.getJavaSourceFolder()).thenReturn((Object)fakeSrcDir);
        ComponentTracker.Location location = new ComponentTracker.Location("com.example.app.MyClass$Inner", "MyClass.java", "whoCares", 99);
        File expectedFile = fakeSrcDir.toPath().resolve(Path.of("com", "example", "app", "MyClass.java")).toFile();
        File javaFile = location.findSourceFile(configuration);
        Assert.assertEquals((Object)expectedFile, (Object)javaFile);
    }

    @Test
    public void findJavaFile_nestedInnerClass() {
        File fakeSrcDir = new File("src");
        AbstractConfiguration configuration = (AbstractConfiguration)Mockito.mock(AbstractConfiguration.class);
        Mockito.when((Object)configuration.getJavaSourceFolder()).thenReturn((Object)fakeSrcDir);
        ComponentTracker.Location location = new ComponentTracker.Location("com.example.app.MyClass$Deep$Nested$Inner", "MyClass.java", "whoCares", 99);
        File expectedFile = fakeSrcDir.toPath().resolve(Path.of("com", "example", "app", "MyClass.java")).toFile();
        File javaFile = location.findSourceFile(configuration);
        Assert.assertEquals((Object)expectedFile, (Object)javaFile);
    }

    @Test
    public void findKotlinFile_simpleClass() {
        File defaultJavaSrcDir = new File("src/main/java");
        File kotlinExpectedSrcDir = new File("src/main/kotlin");
        AbstractConfiguration configuration = (AbstractConfiguration)Mockito.mock(AbstractConfiguration.class);
        Mockito.when((Object)configuration.getJavaSourceFolder()).thenReturn((Object)defaultJavaSrcDir);
        ComponentTracker.Location location = new ComponentTracker.Location("com.example.app.MyClass", "MyClass.kt", "whoCares", 99);
        File expectedFile = kotlinExpectedSrcDir.toPath().resolve(Path.of("com", "example", "app", "MyClass.kt")).toFile();
        File javaFile = location.findSourceFile(configuration);
        Assert.assertEquals((Object)expectedFile, (Object)javaFile);
    }
}

