/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.streams.UploadEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class UploadEventTest {
    private VaadinRequest request;
    private VaadinResponse response;
    private VaadinSession session;
    private Element owner;

    @Before
    public void setUp() throws IOException {
        this.request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        this.response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        this.session = (VaadinSession)Mockito.mock(VaadinSession.class);
        this.owner = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)this.request.getInputStream()).thenReturn((Object)new ByteArrayInputStream(new byte[0]));
    }

    @Test
    public void testInitialState_notRejected() {
        UploadEvent event = new UploadEvent(this.request, this.response, this.session, "test.txt", 100L, "text/plain", this.owner, null);
        Assert.assertFalse((String)"Event should not be rejected initially", (boolean)event.isRejected());
        Assert.assertNull((String)"Rejection message should be null initially", (Object)event.getRejectionMessage());
    }

    @Test
    public void testReject_withDefaultMessage() {
        UploadEvent event = new UploadEvent(this.request, this.response, this.session, "test.txt", 100L, "text/plain", this.owner, null);
        event.reject();
        Assert.assertTrue((String)"Event should be marked as rejected", (boolean)event.isRejected());
        Assert.assertEquals((String)"Default rejection message should be set", (Object)"File rejected", (Object)event.getRejectionMessage());
    }

    @Test
    public void testReject_withCustomMessage() {
        UploadEvent event = new UploadEvent(this.request, this.response, this.session, "test.zip", 100L, "application/zip", this.owner, null);
        String customMessage = "Only PNG files are accepted";
        event.reject(customMessage);
        Assert.assertTrue((String)"Event should be marked as rejected", (boolean)event.isRejected());
        Assert.assertEquals((String)"Custom rejection message should be set", (Object)customMessage, (Object)event.getRejectionMessage());
    }

    @Test
    public void testGetInputStream_rejectedUpload_throwsException() {
        UploadEvent event = new UploadEvent(this.request, this.response, this.session, "test.txt", 100L, "text/plain", this.owner, null);
        event.reject("Not allowed");
        try {
            event.getInputStream();
            Assert.fail((String)"Expected IllegalStateException when accessing rejected upload stream");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((String)"Exception should mention rejection", (boolean)e.getMessage().contains("rejected"));
            Assert.assertTrue((String)"Exception should include rejection reason", (boolean)e.getMessage().contains("Not allowed"));
        }
    }

    @Test
    public void testGetInputStream_beforeRejection_works() {
        UploadEvent event = new UploadEvent(this.request, this.response, this.session, "test.txt", 100L, "text/plain", this.owner, null);
        Assert.assertNotNull((String)"Should be able to get input stream", (Object)event.getInputStream());
    }
}

