/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.server.startup.ServletDeployer;
import jakarta.servlet.Registration;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ServletDeployerTest {
    private final ServletDeployer deployer = new ServletDeployer();
    private List<String> servletNames;
    private List<String> servletMappings;
    private List<Integer> servletLoadOnStartup;
    private boolean disableAutomaticServletRegistration = false;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Before
    public void clearCaptures() {
        this.servletNames = new ArrayList<String>();
        this.servletMappings = new ArrayList<String>();
        this.servletLoadOnStartup = new ArrayList<Integer>();
    }

    @Test
    public void automaticallyRegisterTwoServletsWhenNoServletsPresent() throws Exception {
        this.deployer.contextInitialized(this.getContextEvent(new ServletRegistration[0]));
        this.assertMappingsCount(1, 1);
        this.assertMappingIsRegistered(ServletDeployer.class.getName(), "/*");
        this.assertLoadOnStartupSet();
    }

    @Test
    public void doNotRegisterAnythingIfRegistrationIsDisabled() throws Exception {
        this.disableAutomaticServletRegistration = true;
        this.deployer.contextInitialized(this.getContextEvent(this.getServletRegistration("testServlet", TestServlet.class, Collections.singletonList("/test/*"), Collections.emptyMap())));
        this.assertMappingsCount(0, 0);
    }

    @Test
    public void registeredNonVaadinServlets_vaadinServletsAreRegistered() throws Exception {
        this.deployer.contextInitialized(this.getContextEvent(this.getServletRegistration("testServlet", TestServlet.class, Collections.singletonList("/test/*"), Collections.emptyMap())));
        this.assertMappingsCount(1, 1);
        this.assertLoadOnStartupSet();
    }

    @Test
    public void frontendServletIsNotRegisteredWhenProductionModeIsActive() throws Exception {
        this.deployer.contextInitialized(this.getContextEvent(this.getServletRegistration("testServlet", TestServlet.class, Collections.singletonList("/test/*"), Collections.singletonMap("productionMode", "true"))));
        this.assertMappingsCount(1, 1);
        this.assertMappingIsRegistered(ServletDeployer.class.getName(), "/*");
        this.assertLoadOnStartupSet();
    }

    @Test
    public void frontendServletIsNotRegistered_whenMainServletIsRegistered() throws Exception {
        this.deployer.contextInitialized(this.getContextEvent(new ServletRegistration[0]));
        this.assertMappingsCount(1, 1);
        this.assertMappingIsRegistered(ServletDeployer.class.getName(), "/*");
        this.assertLoadOnStartupSet();
    }

    @Test
    public void servletsWithoutClassName_registrationDoesNotFail() throws Exception {
        this.deployer.contextInitialized(this.getContextEvent(this.getServletRegistration("test", null, Collections.singletonList("/WEB-INF/test.jsp"), Collections.emptyMap())));
        this.assertMappingsCount(1, 1);
        this.assertMappingIsRegistered(ServletDeployer.class.getName(), "/*");
        this.assertLoadOnStartupSet();
    }

    @Test
    public void servletIsNotRegisteredWhenAnotherHasTheSamePathMapping_mainServlet() throws Exception {
        this.deployer.contextInitialized(this.getContextEvent(this.getServletRegistration("test", TestServlet.class, Collections.singletonList("/*"), Collections.emptyMap())));
        this.assertMappingsCount(0, 0);
    }

    @Test
    public void servletIsNotRegisteredWhenAnotherHasTheSamePathMapping_frontendServlet() throws Exception {
        this.deployer.contextInitialized(this.getContextEvent(this.getServletRegistration("test", TestServlet.class, Collections.singletonList("/frontend/*"), Collections.emptyMap())));
        this.assertMappingsCount(1, 1);
        this.assertMappingIsRegistered(ServletDeployer.class.getName(), "/*");
        this.assertLoadOnStartupSet();
    }

    private void assertMappingsCount(int numServlets, int numMappings) {
        Assert.assertEquals((String)String.format("Expected to have exactly '%d' servlets, but got '%d': '%s'", numServlets, this.servletNames.size(), this.servletNames), (long)this.servletNames.size(), (long)numServlets);
        Assert.assertEquals((String)String.format("Expected to have exactly '%d' mappings, but got '%d': '%s'", numMappings, this.servletMappings.size(), this.servletMappings), (long)this.servletMappings.size(), (long)numMappings);
    }

    private void assertMappingIsRegistered(String servletName, String mappedPath) {
        int servletNameIndex = this.servletNames.indexOf(servletName);
        int pathIndex = this.servletMappings.indexOf(mappedPath);
        Assert.assertTrue((String)String.format("Did not find servlet name '%s' among added servlet names: '%s'", servletName, this.servletNames), (servletNameIndex >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)String.format("Did not find mapped path '%s' among added paths: '%s'", mappedPath, this.servletMappings), (pathIndex >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Expected servlet name '%s' and mapped path '%s' to be added for the same servlet in the same time", (long)pathIndex, (long)servletNameIndex);
    }

    private void assertLoadOnStartupSet() {
        Assert.assertEquals((String)"Servlet loadOnStartup should be invoked only once", (long)1L, (long)this.servletLoadOnStartup.size());
        Assert.assertEquals((String)String.format("Expected servlet loadOnStartup to be '%d' but was '%d", 1, this.servletLoadOnStartup.get(0)), (Object)1, (Object)this.servletLoadOnStartup.get(0));
    }

    private ServletContextEvent getContextEvent(ServletRegistration ... servletRegistrations) throws Exception {
        ServletRegistration.Dynamic dynamicMock = (ServletRegistration.Dynamic)Mockito.mock(ServletRegistration.Dynamic.class);
        Mockito.when((Object)dynamicMock.addMapping(new String[]{Mockito.anyString()})).thenAnswer(answer -> {
            String mappings = (String)answer.getArgument(0);
            this.servletMappings.addAll(Arrays.asList(mappings));
            return Collections.emptySet();
        });
        ((ServletRegistration.Dynamic)Mockito.doAnswer(i -> this.servletLoadOnStartup.add((Integer)i.getArgument(0))).when((Object)dynamicMock)).setLoadOnStartup(ArgumentMatchers.anyInt());
        ServletContext contextMock = (ServletContext)Mockito.mock(ServletContext.class);
        Lookup lookup = (Lookup)Mockito.mock(Lookup.class);
        Mockito.when((Object)contextMock.getAttribute(Lookup.class.getName())).thenReturn((Object)lookup);
        ResourceProvider resourceProvider = (ResourceProvider)Mockito.mock(ResourceProvider.class);
        Mockito.when((Object)resourceProvider.getApplicationResources((String)Mockito.any())).thenReturn(Collections.emptyList());
        Mockito.when((Object)((ResourceProvider)lookup.lookup(ResourceProvider.class))).thenReturn((Object)resourceProvider);
        ApplicationConfiguration appConfig = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        Mockito.when((Object)appConfig.getPropertyNames()).thenReturn(Collections.emptyEnumeration());
        Mockito.when((Object)appConfig.isProductionMode()).thenReturn((Object)false);
        Mockito.when((Object)appConfig.disableAutomaticServletRegistration()).thenReturn((Object)this.disableAutomaticServletRegistration);
        Mockito.when((Object)contextMock.getAttribute(ApplicationConfiguration.class.getName())).thenReturn((Object)appConfig);
        Mockito.when((Object)contextMock.getContextPath()).thenReturn((Object)"");
        Mockito.when((Object)contextMock.getClassLoader()).thenReturn((Object)this.getClass().getClassLoader());
        Mockito.when((Object)contextMock.addServlet(Mockito.anyString(), (Class)Mockito.any(Class.class))).thenAnswer(answer -> {
            String servletName = (String)answer.getArgument(0);
            this.servletNames.add(servletName);
            return dynamicMock;
        });
        Map hack = Stream.of(servletRegistrations).collect(Collectors.toMap(Registration::getName, Function.identity()));
        Mockito.when((Object)contextMock.getServletRegistrations()).thenReturn(hack);
        File token = this.tempFolder.newFile();
        FileUtils.write((File)token, (CharSequence)"{}", (Charset)StandardCharsets.UTF_8);
        Mockito.when((Object)contextMock.getInitParameterNames()).thenReturn(Collections.enumeration(Collections.singletonList("vaadin.frontend.token.file")));
        Mockito.when((Object)contextMock.getInitParameter("vaadin.frontend.token.file")).thenReturn((Object)token.getPath());
        return new ServletContextEvent(contextMock);
    }

    private ServletRegistration getServletRegistration(String servletName, Class<?> servletClass, Collection<String> pathMappings, Map<String, String> initParameters) {
        ServletRegistration registrationMock = (ServletRegistration)Mockito.mock(ServletRegistration.class);
        Mockito.when((Object)registrationMock.getClassName()).thenReturn((Object)(servletClass != null ? servletClass.getName() : null));
        Mockito.when((Object)registrationMock.getMappings()).thenReturn(pathMappings);
        Mockito.when((Object)registrationMock.getName()).thenReturn((Object)servletName);
        Mockito.when((Object)registrationMock.getInitParameters()).thenReturn(initParameters);
        Mockito.when((Object)registrationMock.getInitParameter(Mockito.anyString())).thenAnswer(answer -> {
            String name = (String)answer.getArgument(0);
            return initParameters.get(name);
        });
        return registrationMock;
    }

    private static class TestServlet
    implements Servlet {
        private TestServlet() {
        }

        public void init(ServletConfig config) {
        }

        public ServletConfig getServletConfig() {
            return null;
        }

        public void service(ServletRequest req, ServletResponse res) {
        }

        public String getServletInfo() {
            return null;
        }

        public void destroy() {
        }
    }

    @Route
    private static class ComponentWithRoute
    extends Component {
        private ComponentWithRoute() {
        }
    }
}

