/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.router.ParentLayout;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RoutePrefix;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.InvalidRouteLayoutConfigurationException;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.AbstractRouteRegistryInitializer;
import java.util.Set;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AbstractRouteRegistryInitializerTest {
    private AbstractRouteRegistryInitializer initializer = new AbstractRouteRegistryInitializer(){};
    VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);

    @Test(expected=InvalidRouteLayoutConfigurationException.class)
    public void routeAndParentLayout_notRouterLayout_throws() {
        this.initializer.validateRouteClasses(this.context, Stream.of(RouteAndParentLayout.class));
    }

    @Test
    public void validateRouteClasses_annotationOnNonComponentClass_throws() {
        InvalidRouteConfigurationException exception = (InvalidRouteConfigurationException)Assert.assertThrows(InvalidRouteConfigurationException.class, () -> this.initializer.validateRouteClasses(this.context, Stream.of(NonComponent.class)));
        Assert.assertTrue((boolean)AbstractRouteRegistryInitializerTest.containsQuotedAnnotationName(exception.getMessage(), Route.class));
        Assert.assertTrue((boolean)exception.getMessage().contains("not extend '" + Component.class.getCanonicalName()));
    }

    @Test
    public void validateRouteClasses_samePathForRouteAndAlias_throws() {
        InvalidRouteConfigurationException exception = (InvalidRouteConfigurationException)Assert.assertThrows(InvalidRouteConfigurationException.class, () -> this.initializer.validateRouteClasses(this.context, Stream.of(RouteAndAliasWithSamePath.class)));
        Assert.assertTrue((boolean)AbstractRouteRegistryInitializerTest.containsQuotedAnnotationName(exception.getMessage(), Route.class));
        Assert.assertTrue((boolean)AbstractRouteRegistryInitializerTest.containsQuotedAnnotationName(exception.getMessage(), RouteAlias.class));
        Assert.assertTrue((boolean)exception.getMessage().contains("same path"));
        Assert.assertTrue((boolean)exception.getMessage().contains("foo"));
    }

    @Test
    public void validateRouteClasses_samePathForRepeatableAlias_throws() {
        InvalidRouteConfigurationException exception = (InvalidRouteConfigurationException)Assert.assertThrows(InvalidRouteConfigurationException.class, () -> this.initializer.validateRouteClasses(this.context, Stream.of(AliasesWithSamePath.class)));
        Assert.assertFalse((boolean)AbstractRouteRegistryInitializerTest.containsQuotedAnnotationName(exception.getMessage(), Route.class));
        Assert.assertTrue((boolean)AbstractRouteRegistryInitializerTest.containsQuotedAnnotationName(exception.getMessage(), RouteAlias.class));
        Assert.assertTrue((boolean)exception.getMessage().contains("same paths"));
        Assert.assertTrue((boolean)exception.getMessage().contains("bar"));
        Assert.assertTrue((boolean)exception.getMessage().contains("baz"));
        Assert.assertFalse((boolean)exception.getMessage().contains("foo"));
        Assert.assertFalse((boolean)exception.getMessage().contains("hey"));
    }

    @Test
    public void validateRouteClasses_samePathForRouteAndAlias_sameLayoutPrefix_throws() {
        InvalidRouteConfigurationException exception = (InvalidRouteConfigurationException)Assert.assertThrows(InvalidRouteConfigurationException.class, () -> this.initializer.validateRouteClasses(this.context, Stream.of(RouteAndAliasWithSamePathSameLayoutPrefix.class)));
        Assert.assertTrue((boolean)AbstractRouteRegistryInitializerTest.containsQuotedAnnotationName(exception.getMessage(), Route.class));
        Assert.assertTrue((boolean)AbstractRouteRegistryInitializerTest.containsQuotedAnnotationName(exception.getMessage(), RouteAlias.class));
        Assert.assertTrue((boolean)exception.getMessage().contains("same path"));
        Assert.assertTrue((boolean)exception.getMessage().contains("foo"));
    }

    @Test
    public void validateRouteClasses_samePathForRouteAndAlias_sameNestedLayoutPrefix_throws() {
        InvalidRouteConfigurationException exception = (InvalidRouteConfigurationException)Assert.assertThrows(InvalidRouteConfigurationException.class, () -> this.initializer.validateRouteClasses(this.context, Stream.of(RouteAndAliasWithSamePathSameNestedLayoutPrefix.class)));
        Assert.assertTrue((boolean)AbstractRouteRegistryInitializerTest.containsQuotedAnnotationName(exception.getMessage(), Route.class));
        Assert.assertTrue((boolean)AbstractRouteRegistryInitializerTest.containsQuotedAnnotationName(exception.getMessage(), RouteAlias.class));
        Assert.assertTrue((boolean)exception.getMessage().contains("same path"));
        Assert.assertTrue((boolean)exception.getMessage().contains("foo"));
    }

    @Test
    public void validateRouteClasses_samePathForRouteAndAlias_differentLayoutPrefix_doNotThrow() {
        Set classes = this.initializer.validateRouteClasses(this.context, Stream.of(RouteAndAliasWithSamePathDifferentLayoutPrefix.class));
        Assert.assertEquals((long)1L, (long)classes.size());
        Assert.assertEquals(RouteAndAliasWithSamePathDifferentLayoutPrefix.class, classes.iterator().next());
    }

    @Test
    public void routeAndParentLayout_routerLayout_returnsValidatedClass() {
        Set classes = this.initializer.validateRouteClasses(this.context, Stream.of(RouteAndParentRouterLayout.class));
        Assert.assertEquals((long)1L, (long)classes.size());
        Assert.assertEquals(RouteAndParentRouterLayout.class, classes.iterator().next());
    }

    private static boolean containsQuotedAnnotationName(String message, Class<?> clazz) {
        return message.contains("'@" + clazz.getSimpleName() + "'");
    }

    @Tag(value="div")
    @Route(value="foo")
    @ParentLayout(value=TestParentLayout.class)
    public static class RouteAndParentLayout
    extends Component {
    }

    @Tag(value="div")
    @Route(value="foo")
    @RouteAlias(value="foo", layout=PrefixedParentLayout.class)
    public static class RouteAndAliasWithSamePathDifferentLayoutPrefix
    extends Component {
    }

    @Tag(value="div")
    @Route(value="foo")
    @ParentLayout(value=TestParentLayout.class)
    public static class RouteAndParentRouterLayout
    extends Component
    implements RouterLayout {
    }

    @Tag(value="div")
    @Route(value="foo", layout=NestedPrefixedParentLayout.class)
    @RouteAlias(value="foo", layout=NestedPrefixedParentLayout.class)
    public static class RouteAndAliasWithSamePathSameNestedLayoutPrefix
    extends Component {
    }

    @Tag(value="div")
    @Route(value="foo", layout=PrefixedParentLayout.class)
    @RouteAlias(value="foo", layout=PrefixedParentLayout.class)
    public static class RouteAndAliasWithSamePathSameLayoutPrefix
    extends Component {
    }

    @Tag(value="div")
    @Route(value="foo")
    @RouteAlias.Container(value={@RouteAlias(value="bar"), @RouteAlias(value="baz"), @RouteAlias(value="bar"), @RouteAlias(value="baz"), @RouteAlias(value="hey")})
    public static class AliasesWithSamePath
    extends Component {
    }

    @Tag(value="div")
    @Route(value="foo")
    @RouteAlias(value="foo")
    public static class RouteAndAliasWithSamePath
    extends Component {
    }

    @Route(value="foo")
    public static class NonComponent {
    }

    @Tag(value="div")
    @RoutePrefix(value="nested")
    @ParentLayout(value=PrefixedParentLayout.class)
    public static class NestedPrefixedParentLayout
    extends Component
    implements RouterLayout {
    }

    @Tag(value="div")
    @RoutePrefix(value="parent")
    public static class PrefixedParentLayout
    extends Component
    implements RouterLayout {
    }

    @Tag(value="div")
    public static class TestParentLayout
    extends Component
    implements RouterLayout {
    }
}

