/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.NodeFeatureRegistry;
import com.vaadin.flow.internal.nodefeature.NodeList;
import com.vaadin.flow.internal.nodefeature.NodeMap;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;

public abstract class AbstractNodeFeatureTest<T extends NodeFeature> {
    public T createFeature() {
        Class<T> featureType = this.findFeatureType();
        return AbstractNodeFeatureTest.createFeature(featureType);
    }

    public static <T extends NodeFeature> T createFeature(Class<T> featureType) {
        StateNode node = new StateNode(new Class[]{featureType});
        return (T)node.getFeature(featureType);
    }

    private Class<T> findFeatureType() {
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        Class paramType = (Class)genericSuperclass.getActualTypeArguments()[0];
        Class<NodeFeature> featureType = paramType.asSubclass(NodeFeature.class);
        return featureType;
    }

    public List<NodeChange> collectChanges(NodeFeature feature) {
        ArrayList<NodeChange> changes = new ArrayList<NodeChange>();
        feature.collectChanges(changes::add);
        feature.getNode().clearChanges();
        return changes;
    }

    protected void assertNodeEquals(StateNode node1, StateNode node2) {
        Assert.assertEquals((long)node1.getId(), (long)node2.getId());
        NodeFeatureRegistry.nodeFeatures.keySet().forEach(k -> {
            Assert.assertEquals((Object)node1.hasFeature(k), (Object)node2.hasFeature(k));
            if (node1.hasFeature(k)) {
                this.assertFeaturesEquals(node1.getFeature(k), node2.getFeature(k));
            }
        });
    }

    protected void assertFeaturesEquals(NodeFeature feature1, NodeFeature feature2) {
        Assert.assertEquals(feature1.getClass(), feature2.getClass());
        if (feature1 instanceof NodeMap) {
            this.assertMapFeatureEquals((NodeMap)feature1, (NodeMap)feature2);
        } else if (feature1 instanceof NodeList) {
            this.assertListFeatureEquals((NodeList)feature1, (NodeList)feature2);
        } else {
            Assert.fail((String)("Unknown feature type " + feature1.getClass().getName()));
        }
    }

    protected void assertListFeatureEquals(NodeList feature1, NodeList feature2) {
        Assert.assertEquals((long)feature1.size(), (long)feature2.size());
        for (int i = 0; i < feature1.size(); ++i) {
            Assert.assertEquals((Object)feature1.get(i), (Object)feature2.get(i));
        }
    }

    protected void assertMapFeatureEquals(NodeMap feature1, NodeMap feature2) {
        Assert.assertEquals((long)feature1.keySet().size(), (long)feature2.keySet().size());
        feature1.keySet().forEach(k -> Assert.assertEquals((Object)feature1.get(k), (Object)feature2.get(k)));
    }
}

