/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.CustomElementNameValidator;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class CustomElementNameValidatorTest {
    @Test
    public void testInvalidElementNames() {
        Stream.of("", "foo", "annotation-xml", "0-foo", "-foo", "foo-$", "foo-/", "FOO-BAR", "foo/", "\u00f8l-unicorn", "foo-\ud83d\udca9", "5th-element").forEach(name -> Assert.assertFalse((String)String.format("Name %s is valid even though it should not be", name), (boolean)CustomElementNameValidator.isCustomElementName((String)name)));
    }

    @Test
    public void testValidNamesWithoutErrorOrWarning() {
        Stream.of("foo-bar", "custom-element", "date-field", "dos-box", "home-4-good").forEach(name -> Assert.assertTrue((String)String.format("Name %s is not valid even though it should be", name), (boolean)CustomElementNameValidator.isCustomElementName((String)name)));
    }

    @Test
    public void testValidButWithWarning() {
        Stream.of("polymer-", "x-", "ng-", "unicorn-", "unicorn-\u00f8", "uni--corn", "uni-----corn", "uni-co___rn", "uni-co.rn", "uni-corn\u00e9", "xml-unicorn", "n\u00e3o-t\u00e9m", "foo-b\u00e5r").forEach(name -> Assert.assertTrue((String)String.format("Name %s is not valid even though it should be", name), (boolean)CustomElementNameValidator.isCustomElementName((String)name)));
    }
}

