/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.webcomponent;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.webcomponent.PropertyConfiguration;
import com.vaadin.flow.component.webcomponent.WebComponent;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.webcomponent.PropertyConfigurationImpl;
import com.vaadin.flow.server.webcomponent.WebComponentBinding;
import java.io.Serializable;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.ValueNode;

public class WebComponentTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private WebComponent<Component> webComponent;

    @Before
    public void init() {
        WebComponentBinding componentBinding = new WebComponentBinding((Component)Mockito.mock(Component.class));
        this.webComponent = new WebComponent(componentBinding, new Element("tag"));
    }

    @Test
    public void fireEvent_throwsWhenNameIsNull() {
        this.exception.expect(NullPointerException.class);
        this.exception.expectMessage("eventName");
        this.webComponent.fireEvent(null);
    }

    @Test
    public void fireEvent_doesNotThrowOnNullObjectData() {
        this.webComponent.fireEvent("name", (JsonNode)null);
    }

    @Test
    public void fireEvent_throwsWhenOptionsIsNull() {
        this.exception.expect(NullPointerException.class);
        this.exception.expectMessage("options");
        this.webComponent.fireEvent("name", (JsonNode)null, null);
    }

    @Test
    public void setProperty_throwsOnNullPropertyConfiguration() {
        this.exception.expect(NullPointerException.class);
        this.exception.expectMessage("propertyConfiguration");
        this.webComponent.setProperty(null, (Serializable)((Object)"value"));
    }

    @Test
    public void setProperty_throwsOnUnknownProperty() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("WebComponent does not have a property identified");
        WebComponentBinding binding = new WebComponentBinding((Component)Mockito.mock(Component.class));
        WebComponent webComponent = new WebComponent(binding, new Element("tag"));
        PropertyConfigurationImpl configuration = new PropertyConfigurationImpl(Component.class, "property", String.class, (Serializable)((Object)"value"));
        webComponent.setProperty((PropertyConfiguration)configuration, (Serializable)((Object)"newValue"));
    }

    @Test
    public void setProperty_throwsWhenGivenWrongPropertyTypeAsParameter() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Property 'property' of type 'java.lang.Integer' cannot be assigned value of type 'java.lang.String'!");
        PropertyConfigurationImpl intConfiguration = new PropertyConfigurationImpl(Component.class, "property", Integer.class, (Serializable)Integer.valueOf(0));
        WebComponentBinding binding = new WebComponentBinding((Component)Mockito.mock(Component.class));
        binding.bindProperty(intConfiguration, false);
        WebComponent webComponent = new WebComponent(binding, new Element("tag"));
        PropertyConfigurationImpl stringConfiguration = new PropertyConfigurationImpl(Component.class, "property", String.class, (Serializable)((Object)"value"));
        webComponent.setProperty((PropertyConfiguration)stringConfiguration, (Serializable)((Object)"newValue"));
    }

    @Test
    public void setProperty_attemptsToWriteSupportedTypes() {
        Element element = (Element)Mockito.spy((Object)new Element("tag"));
        PropertyConfigurationImpl intConfiguration = new PropertyConfigurationImpl(Component.class, "int", Integer.class, (Serializable)Integer.valueOf(0));
        PropertyConfigurationImpl doubleConfiguration = new PropertyConfigurationImpl(Component.class, "double", Double.class, (Serializable)Double.valueOf(0.0));
        PropertyConfigurationImpl stringConfiguration = new PropertyConfigurationImpl(Component.class, "string", String.class, (Serializable)((Object)""));
        PropertyConfigurationImpl booleanConfiguration = new PropertyConfigurationImpl(Component.class, "boolean", Boolean.class, (Serializable)Boolean.valueOf(false));
        PropertyConfigurationImpl jsonNodeConfiguration = new PropertyConfigurationImpl(Component.class, "jsonNode", BaseJsonNode.class, (Serializable)JacksonUtils.nullNode());
        WebComponentBinding binding = new WebComponentBinding((Component)Mockito.mock(Component.class));
        binding.bindProperty(intConfiguration, false);
        binding.bindProperty(doubleConfiguration, false);
        binding.bindProperty(stringConfiguration, false);
        binding.bindProperty(booleanConfiguration, false);
        binding.bindProperty(jsonNodeConfiguration, false);
        WebComponent webComponent = new WebComponent(binding, element);
        webComponent.setProperty((PropertyConfiguration)intConfiguration, (Serializable)Integer.valueOf(1));
        ((Element)Mockito.verify((Object)element, (VerificationMode)Mockito.times((int)1))).executeJs(ArgumentMatchers.anyString(), new Object[]{ArgumentMatchers.any(), ArgumentMatchers.any()});
        webComponent.setProperty((PropertyConfiguration)doubleConfiguration, (Serializable)Double.valueOf(1.0));
        ((Element)Mockito.verify((Object)element, (VerificationMode)Mockito.times((int)2))).executeJs(ArgumentMatchers.anyString(), new Object[]{ArgumentMatchers.any(), ArgumentMatchers.any()});
        webComponent.setProperty((PropertyConfiguration)stringConfiguration, (Serializable)((Object)"asd"));
        ((Element)Mockito.verify((Object)element, (VerificationMode)Mockito.times((int)3))).executeJs(ArgumentMatchers.anyString(), new Object[]{ArgumentMatchers.any(), ArgumentMatchers.any()});
        webComponent.setProperty((PropertyConfiguration)booleanConfiguration, (Serializable)Boolean.valueOf(true));
        ((Element)Mockito.verify((Object)element, (VerificationMode)Mockito.times((int)4))).executeJs(ArgumentMatchers.anyString(), new Object[]{ArgumentMatchers.any(), ArgumentMatchers.any()});
        webComponent.setProperty((PropertyConfiguration)jsonNodeConfiguration, (Serializable)((ValueNode)JacksonUtils.createNode((Object)true)));
        ((Element)Mockito.verify((Object)element, (VerificationMode)Mockito.times((int)5))).executeJs(ArgumentMatchers.anyString(), (Object[])ArgumentMatchers.any(Object[].class));
    }
}

