/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.dom.ThemeList;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class HasThemeTest {
    @Test
    public void addThemeName() {
        HasThemeComponent component = new HasThemeComponent();
        component.addThemeName("foo");
        this.assertThemes(component, "foo");
        component.addThemeName("bar");
        this.assertThemes(component, "foo", "bar");
        component.getThemeNames().add((Object)"baz");
        this.assertThemes(component, "foo", "bar", "baz");
    }

    @Test
    public void setThemeName_useThemeList() {
        HasThemeComponent component = new HasThemeComponent();
        component.setThemeName("foo bar");
        component.getThemeNames().set("bar", false);
        this.assertThemes(component, "foo");
    }

    @Test
    public void removeThemeName() {
        HasThemeComponent component = new HasThemeComponent();
        component.setThemeName("foo Bar baz");
        component.removeThemeName("foo");
        this.assertThemes(component, "Bar", "baz");
        component.removeThemeName("bar");
        this.assertThemes(component, "Bar", "baz");
        component.removeThemeName("Bar");
        this.assertThemes(component, "baz");
        component.removeThemeName("baz");
        this.assertThemes(component, new String[0]);
        component.setThemeName("foo");
        component.getThemeNames().remove((Object)"foo");
        this.assertThemes(component, new String[0]);
    }

    @Test
    public void setThemeName() {
        HasThemeComponent component = new HasThemeComponent();
        Assert.assertNull((Object)component.getThemeName());
        component.setThemeName("foo");
        this.assertThemes(component, "foo");
        component.setThemeName("bar");
        this.assertThemes(component, "bar");
        component.setThemeName("bar foo");
        this.assertThemes(component, "bar", "foo");
        component.setThemeName("");
        this.assertThemes(component, new String[0]);
        component.setThemeName("");
        this.assertThemes(component, new String[0]);
    }

    @Test
    public void getThemeName() {
        HasThemeComponent component = new HasThemeComponent();
        Assert.assertNull((Object)component.getThemeName());
        component.setThemeName("foo");
        Assert.assertEquals((Object)"foo", (Object)component.getThemeName());
        component.setThemeName("");
        Assert.assertEquals((Object)"", (Object)component.getThemeName());
    }

    @Test
    public void setThemeNameToggle() {
        HasThemeComponent component = new HasThemeComponent();
        component.setThemeName("foo", false);
        this.assertThemes(component, new String[0]);
        component.setThemeName("foo", true);
        this.assertThemes(component, "foo");
        component.setThemeName("foo", false);
        this.assertThemes(component, new String[0]);
        component.setThemeName("foo", true);
        component.setThemeName("bar", true);
        component.setThemeName("baz", true);
        this.assertThemes(component, "foo", "bar", "baz");
        component.setThemeName("baz", false);
        this.assertThemes(component, "foo", "bar");
    }

    @Test
    public void hasThemeName() {
        HasThemeComponent component = new HasThemeComponent();
        Assert.assertFalse((boolean)component.hasThemeName("foo"));
        component.setThemeName("foo");
        Assert.assertTrue((boolean)component.hasThemeName("foo"));
        Assert.assertFalse((boolean)component.hasThemeName("fo"));
        component.setThemeName("foo bar");
        Assert.assertTrue((boolean)component.hasThemeName("foo"));
        Assert.assertTrue((boolean)component.hasThemeName("bar"));
    }

    @Test
    public void getThemeList_elementThemeList() {
        HasThemeComponent component = new HasThemeComponent();
        Assert.assertEquals((Object)component.getElement().getThemeList().isEmpty(), (Object)component.getThemeNames().isEmpty());
    }

    @Test
    public void testAddThemeNames() {
        HasThemeComponent component = new HasThemeComponent();
        component.addThemeNames(new String[0]);
        this.assertThemes(component, new String[0]);
        component.addThemeNames(new String[]{"foo", "bar"});
        this.assertThemes(component, "foo", "bar");
        component.addThemeNames(new String[]{"baz1", "baz2"});
        this.assertThemes(component, "foo", "bar", "baz1", "baz2");
    }

    @Test
    public void testRemoveThemeNames() {
        HasThemeComponent component = new HasThemeComponent();
        component.setThemeName("foo bar baz1 baz2 foo2 bar1");
        component.removeThemeNames(new String[0]);
        this.assertThemes(component, "foo", "bar", "baz1", "baz2", "foo2", "bar1");
        component.removeThemeNames(new String[]{"baz2"});
        this.assertThemes(component, "foo", "bar", "baz1", "foo2", "bar1");
        component.removeThemeNames(new String[]{"bar", "foo2", "foo"});
        this.assertThemes(component, "baz1", "bar1");
    }

    private void assertThemes(HasThemeComponent c, String ... expectedThemes) {
        ThemeList actual = c.getThemeNames();
        HashSet<String> expected = new HashSet<String>(Arrays.asList(expectedThemes));
        Assert.assertEquals(expected, (Object)actual);
    }

    @Tag(value="div")
    public static class HasThemeComponent
    extends Component
    implements HasTheme {
    }
}

