/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.signals.BindingActiveException;
import com.vaadin.signals.Signal;
import com.vaadin.signals.local.ValueSignal;
import org.junit.Assert;
import org.junit.Test;

public class HasHelperBindHelperTextTest
extends SignalsUnitTest {
    @Test
    public void bindHelperText_updatesPropertyOnSignalChange() {
        HasHelperComponent c = new HasHelperComponent();
        UI.getCurrent().add(new Component[]{c});
        ValueSignal signal = new ValueSignal((Object)"");
        c.bindHelperText((Signal)signal);
        signal.value((Object)"help-1");
        Assert.assertEquals((Object)"help-1", (Object)c.getElement().getProperty("helperText"));
        signal.value((Object)"help-2");
        Assert.assertEquals((Object)"help-2", (Object)c.getElement().getProperty("helperText"));
    }

    @Test
    public void bindHelperText_setHelperTextWhileBindingActive_throws() {
        HasHelperComponent c = new HasHelperComponent();
        UI.getCurrent().add(new Component[]{c});
        ValueSignal signal = new ValueSignal((Object)"initial");
        c.bindHelperText((Signal)signal);
        Assert.assertThrows(BindingActiveException.class, () -> c.setHelperText("manual"));
    }

    @Test
    public void bindHelperText_unbindWithNull_stopsUpdates() {
        HasHelperComponent c = new HasHelperComponent();
        UI.getCurrent().add(new Component[]{c});
        ValueSignal signal = new ValueSignal((Object)"a");
        c.bindHelperText((Signal)signal);
        Assert.assertEquals((Object)"a", (Object)c.getElement().getProperty("helperText"));
        c.bindHelperText(null);
        signal.value((Object)"b");
        Assert.assertEquals((Object)"a", (Object)c.getElement().getProperty("helperText"));
    }

    @Tag(value="div")
    public static class HasHelperComponent
    extends Component
    implements HasHelper {
    }
}

