/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.ValueChangeMonitor;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.MockServletServiceSessionSetup;
import com.vaadin.tests.PublicApiAnalyzer;
import com.vaadin.tests.util.MockUI;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.JsonNodeType;

public class AbstractSinglePropertyFieldTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void stringField_basicCases() {
        StringField field = new StringField();
        ValueChangeMonitor<String> monitor = new ValueChangeMonitor<String>((HasValue<?, String>)field);
        Assert.assertEquals((Object)"", (Object)field.getValue());
        Assert.assertFalse((boolean)field.getElement().hasProperty("property"));
        monitor.assertNoEvent();
        field.setValue("foo");
        Assert.assertEquals((Object)"foo", (Object)field.getElement().getProperty("property"));
        monitor.assertEvent(false, "", "foo");
        field.getElement().setProperty("property", "bar");
        Assert.assertEquals((Object)"bar", (Object)field.getValue());
        monitor.assertEvent(false, "foo", "bar");
        field.getElement().setProperty("property", null);
        Assert.assertEquals((Object)"", (Object)field.getValue());
        monitor.assertEvent(false, "bar", "");
    }

    @Test
    public void stringField_setValueNull_exceptionAndNoEvent() {
        StringField field = new StringField();
        ValueChangeMonitor monitor = new ValueChangeMonitor(field);
        try {
            this.thrown.expect(NullPointerException.class);
            field.setValue(null);
        }
        finally {
            monitor.assertNoEvent();
        }
    }

    @Test
    public void stringField_initProperty_noEvent() {
        StringField field = new StringField();
        ValueChangeMonitor monitor = new ValueChangeMonitor(field);
        field.getElement().setProperty("property", "");
        monitor.assertNoEvent();
    }

    @Test
    public void synchronizedEvent_default() {
        StringField stringField = new StringField();
        Assert.assertEquals((Object)"property-changed", (Object)stringField.getSynchronizationRegistration().getEventType());
    }

    @Test
    public void synchronizedEvent_redefined() {
        StringField stringField = new StringField();
        DomListenerRegistration origReg = stringField.getSynchronizationRegistration();
        SerializableRunnable unregisterListener = (SerializableRunnable)Mockito.mock(SerializableRunnable.class);
        origReg.onUnregister(unregisterListener);
        stringField.setSynchronizedEvent("blur");
        DomListenerRegistration recentReg = stringField.getSynchronizationRegistration();
        ((SerializableRunnable)Mockito.verify((Object)unregisterListener)).run();
        Assert.assertNotSame((Object)origReg, (Object)recentReg);
        Assert.assertEquals((Object)"blur", (Object)recentReg.getEventType());
    }

    @Test
    public void synchronizedEvent_null_noSynchronization() {
        StringField stringField = new StringField();
        SerializableRunnable unregisterListener = (SerializableRunnable)Mockito.mock(SerializableRunnable.class);
        stringField.getSynchronizationRegistration().onUnregister(unregisterListener);
        stringField.setSynchronizedEvent(null);
        Assert.assertNull((Object)stringField.getSynchronizationRegistration());
        ((SerializableRunnable)Mockito.verify((Object)unregisterListener)).run();
    }

    @Test
    public void synchronizedEvent_camelCaseProperty_dashCaseEvent() {
        StringField stringField = new StringField("immediateValue");
        Assert.assertEquals((Object)"immediate-value-changed", (Object)stringField.getSynchronizationRegistration().getEventType());
    }

    @Test
    public void stringNullField_basicCases() {
        StringNullField field = new StringNullField();
        ValueChangeMonitor<String> monitor = new ValueChangeMonitor<String>((HasValue<?, String>)field);
        Assert.assertEquals(null, (Object)field.getValue());
        Assert.assertFalse((boolean)field.getElement().hasProperty("property"));
        monitor.assertNoEvent();
        field.getElement().setProperty("property", "");
        Assert.assertEquals((Object)"", (Object)field.getValue());
        monitor.assertEvent(false, null, "");
        field.setValue(null);
        Assert.assertFalse((boolean)field.getElement().hasProperty("property"));
        monitor.assertEvent(false, "", null);
    }

    @Test
    public void doubleField_basicCases() {
        DoubleField field = new DoubleField();
        ValueChangeMonitor<Double> monitor = new ValueChangeMonitor<Double>((HasValue<?, Double>)field);
        Assert.assertEquals((double)0.0, (double)((Double)field.getValue()), (double)0.0);
        Assert.assertFalse((boolean)field.getElement().hasProperty("property"));
        monitor.assertNoEvent();
        field.setValue(10.1);
        Assert.assertEquals((double)10.1, (double)field.getElement().getProperty("property", 0.0), (double)0.0);
        monitor.assertEvent(false, 0.0, 10.1);
        field.getElement().setProperty("property", 1.1);
        Assert.assertEquals((double)1.1, (double)((Double)field.getValue()), (double)0.0);
        monitor.assertEvent(false, 10.1, 1.1);
        field.getElement().setProperty("property", null);
        Assert.assertEquals((double)0.0, (double)((Double)field.getValue()), (double)0.0);
        monitor.assertEvent(false, 1.1, 0.0);
    }

    @Test
    public void integerField_basicCases() {
        IntegerField field = new IntegerField();
        ValueChangeMonitor<Integer> monitor = new ValueChangeMonitor<Integer>((HasValue<?, Integer>)field);
        Assert.assertEquals((long)42L, (long)((Integer)field.getValue()).intValue());
        Assert.assertFalse((boolean)field.getElement().hasProperty("property"));
        monitor.assertNoEvent();
        field.setValue(0);
        Assert.assertEquals((long)0L, (long)field.getElement().getProperty("property", -1));
        monitor.assertEvent(false, 42, 0);
        field.getElement().setProperty("property", 1.0);
        Assert.assertEquals((long)1L, (long)((Integer)field.getValue()).intValue());
        monitor.assertEvent(false, 0, 1);
        field.getElement().setProperty("property", null);
        Assert.assertEquals((long)42L, (long)((Integer)field.getValue()).intValue());
        monitor.assertEvent(false, 1, 42);
    }

    @Test
    public void booleanField_basicCases() {
        BooleanField field = new BooleanField();
        ValueChangeMonitor<Boolean> monitor = new ValueChangeMonitor<Boolean>((HasValue<?, Boolean>)field);
        Assert.assertFalse((boolean)((Boolean)field.getValue()));
        Assert.assertFalse((boolean)field.getElement().hasProperty("property"));
        monitor.assertNoEvent();
        field.setValue(true);
        Assert.assertTrue((boolean)field.getElement().getProperty("property", false));
        monitor.assertEvent(false, false, true);
        field.getElement().setProperty("property", false);
        Assert.assertFalse((boolean)((Boolean)field.getValue()));
        monitor.assertEvent(false, true, false);
        field.setValue(true);
        monitor.discard();
        field.getElement().setProperty("property", null);
        Assert.assertFalse((boolean)((Boolean)field.getValue()));
        monitor.assertEvent(false, true, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void simpleDateField_constructor_throws() {
        new SimpleDateField();
    }

    @Test
    public void dateField_basicCases() {
        DateField field = new DateField();
        ValueChangeMonitor<LocalDate> monitor = new ValueChangeMonitor<LocalDate>((HasValue<?, LocalDate>)field);
        Assert.assertEquals(null, (Object)field.getValue());
        Assert.assertFalse((boolean)field.getElement().hasProperty("property"));
        monitor.assertNoEvent();
        field.setValue(LocalDate.of(2018, 4, 25));
        Assert.assertEquals((Object)"2018-04-25", (Object)field.getElement().getProperty("property"));
        monitor.assertEvent(false, null, LocalDate.of(2018, 4, 25));
        field.getElement().setProperty("property", "2017-03-24");
        Assert.assertEquals((Object)LocalDate.of(2017, 3, 24), (Object)field.getValue());
        monitor.assertEvent(false, LocalDate.of(2018, 4, 25), LocalDate.of(2017, 3, 24));
        field.getElement().setProperty("property", null);
        Assert.assertEquals(null, (Object)field.getValue());
        monitor.assertEvent(false, LocalDate.of(2017, 3, 24), null);
    }

    @Test
    public void integerToString_basicCases() {
        IntegerToStringField field = new IntegerToStringField();
        ValueChangeMonitor<Integer> monitor = new ValueChangeMonitor<Integer>((HasValue<?, Integer>)field);
        Assert.assertNull((Object)field.getValue());
        field.getElement().setProperty("property", "10");
        Assert.assertEquals((long)10L, (long)((Integer)field.getValue()).intValue());
        monitor.assertEvent(false, null, 10);
        field.getElement().setProperty("property", null);
        Assert.assertNull((Object)field.getValue());
        monitor.assertEvent(false, 10, null);
        field.setValue(20);
        Assert.assertEquals((Object)"20", (Object)field.getElement().getProperty("property"));
        monitor.assertEvent(false, null, 20);
    }

    @Test
    public void integerToString_nonIntegerInput_ignore() {
        IntegerToStringField field = new IntegerToStringField();
        ValueChangeMonitor<Integer> monitor = new ValueChangeMonitor<Integer>((HasValue<?, Integer>)field);
        field.getElement().setProperty("property", "Not a number");
        monitor.assertNoEvent();
        Assert.assertNull((Object)field.getValue());
        Assert.assertEquals((String)"Unparseable should not affect property", (Object)"Not a number", (Object)field.getElement().getProperty("property"));
        field.setValue(10);
        monitor.assertEvent(false, null, 10);
        Assert.assertEquals((String)"setValue should override unparseable property", (Object)"10", (Object)field.getElement().getProperty("property"));
    }

    @Test
    public void radixField() {
        RadixField field = new RadixField();
        ValueChangeMonitor changeMonitor = new ValueChangeMonitor(field);
        field.setValue(20);
        changeMonitor.discard();
        Assert.assertEquals((Object)"20", (Object)field.getElement().getProperty("property"));
        field.setRadix(16);
        changeMonitor.assertNoEvent();
        Assert.assertEquals((Object)"14", (Object)field.getElement().getProperty("property"));
        field.getElement().setProperty("property", "f");
        changeMonitor.discard();
        Assert.assertEquals((long)15L, (long)((Integer)field.getValue()).intValue());
    }

    @Test
    public void jsonField() {
        JsonField field = new JsonField();
        ValueChangeMonitor monitor = new ValueChangeMonitor(field);
        Assert.assertEquals((Object)JsonNodeType.NULL, (Object)((JsonNode)field.getValue()).getNodeType());
        monitor.assertNoEvent();
        field.setValue(JacksonUtils.createArray((JsonNode[])new JsonNode[]{JacksonUtils.createNode((Object)"foo"), JacksonUtils.createNode((Object)42)}));
        monitor.discard();
        Assert.assertEquals((Object)"[\"foo\",42]", (Object)field.getElement().getPropertyRaw("property").toString());
        field.getElement().setPropertyJson("property", (BaseJsonNode)JacksonUtils.createObjectNode());
        monitor.discard();
        Assert.assertEquals((Object)"{}", (Object)((JsonNode)field.getValue()).toString());
        field.getElement().setProperty("property", "text");
        monitor.discard();
        Assert.assertEquals((Object)"\"text\"", (Object)((JsonNode)field.getValue()).toString());
    }

    @Test
    public void jsonArrayField() {
        JsonArrayField field = new JsonArrayField();
        ValueChangeMonitor monitor = new ValueChangeMonitor(field);
        Assert.assertEquals((Object)JsonNodeType.ARRAY, (Object)((ArrayNode)field.getValue()).getNodeType());
        Assert.assertEquals((long)0L, (long)((ArrayNode)field.getValue()).size());
        monitor.assertNoEvent();
        field.setValue(JacksonUtils.createArray((JsonNode[])new JsonNode[]{JacksonUtils.createNode((Object)"foo"), JacksonUtils.createNode((Object)42)}));
        monitor.discard();
        Assert.assertEquals((Object)"[\"foo\",42]", (Object)field.getElement().getPropertyRaw("property").toString());
        field.getElement().setPropertyJson("property", (BaseJsonNode)JacksonUtils.createArray((JsonNode[])new JsonNode[]{JacksonUtils.createNode((Object)37), JacksonUtils.createNode((Object)"bar")}));
        monitor.discard();
        Assert.assertEquals((Object)"[37,\"bar\"]", (Object)((ArrayNode)field.getValue()).toString());
    }

    @Test
    public void noOwnPublicApi() {
        List newPublicMethods = PublicApiAnalyzer.findNewPublicMethods(AbstractSinglePropertyField.class).collect(Collectors.toList());
        Assert.assertEquals(Collections.emptyList(), newPublicMethods);
    }

    @Test
    public void serializable() {
        StringField field = new StringField();
        field.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ignore -> {});
        field.setValue("foo");
        StringField anotherField = (StringField)((Object)SerializationUtils.roundtrip((Serializable)((Object)field)));
        Assert.assertEquals((Object)"foo", (Object)anotherField.getValue());
    }

    @Test
    public void getValue_wrapExistingElement_elementHasProperty_valueIsThePropertyValue() {
        Element element = new Element("tag");
        element.setProperty("property", "foo");
        MockUI ui = new MockUI();
        UI.setCurrent((UI)ui);
        Instantiator instantiator = (Instantiator)Mockito.mock(Instantiator.class);
        MockServletServiceSessionSetup.TestVaadinServletService service = (MockServletServiceSessionSetup.TestVaadinServletService)ui.getSession().getService();
        service.setInstantiator(instantiator);
        Mockito.when((Object)((Object)((StringField)instantiator.createComponent(StringField.class)))).thenAnswer(a -> new StringField());
        StringField field = (StringField)Component.from((Element)element, StringField.class);
        Assert.assertEquals((Object)"foo", (Object)field.getValue());
    }

    @Test
    public void jacksonField() {
        JacksonField field = new JacksonField();
        ValueChangeMonitor monitor = new ValueChangeMonitor(field);
        Assert.assertEquals((Object)JsonNodeType.NULL, (Object)((BaseJsonNode)field.getValue()).getNodeType());
        monitor.assertNoEvent();
        field.setValue(JacksonUtils.createArray((JsonNode[])new JsonNode[]{JacksonUtils.createNode((Object)"foo"), JacksonUtils.createNode((Object)42)}));
        monitor.discard();
        Assert.assertEquals((Object)"[\"foo\",42]", (Object)field.getElement().getPropertyRaw("property").toString());
        field.getElement().setPropertyJson("property", (BaseJsonNode)JacksonUtils.createObjectNode());
        monitor.discard();
        Assert.assertEquals((Object)"{}", (Object)((BaseJsonNode)field.getValue()).toString());
        field.getElement().setProperty("property", "text");
        monitor.discard();
        Assert.assertEquals((Object)"\"text\"", (Object)((BaseJsonNode)field.getValue()).toString());
    }

    @Test
    public void jacksonArrayField() {
        JacksonArrayField field = new JacksonArrayField();
        ValueChangeMonitor monitor = new ValueChangeMonitor(field);
        Assert.assertEquals((Object)JsonNodeType.ARRAY, (Object)((ArrayNode)field.getValue()).getNodeType());
        Assert.assertEquals((long)0L, (long)((ArrayNode)field.getValue()).size());
        monitor.assertNoEvent();
        field.setValue(JacksonUtils.createArray((JsonNode[])new JsonNode[]{JacksonUtils.createNode((Object)"foo"), JacksonUtils.createNode((Object)42)}));
        monitor.discard();
        Assert.assertEquals((Object)"[\"foo\",42]", (Object)field.getElement().getPropertyRaw("property").toString());
        field.getElement().setPropertyJson("property", (BaseJsonNode)JacksonUtils.createArray((JsonNode[])new JsonNode[]{JacksonUtils.createNode((Object)37), JacksonUtils.createNode((Object)"bar")}));
        monitor.discard();
        Assert.assertEquals((Object)"[37,\"bar\"]", (Object)((ArrayNode)field.getValue()).toString());
    }

    @Tag(value="tag")
    public static class StringField
    extends AbstractSinglePropertyField<StringField, String> {
        public StringField(String synchronizedPropertyName) {
            super(synchronizedPropertyName, (Object)"", false);
        }

        public StringField() {
            this("property");
        }

        public void setSynchronizedEvent(String synchronizedEventName) {
            super.setSynchronizedEvent(synchronizedEventName);
        }
    }

    @Tag(value="tag")
    private static class StringNullField
    extends AbstractSinglePropertyField<StringNullField, String> {
        public StringNullField() {
            super("property", null, true);
        }
    }

    @Tag(value="tag")
    private static class DoubleField
    extends AbstractSinglePropertyField<DoubleField, Double> {
        public DoubleField() {
            super("property", (Object)0.0, false);
        }
    }

    @Tag(value="tag")
    private static class IntegerField
    extends AbstractSinglePropertyField<IntegerField, Integer> {
        public IntegerField() {
            super("property", (Object)42, false);
        }
    }

    @Tag(value="tag")
    private static class BooleanField
    extends AbstractSinglePropertyField<BooleanField, Boolean> {
        public BooleanField() {
            super("property", (Object)Boolean.FALSE, false);
        }
    }

    @Tag(value="tag")
    private static class SimpleDateField
    extends AbstractSinglePropertyField<SimpleDateField, LocalDate> {
        public SimpleDateField() {
            super("property", null, true);
        }
    }

    @Tag(value="tag")
    private static class DateField
    extends AbstractSinglePropertyField<DateField, LocalDate> {
        public DateField() {
            super("property", null, String.class, LocalDate::parse, LocalDate::toString);
        }
    }

    @Tag(value="tag")
    private static class IntegerToStringField
    extends AbstractSinglePropertyField<IntegerToStringField, Integer> {
        public IntegerToStringField() {
            super("property", null, String.class, Integer::new, String::valueOf);
        }

        protected boolean hasValidValue() {
            return this.getElement().getProperty("property", "").matches("[0-9]*");
        }
    }

    @Tag(value="tag")
    private static class RadixField
    extends AbstractSinglePropertyField<RadixField, Integer> {
        private int radix = 10;

        public RadixField() {
            super("property", (Object)0, String.class, (SerializableBiFunction & Serializable)(instance, value) -> instance.presentationToModel((String)value), (SerializableBiFunction & Serializable)(instance, value) -> instance.modelToPresentation((Integer)value));
        }

        private Integer presentationToModel(String presentationValue) {
            return Integer.parseInt(presentationValue, this.radix);
        }

        private String modelToPresentation(Integer integer) {
            return Integer.toString(integer, this.radix);
        }

        public void setRadix(int radix) {
            this.radix = radix;
            this.setPresentationValue((Integer)this.getValue());
        }
    }

    @Tag(value="tag")
    private static class JsonField
    extends AbstractSinglePropertyField<JsonField, JsonNode> {
        public JsonField() {
            super("property", (Object)JacksonUtils.nullNode(), false);
        }
    }

    @Tag(value="tag")
    private static class JsonArrayField
    extends AbstractSinglePropertyField<JsonArrayField, ArrayNode> {
        public JsonArrayField() {
            super("property", (Object)JacksonUtils.createArray((JsonNode[])new JsonNode[0]), false);
        }
    }

    @Tag(value="tag")
    private static class JacksonField
    extends AbstractSinglePropertyField<JacksonField, BaseJsonNode> {
        public JacksonField() {
            super("property", (Object)JacksonUtils.nullNode(), false);
        }
    }

    @Tag(value="tag")
    private static class JacksonArrayField
    extends AbstractSinglePropertyField<JacksonArrayField, ArrayNode> {
        public JacksonArrayField() {
            super("property", (Object)JacksonUtils.createArray((JsonNode[])new JsonNode[0]), false);
        }
    }
}

