/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.MockServletServiceSessionSetup;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.rpc.PublishedServerEventHandlerRpcHandler;
import com.vaadin.tests.util.MockUI;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class ClientCallableBeanSupportTest {
    private MockServletServiceSessionSetup mocks;
    private UI ui;
    private PublishedServerEventHandlerRpcHandler handler;

    @Before
    public void setUp() throws Exception {
        this.mocks = new MockServletServiceSessionSetup();
        MockServletServiceSessionSetup.TestVaadinServletService service = this.mocks.getService();
        service.init();
        this.ui = new MockUI();
        VaadinSession.setCurrent((VaadinSession)this.mocks.getSession());
        UI.setCurrent((UI)this.ui);
        this.handler = new PublishedServerEventHandlerRpcHandler();
    }

    @After
    public void tearDown() {
        this.mocks.cleanup();
    }

    @Test
    public void testSimpleBeanParameter() throws Exception {
        ComponentWithClientCallableMethods component = new ComponentWithClientCallableMethods();
        this.ui.add(new Component[]{component});
        ObjectNode beanJson = JacksonUtils.createObjectNode();
        beanJson.put("name", "TestBean");
        beanJson.put("value", 123);
        beanJson.put("active", true);
        ArrayNode params = JacksonUtils.createArrayNode();
        params.add((JsonNode)beanJson);
        PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"handleSimpleBean", (ArrayNode)params, (int)-1);
        SimpleBean received = component.getReceivedBean();
        Assert.assertNotNull((String)"Bean should be received", (Object)received);
        Assert.assertEquals((Object)"TestBean", (Object)received.name);
        Assert.assertEquals((long)123L, (long)received.value);
        Assert.assertTrue((boolean)received.active);
    }

    @Test
    public void testBeanListParameter() throws Exception {
        ComponentWithClientCallableMethods component = new ComponentWithClientCallableMethods();
        this.ui.add(new Component[]{component});
        ArrayNode beanArray = JacksonUtils.createArrayNode();
        ObjectNode bean1 = JacksonUtils.createObjectNode();
        bean1.put("name", "First");
        bean1.put("value", 1);
        bean1.put("active", true);
        beanArray.add((JsonNode)bean1);
        ObjectNode bean2 = JacksonUtils.createObjectNode();
        bean2.put("name", "Second");
        bean2.put("value", 2);
        bean2.put("active", false);
        beanArray.add((JsonNode)bean2);
        ArrayNode params = JacksonUtils.createArrayNode();
        params.add((JsonNode)beanArray);
        PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"handleBeanList", (ArrayNode)params, (int)-1);
        List<SimpleBean> received = component.getReceivedList();
        Assert.assertNotNull((String)"List should be received", received);
        Assert.assertEquals((String)"Should have 2 beans", (long)2L, (long)received.size());
        Assert.assertEquals((Object)"First", (Object)received.get((int)0).name);
        Assert.assertEquals((long)1L, (long)received.get((int)0).value);
        Assert.assertTrue((boolean)received.get((int)0).active);
        Assert.assertEquals((Object)"Second", (Object)received.get((int)1).name);
        Assert.assertEquals((long)2L, (long)received.get((int)1).value);
        Assert.assertFalse((boolean)received.get((int)1).active);
    }

    @Test
    public void testNestedBeanParameter() throws Exception {
        ComponentWithClientCallableMethods component = new ComponentWithClientCallableMethods();
        this.ui.add(new Component[]{component});
        ObjectNode innerBean = JacksonUtils.createObjectNode();
        innerBean.put("name", "InnerBean");
        innerBean.put("value", 456);
        innerBean.put("active", false);
        ObjectNode nestedBean = JacksonUtils.createObjectNode();
        nestedBean.put("title", "OuterBean");
        nestedBean.set("simple", (JsonNode)innerBean);
        ArrayNode params = JacksonUtils.createArrayNode();
        params.add((JsonNode)nestedBean);
        PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"handleNestedBean", (ArrayNode)params, (int)-1);
        NestedBean received = component.getReceivedNestedBean();
        Assert.assertNotNull((String)"Nested bean should be received", (Object)received);
        Assert.assertEquals((Object)"OuterBean", (Object)received.title);
        Assert.assertNotNull((String)"Inner bean should be present", (Object)received.simple);
        Assert.assertEquals((Object)"InnerBean", (Object)received.simple.name);
        Assert.assertEquals((long)456L, (long)received.simple.value);
        Assert.assertFalse((boolean)received.simple.active);
    }

    @Test
    public void testIntegerListParameter() throws Exception {
        ComponentWithClientCallableMethods component = new ComponentWithClientCallableMethods();
        this.ui.add(new Component[]{component});
        ArrayNode intArray = JacksonUtils.createArrayNode();
        intArray.add(10);
        intArray.add(20);
        intArray.add(30);
        ArrayNode params = JacksonUtils.createArrayNode();
        params.add((JsonNode)intArray);
        PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"handleIntegerList", (ArrayNode)params, (int)-1);
        List<Integer> received = component.getReceivedIntegerList();
        Assert.assertNotNull((String)"Integer list should be received", received);
        Assert.assertEquals((String)"Should have 3 integers", (long)3L, (long)received.size());
        Assert.assertEquals((Object)10, (Object)received.get(0));
        Assert.assertEquals((Object)20, (Object)received.get(1));
        Assert.assertEquals((Object)30, (Object)received.get(2));
    }

    @Tag(value="div")
    public static class ComponentWithClientCallableMethods
    extends Component {
        private SimpleBean receivedBean;
        private List<SimpleBean> receivedList;
        private NestedBean receivedNestedBean;
        private List<Integer> receivedIntegerList;

        @ClientCallable
        public void handleSimpleBean(@EventData(value="bean") SimpleBean bean) {
            this.receivedBean = bean;
        }

        @ClientCallable
        public void handleBeanList(@EventData(value="list") List<SimpleBean> list) {
            this.receivedList = list;
        }

        @ClientCallable
        public void handleNestedBean(@EventData(value="nested") NestedBean nested) {
            this.receivedNestedBean = nested;
        }

        @ClientCallable
        public void handleIntegerList(@EventData(value="integers") List<Integer> integers) {
            this.receivedIntegerList = integers;
        }

        @ClientCallable
        public SimpleBean returnSimpleBean() {
            return new SimpleBean("returned", 42, true);
        }

        @ClientCallable
        public List<SimpleBean> returnBeanList() {
            return Arrays.asList(new SimpleBean("first", 1, true), new SimpleBean("second", 2, false));
        }

        @ClientCallable
        public NestedBean returnNestedBean() {
            return new NestedBean("outer", new SimpleBean("inner", 100, false));
        }

        @ClientCallable
        public List<Integer> returnIntegerList() {
            return Arrays.asList(10, 20, 30);
        }

        public SimpleBean getReceivedBean() {
            return this.receivedBean;
        }

        public List<SimpleBean> getReceivedList() {
            return this.receivedList;
        }

        public NestedBean getReceivedNestedBean() {
            return this.receivedNestedBean;
        }

        public List<Integer> getReceivedIntegerList() {
            return this.receivedIntegerList;
        }
    }

    public static class SimpleBean {
        public String name;
        public int value;
        public boolean active;

        public SimpleBean() {
        }

        public SimpleBean(String name, int value, boolean active) {
            this.name = name;
            this.value = value;
            this.active = active;
        }
    }

    public static class NestedBean {
        public String title;
        public SimpleBean simple;

        public NestedBean() {
        }

        public NestedBean(String title, SimpleBean simple) {
            this.title = title;
            this.simple = simple;
        }
    }
}

