/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.DefaultDeploymentConfiguration;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.communication.CommunicationUtil;
import com.vaadin.flow.server.communication.PushAtmosphereHandler;
import com.vaadin.flow.server.communication.PushHandler;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Properties;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class PushAtmosphereHandlerTest {
    private AtmosphereResource resource;
    private AtmosphereRequest request;
    private AtmosphereResponse response;
    private PrintWriter printWriter;
    private PushAtmosphereHandler atmosphereHandler;

    @Before
    public void setup() throws IOException {
        this.request = (AtmosphereRequest)Mockito.mock(AtmosphereRequest.class);
        this.response = (AtmosphereResponse)Mockito.mock(AtmosphereResponse.class);
        this.printWriter = (PrintWriter)Mockito.mock(PrintWriter.class);
        Mockito.when((Object)this.response.getWriter()).thenReturn((Object)this.printWriter);
        this.resource = (AtmosphereResource)Mockito.mock(AtmosphereResource.class);
        Mockito.when((Object)this.resource.getRequest()).thenReturn((Object)this.request);
        Mockito.when((Object)this.resource.getResponse()).thenReturn((Object)this.response);
        Mockito.when((Object)this.resource.uuid()).thenReturn((Object)"1");
        MockVaadinContext context = new MockVaadinContext();
        ApplicationConfiguration config = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        Mockito.when((Object)config.getPropertyNames()).thenReturn(Collections.emptyEnumeration());
        Mockito.when((Object)config.getContext()).thenReturn((Object)context);
        VaadinServletService service = new VaadinServletService(null, (DeploymentConfiguration)new DefaultDeploymentConfiguration(config, this.getClass(), new Properties()));
        PushHandler handler = new PushHandler(service);
        this.atmosphereHandler = new PushAtmosphereHandler();
        this.atmosphereHandler.setPushHandler(handler);
    }

    @Test
    public void writeSessionExpiredAsyncGet() throws Exception {
        this.writeSessionExpiredAsync("GET");
    }

    @Test
    public void writeSessionExpiredAsyncPost() throws Exception {
        this.writeSessionExpiredAsync("POST");
    }

    private void writeSessionExpiredAsync(String httpMethod) throws IOException {
        Mockito.when((Object)this.request.getMethod()).thenReturn((Object)httpMethod);
        this.atmosphereHandler.onRequest(this.resource);
        String responseContent = CommunicationUtil.getStringWhenWriteString(this.printWriter);
        Assert.assertEquals((String)"Invalid response", (Object)"{\"meta\":{\"async\":true,\"sessionExpired\":true}}", (Object)responseContent);
    }
}

