/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.experimental.DisabledFeatureException;
import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.signals.Signal;
import com.vaadin.signals.shared.SharedListSignal;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.tests.util.MockUI;
import java.util.ArrayList;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jcip.annotations.NotThreadSafe;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@NotThreadSafe
public class VaadinServiceSignalsInitializationTest {
    @Before
    @After
    public void clearTestEnvironment() {
        CurrentInstance.clearAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void init_signalsFeatureFlagOff_throwsWhenSignalUsedWithCurrentService() {
        String signalsFeatureFlagKey = "vaadin.experimental." + FeatureFlags.FLOW_FULLSTACK_SIGNALS.getId();
        String signalsFlag = System.getProperty(signalsFeatureFlagKey);
        try {
            System.setProperty(signalsFeatureFlagKey, "false");
            MockVaadinServletService service = new MockVaadinServletService();
            Signal.effect(() -> {});
            VaadinService.setCurrent((VaadinService)service);
            DisabledFeatureException error = (DisabledFeatureException)Assert.assertThrows(DisabledFeatureException.class, () -> Signal.effect(() -> {}));
            Assert.assertTrue((boolean)error.getMessage().contains(FeatureFlags.FLOW_FULLSTACK_SIGNALS.getId()));
        }
        finally {
            if (signalsFlag != null) {
                System.setProperty(signalsFeatureFlagKey, signalsFlag);
            } else {
                System.clearProperty(signalsFeatureFlagKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void init_signalsFeatureFlagOn_flowSignalEnvironmentInitialized() throws InterruptedException, TimeoutException {
        String signalsFeatureFlagKey = "vaadin.experimental." + FeatureFlags.FLOW_FULLSTACK_SIGNALS.getId();
        String signalsFlag = System.getProperty(signalsFeatureFlagKey);
        try {
            record EffectExecution(UI ui, String threadName) {
            }
            EffectExecution execution;
            System.setProperty(signalsFeatureFlagKey, "true");
            MockVaadinServletService service = new MockVaadinServletService();
            VaadinService.setCurrent((VaadinService)service);
            Phaser phaser = new Phaser(1);
            AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service);
            MockUI ui = new MockUI(session);
            Assert.assertSame((Object)((Object)ui), (Object)UI.getCurrent());
            SharedListSignal signal = new SharedListSignal(String.class);
            ArrayList invocations = new ArrayList();
            try {
                Signal.effect(() -> {
                    invocations.add(new EffectExecution(UI.getCurrent(), Thread.currentThread().getName()));
                    signal.value();
                    phaser.arrive();
                });
                phaser.awaitAdvanceInterruptibly(0, 500L, TimeUnit.MILLISECONDS);
                Assert.assertEquals((String)"Expected effect to be executed", (long)1L, (long)invocations.size());
                execution = (EffectExecution)invocations.get(0);
                Assert.assertEquals((String)"Expected UI to not be available during effect execution", null, (Object)execution.ui);
                Assert.assertTrue((String)"Expected effect to be executed in Vaadin Executor thread", (boolean)execution.threadName.startsWith("VaadinTaskExecutor-thread-"));
            }
            finally {
                session.unlock();
                UI.setCurrent(null);
            }
            signal.insertLast((Object)"update");
            phaser.awaitAdvanceInterruptibly(1, 500L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((String)"Expected effect to be executed twice", (long)2L, (long)invocations.size());
            execution = (EffectExecution)invocations.get(1);
            Assert.assertEquals((String)"Expected UI to not be available during effect execution", null, (Object)execution.ui);
            Assert.assertTrue((String)"Expected effect to be executed in Vaadin Executor thread", (boolean)execution.threadName.startsWith("VaadinTaskExecutor-thread-"));
        }
        finally {
            if (signalsFlag != null) {
                System.setProperty(signalsFeatureFlagKey, signalsFlag);
            } else {
                System.clearProperty(signalsFeatureFlagKey);
            }
        }
    }
}

