/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.StreamRegistration;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import jakarta.servlet.ServletException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Optional;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class StreamResourceRegistryTest {
    private UI ui;
    private VaadinServletService service;
    private VaadinSession session;

    @Before
    public void setUp() throws ServletException, ServiceException {
        this.service = new MockVaadinServletService();
        this.session = new VaadinSession((VaadinService)this.service){

            public boolean hasLock() {
                return true;
            }
        };
        this.ui = (UI)Mockito.mock(UI.class);
        Mockito.when((Object)this.ui.getUIId()).thenReturn((Object)1);
        UI.setCurrent((UI)this.ui);
    }

    @After
    public void tearDown() {
        CurrentInstance.clearAll();
    }

    @Test
    public void registerResource_registrationResultCanBeFound() {
        StreamResourceRegistry registry = new StreamResourceRegistry(this.session);
        StreamResource resource = new StreamResource("name", (InputStreamFactory & Serializable)() -> this.makeEmptyStream());
        StreamRegistration registration = registry.registerResource((AbstractStreamResource)resource);
        Assert.assertNotNull((Object)registration);
        URI uri = registration.getResourceUri();
        Optional stored = registry.getResource(StreamResource.class, uri);
        Assert.assertSame((String)"Unexpected stored resource is returned for registered URI", (Object)resource, stored.get());
        Assert.assertSame((String)"Unexpected resource is returned by the registration instance", (Object)resource, (Object)registration.getResource());
    }

    @Test
    public void registerElementResourceHandler_registrationResultCanBeFound() {
        StreamResourceRegistry registry = new StreamResourceRegistry(this.session);
        ElementRequestHandler & Serializable handler = (ElementRequestHandler & Serializable)(request, response, session, owner) -> {};
        Element owner2 = (Element)Mockito.mock(Element.class);
        StreamRegistration registration = registry.registerResource((ElementRequestHandler)handler, owner2);
        Assert.assertNotNull((Object)registration);
        URI uri = registration.getResourceUri();
        AbstractStreamResource generatedResource = registration.getResource();
        Optional stored = registry.getResource(uri);
        Assert.assertSame((String)"Unexpected stored resource is returned for registered URI", (Object)generatedResource, stored.get());
    }

    @Test
    public void unregisterResource_resourceIsRemoved() {
        StreamResourceRegistry registry = new StreamResourceRegistry(this.session);
        StreamResource resource = new StreamResource("name", (InputStreamFactory & Serializable)() -> this.makeEmptyStream());
        StreamRegistration registration = registry.registerResource((AbstractStreamResource)resource);
        Assert.assertNotNull((Object)registration);
        URI uri = registration.getResourceUri();
        registration.unregister();
        Optional stored = registry.getResource(StreamResource.class, uri);
        Assert.assertFalse((String)"Unexpected stored resource is found after unregister()", (boolean)stored.isPresent());
        Assert.assertNull((String)"Unexpected resource is returned by the registration instance", (Object)registration.getResource());
    }

    @Test
    public void unregisterElementResourceHandler_resourceIsRemoved() {
        StreamResourceRegistry registry = new StreamResourceRegistry(this.session);
        ElementRequestHandler & Serializable handler = (ElementRequestHandler & Serializable)(request, response, session, owner) -> {};
        Element owner2 = (Element)Mockito.mock(Element.class);
        StreamRegistration registration = registry.registerResource((ElementRequestHandler)handler, owner2);
        Assert.assertNotNull((Object)registration);
        URI uri = registration.getResourceUri();
        registration.unregister();
        Optional stored = registry.getResource(uri);
        Assert.assertFalse((String)"Unexpected stored resource is found after unregister()", (boolean)stored.isPresent());
        Assert.assertNull((String)"Unexpected resource is returned by the registration instance", (Object)registration.getResource());
    }

    @Test
    public void registerTwoResourcesWithSameName_resourcesHasDifferentURI() {
        StreamResourceRegistry registry = new StreamResourceRegistry(this.session);
        StreamResource resource1 = new StreamResource("name", (InputStreamFactory & Serializable)() -> this.makeEmptyStream());
        StreamRegistration registration1 = registry.registerResource((AbstractStreamResource)resource1);
        StreamResource resource2 = new StreamResource("name", (InputStreamFactory & Serializable)() -> this.makeEmptyStream());
        StreamRegistration registration2 = registry.registerResource((AbstractStreamResource)resource2);
        Assert.assertNotEquals((String)"Two different resource are registered to the same URI", (Object)registration1.getResourceUri(), (Object)registration2.getResourceUri());
        registration1.unregister();
        Assert.assertTrue((String)"Second resource is not found after first resource has been unregistered", (boolean)registry.getResource(registration2.getResourceUri()).isPresent());
    }

    @Test
    public void getResourceUriIsEncoded_withQueryParams() {
        this.assertResourceUriIsEncoded("a?b=c d&e", "a%3Fb%3Dc%20d%26e");
    }

    @Test
    public void getResourceUriIsEncoded_withContainingPlus() {
        this.assertResourceUriIsEncoded("image++.svg", "image%2B%2B.svg");
    }

    @Test
    public void getResourceUriIsEncoded_withSimpleSpace() {
        this.assertResourceUriIsEncoded("my file.png", "my%20file.png");
    }

    private void assertResourceUriIsEncoded(String resourceName, String suffix) {
        StreamResourceRegistry registry = new StreamResourceRegistry(this.session);
        StreamResource resource = new StreamResource(resourceName, this::makeEmptyStream);
        StreamRegistration registration = registry.registerResource((AbstractStreamResource)resource);
        URI uri = registration.getResourceUri();
        Assert.assertTrue((String)"Resource URI is not properly encoded", (boolean)uri.toString().endsWith(suffix));
    }

    private InputStream makeEmptyStream() {
        return new ByteArrayInputStream(new byte[0]);
    }
}

