/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.EmptyChange;
import com.vaadin.flow.internal.change.MapPutChange;
import com.vaadin.flow.internal.nodefeature.BasicTypeValue;
import com.vaadin.flow.internal.nodefeature.NodeValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NodeValueEmptyRequiredFeatureTest {
    private StateNode node;
    private NodeValue<Serializable> nodeValue;

    @Before
    public void setUp() {
        this.node = new StateNode(Arrays.asList(BasicTypeValue.class), new Class[0]){

            public boolean isAttached() {
                return true;
            }
        };
        this.nodeValue = (NodeValue)this.node.getFeature(BasicTypeValue.class);
    }

    @Test
    public void generateChangesFromEmpty_featureHasChangesToCollect() {
        this.nodeValue.generateChangesFromEmpty();
        AtomicReference change = new AtomicReference();
        this.node.collectChanges(change::set);
        Assert.assertTrue((boolean)(change.get() instanceof EmptyChange));
        this.nodeValue.generateChangesFromEmpty();
        change.set(null);
        this.node.collectChanges(change::set);
        Assert.assertNull(change.get());
    }

    @Test
    public void generateChangesFromEmpty_noEmptyChange() {
        this.nodeValue.setValue((Serializable)((Object)"foo"));
        this.node.clearChanges();
        this.nodeValue.generateChangesFromEmpty();
        ArrayList changes = new ArrayList();
        this.node.collectChanges(changes::add);
        Assert.assertEquals((long)1L, (long)changes.size());
        Assert.assertTrue((boolean)(changes.get(0) instanceof MapPutChange));
    }

    @Test
    public void collectChanges_featureHasEmptyChange() {
        this.nodeValue.generateChangesFromEmpty();
        AtomicReference change = new AtomicReference();
        this.nodeValue.collectChanges(change::set);
        Assert.assertTrue((boolean)(change.get() instanceof EmptyChange));
        change.set(null);
        this.nodeValue.collectChanges(change::set);
        Assert.assertNull(change.get());
    }

    @Test
    public void collectChanges_noEmptyChange() {
        this.nodeValue.setValue((Serializable)((Object)"foo"));
        ArrayList changes = new ArrayList();
        this.node.collectChanges(changes::add);
        Assert.assertEquals((long)1L, (long)changes.size());
        Assert.assertTrue((boolean)(changes.get(0) instanceof MapPutChange));
    }
}

