/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.internal.JacksonCodec;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.NumericNode;
import tools.jackson.databind.node.ObjectNode;

public class JacksonCodecTest {
    private static final List<Object> complexTypeValues = Arrays.asList(new Object(), new StateNode(new Class[0]), new Date(), new String[0], new ArrayList(), new HashSet(), new HashMap());
    private static final ObjectMapper objectMapper = new ObjectMapper();

    @Test
    public void encodeWithoutTypeInfo_supportedTypes() {
        JacksonCodecTest.assertJsonEquals(objectMapper.valueToTree((Object)true), JacksonCodec.encodeWithoutTypeInfo((Object)Boolean.TRUE));
        JacksonCodecTest.assertJsonEquals(objectMapper.valueToTree((Object)"string"), JacksonCodec.encodeWithoutTypeInfo((Object)"string"));
        JacksonCodecTest.assertJsonEquals(objectMapper.valueToTree((Object)3.14), JacksonCodec.encodeWithoutTypeInfo((Object)3.14));
        JacksonCodecTest.assertJsonEquals(objectMapper.valueToTree((Object)42), JacksonCodec.encodeWithoutTypeInfo((Object)42));
        JacksonCodecTest.assertJsonEquals(objectMapper.nullNode(), JacksonCodec.encodeWithoutTypeInfo(null));
        ObjectNode json = objectMapper.createObjectNode();
        json.put("foo", "bar");
        JacksonCodecTest.assertJsonEquals((JsonNode)json, JacksonCodec.encodeWithoutTypeInfo((Object)json));
        JacksonCodecTest.assertJsonEquals(objectMapper.nullNode(), objectMapper.nullNode());
        JacksonCodecTest.assertJsonEquals(objectMapper.valueToTree((Object)false), objectMapper.valueToTree((Object)false));
        JacksonCodecTest.assertJsonEquals(objectMapper.valueToTree((Object)234), objectMapper.valueToTree((Object)234));
        JacksonCodecTest.assertJsonEquals(objectMapper.valueToTree((Object)"string"), objectMapper.valueToTree((Object)"string"));
        JacksonCodecTest.assertJsonEquals((JsonNode)json, (JsonNode)json);
        JacksonCodecTest.assertJsonEquals((JsonNode)objectMapper.createArrayNode(), (JsonNode)objectMapper.createArrayNode());
        this.testComplexTypeSerialization();
    }

    @Test
    public void encodeWithoutTypeInfo_unsupportedTypes() {
        ArrayList<Object> unsupported = new ArrayList<Object>(complexTypeValues);
        unsupported.add(ElementFactory.createDiv());
        for (Object e : unsupported) {
            boolean thrown = false;
            try {
                JacksonCodec.encodeWithoutTypeInfo(e);
            }
            catch (AssertionError expected) {
                thrown = true;
            }
            if (thrown) continue;
            Assert.fail((String)("Should throw for " + String.valueOf(e.getClass())));
        }
    }

    @Test
    public void encodeWithTypeInfo_basicTypes() {
        JacksonCodecTest.assertJsonEquals(objectMapper.valueToTree((Object)true), JacksonCodec.encodeWithTypeInfo((Object)Boolean.TRUE));
        JacksonCodecTest.assertJsonEquals(objectMapper.nullNode(), JacksonCodec.encodeWithTypeInfo(null));
        JacksonCodecTest.assertJsonEquals(objectMapper.valueToTree((Object)234), JacksonCodec.encodeWithTypeInfo((Object)objectMapper.valueToTree((Object)234)));
        JacksonCodecTest.assertJsonEquals(objectMapper.valueToTree((Object)"string"), JacksonCodec.encodeWithTypeInfo((Object)objectMapper.valueToTree((Object)"string")));
        JacksonCodecTest.assertJsonEquals((JsonNode)objectMapper.createObjectNode(), JacksonCodec.encodeWithTypeInfo((Object)objectMapper.createObjectNode()));
        JacksonCodecTest.assertJsonEquals((JsonNode)objectMapper.createArrayNode(), JacksonCodec.encodeWithTypeInfo((Object)objectMapper.createArrayNode()));
    }

    @Test
    public void encodeWithTypeInfo_attachedElement() {
        Element element = ElementFactory.createDiv();
        StateTree tree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add(0, element.getNode());
        JsonNode json = JacksonCodec.encodeWithTypeInfo((Object)element);
        ObjectNode expected = objectMapper.createObjectNode();
        expected.put("@v-node", element.getNode().getId());
        JacksonCodecTest.assertJsonEquals((JsonNode)expected, json);
    }

    @Test
    public void encodeWithTypeInfo_detachedElement() {
        Element element = ElementFactory.createDiv();
        JsonNode json = JacksonCodec.encodeWithTypeInfo((Object)element);
        JacksonCodecTest.assertJsonEquals(objectMapper.nullNode(), json);
    }

    private static void assertJsonEquals(JsonNode expected, JsonNode actual) {
        Assert.assertTrue((String)(actual.toString() + " does not equal " + expected.toString()), (boolean)JacksonUtils.jsonEquals((JsonNode)expected, (JsonNode)actual));
    }

    @Test
    public void decodeAs_booleanJson() {
        JsonNode json = objectMapper.valueToTree((Object)true);
        Assert.assertTrue((boolean)((Boolean)JacksonCodec.decodeAs((JsonNode)json, Boolean.class)));
        Assert.assertEquals((Object)json, (Object)JacksonCodec.decodeAs((JsonNode)json, JsonNode.class));
    }

    @Test
    public void decodeAs_stringJson() {
        JsonNode json = objectMapper.valueToTree((Object)"Test123 String\n !%");
        Assert.assertEquals((Object)"Test123 String\n !%", (Object)JacksonCodec.decodeAs((JsonNode)json, String.class));
        Assert.assertEquals((Object)json, (Object)JacksonCodec.decodeAs((JsonNode)json, JsonNode.class));
    }

    @Test
    public void decodeAs_numberJson() {
        JsonNode intJson = objectMapper.valueToTree((Object)15);
        Assert.assertEquals((Object)15, (Object)JacksonCodec.decodeAs((JsonNode)intJson, Integer.class));
        Assert.assertEquals((Object)15.0, (Object)JacksonCodec.decodeAs((JsonNode)intJson, Double.class));
        JsonNode doubleJson = objectMapper.valueToTree((Object)15.7);
        Assert.assertEquals((Object)15.7, (Object)JacksonCodec.decodeAs((JsonNode)doubleJson, Double.class));
        Assert.assertEquals((Object)doubleJson, (Object)JacksonCodec.decodeAs((JsonNode)doubleJson, JsonNode.class));
    }

    @Test
    public void decodeAs_nullJson() {
        JsonNode json = objectMapper.nullNode();
        Assert.assertNull((Object)JacksonCodec.decodeAs((JsonNode)json, Boolean.class));
        Assert.assertNull((Object)JacksonCodec.decodeAs((JsonNode)json, String.class));
        Assert.assertNull((Object)JacksonCodec.decodeAs((JsonNode)json, Integer.class));
        Assert.assertNull((Object)JacksonCodec.decodeAs((JsonNode)json, Double.class));
        Assert.assertNull((Object)JacksonCodec.decodeAs((JsonNode)json, JsonNode.class));
    }

    @Test
    public void decodeAs_jsonValue() {
        ObjectNode json = objectMapper.createObjectNode();
        json.put("foo", "bar");
        Assert.assertEquals((Object)json, (Object)JacksonCodec.decodeAs((JsonNode)json, JsonNode.class));
    }

    @Test(expected=ClassCastException.class)
    public void decodeAs_jsonValueWrongType_classCastException() {
        ObjectNode json = objectMapper.createObjectNode();
        json.put("foo", "bar");
        JacksonCodec.decodeAs((JsonNode)json, NumericNode.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void decodeAs_unsupportedType() {
        Assert.assertNull((Object)JacksonCodec.decodeAs((JsonNode)objectMapper.valueToTree((Object)"foo"), Float.TYPE));
    }

    @Test
    public void testSimpleBeanSerialization() {
        SimpleBean bean = new SimpleBean("Test", 42);
        JsonNode encoded = JacksonCodec.encodeWithTypeInfo((Object)bean);
        Assert.assertTrue((String)"Should be object", (boolean)encoded.isObject());
        Assert.assertEquals((Object)"Test", (Object)encoded.get("text").asString());
        Assert.assertEquals((long)42L, (long)encoded.get("value").asInt());
    }

    @Test
    public void testNestedBeanSerialization() {
        NestedBean nested = new NestedBean("inner", 123);
        OuterBean outer = new OuterBean("outer", nested);
        JsonNode encoded = JacksonCodec.encodeWithTypeInfo((Object)outer);
        Assert.assertTrue((String)"Should be object", (boolean)encoded.isObject());
        Assert.assertEquals((Object)"outer", (Object)encoded.get("name").asString());
        JsonNode nestedJson = encoded.get("nested");
        Assert.assertEquals((Object)"inner", (Object)nestedJson.get("text").asString());
        Assert.assertEquals((long)123L, (long)nestedJson.get("number").asInt());
    }

    @Test
    public void testComplexTypeSerialization() {
        Object obj = new Object();
        JsonNode objEncoded = JacksonCodec.encodeWithTypeInfo((Object)obj);
        Assert.assertTrue((String)"Object should serialize as JSON object", (boolean)objEncoded.isObject());
        Assert.assertEquals((String)"Object should serialize as empty object", (long)0L, (long)objEncoded.size());
        StateNode stateNode = new StateNode(new Class[0]);
        JsonNode stateNodeEncoded = JacksonCodec.encodeWithTypeInfo((Object)stateNode);
        Assert.assertTrue((String)"StateNode should serialize as JSON object", (boolean)stateNodeEncoded.isObject());
        Assert.assertTrue((String)"StateNode should have properties", (stateNodeEncoded.size() > 0 ? 1 : 0) != 0);
        Date date = new Date(1234567890000L);
        JsonNode dateEncoded = JacksonCodec.encodeWithTypeInfo((Object)date);
        Assert.assertTrue((String)"Date should serialize as number or string", (dateEncoded.isNumber() || dateEncoded.isTextual() ? 1 : 0) != 0);
        if (dateEncoded.isNumber()) {
            Assert.assertEquals((String)"Date should serialize to correct timestamp", (long)1234567890000L, (long)dateEncoded.asLong());
        }
        String[] stringArray = new String[]{"hello", "world"};
        JsonNode arrayEncoded = JacksonCodec.encodeWithTypeInfo((Object)stringArray);
        Assert.assertTrue((String)"String array should serialize as JSON array", (boolean)arrayEncoded.isArray());
        Assert.assertEquals((String)"Array should have correct length", (long)2L, (long)arrayEncoded.size());
        Assert.assertEquals((String)"First element should be correct", (Object)"hello", (Object)arrayEncoded.get(0).asString());
        Assert.assertEquals((String)"Second element should be correct", (Object)"world", (Object)arrayEncoded.get(1).asString());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("item1");
        arrayList.add("item2");
        JsonNode listEncoded = JacksonCodec.encodeWithTypeInfo(arrayList);
        Assert.assertTrue((String)"ArrayList should serialize as JSON array", (boolean)listEncoded.isArray());
        Assert.assertEquals((String)"List should have correct size", (long)2L, (long)listEncoded.size());
        Assert.assertEquals((String)"First list item should be correct", (Object)"item1", (Object)listEncoded.get(0).asString());
        Assert.assertEquals((String)"Second list item should be correct", (Object)"item2", (Object)listEncoded.get(1).asString());
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("value1");
        hashSet.add("value2");
        JsonNode setEncoded = JacksonCodec.encodeWithTypeInfo(hashSet);
        Assert.assertTrue((String)"HashSet should serialize as JSON array", (boolean)setEncoded.isArray());
        Assert.assertEquals((String)"Set should have correct size", (long)2L, (long)setEncoded.size());
        boolean hasValue1 = false;
        boolean hasValue2 = false;
        for (JsonNode node : setEncoded) {
            String value = node.asString();
            if ("value1".equals(value)) {
                hasValue1 = true;
            }
            if (!"value2".equals(value)) continue;
            hasValue2 = true;
        }
        Assert.assertTrue((String)"Set should contain value1", (boolean)hasValue1);
        Assert.assertTrue((String)"Set should contain value2", (boolean)hasValue2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("key1", "stringValue");
        hashMap.put("key2", 42);
        hashMap.put("key3", true);
        JsonNode mapEncoded = JacksonCodec.encodeWithTypeInfo(hashMap);
        Assert.assertTrue((String)"HashMap should serialize as JSON object", (boolean)mapEncoded.isObject());
        Assert.assertEquals((String)"Map should have correct size", (long)3L, (long)mapEncoded.size());
        Assert.assertEquals((String)"String value should be correct", (Object)"stringValue", (Object)mapEncoded.get("key1").asString());
        Assert.assertEquals((String)"Integer value should be correct", (long)42L, (long)mapEncoded.get("key2").asInt());
        Assert.assertEquals((String)"Boolean value should be correct", (Object)true, (Object)mapEncoded.get("key3").asBoolean());
    }

    @Test
    public void testDecodeAsSimpleBean() {
        ObjectNode json = objectMapper.createObjectNode();
        json.put("text", "TestBean");
        json.put("value", 42);
        SimpleBean decoded = (SimpleBean)JacksonCodec.decodeAs((JsonNode)json, SimpleBean.class);
        Assert.assertEquals((Object)"TestBean", (Object)decoded.text);
        Assert.assertEquals((long)42L, (long)decoded.value);
    }

    @Test
    public void testDecodeAsNestedBean() {
        ObjectNode nestedJson = objectMapper.createObjectNode();
        nestedJson.put("text", "NestedTest");
        nestedJson.put("number", 456);
        ObjectNode outerJson = objectMapper.createObjectNode();
        outerJson.put("name", "OuterTest");
        outerJson.set("nested", (JsonNode)nestedJson);
        OuterBean decoded = (OuterBean)JacksonCodec.decodeAs((JsonNode)outerJson, OuterBean.class);
        Assert.assertEquals((Object)"OuterTest", (Object)decoded.name);
        Assert.assertEquals((Object)"NestedTest", (Object)decoded.nested.text);
        Assert.assertEquals((long)456L, (long)decoded.nested.number);
    }

    @Test
    public void testDecodeAsNullValue() {
        JsonNode nullNode = objectMapper.nullNode();
        SimpleBean decoded = (SimpleBean)JacksonCodec.decodeAs((JsonNode)nullNode, SimpleBean.class);
        Assert.assertNull((Object)decoded);
    }

    @Test
    public void testDecodeAsInvalidJson() {
        JsonNode invalidJson = objectMapper.valueToTree((Object)"not an object");
        try {
            JacksonCodec.decodeAs((JsonNode)invalidJson, SimpleBean.class);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot deserialize JSON to type"));
        }
    }

    @Test
    public void testDecodeAsForPrimitiveTypes() {
        Assert.assertEquals((Object)"test", (Object)JacksonCodec.decodeAs((JsonNode)objectMapper.valueToTree((Object)"test"), String.class));
        Assert.assertEquals((Object)42, (Object)JacksonCodec.decodeAs((JsonNode)objectMapper.valueToTree((Object)42), Integer.class));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)JacksonCodec.decodeAs((JsonNode)objectMapper.valueToTree((Object)true), Boolean.class));
        Assert.assertEquals((Object)3.14, (Object)JacksonCodec.decodeAs((JsonNode)objectMapper.valueToTree((Object)3.14), Double.class));
    }

    @Test
    public void testListOfBeansSerialization() {
        List<SimpleBean> beanList = Arrays.asList(new SimpleBean("First", 1), new SimpleBean("Second", 2), new SimpleBean("Third", 3));
        JsonNode encoded = JacksonCodec.encodeWithTypeInfo(beanList);
        Assert.assertTrue((String)"Should be array", (boolean)encoded.isArray());
        Assert.assertEquals((String)"Should have 3 beans", (long)3L, (long)encoded.size());
        Assert.assertEquals((Object)"First", (Object)encoded.get(0).get("text").asString());
        Assert.assertEquals((long)1L, (long)encoded.get(0).get("value").asInt());
        Assert.assertEquals((Object)"Second", (Object)encoded.get(1).get("text").asString());
        Assert.assertEquals((long)2L, (long)encoded.get(1).get("value").asInt());
        Assert.assertEquals((Object)"Third", (Object)encoded.get(2).get("text").asString());
        Assert.assertEquals((long)3L, (long)encoded.get(2).get("value").asInt());
    }

    @Test
    public void testListOfBeansDeserialization() {
        ObjectNode bean1 = objectMapper.createObjectNode();
        bean1.put("text", "FirstBean");
        bean1.put("value", 100);
        ObjectNode bean2 = objectMapper.createObjectNode();
        bean2.put("text", "SecondBean");
        bean2.put("value", 200);
        ArrayNode arrayJson = objectMapper.createArrayNode().add((JsonNode)bean1).add((JsonNode)bean2);
        List decoded = (List)JacksonUtils.getMapper().convertValue((Object)arrayJson, (JavaType)JacksonUtils.getMapper().getTypeFactory().constructCollectionType(List.class, SimpleBean.class));
        Assert.assertEquals((String)"Should have 2 elements", (long)2L, (long)decoded.size());
        Assert.assertEquals((Object)"FirstBean", (Object)((SimpleBean)decoded.get((int)0)).text);
        Assert.assertEquals((long)100L, (long)((SimpleBean)decoded.get((int)0)).value);
        Assert.assertEquals((Object)"SecondBean", (Object)((SimpleBean)decoded.get((int)1)).text);
        Assert.assertEquals((long)200L, (long)((SimpleBean)decoded.get((int)1)).value);
    }

    @Test
    public void testSetOfBeansSerialization() {
        HashSet<SimpleBean> beanSet = new HashSet<SimpleBean>(Arrays.asList(new SimpleBean("Alpha", 10), new SimpleBean("Beta", 20)));
        JsonNode encoded = JacksonCodec.encodeWithTypeInfo(beanSet);
        Assert.assertTrue((String)"Should be array", (boolean)encoded.isArray());
        Assert.assertEquals((String)"Should have 2 elements", (long)2L, (long)encoded.size());
        HashSet<String> texts = new HashSet<String>();
        HashSet<Integer> values = new HashSet<Integer>();
        for (JsonNode node : encoded) {
            texts.add(node.get("text").asString());
            values.add(node.get("value").asInt());
        }
        Assert.assertTrue((String)"Should contain Alpha", (boolean)texts.contains("Alpha"));
        Assert.assertTrue((String)"Should contain Beta", (boolean)texts.contains("Beta"));
        Assert.assertTrue((String)"Should contain value 10", (boolean)values.contains(10));
        Assert.assertTrue((String)"Should contain value 20", (boolean)values.contains(20));
    }

    @Test
    public void testSetOfBeansDeserialization() {
        ObjectNode bean1 = objectMapper.createObjectNode();
        bean1.put("text", "Gamma");
        bean1.put("value", 300);
        ObjectNode bean2 = objectMapper.createObjectNode();
        bean2.put("text", "Delta");
        bean2.put("value", 400);
        ArrayNode arrayJson = objectMapper.createArrayNode().add((JsonNode)bean1).add((JsonNode)bean2);
        Set decoded = (Set)JacksonUtils.getMapper().convertValue((Object)arrayJson, (JavaType)JacksonUtils.getMapper().getTypeFactory().constructCollectionType(Set.class, SimpleBean.class));
        Assert.assertEquals((String)"Should have 2 elements", (long)2L, (long)decoded.size());
        Set texts = decoded.stream().map(b -> b.text).collect(Collectors.toSet());
        Set values = decoded.stream().map(b -> b.value).collect(Collectors.toSet());
        Assert.assertTrue((String)"Should contain Gamma", (boolean)texts.contains("Gamma"));
        Assert.assertTrue((String)"Should contain Delta", (boolean)texts.contains("Delta"));
        Assert.assertTrue((String)"Should contain value 300", (boolean)values.contains(300));
        Assert.assertTrue((String)"Should contain value 400", (boolean)values.contains(400));
    }

    @Test
    public void testListOfIntegersSerialization() {
        List<Integer> integerList = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
        JsonNode encoded = JacksonCodec.encodeWithTypeInfo(integerList);
        Assert.assertTrue((String)"Should be array", (boolean)encoded.isArray());
        Assert.assertEquals((String)"Should have 3 integers", (long)3L, (long)encoded.size());
        Assert.assertEquals((long)1L, (long)encoded.get(0).asInt());
        Assert.assertEquals((long)2L, (long)encoded.get(1).asInt());
        Assert.assertEquals((long)3L, (long)encoded.get(2).asInt());
    }

    @Test
    public void testMapOfBeansSerialization() {
        HashMap<String, SimpleBean> beanMap = new HashMap<String, SimpleBean>();
        beanMap.put("first", new SimpleBean("FirstBean", 100));
        beanMap.put("second", new SimpleBean("SecondBean", 200));
        beanMap.put("third", new SimpleBean("ThirdBean", 300));
        JsonNode encoded = JacksonCodec.encodeWithTypeInfo(beanMap);
        Assert.assertTrue((String)"Should be object", (boolean)encoded.isObject());
        Assert.assertEquals((String)"Should have 3 entries", (long)3L, (long)encoded.size());
        Assert.assertEquals((Object)"FirstBean", (Object)encoded.get("first").get("text").asString());
        Assert.assertEquals((long)100L, (long)encoded.get("first").get("value").asInt());
        Assert.assertEquals((Object)"SecondBean", (Object)encoded.get("second").get("text").asString());
        Assert.assertEquals((long)200L, (long)encoded.get("second").get("value").asInt());
        Assert.assertEquals((Object)"ThirdBean", (Object)encoded.get("third").get("text").asString());
        Assert.assertEquals((long)300L, (long)encoded.get("third").get("value").asInt());
    }

    @Test
    public void testMapOfBeansDeserialization() {
        ObjectNode bean1 = objectMapper.createObjectNode();
        bean1.put("text", "Alpha");
        bean1.put("value", 111);
        ObjectNode bean2 = objectMapper.createObjectNode();
        bean2.put("text", "Beta");
        bean2.put("value", 222);
        ObjectNode mapJson = objectMapper.createObjectNode();
        mapJson.set("keyA", (JsonNode)bean1);
        mapJson.set("keyB", (JsonNode)bean2);
        Map decoded = (Map)JacksonUtils.getMapper().convertValue((Object)mapJson, (JavaType)JacksonUtils.getMapper().getTypeFactory().constructMapType(Map.class, String.class, SimpleBean.class));
        Assert.assertEquals((String)"Should have 2 entries", (long)2L, (long)decoded.size());
        Assert.assertNotNull((String)"Should have keyA", decoded.get("keyA"));
        Assert.assertEquals((Object)"Alpha", (Object)((SimpleBean)decoded.get((Object)"keyA")).text);
        Assert.assertEquals((long)111L, (long)((SimpleBean)decoded.get((Object)"keyA")).value);
        Assert.assertNotNull((String)"Should have keyB", decoded.get("keyB"));
        Assert.assertEquals((Object)"Beta", (Object)((SimpleBean)decoded.get((Object)"keyB")).text);
        Assert.assertEquals((long)222L, (long)((SimpleBean)decoded.get((Object)"keyB")).value);
    }

    @Test
    public void testNestedMapSerialization() {
        HashMap<String, Object> nestedMap = new HashMap<String, Object>();
        nestedMap.put("bean", new SimpleBean("NestedBean", 999));
        nestedMap.put("number", 42);
        nestedMap.put("text", "Hello");
        HashMap<String, Object> outerMap = new HashMap<String, Object>();
        outerMap.put("nested", nestedMap);
        outerMap.put("simple", "value");
        JsonNode encoded = JacksonCodec.encodeWithTypeInfo(outerMap);
        Assert.assertTrue((String)"Should be object", (boolean)encoded.isObject());
        Assert.assertEquals((String)"Should have 2 entries", (long)2L, (long)encoded.size());
        Assert.assertEquals((Object)"value", (Object)encoded.get("simple").asString());
        JsonNode nestedJson = encoded.get("nested");
        Assert.assertTrue((String)"Nested should be object", (boolean)nestedJson.isObject());
        Assert.assertEquals((long)42L, (long)nestedJson.get("number").asInt());
        Assert.assertEquals((Object)"Hello", (Object)nestedJson.get("text").asString());
        Assert.assertEquals((Object)"NestedBean", (Object)nestedJson.get("bean").get("text").asString());
        Assert.assertEquals((long)999L, (long)nestedJson.get("bean").get("value").asInt());
    }

    @Test
    public void testListOfComponentElementsSerialization() {
        Element element1 = ElementFactory.createDiv();
        Element element2 = ElementFactory.createDiv();
        StateTree tree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add(0, element1.getNode());
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add(1, element2.getNode());
        List<Element> elementList = Arrays.asList(element1, element2);
        JsonNode listEncoded = JacksonCodec.encodeWithTypeInfo(elementList);
        Assert.assertTrue((String)"Should be array", (boolean)listEncoded.isArray());
        Assert.assertEquals((String)"Should have 2 elements", (long)2L, (long)listEncoded.size());
        JsonNode element1Json = listEncoded.get(0);
        Assert.assertTrue((String)"First element should be object", (boolean)element1Json.isObject());
        Assert.assertTrue((String)"First element should have @v-node", (boolean)element1Json.has("@v-node"));
        Assert.assertEquals((long)element1.getNode().getId(), (long)element1Json.get("@v-node").asInt());
        JsonNode element2Json = listEncoded.get(1);
        Assert.assertTrue((String)"Second element should be object", (boolean)element2Json.isObject());
        Assert.assertTrue((String)"Second element should have @v-node", (boolean)element2Json.has("@v-node"));
        Assert.assertEquals((long)element2.getNode().getId(), (long)element2Json.get("@v-node").asInt());
    }

    @Test
    public void testBeanWithComponentSerialization() {
        TestComponent component = new TestComponent();
        BeanWithComponent bean = new BeanWithComponent("TestComponent", component, 42);
        List<BeanWithComponent> beanList = Arrays.asList(bean);
        JsonNode listEncoded = JacksonCodec.encodeWithTypeInfo(beanList);
        Assert.assertTrue((String)"Should be array", (boolean)listEncoded.isArray());
        Assert.assertEquals((String)"Should have 1 bean", (long)1L, (long)listEncoded.size());
        JsonNode beanJson = listEncoded.get(0);
        Assert.assertTrue((String)"Bean should serialize as object", (boolean)beanJson.isObject());
        Assert.assertEquals((Object)"TestComponent", (Object)beanJson.get("name").asString());
        Assert.assertEquals((long)42L, (long)beanJson.get("value").asInt());
        Assert.assertTrue((String)"Bean should have component field", (boolean)beanJson.has("component"));
        JsonNode componentJson = beanJson.get("component");
        Assert.assertTrue((String)"Detached component should serialize as null", (boolean)componentJson.isNull());
    }

    @Test
    public void testArrayWithComponentsSerialization() {
        TestComponent component1 = new TestComponent();
        TestComponent component2 = new TestComponent();
        TestComponent[] componentArray = new TestComponent[]{component1, component2};
        JsonNode encoded = JacksonCodec.encodeWithTypeInfo((Object)componentArray);
        Assert.assertTrue((String)"Should be array", (boolean)encoded.isArray());
        Assert.assertEquals((String)"Should have 2 components", (long)2L, (long)encoded.size());
        JsonNode first = encoded.get(0);
        Assert.assertTrue((String)"First detached component should be null", (boolean)first.isNull());
        JsonNode second = encoded.get(1);
        Assert.assertTrue((String)"Second detached component should be null", (boolean)second.isNull());
    }

    @Test
    public void testListOfBeansWithComponentsSerialization() {
        TestComponent component1 = new TestComponent();
        TestComponent component2 = new TestComponent();
        List<BeanWithComponent> beanList = Arrays.asList(new BeanWithComponent("First", component1, 10), new BeanWithComponent("Second", component2, 20));
        JsonNode encoded = JacksonCodec.encodeWithTypeInfo(beanList);
        Assert.assertTrue((String)"Should be array", (boolean)encoded.isArray());
        Assert.assertEquals((String)"Should have 2 beans", (long)2L, (long)encoded.size());
        JsonNode firstBean = encoded.get(0);
        Assert.assertEquals((Object)"First", (Object)firstBean.get("name").asString());
        Assert.assertEquals((long)10L, (long)firstBean.get("value").asInt());
        Assert.assertTrue((String)"First bean should have component", (boolean)firstBean.has("component"));
        JsonNode firstComponent = firstBean.get("component");
        Assert.assertTrue((String)"First detached component should be null", (boolean)firstComponent.isNull());
        JsonNode secondBean = encoded.get(1);
        Assert.assertEquals((Object)"Second", (Object)secondBean.get("name").asString());
        Assert.assertEquals((long)20L, (long)secondBean.get("value").asInt());
        Assert.assertTrue((String)"Second bean should have component", (boolean)secondBean.has("component"));
        JsonNode secondComponent = secondBean.get("component");
        Assert.assertTrue((String)"Second detached component should be null", (boolean)secondComponent.isNull());
    }

    @Test
    public void testTypeReferenceListDeserialization() {
        ObjectNode bean1 = objectMapper.createObjectNode();
        bean1.put("text", "FirstBean");
        bean1.put("value", 100);
        ObjectNode bean2 = objectMapper.createObjectNode();
        bean2.put("text", "SecondBean");
        bean2.put("value", 200);
        ArrayNode arrayJson = objectMapper.createArrayNode().add((JsonNode)bean1).add((JsonNode)bean2);
        TypeReference<List<SimpleBean>> typeRef = new TypeReference<List<SimpleBean>>(this){};
        List result = (List)JacksonCodec.decodeAs((JsonNode)arrayJson, (TypeReference)typeRef);
        Assert.assertNotNull((String)"Result should not be null", (Object)result);
        Assert.assertEquals((String)"Should have 2 elements", (long)2L, (long)result.size());
        Assert.assertEquals((Object)"FirstBean", (Object)((SimpleBean)result.get((int)0)).text);
        Assert.assertEquals((long)100L, (long)((SimpleBean)result.get((int)0)).value);
        Assert.assertEquals((Object)"SecondBean", (Object)((SimpleBean)result.get((int)1)).text);
        Assert.assertEquals((long)200L, (long)((SimpleBean)result.get((int)1)).value);
    }

    @Test
    public void testTypeReferenceMapDeserialization() {
        ObjectNode bean1 = objectMapper.createObjectNode();
        bean1.put("text", "Alpha");
        bean1.put("value", 111);
        ObjectNode bean2 = objectMapper.createObjectNode();
        bean2.put("text", "Beta");
        bean2.put("value", 222);
        ObjectNode mapJson = objectMapper.createObjectNode();
        mapJson.set("keyA", (JsonNode)bean1);
        mapJson.set("keyB", (JsonNode)bean2);
        TypeReference<Map<String, SimpleBean>> typeRef = new TypeReference<Map<String, SimpleBean>>(this){};
        Map result = (Map)JacksonCodec.decodeAs((JsonNode)mapJson, (TypeReference)typeRef);
        Assert.assertNotNull((String)"Result should not be null", (Object)result);
        Assert.assertEquals((String)"Should have 2 entries", (long)2L, (long)result.size());
        Assert.assertEquals((Object)"Alpha", (Object)((SimpleBean)result.get((Object)"keyA")).text);
        Assert.assertEquals((long)111L, (long)((SimpleBean)result.get((Object)"keyA")).value);
        Assert.assertEquals((Object)"Beta", (Object)((SimpleBean)result.get((Object)"keyB")).text);
        Assert.assertEquals((long)222L, (long)((SimpleBean)result.get((Object)"keyB")).value);
    }

    @Test
    public void testTypeReferenceNestedList() {
        ObjectNode innerBean = objectMapper.createObjectNode();
        innerBean.put("text", "Nested");
        innerBean.put("value", 999);
        ObjectNode innerMap = objectMapper.createObjectNode();
        innerMap.set("item", (JsonNode)innerBean);
        ArrayNode outerArray = objectMapper.createArrayNode().add((JsonNode)innerMap);
        TypeReference<List<Map<String, SimpleBean>>> typeRef = new TypeReference<List<Map<String, SimpleBean>>>(this){};
        List result = (List)JacksonCodec.decodeAs((JsonNode)outerArray, (TypeReference)typeRef);
        Assert.assertNotNull((String)"Result should not be null", (Object)result);
        Assert.assertEquals((String)"Should have 1 element", (long)1L, (long)result.size());
        Assert.assertTrue((String)"First element should have 'item' key", (boolean)((Map)result.get(0)).containsKey("item"));
        Assert.assertEquals((Object)"Nested", (Object)((SimpleBean)((Map)result.get((int)0)).get((Object)"item")).text);
        Assert.assertEquals((long)999L, (long)((SimpleBean)((Map)result.get((int)0)).get((Object)"item")).value);
    }

    @Test
    public void testTypeReferenceNullHandling() {
        JsonNode nullJson = objectMapper.nullNode();
        TypeReference<List<SimpleBean>> typeRef = new TypeReference<List<SimpleBean>>(this){};
        List result = (List)JacksonCodec.decodeAs((JsonNode)nullJson, (TypeReference)typeRef);
        Assert.assertNull((String)"Null JSON should deserialize to null", (Object)result);
    }

    @Test
    public void testTypeReferenceListOfPrimitives() {
        ArrayNode arrayJson = objectMapper.createArrayNode().add(10).add(20).add(30);
        TypeReference<List<Integer>> typeRef = new TypeReference<List<Integer>>(this){};
        List result = (List)JacksonCodec.decodeAs((JsonNode)arrayJson, (TypeReference)typeRef);
        Assert.assertNotNull((String)"Result should not be null", (Object)result);
        Assert.assertEquals((String)"Should have 3 elements", (long)3L, (long)result.size());
        Assert.assertEquals((Object)10, result.get(0));
        Assert.assertEquals((Object)20, result.get(1));
        Assert.assertEquals((Object)30, result.get(2));
    }

    @Test
    public void testNestedRecordDeserialization() {
        ObjectNode eventNode = objectMapper.createObjectNode();
        eventNode.put("button", 0);
        eventNode.put("clientX", 150);
        eventNode.put("clientY", 200);
        ObjectNode rootNode = objectMapper.createObjectNode();
        rootNode.set("event", (JsonNode)eventNode);
        rootNode.put("type", "click");
        record MouseEventData(EventDetails event, String type) {
            private final EventDetails event;

            MouseEventData {
                record EventDetails(int button, int clientX, int clientY) {
                }
            }

            public EventDetails event() {
                return this.event;
            }
        }
        MouseEventData result = (MouseEventData)JacksonCodec.decodeAs((JsonNode)rootNode, MouseEventData.class);
        Assert.assertNotNull((String)"Result should not be null", (Object)result);
        Assert.assertEquals((String)"Type should match", (Object)"click", (Object)result.type());
        Assert.assertNotNull((String)"Event should not be null", (Object)result.event());
        Assert.assertEquals((String)"Button should be 0", (long)0L, (long)result.event().button());
        Assert.assertEquals((String)"ClientX should be 150", (long)150L, (long)result.event().clientX());
        Assert.assertEquals((String)"ClientY should be 200", (long)200L, (long)result.event().clientY());
    }

    @Test
    public void testNestedRecordWithTypeReference() {
        ObjectNode point1 = objectMapper.createObjectNode();
        point1.put("x", 10);
        point1.put("y", 20);
        ObjectNode point2 = objectMapper.createObjectNode();
        point2.put("x", 30);
        point2.put("y", 40);
        ArrayNode arrayJson = objectMapper.createArrayNode().add((JsonNode)point1).add((JsonNode)point2);
        TypeReference<List<Point>> typeRef = new TypeReference<List<Point>>(this){};
        List result = (List)JacksonCodec.decodeAs((JsonNode)arrayJson, (TypeReference)typeRef);
        Assert.assertNotNull((String)"Result should not be null", (Object)result);
        Assert.assertEquals((String)"Should have 2 points", (long)2L, (long)result.size());
        record Point(int x, int y) {
        }
        Assert.assertEquals((long)10L, (long)((Point)result.get(0)).x());
        Assert.assertEquals((long)20L, (long)((Point)result.get(0)).y());
        Assert.assertEquals((long)30L, (long)((Point)result.get(1)).x());
        Assert.assertEquals((long)40L, (long)((Point)result.get(1)).y());
    }

    private static class SimpleBean {
        public String text;
        public int value;

        public SimpleBean() {
        }

        public SimpleBean(String text, int value) {
            this.text = text;
            this.value = value;
        }
    }

    private static class NestedBean {
        public String text;
        public int number;

        public NestedBean() {
        }

        public NestedBean(String text, int number) {
            this.text = text;
            this.number = number;
        }
    }

    private static class OuterBean {
        public String name;
        public NestedBean nested;

        public OuterBean() {
        }

        public OuterBean(String name, NestedBean nested) {
            this.name = name;
            this.nested = nested;
        }
    }

    public static class TestComponent
    extends Component {
        public TestComponent() {
            super(ElementFactory.createDiv());
        }
    }

    public static class BeanWithComponent {
        public String name;
        public TestComponent component;
        public int value;

        public BeanWithComponent() {
        }

        public BeanWithComponent(String name, TestComponent component, int value) {
            this.name = name;
            this.component = component;
            this.value = value;
        }
    }
}

