/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.nodefeature.TextBindingFeature;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.signals.BindingActiveException;
import com.vaadin.signals.Signal;
import com.vaadin.signals.local.ValueSignal;
import com.vaadin.tests.util.MockUI;
import java.util.LinkedList;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class ElementBindTextTest {
    private static MockVaadinServletService service;
    private MockedStatic<FeatureFlags> featureFlagStaticMock;
    private LinkedList<ErrorEvent> events;

    @BeforeClass
    public static void init() {
        MockedStatic featureFlagStaticMock = Mockito.mockStatic(FeatureFlags.class);
        ElementBindTextTest.featureFlagEnabled((MockedStatic<FeatureFlags>)featureFlagStaticMock);
        service = new MockVaadinServletService();
        ElementBindTextTest.close((MockedStatic<FeatureFlags>)featureFlagStaticMock);
    }

    @AfterClass
    public static void clean() {
        CurrentInstance.clearAll();
        service.destroy();
    }

    @Before
    public void before() {
        this.featureFlagStaticMock = Mockito.mockStatic(FeatureFlags.class);
        ElementBindTextTest.featureFlagEnabled(this.featureFlagStaticMock);
        this.events = this.mockLockedSessionWithErrorHandler();
    }

    @After
    public void after() {
        ElementBindTextTest.close(this.featureFlagStaticMock);
        this.events = null;
    }

    private static void featureFlagEnabled(MockedStatic<FeatureFlags> featureFlagStaticMock) {
        FeatureFlags flags = (FeatureFlags)Mockito.mock(FeatureFlags.class);
        Mockito.when((Object)flags.isEnabled(FeatureFlags.FLOW_FULLSTACK_SIGNALS.getId())).thenReturn((Object)true);
        featureFlagStaticMock.when(() -> FeatureFlags.get((VaadinContext)((VaadinContext)ArgumentMatchers.any()))).thenReturn((Object)flags);
    }

    private static void close(MockedStatic<FeatureFlags> featureFlagStaticMock) {
        CurrentInstance.clearAll();
        featureFlagStaticMock.close();
    }

    private LinkedList<ErrorEvent> mockLockedSessionWithErrorHandler() {
        VaadinService.setCurrent((VaadinService)service);
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        MockUI ui = new MockUI(session);
        LinkedList<ErrorEvent> events = new LinkedList<ErrorEvent>();
        session.setErrorHandler(events::add);
        return events;
    }

    @Test
    public void bindTextComputedSignal_getText_returnsCorrectValue() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        Signal computedSignal = Signal.computed(() -> "computed-" + (String)signal.value());
        element.bindText(computedSignal);
        Assert.assertEquals((Object)"computed-text", (Object)element.getText());
    }

    @Test
    public void bindTextMappedSignal_getText_returnsCorrectValue() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText(signal.map(text -> "mapped-" + text));
        Assert.assertEquals((Object)"mapped-text", (Object)element.getText());
    }

    @Test
    public void bindText_detachAttach_returnsCorrectValue() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        Assert.assertEquals((Object)"text", (Object)element.getText());
        UI.getCurrent().getElement().removeChild(new Element[]{element});
        signal.value((Object)"text2");
        Assert.assertEquals((Object)"text", (Object)element.getText());
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assert.assertEquals((Object)"text2", (Object)element.getText());
    }

    @Test
    public void bindText_setTextWithExistingActiveBinding_throws() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        Assert.assertThrows(BindingActiveException.class, () -> element.setText("text2"));
    }

    @Test
    public void bindText_setTextWithExistingInactiveBinding_throws() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        UI.getCurrent().getElement().removeChild(new Element[]{element});
        Assert.assertThrows(BindingActiveException.class, () -> element.setText("text2"));
    }

    @Test
    public void bindText_initialNullSignalValue_treatAsBlank() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal();
        element.bindText((Signal)signal);
        Assert.assertEquals((Object)"", (Object)element.getText());
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindText_setNullSignalValue_treatAsBlank() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        signal.value(null);
        Assert.assertTrue((boolean)this.events.isEmpty());
        Assert.assertEquals((Object)"", (Object)element.getText());
    }

    @Test
    public void bindText_bindTextWithExistingActiveBinding_throws() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        ValueSignal signal2 = new ValueSignal((Object)"text2");
        Assert.assertThrows(BindingActiveException.class, () -> element.bindText((Signal)signal2));
    }

    @Test
    public void bindText_bindTextWithExistingInactiveBinding_returnsCorrectValue() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        UI.getCurrent().getElement().removeChild(new Element[]{element});
        ValueSignal signal2 = new ValueSignal((Object)"text2");
        element.bindText((Signal)signal2);
    }

    @Test
    public void bindText_unbindText_returnsCorrectValue() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        element.bindText(null);
        Assert.assertEquals((Object)"text", (Object)element.getText());
    }

    @Test
    public void bindText_unbindText_allowsSetText() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        element.bindText(null);
        element.setText("text2");
        Assert.assertEquals((Object)"text2", (Object)element.getText());
    }

    @Test
    public void bindText_componentNotAttached_bindingIgnored() {
        Element element = new Element("span");
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        Assert.assertEquals((Object)"", (Object)element.getText());
    }

    @Test
    public void bindText_componentAttached_returnsCorrectValue() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        Assert.assertEquals((Object)"text", (Object)element.getText());
        signal.value((Object)"text2");
        Assert.assertEquals((Object)"text2", (Object)element.getText());
    }

    @Test
    public void lazyInitSignalBindingFeature() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        element.setText("text2");
        element.getText();
        element.getNode().getFeatureIfInitialized(TextBindingFeature.class).ifPresent(feature -> Assert.fail((String)"TextBindingFeature should not be initialized before binding a signal"));
        ValueSignal signal = new ValueSignal((Object)"text");
        element.bindText((Signal)signal);
        element.getNode().getFeatureIfInitialized(TextBindingFeature.class).orElseThrow(() -> new AssertionError((Object)"TextBindingFeature should be initialized after binding a signal"));
    }

    @Test
    public void bindText_componentWithHasText() {
        @Tag(value="span")
        class SpanWithHasText
        extends Component
        implements HasText {
            SpanWithHasText() {
            }
        }
        SpanWithHasText span = new SpanWithHasText();
        UI.getCurrent().add(new Component[]{span});
        ValueSignal signal = new ValueSignal((Object)"text");
        span.bindText((Signal)signal);
        Assert.assertEquals((Object)"text", (Object)span.getText());
        signal.value((Object)"text2");
        Assert.assertEquals((Object)"text2", (Object)span.getText());
        signal.value(null);
        Assert.assertEquals((Object)"", (Object)span.getText());
        Assert.assertThrows(BindingActiveException.class, () -> span.setText(""));
        UI.getCurrent().remove(new Component[]{span});
        signal.value((Object)"text3");
        Assert.assertEquals((Object)"", (Object)span.getText());
        UI.getCurrent().add(new Component[]{span});
        Assert.assertEquals((Object)"text3", (Object)span.getText());
        span.bindText(null);
        span.setText("text");
        Assert.assertEquals((Object)"text", (Object)span.getText());
    }
}

