/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.signals.BindingActiveException;
import com.vaadin.signals.Signal;
import com.vaadin.signals.local.ValueSignal;
import org.junit.Assert;
import org.junit.Test;

public class ClassListBindTest
extends SignalsUnitTest {
    @Test
    public void bindingMirrorsSignalWhileAttached_toggleAddsRemovesClass() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)false);
        element.getClassList().bind("highlight", (Signal)signal);
        Assert.assertFalse((boolean)element.getClassList().contains((Object)"highlight"));
        signal.value((Object)true);
        Assert.assertTrue((boolean)element.getClassList().contains((Object)"highlight"));
        signal.value((Object)false);
        Assert.assertFalse((boolean)element.getClassList().contains((Object)"highlight"));
    }

    @Test
    public void bindingInactiveWhenDetached_reactivatedOnAttach_appliesCurrentValue() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)false);
        element.getClassList().bind("active", (Signal)signal);
        UI.getCurrent().getElement().removeChild(new Element[]{element});
        signal.value((Object)true);
        Assert.assertFalse((boolean)element.getClassList().contains((Object)"active"));
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assert.assertTrue((boolean)element.getClassList().contains((Object)"active"));
    }

    @Test
    public void manualAddRemoveForBoundName_throwsBindingActiveException() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)true);
        element.getClassList().bind("locked", (Signal)signal);
        Assert.assertThrows(BindingActiveException.class, () -> element.getClassList().add((Object)"locked"));
        Assert.assertThrows(BindingActiveException.class, () -> element.getClassList().remove((Object)"locked"));
        Assert.assertThrows(BindingActiveException.class, () -> element.getClassList().set("locked", true));
        Assert.assertThrows(BindingActiveException.class, () -> element.getClassList().set("locked", false));
    }

    @Test
    public void clear_clearsBindingsSilently_andClearsClasses() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal a = new ValueSignal((Object)true);
        ValueSignal b = new ValueSignal((Object)true);
        element.getClassList().bind("a", (Signal)a);
        element.getClassList().bind("b", (Signal)b);
        Assert.assertTrue((boolean)element.getClassList().contains((Object)"a"));
        Assert.assertTrue((boolean)element.getClassList().contains((Object)"b"));
        element.getClassList().clear();
        Assert.assertFalse((boolean)element.getClassList().contains((Object)"a"));
        Assert.assertFalse((boolean)element.getClassList().contains((Object)"b"));
        a.value((Object)false);
        b.value((Object)false);
        a.value((Object)true);
        b.value((Object)true);
        Assert.assertFalse((boolean)element.getClassList().contains((Object)"a"));
        Assert.assertFalse((boolean)element.getClassList().contains((Object)"b"));
        Assert.assertFalse((boolean)element.getClassList().iterator().hasNext());
    }

    @Test
    public void setAttributeClass_bulkReplacement_clearsBindingsSilently() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal bound = new ValueSignal((Object)true);
        element.getClassList().bind("flag", (Signal)bound);
        Assert.assertTrue((boolean)element.getClassList().contains((Object)"flag"));
        element.setAttribute("class", "foo bar");
        Assert.assertTrue((boolean)element.getClassList().contains((Object)"foo"));
        Assert.assertTrue((boolean)element.getClassList().contains((Object)"bar"));
        Assert.assertFalse((boolean)element.getClassList().contains((Object)"flag"));
        bound.value((Object)false);
        bound.value((Object)true);
        Assert.assertFalse((boolean)element.getClassList().contains((Object)"flag"));
    }

    @Test
    public void bindNull_unbindsAndKeepsLastAppliedPresence() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)true);
        element.getClassList().bind("badge", (Signal)signal);
        Assert.assertTrue((boolean)element.getClassList().contains((Object)"badge"));
        element.getClassList().bind("badge", null);
        Assert.assertTrue((boolean)element.getClassList().contains((Object)"badge"));
        signal.value((Object)false);
        Assert.assertTrue((boolean)element.getClassList().contains((Object)"badge"));
    }

    @Test(expected=BindingActiveException.class)
    public void rebinding_alreadyBound_throws() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal s1 = new ValueSignal((Object)true);
        ValueSignal s2 = new ValueSignal((Object)false);
        element.getClassList().bind("tag", (Signal)s1);
        Assert.assertTrue((boolean)element.getClassList().contains((Object)"tag"));
        element.getClassList().bind("tag", (Signal)s2);
    }

    @Test
    public void internalUpdatesDoNotThrowOrRecurse() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)false);
        element.getClassList().bind("spin", (Signal)signal);
        signal.value((Object)true);
        signal.value((Object)true);
        Assert.assertTrue((boolean)element.getClassList().contains((Object)"spin"));
        Assert.assertEquals((long)1L, (long)element.getClassList().stream().filter("spin"::equals).count());
        signal.value((Object)false);
        signal.value((Object)false);
        Assert.assertFalse((boolean)element.getClassList().contains((Object)"spin"));
    }

    @Test
    public void lazyInitSignalBindingFeature() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        element.getClassList().add((Object)"spin");
        Assert.assertTrue((boolean)element.getClassList().contains((Object)"spin"));
        element.getNode().getFeatureIfInitialized(SignalBindingFeature.class).ifPresent(feature -> Assert.fail((String)"SignalBindingFeature should not be initialized before binding a signal"));
        ValueSignal signal = new ValueSignal((Object)false);
        element.getClassList().bind("spin", (Signal)signal);
        element.getNode().getFeatureIfInitialized(SignalBindingFeature.class).orElseThrow(() -> new AssertionError((Object)"SignalBindingFeature should be initialized after binding a signal"));
    }
}

