/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.DependencyList;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.tests.util.MockUI;
import java.util.Collection;
import net.jcip.annotations.NotThreadSafe;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

@NotThreadSafe
public class PageTest {
    private MockUI ui = new MockUI();
    private Page page = this.ui.getPage();

    @After
    public void tearDown() {
        UI.setCurrent(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddNullStyleSheet() {
        this.page.addStyleSheet(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddNullJavaScript() {
        this.page.addJavaScript(null);
    }

    @Test
    public void testJavasScriptExecutionCancel() {
        Assert.assertEquals((long)0L, (long)this.countPendingInvocations());
        PendingJavaScriptResult executeJavaScript = this.page.executeJs("window.alert('$0');", new Object[]{"foobar"});
        Assert.assertEquals((long)1L, (long)this.countPendingInvocations());
        Assert.assertTrue((boolean)executeJavaScript.cancelExecution());
        Assert.assertEquals((long)0L, (long)this.countPendingInvocations());
    }

    @Test
    public void testJavaScriptExecutionTooLateCancel() {
        Assert.assertEquals((long)0L, (long)this.countPendingInvocations());
        PendingJavaScriptResult executeJavaScript = this.page.executeJs("window.alert('$0');", new Object[]{"foobar"});
        Assert.assertEquals((long)1L, (long)this.countPendingInvocations());
        Assert.assertEquals((long)1L, (long)this.ui.getInternals().dumpPendingJavaScriptInvocations().size());
        Assert.assertEquals((long)0L, (long)this.countPendingInvocations());
        Assert.assertFalse((boolean)executeJavaScript.cancelExecution());
    }

    @Test
    public void addDynamicImport_dynamicDependencyIsAvaialbleViaGetPendingSendToClient() {
        this.page.addDynamicImport("foo");
        DependencyList list = this.ui.getInternals().getDependencyList();
        Collection dependencies = list.getPendingSendToClient();
        Assert.assertEquals((long)1L, (long)dependencies.size());
        Dependency dependency = (Dependency)dependencies.iterator().next();
        Assert.assertEquals((Object)"foo", (Object)dependency.getUrl());
    }

    private long countPendingInvocations() {
        return this.ui.getInternals().getPendingJavaScriptInvocations().count();
    }
}

