/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.HasText;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.dom.Style;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class HasTextTest {
    private HasText hasText = (HasText)Mockito.mock(HasText.class);

    @Before
    public void setUp() {
        Element element = ElementFactory.createDiv();
        Mockito.when((Object)this.hasText.getElement()).thenReturn((Object)element);
        ((HasText)Mockito.doCallRealMethod().when((Object)this.hasText)).setWhiteSpace((HasText.WhiteSpace)Mockito.any());
        ((HasText)Mockito.doCallRealMethod().when((Object)this.hasText)).getWhiteSpace();
    }

    @Test
    public void setWhiteSpace_styleIsSet() {
        this.hasText.setWhiteSpace(HasText.WhiteSpace.NOWRAP);
        Assert.assertEquals((Object)"nowrap", (Object)this.hasText.getElement().getStyle().get("white-space"));
    }

    @Test
    public void getWhiteSpace_getStyleValue() {
        this.hasText.getElement().getStyle().setWhiteSpace(Style.WhiteSpace.INHERIT);
        Assert.assertEquals((Object)HasText.WhiteSpace.INHERIT, (Object)this.hasText.getWhiteSpace());
    }

    @Test
    public void getWhiteSpace_noStyleIsSet_normalIsReturned() {
        Assert.assertEquals((Object)HasText.WhiteSpace.NORMAL, (Object)this.hasText.getWhiteSpace());
    }

    @Test
    public void getWhiteSpace_notStandardValue_nullIsReturned() {
        this.hasText.getElement().getStyle().set("white-space", "foo");
        Assert.assertEquals(null, (Object)this.hasText.getWhiteSpace());
    }
}

