/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasOrderedComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.dom.Element;
import java.util.Arrays;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class HasOrderedComponentsTest {
    private HasOrderedComponents components = (HasOrderedComponents)Mockito.spy(TestOrderedComponents.class);
    private TestComponentContianer contianer = new TestComponentContianer();

    @Test
    public void indexOf_componentIsChild_returnsIndexOfChild() {
        Component comp = (Component)Mockito.mock(Component.class);
        Mockito.when((Object)this.components.getChildren()).thenReturn(Arrays.asList((Component)Mockito.mock(Component.class), comp, (Component)Mockito.mock(Component.class)).stream());
        Assert.assertEquals((long)1L, (long)this.components.indexOf(comp));
        this.contianer = new TestComponentContianer();
        comp = new Anchor();
        this.contianer.add(new Component[]{new Text(""), comp});
        Assert.assertEquals((long)1L, (long)this.contianer.indexOf(comp));
    }

    @Test
    public void indexOf_componentIsNotChild_returnsNegative() {
        Component comp = (Component)Mockito.mock(Component.class);
        Mockito.when((Object)this.components.getChildren()).thenReturn(Arrays.asList((Component)Mockito.mock(Component.class), (Component)Mockito.mock(Component.class)).stream());
        Assert.assertEquals((long)-1L, (long)this.components.indexOf(comp));
    }

    @Test(expected=IllegalArgumentException.class)
    public void indexOf_componentIsNull_throws() {
        Mockito.when((Object)this.components.getChildren()).thenReturn(Stream.empty());
        this.components.indexOf(null);
    }

    @Test
    public void getComponentCount_returnsChildrenSize() {
        Mockito.when((Object)this.components.getChildren()).thenReturn(Arrays.asList((Component)Mockito.mock(Component.class), (Component)Mockito.mock(Component.class)).stream());
        Assert.assertEquals((long)2L, (long)this.components.getComponentCount());
        this.contianer = new TestComponentContianer();
        this.contianer.add(new Component[]{new Text(""), new Anchor()});
        Assert.assertEquals((long)2L, (long)this.contianer.getComponentCount());
    }

    @Test
    public void getComponentAt_returnsComponentAtIndex() {
        Component comp = (Component)Mockito.mock(Component.class);
        Mockito.when((Object)this.components.getChildren()).thenReturn(Arrays.asList((Component)Mockito.mock(Component.class), comp, (Component)Mockito.mock(Component.class)).stream());
        Assert.assertSame((Object)comp, (Object)this.components.getComponentAt(1));
        this.contianer = new TestComponentContianer();
        comp = new Anchor();
        this.contianer.add(new Component[]{new Text(""), comp});
        Assert.assertSame((Object)comp, (Object)this.contianer.getComponentAt(1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getComponentAt_negativeIndex_throws() {
        Mockito.when((Object)this.components.getChildren()).thenReturn(Arrays.asList((Component)Mockito.mock(Component.class), (Component)Mockito.mock(Component.class)).stream());
        this.components.getComponentAt(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getComponentAt_indexIsGreaterThanSize_throws() {
        Mockito.when((Object)this.components.getChildren()).thenReturn(Stream.of((Component)Mockito.mock(Component.class)));
        this.components.getComponentAt(2);
    }

    static class TestOrderedComponents
    implements HasOrderedComponents {
        TestOrderedComponents() {
        }

        public Element getElement() {
            return null;
        }

        public Stream<Component> getChildren() {
            return null;
        }
    }

    @Tag(value="div")
    static class TestComponentContianer
    extends Component
    implements HasOrderedComponents {
        TestComponentContianer() {
        }
    }

    @Tag(value="a")
    static class Anchor
    extends Component {
        Anchor() {
        }
    }
}

