/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.FocusOption;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.tests.util.MockUI;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class FocusableTest {
    private final MockUI ui = new MockUI();
    private final FocusableTestComponent component = new FocusableTestComponent();

    @Test
    public void focusUnattached_nothingScheduled() {
        this.component.focus();
        this.assertPendingInvocationCount("Nothing should be scheduled when component is not attached", 0);
    }

    @Test
    public void focusBeforeAttach_executionScheduled() {
        this.component.focus();
        this.ui.add(new Component[]{this.component});
        this.assertPendingInvocationCount("An focus() inovocation should be pending for the attached component", 1);
    }

    @Test
    public void focusAfterAttach_executionScheduled() {
        this.ui.add(new Component[]{this.component});
        this.component.focus();
        this.assertPendingInvocationCount("An focus() inovocation should be pending for the attached component", 1);
    }

    @Test
    public void detachAfterFocus_nothingScheduled() {
        this.ui.add(new Component[]{this.component});
        this.component.focus();
        this.ui.remove(new Component[]{this.component});
        this.assertPendingInvocationCount("Nothing should be scheduled when component is not attached", 0);
    }

    private void assertPendingInvocationCount(String message, int expected) {
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assert.assertEquals((String)message, (long)expected, (long)invocations.size());
    }

    @Test
    public void focus_withFocusVisible_generatesCorrectJS() {
        this.ui.add(new Component[]{this.component});
        this.component.focus(new FocusOption[]{FocusOption.FocusVisible.VISIBLE});
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assert.assertEquals((long)1L, (long)invocations.size());
        String expression = invocations.get(0).getInvocation().getExpression();
        Assert.assertTrue((String)"Should contain setTimeout wrapper", (boolean)expression.contains("setTimeout"));
        Assert.assertTrue((String)"Should contain focus call with parameter", (boolean)expression.contains(".focus($1)"));
        List params = invocations.get(0).getInvocation().getParameters();
        Assert.assertTrue((String)"Should have at least 2 parameters", (params.size() >= 2 ? 1 : 0) != 0);
        String paramJson = params.get(1).toString();
        Assert.assertTrue((String)"Should set focusVisible to true", (boolean)paramJson.contains("\"focusVisible\":true"));
        Assert.assertFalse((String)"Should not contain preventScroll", (boolean)paramJson.contains("preventScroll"));
    }

    @Test
    public void focus_withFocusNotVisible_generatesCorrectJS() {
        this.ui.add(new Component[]{this.component});
        this.component.focus(new FocusOption[]{FocusOption.FocusVisible.NOT_VISIBLE});
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assert.assertEquals((long)1L, (long)invocations.size());
        String expression = invocations.get(0).getInvocation().getExpression();
        Assert.assertTrue((String)"Should contain setTimeout wrapper", (boolean)expression.contains("setTimeout"));
        Assert.assertTrue((String)"Should contain focus call with parameter", (boolean)expression.contains(".focus($1)"));
        List params = invocations.get(0).getInvocation().getParameters();
        Assert.assertTrue((String)"Should have at least 2 parameters", (params.size() >= 2 ? 1 : 0) != 0);
        String paramJson = params.get(1).toString();
        Assert.assertTrue((String)"Should set focusVisible to false", (boolean)paramJson.contains("\"focusVisible\":false"));
    }

    @Test
    public void focus_withPreventScrollEnabled_generatesCorrectJS() {
        this.ui.add(new Component[]{this.component});
        this.component.focus(new FocusOption[]{FocusOption.PreventScroll.ENABLED});
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assert.assertEquals((long)1L, (long)invocations.size());
        String expression = invocations.get(0).getInvocation().getExpression();
        Assert.assertTrue((String)"Should contain setTimeout wrapper", (boolean)expression.contains("setTimeout"));
        Assert.assertTrue((String)"Should contain focus call with parameter", (boolean)expression.contains(".focus($1)"));
        List params = invocations.get(0).getInvocation().getParameters();
        Assert.assertTrue((String)"Should have at least 2 parameters", (params.size() >= 2 ? 1 : 0) != 0);
        String paramJson = params.get(1).toString();
        Assert.assertTrue((String)"Should set preventScroll to true", (boolean)paramJson.contains("\"preventScroll\":true"));
        Assert.assertFalse((String)"Should not contain focusVisible", (boolean)paramJson.contains("focusVisible"));
    }

    @Test
    public void focus_withPreventScrollDisabled_generatesCorrectJS() {
        this.ui.add(new Component[]{this.component});
        this.component.focus(new FocusOption[]{FocusOption.PreventScroll.DISABLED});
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assert.assertEquals((long)1L, (long)invocations.size());
        String expression = invocations.get(0).getInvocation().getExpression();
        Assert.assertTrue((String)"Should contain setTimeout wrapper", (boolean)expression.contains("setTimeout"));
        Assert.assertTrue((String)"Should contain focus call with parameter", (boolean)expression.contains(".focus($1)"));
        List params = invocations.get(0).getInvocation().getParameters();
        Assert.assertTrue((String)"Should have at least 2 parameters", (params.size() >= 2 ? 1 : 0) != 0);
        String paramJson = params.get(1).toString();
        Assert.assertTrue((String)"Should set preventScroll to false", (boolean)paramJson.contains("\"preventScroll\":false"));
    }

    @Test
    public void focus_withBothOptions_generatesCorrectJS() {
        this.ui.add(new Component[]{this.component});
        this.component.focus(new FocusOption[]{FocusOption.FocusVisible.VISIBLE, FocusOption.PreventScroll.ENABLED});
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assert.assertEquals((long)1L, (long)invocations.size());
        String expression = invocations.get(0).getInvocation().getExpression();
        Assert.assertTrue((String)"Should contain setTimeout wrapper", (boolean)expression.contains("setTimeout"));
        Assert.assertTrue((String)"Should contain focus call with parameter", (boolean)expression.contains(".focus($1)"));
        List params = invocations.get(0).getInvocation().getParameters();
        Assert.assertTrue((String)"Should have at least 2 parameters", (params.size() >= 2 ? 1 : 0) != 0);
        String paramJson = params.get(1).toString();
        Assert.assertTrue((String)"Should set preventScroll to true", (boolean)paramJson.contains("\"preventScroll\":true"));
        Assert.assertTrue((String)"Should set focusVisible to true", (boolean)paramJson.contains("\"focusVisible\":true"));
    }

    @Test
    public void focus_withBothOptionsFalse_generatesCorrectJS() {
        this.ui.add(new Component[]{this.component});
        this.component.focus(new FocusOption[]{FocusOption.FocusVisible.NOT_VISIBLE, FocusOption.PreventScroll.DISABLED});
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assert.assertEquals((long)1L, (long)invocations.size());
        String expression = invocations.get(0).getInvocation().getExpression();
        Assert.assertTrue((String)"Should contain setTimeout wrapper", (boolean)expression.contains("setTimeout"));
        Assert.assertTrue((String)"Should contain focus call with parameter", (boolean)expression.contains(".focus($1)"));
        List params = invocations.get(0).getInvocation().getParameters();
        Assert.assertTrue((String)"Should have at least 2 parameters", (params.size() >= 2 ? 1 : 0) != 0);
        String paramJson = params.get(1).toString();
        Assert.assertTrue((String)"Should set preventScroll to false", (boolean)paramJson.contains("\"preventScroll\":false"));
        Assert.assertTrue((String)"Should set focusVisible to false", (boolean)paramJson.contains("\"focusVisible\":false"));
    }

    @Test
    public void focus_withoutOptions_generatesCorrectJS() {
        this.ui.add(new Component[]{this.component});
        this.component.focus();
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assert.assertEquals((long)1L, (long)invocations.size());
        String expression = invocations.getFirst().getInvocation().getExpression();
        Assert.assertTrue((String)"Should contain setTimeout wrapper", (boolean)expression.contains("setTimeout"));
        Assert.assertTrue((String)"Should contain focus call without parameters", (boolean)expression.contains(".focus()"));
        Assert.assertFalse((String)"Should not contain focus call with parameter", (boolean)expression.contains(".focus($1)"));
        List params = invocations.getFirst().getInvocation().getParameters();
        Assert.assertEquals((String)"Should have exactly 1 parameter (the element node and wrapped parameter)", (long)2L, (long)params.size());
    }

    @Tag(value="div")
    private static class FocusableTestComponent
    extends Component
    implements Focusable {
        private FocusableTestComponent() {
        }
    }
}

