/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEffect;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasOrderedComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementAttachListener;
import com.vaadin.flow.dom.ElementDetachListener;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import com.vaadin.signals.Signal;
import com.vaadin.signals.local.ValueSignal;
import com.vaadin.signals.shared.AbstractSignal;
import com.vaadin.signals.shared.SharedListSignal;
import com.vaadin.signals.shared.SharedValueSignal;
import com.vaadin.tests.util.MockUI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ComponentEffectTest {
    private static TestService service;

    @BeforeClass
    public static void init() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            service = new TestService();
        });
    }

    @AfterClass
    public static void clean() {
        CurrentInstance.clearAll();
        service.destroy();
    }

    @Test
    public void effect_triggeredWithOwnerUILocked_effectRunSynchronously() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            MockUI ui = new MockUI();
            AtomicReference currentThread = new AtomicReference();
            AtomicReference currentUI = new AtomicReference();
            ComponentEffect.effect((Component)ui, () -> {
                currentThread.set(Thread.currentThread());
                currentUI.set(UI.getCurrent());
            });
            Assert.assertSame((Object)Thread.currentThread(), currentThread.get());
            Assert.assertSame((Object)((Object)ui), currentUI.get());
        });
    }

    @Test
    public void effect_triggeredWithNoUILocked_effectRunAsynchronously() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            VaadinService.setCurrent((VaadinService)service);
            MockVaadinSession session = new MockVaadinSession((VaadinService)service);
            session.lock();
            MockUI ui = new MockUI(session);
            session.unlock();
            UI.setCurrent(null);
            AtomicReference currentUI = new AtomicReference();
            ComponentEffect.effect((Component)ui, () -> currentUI.set(UI.getCurrent()));
            service.flushExecutorAndAccessTasks(session);
            Assert.assertSame((String)"Effect should run with correct UI context", (Object)((Object)ui), currentUI.get());
        });
    }

    @Test
    public void effect_triggeredWithOtherUILocked_effectRunAsynchronously() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            VaadinService.setCurrent((VaadinService)service);
            MockVaadinSession session = new MockVaadinSession((VaadinService)service);
            session.lock();
            MockUI ui = new MockUI(session);
            session.unlock();
            VaadinSession.setCurrent(null);
            UI.setCurrent(null);
            MockVaadinSession otherSession = new MockVaadinSession((VaadinService)service);
            otherSession.lock();
            MockUI otherUi = new MockUI(otherSession);
            otherSession.unlock();
            UI.setCurrent((UI)otherUi);
            AtomicReference currentUI = new AtomicReference();
            ComponentEffect.effect((Component)ui, () -> currentUI.set(UI.getCurrent()));
            service.flushExecutorAndAccessTasks(session);
            Assert.assertSame((String)"Effect should run with correct UI context", (Object)((Object)ui), currentUI.get());
        });
    }

    @Test
    public void effect_throwExceptionWhenRunningDirectly_delegatedToErrorHandler() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            VaadinService.setCurrent((VaadinService)service);
            MockVaadinSession session = new MockVaadinSession((VaadinService)service);
            session.lock();
            MockUI ui = new MockUI(session);
            ArrayList events = new ArrayList();
            session.setErrorHandler(events::add);
            ComponentEffect.effect((Component)ui, () -> {
                throw new RuntimeException("Expected exception");
            });
            Assert.assertEquals((long)1L, (long)events.size());
            Throwable throwable = ((ErrorEvent)events.get(0)).getThrowable();
            Assert.assertEquals(RuntimeException.class, throwable.getClass());
        });
    }

    @Test
    public void effect_throwExceptionWhenRunningAsynchronously_delegatedToErrorHandler() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            VaadinService.setCurrent((VaadinService)service);
            MockVaadinSession session = new MockVaadinSession((VaadinService)service);
            session.lock();
            MockUI ui = new MockUI(session);
            ArrayList events = new ArrayList();
            session.setErrorHandler(events::add);
            UI.setCurrent(null);
            session.unlock();
            ComponentEffect.effect((Component)ui, () -> {
                throw new RuntimeException("Expected exception");
            });
            service.flushExecutorAndAccessTasks(session);
            Assert.assertEquals((String)"Error handler should have been called", (long)1L, (long)events.size());
            Throwable throwable = ((ErrorEvent)events.get(0)).getThrowable();
            Assert.assertEquals(RuntimeException.class, throwable.getClass());
        });
    }

    @Test
    public void effect_componentAttachedAndDetached_effectEnabledAndDisabled() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            TestComponent component = new TestComponent();
            ValueSignal signal = new ValueSignal((Object)"initial");
            AtomicInteger count = new AtomicInteger();
            Registration registration = ComponentEffect.effect((Component)component, () -> {
                signal.value();
                count.incrementAndGet();
            });
            Assert.assertEquals((String)"Effect should not be run until component is attached", (long)0L, (long)count.get());
            signal.value((Object)"test");
            Assert.assertEquals((String)"Effect should not be run until component is attached even after signal value change", (long)0L, (long)count.get());
            MockUI ui = new MockUI();
            ui.add(new Component[]{component});
            Assert.assertEquals((String)"Effect should be run once component is attached", (long)1L, (long)count.get());
            signal.value((Object)"test2");
            Assert.assertEquals((String)"Effect should be run when signal value is chaged", (long)2L, (long)count.get());
            ui.remove(new Component[]{component});
            signal.value((Object)"test3");
            Assert.assertEquals((String)"Effect should not be run after detach", (long)2L, (long)count.get());
            ui.add(new Component[]{component});
            Assert.assertEquals((String)"Effect should be run after attach", (long)3L, (long)count.get());
            registration.remove();
            signal.value((Object)"test4");
            Assert.assertEquals((String)"Effect should not be run after remove", (long)3L, (long)count.get());
        });
    }

    @Test
    public void bind_signalValueChanges_componentUpdated() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            TestComponent component = new TestComponent();
            ValueSignal signal = new ValueSignal((Object)"initial");
            MockUI ui = new MockUI();
            ui.add(new Component[]{component});
            Registration registration = ComponentEffect.bind((Component)component, (Signal)signal, TestComponent::setValue);
            Assert.assertEquals((String)"Initial value should be set", (Object)"initial", (Object)component.getValue());
            signal.value((Object)"new value");
            Assert.assertEquals((String)"Component should be updated with new value", (Object)"new value", (Object)component.getValue());
            signal.value((Object)"another value");
            Assert.assertEquals((String)"Component should be updated with another value", (Object)"another value", (Object)component.getValue());
            registration.remove();
            signal.value((Object)"final value");
            Assert.assertEquals((String)"Component should not be updated after registration is removed", (Object)"another value", (Object)component.getValue());
        });
    }

    @Test
    public void bindChildren_nullArguments_throws() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            SharedListSignal taskList = new SharedListSignal(String.class);
            TestLayout parentComponent = new TestLayout();
            new MockUI();
            Assert.assertThrows(NullPointerException.class, () -> ComponentEffect.bindChildren(null, (Signal)taskList, (SerializableFunction & Serializable)valueSignal -> null));
            Assert.assertThrows(NullPointerException.class, () -> ComponentEffect.bindChildren((Component)parentComponent, null, (SerializableFunction & Serializable)valueSignal -> null));
            Assert.assertThrows(NullPointerException.class, () -> ComponentEffect.bindChildren((Component)parentComponent, (Signal)taskList, null));
        });
    }

    @Test
    public void bindChildren_emptySharedListSignal_emptyParent() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            SharedListSignal taskList = new SharedListSignal(String.class);
            TestLayout parentComponent = new TestLayout();
            new MockUI().add(new Component[]{parentComponent});
            ComponentEffect.bindChildren((Component)parentComponent, (Signal)taskList, (SerializableFunction & Serializable)valueSignal -> new TestComponent((String)valueSignal.value()));
            Assert.assertEquals((long)0L, (long)parentComponent.getComponentCount());
        });
    }

    @Test
    public void bindChildren_emptySharedListSignalWithNotInitiallyEmptyParent_throw() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            SharedListSignal taskList = new SharedListSignal(String.class);
            TestLayout parentComponent = new TestLayout();
            TestComponent initialComponent = new TestComponent("initial");
            parentComponent.add(new Component[]{initialComponent});
            new MockUI().add(new Component[]{parentComponent});
            Assert.assertThrows(IllegalStateException.class, () -> ComponentEffect.bindChildren((Component)parentComponent, (Signal)taskList, (SerializableFunction & Serializable)valueSignal -> {
                Assert.fail((String)"Should not call element factory");
                return null;
            }));
            Assert.assertEquals((long)1L, (long)parentComponent.getComponentCount());
        });
    }

    @Test
    public void bindChildren_listSignalWithItem_parentUpdated() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            SharedListSignal taskList = new SharedListSignal(String.class);
            taskList.insertFirst((Object)"first");
            TestLayout parentComponent = new TestLayout();
            TestComponent expectedComponent = new TestComponent();
            new MockUI().add(new Component[]{parentComponent});
            ComponentEffect.bindChildren((Component)parentComponent, (Signal)taskList, (SerializableFunction & Serializable)valueSignal -> {
                expectedComponent.setValue((String)valueSignal.value());
                return expectedComponent;
            });
            Assert.assertEquals((long)1L, (long)parentComponent.getComponentCount());
            Assert.assertEquals((Object)((Object)expectedComponent), parentComponent.getChildren().findFirst().orElse(null));
            Assert.assertEquals((Object)"first", (Object)expectedComponent.getValue());
            Assert.assertEquals((long)1L, (long)expectedComponent.attachCounter);
            Assert.assertEquals((long)0L, (long)expectedComponent.detachCounter);
        });
    }

    @Test
    public void bindChildren_addItem_parentUpdated() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            SharedListSignal taskList = new SharedListSignal(String.class);
            taskList.insertFirst((Object)"first");
            TestLayout parentComponent = new TestLayout();
            new MockUI().add(new Component[]{parentComponent});
            ComponentEffect.bindChildren((Component)parentComponent, (Signal)taskList, (SerializableFunction & Serializable)valueSignal -> new TestComponent((String)valueSignal.value()));
            Assert.assertEquals((String)"Parent component children count is wrong", (long)1L, (long)parentComponent.getComponentCount());
            Assert.assertEquals((Object)"first", (Object)((TestComponent)((Object)((Object)parentComponent.getChildren().toList().get(0)))).getValue());
            taskList.insertLast((Object)"last");
            List<TestComponent> children = parentComponent.getChildren().map(TestComponent.class::cast).toList();
            Assert.assertEquals((String)"Parent component children count is wrong", (long)2L, (long)parentComponent.getComponentCount());
            Assert.assertEquals((Object)"last", (Object)children.get(1).getValue());
            Assert.assertEquals((long)1L, (long)children.get((int)0).attachCounter);
            Assert.assertEquals((long)0L, (long)children.get((int)0).detachCounter);
            Assert.assertEquals((long)1L, (long)children.get((int)1).attachCounter);
            Assert.assertEquals((long)0L, (long)children.get((int)1).detachCounter);
        });
    }

    @Test
    public void bindChildren_removeItem_parentUpdated() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            SharedListSignal taskList = new SharedListSignal(String.class);
            taskList.insertFirst((Object)"first");
            taskList.insertLast((Object)"middle");
            taskList.insertLast((Object)"last");
            TestLayout parentComponent = new TestLayout();
            new MockUI().add(new Component[]{parentComponent});
            ComponentEffect.bindChildren((Component)parentComponent, (Signal)taskList, (SerializableFunction & Serializable)valueSignal -> new TestComponent((String)valueSignal.value()));
            Assert.assertEquals((String)"Parent component children count is wrong", (long)3L, (long)parentComponent.getComponentCount());
            List<TestComponent> children = parentComponent.getChildren().map(TestComponent.class::cast).toList();
            taskList.remove((SharedValueSignal)((List)taskList.value()).get(0));
            Assert.assertEquals((String)"Parent component children count is wrong", (long)2L, (long)parentComponent.getComponentCount());
            Assert.assertEquals((Object)"middle", (Object)((TestComponent)((Object)((Object)parentComponent.getChildren().toList().get(0)))).getValue());
            Assert.assertEquals((Object)"last", (Object)((TestComponent)((Object)((Object)parentComponent.getChildren().toList().get(1)))).getValue());
            Assert.assertEquals((long)1L, (long)children.get((int)0).attachCounter);
            Assert.assertEquals((long)1L, (long)children.get((int)0).detachCounter);
            Assert.assertEquals((long)1L, (long)children.get((int)1).attachCounter);
            Assert.assertEquals((long)0L, (long)children.get((int)1).detachCounter);
            Assert.assertEquals((long)1L, (long)children.get((int)2).attachCounter);
            Assert.assertEquals((long)0L, (long)children.get((int)2).detachCounter);
        });
    }

    @Test
    public void bindChildren_moveItem_parentUpdated() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            SharedListSignal taskList = new SharedListSignal(String.class);
            taskList.insertFirst((Object)"first");
            taskList.insertLast((Object)"middle");
            taskList.insertLast((Object)"last");
            TestLayout parentComponent = new TestLayout();
            new MockUI().add(new Component[]{parentComponent});
            ComponentEffect.bindChildren((Component)parentComponent, (Signal)taskList, (SerializableFunction & Serializable)valueSignal -> new TestComponent((String)valueSignal.value()));
            Assert.assertEquals((String)"Parent component children count is wrong", (long)3L, (long)parentComponent.getComponentCount());
            taskList.moveTo((AbstractSignal)((List)taskList.value()).get(2), SharedListSignal.ListPosition.first());
            Assert.assertEquals((String)"Parent component children count is wrong", (long)3L, (long)parentComponent.getComponentCount());
            Assert.assertEquals((Object)"last", (Object)((TestComponent)((Object)((Object)parentComponent.getChildren().toList().get(0)))).getValue());
            taskList.moveTo((AbstractSignal)((List)taskList.value()).get(0), SharedListSignal.ListPosition.last());
            Assert.assertEquals((Object)"last", (Object)((TestComponent)((Object)((Object)parentComponent.getChildren().toList().get(2)))).getValue());
            taskList.moveTo((AbstractSignal)((List)taskList.value()).get(2), SharedListSignal.ListPosition.between((AbstractSignal)((AbstractSignal)((List)taskList.value()).get(0)), (AbstractSignal)((AbstractSignal)((List)taskList.value()).get(1))));
            Assert.assertEquals((Object)"last", (Object)((TestComponent)((Object)((Object)parentComponent.getChildren().toList().get(1)))).getValue());
        });
    }

    @Test
    public void bindChildren_moveLastToFirst_verifyElementAttachDetachCount() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            SharedListSignal taskList = new SharedListSignal(String.class);
            taskList.insertFirst((Object)"first");
            taskList.insertLast((Object)"middle");
            taskList.insertLast((Object)"last");
            TestLayout parentComponent = this.prepareTestLayout((SharedListSignal<String>)taskList);
            taskList.moveTo((AbstractSignal)((List)taskList.value()).get(2), SharedListSignal.ListPosition.first());
            List<TestComponent> children = parentComponent.getChildren().map(TestComponent.class::cast).toList();
            Assert.assertEquals((long)1L, (long)children.get((int)0).attachCounter);
            Assert.assertEquals((long)1L, (long)children.get((int)0).detachCounter);
            Assert.assertEquals((long)0L, (long)children.get((int)1).attachCounter);
            Assert.assertEquals((long)0L, (long)children.get((int)1).detachCounter);
            Assert.assertEquals((long)0L, (long)children.get((int)2).attachCounter);
            Assert.assertEquals((long)0L, (long)children.get((int)2).detachCounter);
        });
    }

    @Test
    public void bindChildren_moveFirstToLast_verifyElementAttachDetachCount() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            SharedListSignal taskList = new SharedListSignal(String.class);
            taskList.insertFirst((Object)"first");
            taskList.insertLast((Object)"middle");
            taskList.insertLast((Object)"last");
            TestLayout parentComponent = this.prepareTestLayout((SharedListSignal<String>)taskList);
            taskList.moveTo((AbstractSignal)((List)taskList.value()).get(0), SharedListSignal.ListPosition.last());
            List<TestComponent> children = parentComponent.getChildren().map(TestComponent.class::cast).toList();
            Assert.assertEquals((long)0L, (long)children.get((int)0).attachCounter);
            Assert.assertEquals((long)0L, (long)children.get((int)0).detachCounter);
            Assert.assertEquals((long)0L, (long)children.get((int)1).attachCounter);
            Assert.assertEquals((long)0L, (long)children.get((int)1).detachCounter);
            Assert.assertEquals((long)1L, (long)children.get((int)2).attachCounter);
            Assert.assertEquals((long)1L, (long)children.get((int)2).detachCounter);
        });
    }

    @Test
    public void bindChildren_moveLastBetweenFirstAndSecond_verifyElementAttachDetachCount() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            SharedListSignal taskList = new SharedListSignal(String.class);
            taskList.insertFirst((Object)"first");
            taskList.insertLast((Object)"middle");
            taskList.insertLast((Object)"last");
            TestLayout parentComponent = this.prepareTestLayout((SharedListSignal<String>)taskList);
            taskList.moveTo((AbstractSignal)((List)taskList.value()).get(2), SharedListSignal.ListPosition.between((AbstractSignal)((AbstractSignal)((List)taskList.value()).get(0)), (AbstractSignal)((AbstractSignal)((List)taskList.value()).get(1))));
            List<TestComponent> children = parentComponent.getChildren().map(TestComponent.class::cast).toList();
            Assert.assertEquals((long)0L, (long)children.get((int)0).attachCounter);
            Assert.assertEquals((long)0L, (long)children.get((int)0).detachCounter);
            Assert.assertEquals((long)0L, (long)children.get((int)1).attachCounter);
            Assert.assertEquals((long)0L, (long)children.get((int)1).detachCounter);
            Assert.assertEquals((long)1L, (long)children.get((int)2).attachCounter);
            Assert.assertEquals((long)1L, (long)children.get((int)2).detachCounter);
        });
    }

    @Test
    public void bindChildren_addToParentComponentAndAddItem_throw() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            LinkedList<ErrorEvent> events = this.mockLockedSessionWithErrorHandler();
            UI ui = UI.getCurrent();
            SharedListSignal taskList = new SharedListSignal(String.class);
            taskList.insertFirst((Object)"first");
            TestLayout parentComponent = new TestLayout();
            ui.add(new Component[]{parentComponent});
            ComponentEffect.bindChildren((Component)parentComponent, (Signal)taskList, (SerializableFunction & Serializable)valueSignal -> new TestComponent((String)valueSignal.value()));
            TestComponent expectedComponent = new TestComponent("added directly");
            parentComponent.add(new Component[]{expectedComponent});
            taskList.insertLast((Object)"last");
            ErrorEvent event = events.pollFirst();
            Assert.assertNotNull((Object)event);
            Assert.assertEquals(IllegalStateException.class, event.getThrowable().getClass());
            Assert.assertEquals((String)"Parent component children count is wrong", (long)2L, (long)parentComponent.getComponentCount());
            Assert.assertEquals((Object)"first", (Object)((TestComponent)((Object)((Object)parentComponent.getChildren().toList().get(0)))).getValue());
            Assert.assertEquals((Object)"added directly", (Object)((TestComponent)((Object)((Object)parentComponent.getChildren().toList().get(1)))).getValue());
        });
    }

    @Test
    public void bindChildren_directParentComponentChanges_sameChildrenSizeBeforeAfter_throw() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            LinkedList<ErrorEvent> events = this.mockLockedSessionWithErrorHandler();
            UI ui = UI.getCurrent();
            SharedListSignal taskList = new SharedListSignal(String.class);
            taskList.insertLast((Object)"first");
            taskList.insertLast((Object)"middle");
            TestLayout parentComponent = new TestLayout();
            ui.add(new Component[]{parentComponent});
            ComponentEffect.bindChildren((Component)parentComponent, (Signal)taskList, (SerializableFunction & Serializable)valueSignal -> new TestComponent((String)valueSignal.value()));
            TestComponent directlyAddedComponent1 = new TestComponent("added directly 1");
            TestComponent directlyAddedComponent2 = new TestComponent("added directly 2");
            parentComponent.removeAll();
            parentComponent.add(new Component[]{directlyAddedComponent1});
            parentComponent.add(new Component[]{directlyAddedComponent2});
            taskList.insertLast((Object)"last");
            ErrorEvent event = events.pollFirst();
            Assert.assertNotNull((Object)event);
            Assert.assertEquals(IllegalStateException.class, event.getThrowable().getClass());
            List<TestComponent> children = parentComponent.getChildren().map(TestComponent.class::cast).toList();
            Assert.assertEquals((String)"Parent component children count is wrong", (long)5L, (long)parentComponent.getComponentCount());
            Assert.assertEquals((Object)"first", (Object)children.get(0).getValue());
            Assert.assertEquals((Object)"middle", (Object)children.get(1).getValue());
            Assert.assertEquals((Object)"last", (Object)children.get(2).getValue());
            Assert.assertEquals((Object)"added directly 1", (Object)children.get(3).getValue());
            Assert.assertEquals((Object)"added directly 2", (Object)children.get(4).getValue());
        });
    }

    @Test
    public void bindChildren_directParentComponentChangeByFactory_throw() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            LinkedList<ErrorEvent> events = this.mockLockedSessionWithErrorHandler();
            UI ui = UI.getCurrent();
            SharedListSignal taskList = new SharedListSignal(String.class);
            taskList.insertLast((Object)"first");
            taskList.insertLast((Object)"middle");
            TestLayout parentComponent = new TestLayout();
            ui.add(new Component[]{parentComponent});
            ComponentEffect.bindChildren((Component)parentComponent, (Signal)taskList, (SerializableFunction & Serializable)valueSignal -> {
                String value = (String)valueSignal.value();
                TestComponent component = new TestComponent(value);
                if ("middle".equals(value)) {
                    parentComponent.add(new Component[]{new TestComponent("added directly")});
                }
                return component;
            });
            taskList.insertLast((Object)"last");
            ErrorEvent event = events.pollFirst();
            Assert.assertNotNull((Object)event);
            Assert.assertEquals(IllegalStateException.class, event.getThrowable().getClass());
            Assert.assertEquals((Object)"Parent element must have children matching the list signal. Unexpected child at index 2: <div></div>, expected: none", (Object)event.getThrowable().getMessage());
            List<TestComponent> children = parentComponent.getChildren().map(TestComponent.class::cast).toList();
            Assert.assertEquals((String)"Parent component children count is wrong", (long)3L, (long)parentComponent.getComponentCount());
            Assert.assertEquals((Object)"first", (Object)children.get(0).getValue());
            Assert.assertEquals((Object)"middle", (Object)children.get(1).getValue());
            Assert.assertEquals((Object)"added directly", (Object)children.get(2).getValue());
        });
    }

    @Test
    public void bindChildren_directParentComponentChangeByCustomAttach_throw() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            LinkedList<ErrorEvent> events = this.mockLockedSessionWithErrorHandler();
            UI ui = UI.getCurrent();
            SharedListSignal taskList = new SharedListSignal(String.class);
            taskList.insertLast((Object)"first");
            taskList.insertLast((Object)"middle");
            TestLayout parentComponent = new TestLayout();
            ui.add(new Component[]{parentComponent});
            ComponentEffect.bindChildren((Component)parentComponent, (Signal)taskList, (SerializableFunction & Serializable)valueSignal -> {
                String value = (String)valueSignal.value();
                TestComponent component = new TestComponent(value);
                if ("middle".equals(value)) {
                    component.addAttachListener((ComponentEventListener & Serializable)event -> {
                        parentComponent.add(new Component[]{new TestComponent("added directly")});
                        event.unregisterListener();
                    });
                }
                return component;
            });
            ErrorEvent event = events.pollFirst();
            Assert.assertNotNull((Object)event);
            Assert.assertEquals(IllegalStateException.class, event.getThrowable().getClass());
            Assert.assertEquals((Object)"Parent element must have children matching the list signal. Unexpected child at index 2: <div></div>, expected: none", (Object)event.getThrowable().getMessage());
            List<TestComponent> children = parentComponent.getChildren().map(TestComponent.class::cast).toList();
            Assert.assertEquals((String)"Parent component children count is wrong", (long)3L, (long)parentComponent.getComponentCount());
            Assert.assertEquals((Object)"first", (Object)children.get(0).getValue());
            Assert.assertEquals((Object)"middle", (Object)children.get(1).getValue());
            Assert.assertEquals((Object)"added directly", (Object)children.get(2).getValue());
        });
    }

    @Test
    public void bindChildren_directParentComponentChildOrderChanges_throw() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            LinkedList<ErrorEvent> events = this.mockLockedSessionWithErrorHandler();
            UI ui = UI.getCurrent();
            SharedListSignal taskList = new SharedListSignal(String.class);
            taskList.insertLast((Object)"first");
            taskList.insertLast((Object)"middle");
            taskList.insertLast((Object)"last");
            TestLayout parentComponent = new TestLayout();
            ui.add(new Component[]{parentComponent});
            ComponentEffect.bindChildren((Component)parentComponent, (Signal)taskList, (SerializableFunction & Serializable)valueSignal -> {
                String value = (String)valueSignal.value();
                TestComponent component = new TestComponent(value);
                component.getElement().setText(value);
                if ("last".equals(value)) {
                    parentComponent.getElement().insertChild(0, new Element[]{parentComponent.getElement().getChild(1)});
                }
                return component;
            });
            ErrorEvent event = events.pollFirst();
            Assert.assertNotNull((Object)event);
            Assert.assertEquals(IllegalStateException.class, event.getThrowable().getClass());
            List<TestComponent> children = parentComponent.getChildren().map(TestComponent.class::cast).toList();
            Assert.assertEquals((Object)"Parent element must have children matching the list signal. Unexpected child at index 0: <div>middle</div>, expected: <div>first</div>", (Object)event.getThrowable().getMessage());
            Assert.assertEquals((String)"Parent component children count is wrong", (long)3L, (long)parentComponent.getComponentCount());
            Assert.assertEquals((Object)"middle", (Object)children.get(0).getValue());
            Assert.assertEquals((Object)"first", (Object)children.get(1).getValue());
            Assert.assertEquals((Object)"last", (Object)children.get(2).getValue());
        });
    }

    @Test
    public void bindChildren_runInTransaction_effectRunOnce() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            ArrayList<Element> expectedMockedElements = new ArrayList<Element>();
            SharedListSignal taskList = new SharedListSignal(String.class);
            TestLayout parentComponent = new TestLayout(expectedMockedElements);
            new MockUI().add(new Component[]{parentComponent});
            ComponentEffect.bindChildren((Component)parentComponent, (Signal)taskList, (SerializableFunction & Serializable)valueSignal -> {
                TestComponent component = new TestComponent((String)valueSignal.value(), parentComponent.getElement(), null);
                expectedMockedElements.add(component.getElement());
                return component;
            });
            Mockito.clearInvocations((Object[])expectedMockedElements.toArray());
            Mockito.clearInvocations((Object[])new Element[]{parentComponent.getElement()});
            Signal.runInTransaction(() -> {
                taskList.insertFirst((Object)"first");
                taskList.insertLast((Object)"last");
                taskList.insertLast((Object)"middle");
                taskList.moveTo((AbstractSignal)((List)taskList.value()).get(2), SharedListSignal.ListPosition.between((AbstractSignal)((AbstractSignal)((List)taskList.value()).get(0)), (AbstractSignal)((AbstractSignal)((List)taskList.value()).get(1))));
                taskList.remove((SharedValueSignal)((List)taskList.value()).get(0));
            });
            ((Element)Mockito.verify((Object)parentComponent.getElement(), (VerificationMode)Mockito.times((int)2))).getChildren();
            Assert.assertEquals((String)"Parent component children count is wrong", (long)2L, (long)parentComponent.getComponentCount());
            Assert.assertEquals((Object)"middle", (Object)((TestComponent)((Object)((Object)parentComponent.getChildren().toList().get(0)))).getValue());
            Assert.assertEquals((Object)"last", (Object)((TestComponent)((Object)((Object)parentComponent.getChildren().toList().get(1)))).getValue());
        });
    }

    @Test
    public void bindChildren_withNullFromChildFactory_throws() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            LinkedList<ErrorEvent> events = this.mockLockedSessionWithErrorHandler();
            UI ui = UI.getCurrent();
            SharedListSignal taskList = new SharedListSignal(String.class);
            taskList.insertFirst((Object)"first");
            TestLayout parentComponent = new TestLayout();
            ui.add(new Component[]{parentComponent});
            ComponentEffect.bindChildren((Component)parentComponent, (Signal)taskList, (SerializableFunction & Serializable)valueSignal -> null);
            ErrorEvent event = events.pollFirst();
            Assert.assertNotNull((Object)event);
            Assert.assertEquals(IllegalStateException.class, event.getThrowable().getClass());
            Assert.assertEquals((Object)"ComponentEffect.bindChildren childFactory must not return null", (Object)event.getThrowable().getMessage());
        });
    }

    @Test
    public void bindChildren_registrationRemove_effectRemoved() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            SharedListSignal taskList = new SharedListSignal(String.class);
            taskList.insertFirst((Object)"first");
            taskList.insertLast((Object)"second");
            TestLayout parentComponent = new TestLayout();
            new MockUI().add(new Component[]{parentComponent});
            Registration registration = ComponentEffect.bindChildren((Component)parentComponent, (Signal)taskList, (SerializableFunction & Serializable)valueSignal -> new TestComponent((String)valueSignal.value()));
            Assert.assertEquals((String)"Parent should have initial children", (long)2L, (long)parentComponent.getComponentCount());
            Assert.assertEquals((Object)"first", (Object)((TestComponent)((Object)((Object)parentComponent.getChildren().toList().get(0)))).getValue());
            Assert.assertEquals((Object)"second", (Object)((TestComponent)((Object)((Object)parentComponent.getChildren().toList().get(1)))).getValue());
            registration.remove();
            taskList.insertLast((Object)"third");
            Assert.assertEquals((String)"Parent should still have only 2 children", (long)2L, (long)parentComponent.getComponentCount());
            Assert.assertEquals((Object)"first", (Object)((TestComponent)((Object)((Object)parentComponent.getChildren().toList().get(0)))).getValue());
            Assert.assertEquals((Object)"second", (Object)((TestComponent)((Object)((Object)parentComponent.getChildren().toList().get(1)))).getValue());
        });
    }

    @Test
    public void bindChildren_withLocalValueSignalList_parentUpdated() {
        ComponentEffectTest.runWithFeatureFlagEnabled(() -> {
            ValueSignal first = new ValueSignal((Object)"first");
            ValueSignal second = new ValueSignal((Object)"second");
            ValueSignal listSignal = new ValueSignal(new ArrayList<ValueSignal>(List.of(first)));
            TestLayout parentComponent = new TestLayout();
            new MockUI().add(new Component[]{parentComponent});
            ComponentEffect.bindChildren((Component)parentComponent, (Signal)listSignal, (SerializableFunction & Serializable)valueSignal -> new TestComponent((String)valueSignal.value()));
            Assert.assertEquals((long)1L, (long)parentComponent.getComponentCount());
            Assert.assertEquals((Object)"first", (Object)((TestComponent)((Object)((Object)parentComponent.getChildren().toList().get(0)))).getValue());
            listSignal.value(new ArrayList<ValueSignal>(List.of(first, second)));
            Assert.assertEquals((long)2L, (long)parentComponent.getComponentCount());
            Assert.assertEquals((Object)"first", (Object)((TestComponent)((Object)((Object)parentComponent.getChildren().toList().get(0)))).getValue());
            Assert.assertEquals((Object)"second", (Object)((TestComponent)((Object)((Object)parentComponent.getChildren().toList().get(1)))).getValue());
            listSignal.value(new ArrayList<ValueSignal>(List.of(second)));
            Assert.assertEquals((long)1L, (long)parentComponent.getComponentCount());
            Assert.assertEquals((Object)"second", (Object)((TestComponent)((Object)((Object)parentComponent.getChildren().toList().get(0)))).getValue());
            listSignal.value(new ArrayList());
            Assert.assertEquals((long)0L, (long)parentComponent.getComponentCount());
        });
    }

    private TestLayout prepareTestLayout(SharedListSignal<String> listSignal) {
        TestLayout parentComponent = new TestLayout();
        new MockUI().add(new Component[]{parentComponent});
        ComponentEffect.bindChildren((Component)parentComponent, listSignal, (SerializableFunction & Serializable)valueSignal -> new TestComponent((String)valueSignal.value()));
        parentComponent.getChildren().map(TestComponent.class::cast).forEach(TestComponent::resetCounters);
        return parentComponent;
    }

    private static void runWithFeatureFlagEnabled(InterruptableRunnable test) {
        try (MockedStatic featureFlagStaticMock = Mockito.mockStatic(FeatureFlags.class);){
            FeatureFlags flags = (FeatureFlags)Mockito.mock(FeatureFlags.class);
            Mockito.when((Object)flags.isEnabled(FeatureFlags.FLOW_FULLSTACK_SIGNALS.getId())).thenReturn((Object)true);
            featureFlagStaticMock.when(() -> FeatureFlags.get((VaadinContext)((VaadinContext)ArgumentMatchers.any()))).thenReturn((Object)flags);
            test.run();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            CurrentInstance.clearAll();
        }
    }

    private LinkedList<ErrorEvent> mockLockedSessionWithErrorHandler() {
        VaadinService.setCurrent((VaadinService)service);
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        MockUI ui = new MockUI(session);
        LinkedList<ErrorEvent> events = new LinkedList<ErrorEvent>();
        session.setErrorHandler(events::add);
        return events;
    }

    @FunctionalInterface
    private static interface InterruptableRunnable {
        public void run() throws InterruptedException;
    }

    private static class TestService
    extends MockVaadinServletService {
        private FlushableExecutor executor;

        private TestService() {
        }

        protected Executor createDefaultExecutor() {
            this.executor = new FlushableExecutor();
            return this.executor;
        }

        public void flushExecutorAndAccessTasks(VaadinSession session) {
            this.executor.flush();
            session.lock();
            try {
                this.runPendingAccessTasks(session);
            }
            finally {
                session.unlock();
            }
        }
    }

    @Tag(value="div")
    private static class TestLayout
    extends TestComponent
    implements HasOrderedComponents {
        public TestLayout() {
        }

        public TestLayout(List<Element> expectedMockedChildren) {
            super(null, expectedMockedChildren);
        }
    }

    @Tag(value="div")
    private static class TestComponent
    extends Component {
        String value;
        int attachCounter;
        int detachCounter;

        public TestComponent() {
            super(new Element("div"));
            this.getElement().addAttachListener((ElementAttachListener & Serializable)event -> ++this.attachCounter);
            this.getElement().addDetachListener((ElementDetachListener & Serializable)event -> ++this.detachCounter);
        }

        public TestComponent(final Element expectedParentElementMock, final List<Element> expectedMockedChildren) {
            super((Element)Mockito.spy((Object)new Element("div"){

                public Node getParentNode() {
                    Node actualParent = super.getParentNode();
                    if (actualParent != null && expectedParentElementMock != null) {
                        return expectedParentElementMock;
                    }
                    return super.getParentNode();
                }

                public Element getChild(int index) {
                    if (expectedMockedChildren != null) {
                        return (Element)expectedMockedChildren.get(index);
                    }
                    return super.getChild(index);
                }
            }));
        }

        public TestComponent(String initialValue) {
            this();
            this.setValue(initialValue);
        }

        public TestComponent(String initialValue, Element expectedParentElementMock, List<Element> expectedMockedChildren) {
            this(expectedParentElementMock, expectedMockedChildren);
            this.setValue(initialValue);
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        void resetCounters() {
            this.attachCounter = 0;
            this.detachCounter = 0;
        }
    }

    private static class FlushableExecutor
    implements Executor {
        private final List<Runnable> pendingTasks = new ArrayList<Runnable>();

        private FlushableExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            this.pendingTasks.add(command);
        }

        public void flush() {
            while (!this.pendingTasks.isEmpty()) {
                ArrayList<Runnable> tasks = new ArrayList<Runnable>(this.pendingTasks);
                this.pendingTasks.clear();
                tasks.forEach(Runnable::run);
            }
        }
    }
}

