/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.component.webcomponent.WebComponentConfiguration;
import com.vaadin.flow.internal.CustomElementNameValidator;
import com.vaadin.flow.server.InvalidCustomElementNameException;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.AbstractAnnotationValidator;
import com.vaadin.flow.server.startup.VaadinInitializerException;
import com.vaadin.flow.server.startup.VaadinServletContextStartupInitializer;
import com.vaadin.flow.server.webcomponent.WebComponentConfigurationRegistry;
import com.vaadin.flow.server.webcomponent.WebComponentExporterUtils;
import jakarta.servlet.annotation.HandlesTypes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@HandlesTypes(value={WebComponentExporter.class, WebComponentExporterFactory.class})
public class WebComponentConfigurationRegistryInitializer
implements VaadinServletContextStartupInitializer {
    @Override
    public void initialize(Set<Class<?>> classSet, VaadinContext context) throws VaadinInitializerException {
        WebComponentConfigurationRegistry instance = WebComponentConfigurationRegistry.getInstance(context);
        if ((classSet = AbstractAnnotationValidator.removeHandleTypesSelfReferences(classSet, this)).isEmpty()) {
            instance.setConfigurations(Collections.emptySet());
            return;
        }
        try {
            Set<WebComponentExporterFactory> factories = WebComponentExporterUtils.getFactories(classSet);
            Set<WebComponentConfiguration<? extends Component>> configurations = WebComponentConfigurationRegistryInitializer.constructConfigurations(factories);
            WebComponentConfigurationRegistryInitializer.validateTagNames(configurations);
            WebComponentConfigurationRegistryInitializer.validateDistinctTagNames(configurations);
            instance.setConfigurations(configurations);
        }
        catch (Exception e) {
            throw new VaadinInitializerException(String.format("%s failed to collect %s implementations!", WebComponentConfigurationRegistryInitializer.class.getSimpleName(), WebComponentExporter.class.getSimpleName()), e);
        }
    }

    private static Set<WebComponentConfiguration<? extends Component>> constructConfigurations(Set<WebComponentExporterFactory> factories) {
        Objects.requireNonNull(factories, "Parameter 'exporterClasses' cannot be null!");
        WebComponentExporter.WebComponentConfigurationFactory factory = new WebComponentExporter.WebComponentConfigurationFactory();
        Stream<WebComponentConfiguration> stream = factories.stream().map(WebComponentExporterFactory::create).map(factory::create);
        return stream.collect(Collectors.toSet());
    }

    private static void validateTagNames(Set<WebComponentConfiguration<? extends Component>> configurationSet) {
        for (WebComponentConfiguration<? extends Component> configuration : configurationSet) {
            if (CustomElementNameValidator.isCustomElementName(configuration.getTag())) continue;
            throw new InvalidCustomElementNameException(String.format("Tag name '%s' given by '%s' is not a valid custom element name.", configuration.getTag(), configuration.getExporterClass().getCanonicalName()));
        }
    }

    private static void validateDistinctTagNames(Set<WebComponentConfiguration<? extends Component>> configurationSet) {
        long count = configurationSet.stream().map(WebComponentConfiguration::getTag).distinct().count();
        if ((long)configurationSet.size() != count) {
            HashMap<String, WebComponentConfiguration<? extends Component>> items = new HashMap<String, WebComponentConfiguration<? extends Component>>();
            for (WebComponentConfiguration<? extends Component> configuration : configurationSet) {
                String tag = configuration.getTag();
                if (items.containsKey(tag)) {
                    String message = String.format("Found two %s classes '%s' and '%s' for the tag name '%s'. Tag must be unique.", WebComponentExporter.class.getSimpleName(), ((WebComponentConfiguration)items.get(tag)).getExporterClass().getCanonicalName(), configuration.getExporterClass().getCanonicalName(), tag);
                    throw new IllegalArgumentException(message);
                }
                items.put(tag, configuration);
            }
        }
    }
}

