/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.StreamRegistration;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WrappedSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import com.vaadin.tests.util.MockUI;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SerializationTest {
    Runnable cleaner;

    @Before
    public void enabledSerializationDebugInfo() {
        String extendedDebugInfo = System.getProperty("sun.io.serialization.extendedDebugInfo");
        System.setProperty("sun.io.serialization.extendedDebugInfo", "true");
        this.cleaner = () -> {
            if (extendedDebugInfo != null) {
                System.setProperty("sun.io.serialization.extendedDebugInfo", extendedDebugInfo);
            } else {
                System.clearProperty("sun.io.serialization.extendedDebugInfo");
            }
        };
    }

    @After
    public void restore() {
        if (this.cleaner != null) {
            this.cleaner.run();
        }
    }

    @Test
    public void testSerializeVaadinSession_accessQueueIsRecreated() throws Exception {
        MockVaadinService vaadinService = new MockVaadinService(true);
        VaadinSession session = new VaadinSession((VaadinService)vaadinService);
        session = SerializationTest.serializeAndDeserialize(session);
        Assert.assertNotNull((String)"Pending access queue was not recreated after deserialization", (Object)session.getPendingAccessQueue());
    }

    @Test
    public void testSerializeVaadinSession_notProductionMode_disableDevModeSerialization_deserializedSessionHasNoUIs() throws Exception {
        VaadinSession session = SerializationTest.serializeAndDeserializeWithUI(false);
        Assert.assertNotNull((String)"UIs should be available after empty deserialization", (Object)session.getUIs());
        Assert.assertTrue((String)"UIs should be empty after empty deserialization", (boolean)session.getUIs().isEmpty());
    }

    @Test
    public void testSerializeVaadinSession_notProductionMode_disableDevModeSerialization_streamResources_deserializedSessionHasNoUIs() throws Exception {
        MockVaadinService vaadinService = new MockVaadinService(false, false);
        VaadinSession session = new VaadinSession((VaadinService)vaadinService);
        session.refreshTransients(null, (VaadinService)vaadinService);
        MockUI ui = new MockUI(session);
        ui.doInit(null, 42, "foo");
        session.addUI((UI)ui);
        session.lock();
        StreamRegistration name = session.getResourceRegistry().registerResource((AbstractStreamResource)new StreamResource("name", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(new byte[0])));
        session.unlock();
        session = SerializationTest.serializeAndDeserialize(session);
        session.refreshTransients(null, (VaadinService)vaadinService);
        Assert.assertNotNull((String)"UIs map should be available after devmode deserialization", (Object)session.getUIs());
        Assert.assertTrue((String)"UIs should be empty after devmode deserialization", (boolean)session.getUIs().isEmpty());
        Assert.assertTrue((String)"StreamResources should be empty after devmode deserialization", (boolean)session.getResourceRegistry().getResource(name.getResourceUri()).isEmpty());
    }

    @Test
    public void testSerializeVaadinSession_notProductionMode_enableDevModeSerialization_deserializedSessionHasUI() throws Exception {
        VaadinSession session = SerializationTest.serializeAndDeserializeWithUI(true);
        Assert.assertNotNull((String)"UIs should be available after empty deserialization", (Object)session.getUIs());
        Assert.assertEquals((String)"UIs should contain a UI instance after empty deserialization", (long)1L, (long)session.getUIs().size());
        Assert.assertEquals((String)"Unexpected UI id after empty deserialization", (long)42L, (long)((UI)session.getUIs().iterator().next()).getUIId());
    }

    @Test
    public void testSerializeVaadinSession_notProductionMode_canSerializeWithoutTransients() throws Exception {
        MockVaadinService vaadinService = new MockVaadinService(false, true);
        VaadinSession session = (VaadinSession)Mockito.spy((Object)new VaadinSession((VaadinService)vaadinService));
        Assert.assertEquals((Object)((Object)vaadinService), (Object)session.getService());
        VaadinSession serializedAndDeserializedSession = SerializationTest.serializeAndDeserialize(session);
        Assert.assertNull((Object)serializedAndDeserializedSession.getService());
        VaadinSession againSerializedAndDeserializedSession = SerializationTest.serializeAndDeserialize(serializedAndDeserializedSession);
        Assert.assertNull((Object)againSerializedAndDeserializedSession.getService());
    }

    @Test
    public void serializeUI_currentUI_availableDuringSerialization() throws Exception {
        VaadinSession deserializeSession = SerializationTest.serializeAndDeserializeWithUI(true, true, ui -> ui.add(new Component[]{new MyComponent()}));
        MyComponent deserializedComponent = ((UI)deserializeSession.getUIs().iterator().next()).getChildren().filter(MyComponent.class::isInstance).map(MyComponent.class::cast).findFirst().orElseThrow(() -> new AssertionError((Object)"Custom component has not been deserialized"));
        deserializedComponent.checker.assertInstancesAvailable();
    }

    @Test
    public void serializeUI_currentVaadinSession_availableDuringSerialization() throws Exception {
        VaadinSession deserializeSession = SerializationTest.serializeAndDeserializeWithUI(true, true, ui -> ui.getSession().addRequestHandler((RequestHandler)new MyListener()));
        MyListener deserializedListener = deserializeSession.getRequestHandlers().stream().filter(MyListener.class::isInstance).map(MyListener.class::cast).findFirst().orElseThrow(() -> new AssertionError((Object)"Session request listener has not been deserialized"));
        deserializedListener.checker.assertSessionAvailable();
    }

    private static VaadinSession serializeAndDeserializeWithUI(boolean serializeUI) throws Exception {
        return SerializationTest.serializeAndDeserializeWithUI(serializeUI, false, ui -> {});
    }

    private static VaadinSession serializeAndDeserializeWithUI(boolean serializeUI, boolean background, Consumer<UI> uiConsumer) throws Exception {
        MockVaadinService vaadinService = new MockVaadinService(false, serializeUI);
        VaadinSession session = new VaadinSession((VaadinService)vaadinService);
        session.refreshTransients(null, (VaadinService)vaadinService);
        MockUI ui = new MockUI(session);
        ui.doInit(null, 42, "foo");
        session.addUI((UI)ui);
        uiConsumer.accept(ui);
        VaadinSession deserializedSession = background ? CompletableFuture.supplyAsync(() -> {
            try {
                return SerializationTest.serializeAndDeserialize(session);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).get() : SerializationTest.serializeAndDeserialize(session);
        deserializedSession.refreshTransients(null, (VaadinService)vaadinService);
        return deserializedSession;
    }

    private static <S extends Serializable> S serializeAndDeserialize(S s) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bs);
        out.writeObject(s);
        byte[] data = bs.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
        Serializable s2 = (Serializable)in.readObject();
        if (s.equals(s2)) {
            System.out.println(SerializationTest.toString(s) + " equals " + SerializationTest.toString(s2));
        } else {
            System.out.println(SerializationTest.toString(s) + " does NOT equal " + SerializationTest.toString(s2));
        }
        return (S)s2;
    }

    private static String toString(Object o) {
        return String.valueOf(o);
    }

    private static class MockVaadinService
    extends VaadinServletService {
        private final VaadinContext vaadinContext;
        private final boolean productionMode;
        private final boolean serialize;
        private final Lock lock = new ReentrantLock();

        public MockVaadinService(boolean productionMode) {
            this.lock.lock();
            this.vaadinContext = (VaadinContext)Mockito.mock(VaadinContext.class);
            this.productionMode = productionMode;
            this.serialize = false;
        }

        public MockVaadinService(boolean productionMode, boolean serialize) {
            this.lock.lock();
            this.vaadinContext = (VaadinContext)Mockito.mock(VaadinContext.class);
            this.productionMode = productionMode;
            this.serialize = serialize;
        }

        public VaadinContext getContext() {
            ApplicationConfiguration applicationConfiguration = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
            Mockito.when((Object)this.vaadinContext.getAttribute((Class)Mockito.any(), (Supplier)Mockito.any())).thenReturn((Object)applicationConfiguration);
            Mockito.when((Object)applicationConfiguration.isProductionMode()).thenReturn((Object)this.productionMode);
            Mockito.when((Object)applicationConfiguration.isDevModeSessionSerializationEnabled()).thenReturn((Object)this.serialize);
            return this.vaadinContext;
        }

        protected Lock getSessionLock(WrappedSession wrappedSession) {
            return this.lock;
        }

        public String getMainDivId(VaadinSession session, VaadinRequest request) {
            return "main-div-id";
        }

        public DeploymentConfiguration getDeploymentConfiguration() {
            MockDeploymentConfiguration config = new MockDeploymentConfiguration();
            config.setProductionMode(this.productionMode);
            return config;
        }
    }

    @Tag(value="my-component")
    private static class MyComponent
    extends Component {
        private final SerializationInstancesChecker checker = new SerializationInstancesChecker();

        private MyComponent() {
        }
    }

    private static class SerializationInstancesChecker
    implements Serializable {
        private boolean uiAvailableOnRead = false;
        private boolean sessionAvailableOnRead = false;
        private boolean uiAvailableOnWrite = false;
        private boolean sessionAvailableOnWrite = false;

        private SerializationInstancesChecker() {
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this.uiAvailableOnWrite = UI.getCurrent() != null;
            this.sessionAvailableOnWrite = VaadinSession.getCurrent() != null;
            out.defaultWriteObject();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.uiAvailableOnRead = UI.getCurrent() != null;
            this.sessionAvailableOnRead = VaadinSession.getCurrent() != null;
        }

        void assertInstancesAvailable() {
            this.assertUIAvailable();
            this.assertSessionAvailable();
        }

        void assertUIAvailable() {
            Assert.assertTrue((String)"Expecting serialization hook to be called with UI thread local set", (boolean)this.uiAvailableOnWrite);
            Assert.assertTrue((String)"Expecting deserialization hook to be called with UI thread local set", (boolean)this.uiAvailableOnRead);
        }

        void assertSessionAvailable() {
            Assert.assertTrue((String)"Expecting serialization hook to be called with VaadinSession thread local set", (boolean)this.sessionAvailableOnWrite);
            Assert.assertTrue((String)"Expecting deserialization hook to be called with VaadinSession thread local set", (boolean)this.sessionAvailableOnRead);
        }
    }

    private static class MyListener
    implements RequestHandler {
        private final SerializationInstancesChecker checker = new SerializationInstancesChecker();

        private MyListener() {
        }

        public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
            return false;
        }
    }

    public static class Data
    implements Serializable {
        private String dummyGetter;
        private String dummyGetterAndSetter;
        private int dummyInt;

        public String getDummyGetterAndSetter() {
            return this.dummyGetterAndSetter;
        }

        public void setDummyGetterAndSetter(String dummyGetterAndSetter) {
            this.dummyGetterAndSetter = dummyGetterAndSetter;
        }

        public int getDummyInt() {
            return this.dummyInt;
        }

        public void setDummyInt(int dummyInt) {
            this.dummyInt = dummyInt;
        }

        public String getDummyGetter() {
            return this.dummyGetter;
        }
    }
}

