/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.streams.AbstractDownloadHandler;
import com.vaadin.flow.server.streams.DownloadEvent;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.DownloadResponse;
import com.vaadin.flow.server.streams.InputStreamDownloadCallback;
import com.vaadin.flow.server.streams.InputStreamDownloadHandler;
import com.vaadin.flow.server.streams.TransferContext;
import com.vaadin.flow.server.streams.TransferProgressListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class InputStreamDownloadHandlerTest {
    private static final int SIMULATED_DOWNLOAD_SIZE = 165000;
    private VaadinRequest request;
    private VaadinResponse response;
    private VaadinSession session;
    private VaadinService service;
    private DownloadEvent downloadEvent;
    private OutputStream outputStream;
    private Element owner;
    private UI ui;

    @Before
    public void setUp() throws IOException {
        this.request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        this.response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        this.session = (VaadinSession)Mockito.mock(VaadinSession.class);
        this.service = (VaadinService)Mockito.mock(VaadinService.class);
        this.ui = (UI)Mockito.mock(UI.class);
        ((UI)Mockito.doAnswer(invocation -> {
            Command command = (Command)invocation.getArgument(0);
            command.execute();
            return null;
        }).when((Object)this.ui)).access((Command)Mockito.any(Command.class));
        this.owner = (Element)Mockito.mock(Element.class);
        Component componentOwner = (Component)Mockito.mock(Component.class);
        Mockito.when((Object)this.owner.getComponent()).thenReturn(Optional.of(componentOwner));
        Mockito.when((Object)componentOwner.getUI()).thenReturn(Optional.of(this.ui));
        this.downloadEvent = new DownloadEvent(this.request, this.response, this.session, this.owner);
        this.outputStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)this.outputStream);
        Mockito.when((Object)this.response.getService()).thenReturn((Object)this.service);
        Mockito.when((Object)this.service.getMimeType(Mockito.anyString())).thenReturn((Object)"application/octet-stream");
    }

    @Test
    public void transferProgressListener_addListener_listenersInvoked() throws URISyntaxException, IOException {
        final ArrayList invocations = new ArrayList();
        final ArrayList transferredBytesRecords = new ArrayList();
        InputStreamDownloadHandler handler = DownloadHandler.fromInputStream((InputStreamDownloadCallback & Serializable)request -> {
            byte[] data = InputStreamDownloadHandlerTest.getBytes();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            return new DownloadResponse((InputStream)inputStream, "download", "application/octet-stream", (long)data.length);
        }, (TransferProgressListener)new TransferProgressListener(){

            public void onStart(TransferContext context) {
                Assert.assertEquals((long)165000L, (long)context.contentLength());
                Assert.assertEquals((Object)"download", (Object)context.fileName());
                invocations.add("onStart");
            }

            public void onProgress(TransferContext context, long transferredBytes, long totalBytes) {
                transferredBytesRecords.add(transferredBytes);
                Assert.assertEquals((long)165000L, (long)totalBytes);
                Assert.assertEquals((Object)"download", (Object)context.fileName());
                invocations.add("onProgress");
            }

            public void onComplete(TransferContext context, long transferredBytes) {
                Assert.assertEquals((long)165000L, (long)context.contentLength());
                Assert.assertEquals((long)165000L, (long)transferredBytes);
                Assert.assertEquals((Object)"download", (Object)context.fileName());
                invocations.add("onComplete");
            }

            public void onError(TransferContext context, IOException reason) {
                invocations.add("onError");
            }
        });
        handler.handleDownloadRequest(this.downloadEvent);
        Assert.assertEquals(List.of("onStart", "onProgress", "onProgress", "onComplete"), invocations);
        Assert.assertArrayEquals((long[])new long[]{65536L, 131072L}, (long[])transferredBytesRecords.stream().mapToLong(Long::longValue).toArray());
        ((VaadinResponse)Mockito.verify((Object)this.response)).setContentType("application/octet-stream");
    }

    @Test
    public void transferProgressListener_addListener_errorOccurred_errorListenerInvoked() throws IOException {
        DownloadEvent event = (DownloadEvent)Mockito.mock(DownloadEvent.class);
        Mockito.when((Object)event.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)event.getResponse()).thenReturn((Object)this.response);
        Mockito.when((Object)event.getOwningElement()).thenReturn((Object)this.owner);
        Mockito.when((Object)event.getUI()).thenReturn((Object)this.ui);
        OutputStream outputStreamMock = (OutputStream)Mockito.mock(OutputStream.class);
        ((OutputStream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("I/O exception")}).when((Object)outputStreamMock)).write((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt());
        Mockito.when((Object)event.getOutputStream()).thenReturn((Object)outputStreamMock);
        AtomicReference whenCompleteResult = new AtomicReference();
        InvocationTrackingTransferProgressListener transferListener = new InvocationTrackingTransferProgressListener();
        DownloadHandler handler = (DownloadHandler)DownloadHandler.fromInputStream((InputStreamDownloadCallback & Serializable)req -> {
            byte[] data = InputStreamDownloadHandlerTest.getBytes();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            return new DownloadResponse((InputStream)inputStream, "download", "application/octet-stream", (long)data.length);
        }, (TransferProgressListener)transferListener).whenComplete((SerializableBiConsumer & Serializable)(context, success) -> whenCompleteResult.set(success));
        try {
            handler.handleDownloadRequest(event);
            Assert.fail((String)"Expected an IOException to be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals(List.of("onStart", "onError"), transferListener.invocations);
        Assert.assertNotNull((String)"Expected whenComplete to be invoked, but was not", whenCompleteResult.get());
        Assert.assertFalse((String)"Expected whenComplete to be invoked with false result, but got true", (boolean)((Boolean)whenCompleteResult.get()));
        ((DownloadEvent)Mockito.verify((Object)event)).setException((Exception)Mockito.any(IOException.class));
    }

    @Test
    public void transferProgressListener_addListener_callbackIOExceptionOccurred_errorListenerInvoked() {
        DownloadEvent event = (DownloadEvent)Mockito.mock(DownloadEvent.class);
        Mockito.when((Object)event.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)event.getResponse()).thenReturn((Object)this.response);
        Mockito.when((Object)event.getOwningElement()).thenReturn((Object)this.owner);
        Mockito.when((Object)event.getUI()).thenReturn((Object)this.ui);
        OutputStream outputStreamMock = (OutputStream)Mockito.mock(OutputStream.class);
        Mockito.when((Object)event.getOutputStream()).thenReturn((Object)outputStreamMock);
        AtomicReference whenCompleteResult = new AtomicReference();
        InvocationTrackingTransferProgressListener transferListener = new InvocationTrackingTransferProgressListener();
        DownloadHandler handler = (DownloadHandler)DownloadHandler.fromInputStream((InputStreamDownloadCallback & Serializable)req -> {
            throw new IOException("I/O exception");
        }, (TransferProgressListener)transferListener).whenComplete((SerializableBiConsumer & Serializable)(context, success) -> whenCompleteResult.set(success));
        try {
            handler.handleDownloadRequest(event);
            Assert.fail((String)"Expected an IOException to be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals(List.of("onError"), transferListener.invocations);
        Assert.assertNotNull((String)"Expected whenComplete to be invoked, but was not", whenCompleteResult.get());
        Assert.assertFalse((String)"Expected whenComplete to be invoked with false result, but got true", (boolean)((Boolean)whenCompleteResult.get()));
        ((DownloadEvent)Mockito.verify((Object)event)).setException((Exception)Mockito.any(IOException.class));
    }

    @Test
    public void transferProgressListener_addListener_callbackUncheckedExceptionOccurred_errorListenerInvoked() {
        DownloadEvent event = (DownloadEvent)Mockito.mock(DownloadEvent.class);
        Mockito.when((Object)event.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)event.getResponse()).thenReturn((Object)this.response);
        Mockito.when((Object)event.getOwningElement()).thenReturn((Object)this.owner);
        Mockito.when((Object)event.getUI()).thenReturn((Object)this.ui);
        OutputStream outputStreamMock = (OutputStream)Mockito.mock(OutputStream.class);
        Mockito.when((Object)event.getOutputStream()).thenReturn((Object)outputStreamMock);
        AtomicReference whenCompleteResult = new AtomicReference();
        InvocationTrackingTransferProgressListener transferListener = new InvocationTrackingTransferProgressListener();
        DownloadHandler handler = (DownloadHandler)DownloadHandler.fromInputStream((InputStreamDownloadCallback & Serializable)req -> {
            throw new RuntimeException("I/O exception");
        }, (TransferProgressListener)transferListener).whenComplete((SerializableBiConsumer & Serializable)(context, success) -> whenCompleteResult.set(success));
        try {
            handler.handleDownloadRequest(event);
            Assert.fail((String)"Expected an exception to be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals(List.of("onError"), transferListener.invocations);
        Assert.assertNotNull((String)"Expected whenComplete to be invoked, but was not", whenCompleteResult.get());
        Assert.assertFalse((String)"Expected whenComplete to be invoked with false result, but got true", (boolean)((Boolean)whenCompleteResult.get()));
        ((DownloadEvent)Mockito.verify((Object)event)).setException((Exception)Mockito.any(RuntimeException.class));
    }

    @Test
    public void transferProgressListener_addListener_callbackResponseError_errorListenerInvoked() throws IOException {
        DownloadEvent event = (DownloadEvent)Mockito.mock(DownloadEvent.class);
        Mockito.when((Object)event.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)event.getResponse()).thenReturn((Object)this.response);
        Mockito.when((Object)event.getOwningElement()).thenReturn((Object)this.owner);
        Mockito.when((Object)event.getUI()).thenReturn((Object)this.ui);
        OutputStream outputStreamMock = (OutputStream)Mockito.mock(OutputStream.class);
        Mockito.when((Object)event.getOutputStream()).thenReturn((Object)outputStreamMock);
        AtomicReference whenCompleteResult = new AtomicReference();
        InvocationTrackingTransferProgressListener transferListener = new InvocationTrackingTransferProgressListener();
        DownloadHandler handler = (DownloadHandler)DownloadHandler.fromInputStream((InputStreamDownloadCallback & Serializable)req -> DownloadResponse.error((int)500, (String)"I/O exception"), (TransferProgressListener)transferListener).whenComplete((SerializableBiConsumer & Serializable)(context, success) -> whenCompleteResult.set(success));
        handler.handleDownloadRequest(event);
        Assert.assertEquals(List.of("onError"), transferListener.invocations);
        Assert.assertNotNull((String)"Expected whenComplete to be invoked, but was not", whenCompleteResult.get());
        Assert.assertFalse((String)"Expected whenComplete to be invoked with false result, but got true", (boolean)((Boolean)whenCompleteResult.get()));
        ((DownloadEvent)Mockito.verify((Object)event)).setException((Exception)Mockito.any(IOException.class));
    }

    @Test
    public void transferProgressListener_addListener_callbackResponseException_errorListenerInvoked() throws IOException {
        DownloadEvent event = (DownloadEvent)Mockito.mock(DownloadEvent.class);
        Mockito.when((Object)event.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)event.getResponse()).thenReturn((Object)this.response);
        Mockito.when((Object)event.getOwningElement()).thenReturn((Object)this.owner);
        Mockito.when((Object)event.getUI()).thenReturn((Object)this.ui);
        OutputStream outputStreamMock = (OutputStream)Mockito.mock(OutputStream.class);
        Mockito.when((Object)event.getOutputStream()).thenReturn((Object)outputStreamMock);
        AtomicReference whenCompleteResult = new AtomicReference();
        RuntimeException responseException = new RuntimeException("runtime exception");
        InvocationTrackingTransferProgressListener transferListener = new InvocationTrackingTransferProgressListener(){

            @Override
            public void onError(TransferContext context, IOException reason) {
                this.invocations.add("onError");
                Assert.assertEquals((Object)"Runtime exception", (Object)reason.getMessage());
            }
        };
        DownloadHandler handler = (DownloadHandler)DownloadHandler.fromInputStream((InputStreamDownloadCallback & Serializable)req -> DownloadResponse.error((int)500, (String)"Runtime exception", (Exception)responseException), (TransferProgressListener)transferListener).whenComplete((SerializableBiConsumer & Serializable)(context, success) -> whenCompleteResult.set(success));
        handler.handleDownloadRequest(event);
        Assert.assertEquals(List.of("onError"), transferListener.invocations);
        Assert.assertNotNull((String)"Expected whenComplete to be invoked, but was not", whenCompleteResult.get());
        Assert.assertFalse((String)"Expected whenComplete to be invoked with false result, but got true", (boolean)((Boolean)whenCompleteResult.get()));
        ((DownloadEvent)Mockito.verify((Object)event)).setException((Exception)responseException);
    }

    @Test
    public void inline_setFileNameInvokedByDefault() throws IOException {
        DownloadEvent event = (DownloadEvent)Mockito.mock(DownloadEvent.class);
        InputStreamDownloadHandler handler = DownloadHandler.fromInputStream((InputStreamDownloadCallback & Serializable)request -> {
            ((DownloadEvent)Mockito.verify((Object)event, (VerificationMode)Mockito.times((int)0))).setFileName("my-download.bin");
            ((DownloadEvent)Mockito.verify((Object)event, (VerificationMode)Mockito.times((int)0))).setContentType("application/octet-stream");
            byte[] data = InputStreamDownloadHandlerTest.getBytes();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            return new DownloadResponse((InputStream)inputStream, "my-download.bin", "application/octet-stream", (long)data.length);
        });
        Mockito.when((Object)event.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)event.getRequest()).thenReturn((Object)this.request);
        Mockito.when((Object)event.getResponse()).thenReturn((Object)this.response);
        Mockito.when((Object)event.getOwningElement()).thenReturn((Object)this.owner);
        Mockito.when((Object)event.getOutputStream()).thenReturn((Object)this.outputStream);
        Mockito.when((Object)event.getUI()).thenReturn((Object)this.ui);
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)this.outputStream);
        Mockito.when((Object)this.response.getService()).thenReturn((Object)this.service);
        Mockito.when((Object)this.service.getMimeType(Mockito.anyString())).thenReturn((Object)"application/octet-stream");
        handler.handleDownloadRequest(event);
        ((DownloadEvent)Mockito.verify((Object)event)).setFileName("my-download.bin");
        ((DownloadEvent)Mockito.verify((Object)event)).setContentType("application/octet-stream");
    }

    @Test
    public void attachment_doesNotSetFileNameWhenInlined() throws IOException {
        AbstractDownloadHandler handler = DownloadHandler.fromInputStream((InputStreamDownloadCallback & Serializable)request -> {
            byte[] data = InputStreamDownloadHandlerTest.getBytes();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            return new DownloadResponse((InputStream)inputStream, "download", "application/octet-stream", (long)data.length);
        }).inline();
        DownloadEvent event = (DownloadEvent)Mockito.mock(DownloadEvent.class);
        Mockito.when((Object)event.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)event.getRequest()).thenReturn((Object)this.request);
        Mockito.when((Object)event.getResponse()).thenReturn((Object)this.response);
        Mockito.when((Object)event.getOwningElement()).thenReturn((Object)this.owner);
        Mockito.when((Object)event.getOutputStream()).thenReturn((Object)this.outputStream);
        Mockito.when((Object)event.getUI()).thenReturn((Object)this.ui);
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)this.outputStream);
        Mockito.when((Object)this.response.getService()).thenReturn((Object)this.service);
        Mockito.when((Object)this.service.getMimeType(Mockito.anyString())).thenReturn((Object)"application/octet-stream");
        handler.handleDownloadRequest(event);
        ((DownloadEvent)Mockito.verify((Object)event, (VerificationMode)Mockito.times((int)0))).setFileName("my-download.bin");
        ((DownloadEvent)Mockito.verify((Object)event)).setContentType("application/octet-stream");
    }

    @Test
    public void inputStreamDownloadCallback_doesNotRequireCatch() {
        new InputStreamDownloadHandler((InputStreamDownloadCallback & Serializable)event -> {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(InputStreamDownloadHandlerTest.getBytes());){
                ((InputStream)inputStream).readAllBytes();
                DownloadResponse downloadResponse = null;
                return downloadResponse;
            }
        });
    }

    @Test
    public void downloadResponseHasContentType_contentTypeUsed() throws IOException {
        String contentType = "custom";
        InputStreamDownloadHandler handler = new InputStreamDownloadHandler((InputStreamDownloadCallback & Serializable)event -> {
            InputStream stream = (InputStream)Mockito.mock(InputStream.class);
            Mockito.when((Object)stream.read((byte[])Mockito.any(), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)-1);
            return new DownloadResponse(stream, "report.pdf", contentType, 0L);
        });
        DownloadEvent event2 = new DownloadEvent(this.request, this.response, this.session, new Element("div"));
        handler.handleDownloadRequest(event2);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setContentType(contentType);
    }

    @Test
    public void downloadResponseNullContentType_fileTypeIsUsed() throws IOException {
        String contentType = "file/pdf";
        Mockito.when((Object)this.service.getMimeType("report.pdf")).thenReturn((Object)contentType);
        InputStreamDownloadHandler handler = new InputStreamDownloadHandler((InputStreamDownloadCallback & Serializable)event -> {
            InputStream stream = (InputStream)Mockito.mock(InputStream.class);
            Mockito.when((Object)stream.read((byte[])Mockito.any(), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)-1);
            return new DownloadResponse(stream, "report.pdf", null, 0L);
        });
        DownloadEvent event2 = new DownloadEvent(this.request, this.response, this.session, new Element("div"));
        handler.handleDownloadRequest(event2);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setContentType(contentType);
    }

    @Test
    public void handleSetToInline_contentDispositionIsInlineWithFilename() throws IOException {
        InputStream stream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)stream.read((byte[])Mockito.any(), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)-1);
        AbstractDownloadHandler handler = DownloadHandler.fromInputStream((InputStreamDownloadCallback & Serializable)event -> new DownloadResponse(stream, "download", "application/octet-stream", 0L)).inline();
        DownloadEvent event2 = new DownloadEvent(this.request, this.response, this.session, new Element("t"));
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)this.outputStream);
        Mockito.when((Object)this.response.getService()).thenReturn((Object)this.service);
        Mockito.when((Object)this.service.getMimeType(Mockito.anyString())).thenReturn((Object)"application/octet-stream");
        handler.handleDownloadRequest(event2);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setHeader("Content-Disposition", "inline; filename=\"download\"");
    }

    @Test
    public void contentLengthProvided_contentLengthHeaderSet() throws IOException {
        long expectedContentLength = 12345L;
        InputStream stream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)stream.read((byte[])Mockito.any(), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)-1);
        InputStreamDownloadHandler handler = new InputStreamDownloadHandler((InputStreamDownloadCallback & Serializable)event -> new DownloadResponse(stream, "report.pdf", "application/pdf", expectedContentLength));
        DownloadEvent event2 = new DownloadEvent(this.request, this.response, this.session, new Element("div"));
        handler.handleDownloadRequest(event2);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setContentLengthLong(expectedContentLength);
    }

    private static byte[] getBytes() {
        byte[] data = new byte[165000];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(i % 256);
        }
        return data;
    }

    private static class InvocationTrackingTransferProgressListener
    implements TransferProgressListener {
        final List<String> invocations = new ArrayList<String>();

        private InvocationTrackingTransferProgressListener() {
        }

        public void onStart(TransferContext context) {
            this.invocations.add("onStart");
        }

        public void onProgress(TransferContext context, long transferredBytes, long totalBytes) {
            this.invocations.add("onProgress");
        }

        public void onComplete(TransferContext context, long transferredBytes) {
            this.invocations.add("onComplete");
        }

        public void onError(TransferContext context, IOException reason) {
            this.invocations.add("onError");
            Assert.assertEquals((Object)"I/O exception", (Object)reason.getMessage());
        }
    }
}

