/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.streams.AbstractDownloadHandler;
import com.vaadin.flow.server.streams.ClassDownloadHandler;
import com.vaadin.flow.server.streams.DownloadEvent;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.TransferContext;
import com.vaadin.flow.server.streams.TransferProgressListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ClassDownloadHandlerTest {
    private static final String PATH_TO_FILE = "downloads/generated_binary_file.bin";
    private VaadinRequest request;
    private VaadinResponse response;
    private VaadinSession session;
    private VaadinService service;
    private DownloadEvent downloadEvent;
    private OutputStream outputStream;
    private Element owner;
    private UI ui;

    @Before
    public void setUp() throws IOException {
        this.request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        this.response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        this.session = (VaadinSession)Mockito.mock(VaadinSession.class);
        this.service = (VaadinService)Mockito.mock(VaadinService.class);
        this.ui = (UI)Mockito.mock(UI.class);
        ((UI)Mockito.doAnswer(invocation -> {
            Command command = (Command)invocation.getArgument(0);
            command.execute();
            return null;
        }).when((Object)this.ui)).access((Command)Mockito.any(Command.class));
        this.owner = (Element)Mockito.mock(Element.class);
        Component componentOwner = (Component)Mockito.mock(Component.class);
        Mockito.when((Object)this.owner.getComponent()).thenReturn(Optional.of(componentOwner));
        Mockito.when((Object)componentOwner.getUI()).thenReturn(Optional.of(this.ui));
        this.downloadEvent = new DownloadEvent(this.request, this.response, this.session, this.owner);
        this.outputStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)this.outputStream);
        Mockito.when((Object)this.response.getService()).thenReturn((Object)this.service);
        Mockito.when((Object)this.service.getMimeType(Mockito.anyString())).thenReturn((Object)"application/octet-stream");
    }

    @Test
    public void transferProgressListener_addListener_listenersInvoked() throws URISyntaxException, IOException {
        final ArrayList invocations = new ArrayList();
        final ArrayList transferredBytesRecords = new ArrayList();
        ClassDownloadHandler handler = DownloadHandler.forClassResource(this.getClass(), (String)PATH_TO_FILE, (String)"download", (TransferProgressListener)new TransferProgressListener(){

            public void onStart(TransferContext context) {
                Assert.assertEquals((long)-1L, (long)context.contentLength());
                Assert.assertEquals((Object)"download", (Object)context.fileName());
                invocations.add("onStart");
            }

            public void onProgress(TransferContext context, long transferredBytes, long totalBytes) {
                transferredBytesRecords.add(transferredBytes);
                Assert.assertEquals((long)-1L, (long)totalBytes);
                Assert.assertEquals((Object)"download", (Object)context.fileName());
                invocations.add("onProgress");
            }

            public void onComplete(TransferContext context, long transferredBytes) {
                Assert.assertEquals((long)-1L, (long)context.contentLength());
                Assert.assertEquals((long)165000L, (long)transferredBytes);
                Assert.assertEquals((Object)"download", (Object)context.fileName());
                invocations.add("onComplete");
            }

            public void onError(TransferContext context, IOException reason) {
                invocations.add("onError");
            }
        });
        handler.handleDownloadRequest(this.downloadEvent);
        Assert.assertEquals(List.of("onStart", "onProgress", "onProgress", "onComplete"), invocations);
        Assert.assertArrayEquals((long[])new long[]{65536L, 131072L}, (long[])transferredBytesRecords.stream().mapToLong(Long::longValue).toArray());
        ((VaadinResponse)Mockito.verify((Object)this.response)).setContentType("application/octet-stream");
        Assert.assertNull((Object)this.downloadEvent.getException());
    }

    @Test
    public void transferProgressListener_addListener_errorOccured_errorlistenerInvoked() throws URISyntaxException, IOException {
        DownloadEvent event = (DownloadEvent)Mockito.mock(DownloadEvent.class);
        Mockito.when((Object)event.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)event.getResponse()).thenReturn((Object)this.response);
        Mockito.when((Object)event.getOwningElement()).thenReturn((Object)this.owner);
        Mockito.when((Object)event.getUI()).thenReturn((Object)this.ui);
        OutputStream outputStreamMock = (OutputStream)Mockito.mock(OutputStream.class);
        ((OutputStream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("I/O exception")}).when((Object)outputStreamMock)).write((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt());
        Mockito.when((Object)event.getOutputStream()).thenReturn((Object)outputStreamMock);
        final ArrayList invocations = new ArrayList();
        ClassDownloadHandler handler = DownloadHandler.forClassResource(this.getClass(), (String)PATH_TO_FILE, (String)"download", (TransferProgressListener)new TransferProgressListener(){

            public void onStart(TransferContext context) {
                invocations.add("onStart");
            }

            public void onProgress(TransferContext context, long transferredBytes, long totalBytes) {
                invocations.add("onProgress");
            }

            public void onComplete(TransferContext context, long transferredBytes) {
                invocations.add("onComplete");
            }

            public void onError(TransferContext context, IOException reason) {
                invocations.add("onError");
                Assert.assertEquals((Object)"I/O exception", (Object)reason.getMessage());
            }
        });
        try {
            handler.handleDownloadRequest(event);
            Assert.fail((String)"Expected an IOException to be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals(List.of("onStart", "onError"), invocations);
        ((DownloadEvent)Mockito.verify((Object)event)).setException((Exception)Mockito.any(IOException.class));
    }

    @Test
    public void inline_setFileNameInvokedByDefault() throws IOException {
        ClassDownloadHandler handler = DownloadHandler.forClassResource(this.getClass(), (String)PATH_TO_FILE, (String)"my-download.pdf");
        DownloadEvent event = (DownloadEvent)Mockito.mock(DownloadEvent.class);
        Mockito.when((Object)event.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)event.getResponse()).thenReturn((Object)this.response);
        Mockito.when((Object)event.getOwningElement()).thenReturn((Object)this.owner);
        Mockito.when((Object)event.getOutputStream()).thenReturn((Object)this.outputStream);
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)this.outputStream);
        Mockito.when((Object)this.response.getService()).thenReturn((Object)this.service);
        Mockito.when((Object)this.service.getMimeType(Mockito.anyString())).thenReturn((Object)"application/pdf");
        handler.handleDownloadRequest(event);
        ((DownloadEvent)Mockito.verify((Object)event)).setFileName("my-download.pdf");
        ((DownloadEvent)Mockito.verify((Object)event)).setContentType("application/pdf");
    }

    @Test
    public void attachment_doesNotSetFileNameWhenInlined() throws IOException {
        AbstractDownloadHandler handler = DownloadHandler.forClassResource(this.getClass(), (String)PATH_TO_FILE, (String)"my-download.pdf").inline();
        DownloadEvent event = (DownloadEvent)Mockito.mock(DownloadEvent.class);
        Mockito.when((Object)event.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)event.getResponse()).thenReturn((Object)this.response);
        Mockito.when((Object)event.getOwningElement()).thenReturn((Object)this.owner);
        Mockito.when((Object)event.getOutputStream()).thenReturn((Object)this.outputStream);
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)this.outputStream);
        Mockito.when((Object)this.response.getService()).thenReturn((Object)this.service);
        Mockito.when((Object)this.service.getMimeType(Mockito.anyString())).thenReturn((Object)"application/pdf");
        handler.handleDownloadRequest(event);
        ((DownloadEvent)Mockito.verify((Object)event, (VerificationMode)Mockito.times((int)0))).setFileName("my-download.pdf");
        ((DownloadEvent)Mockito.verify((Object)event)).setContentType("application/pdf");
    }

    @Test
    public void handleSetToInline_contentDispositionIsInlineWithFilename() throws IOException {
        AbstractDownloadHandler handler = DownloadHandler.forClassResource(this.getClass(), (String)PATH_TO_FILE, (String)"my-download.pdf").inline();
        DownloadEvent event = new DownloadEvent(this.request, this.response, this.session, new Element("t"));
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)this.outputStream);
        Mockito.when((Object)this.response.getService()).thenReturn((Object)this.service);
        Mockito.when((Object)this.service.getMimeType(Mockito.anyString())).thenReturn((Object)"application/octet-stream");
        handler.handleDownloadRequest(event);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setHeader("Content-Disposition", "inline; filename=\"my-download.pdf\"");
    }
}

