/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccessor;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.SessionExpiredException;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.PushHandler;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResponse;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PushHandlerTest {
    @Test
    public void onConnect_websocketTransport_requestStartIsCalledOnServiceInstance() {
        VaadinServletService service = this.runTest((handler, resource) -> {
            Mockito.when((Object)resource.transport()).thenReturn((Object)AtmosphereResource.TRANSPORT.WEBSOCKET);
            handler.onConnect(resource);
        });
        ((VaadinServletService)Mockito.verify((Object)service)).requestStart((VaadinRequest)Mockito.any(), (VaadinResponse)Mockito.any());
    }

    @Test
    public void onConnect_notWebsocketTransport_requestStartIsNotCalledOnServiceInstance() {
        VaadinServletService service = this.runTest((handler, resource) -> {
            Mockito.when((Object)resource.transport()).thenReturn((Object)AtmosphereResource.TRANSPORT.AJAX);
            handler.onConnect(resource);
        });
        ((VaadinServletService)Mockito.verify((Object)service, (VerificationMode)Mockito.times((int)0))).requestStart((VaadinRequest)Mockito.any(), (VaadinResponse)Mockito.any());
    }

    @Test
    public void onMessage_websocketTransport_requestStartIsCalledOnServiceInstance() {
        VaadinServletService service = this.runTest((handler, resource) -> {
            Mockito.when((Object)resource.transport()).thenReturn((Object)AtmosphereResource.TRANSPORT.WEBSOCKET);
            handler.onMessage(resource);
        });
        ((VaadinServletService)Mockito.verify((Object)service)).requestStart((VaadinRequest)Mockito.any(), (VaadinResponse)Mockito.any());
    }

    @Test
    public void onMessage_notWebsocketTransport_requestStartIsNotCalledOnServiceInstance() {
        VaadinServletService service = this.runTest((handler, resource) -> {
            Mockito.when((Object)resource.transport()).thenReturn((Object)AtmosphereResource.TRANSPORT.AJAX);
            handler.onMessage(resource);
        });
        ((VaadinServletService)Mockito.verify((Object)service, (VerificationMode)Mockito.times((int)0))).requestStart((VaadinRequest)Mockito.any(), (VaadinResponse)Mockito.any());
    }

    @Test
    public void onConnect_devMode_websocket_refreshConnection_onConnectIsCalled_callWithUIIsNotCalled() throws ServiceException {
        MockVaadinServletService service = (MockVaadinServletService)((Object)Mockito.spy(MockVaadinServletService.class));
        MockDeploymentConfiguration deploymentConfiguration = (MockDeploymentConfiguration)service.getDeploymentConfiguration();
        deploymentConfiguration.setProductionMode(false);
        deploymentConfiguration.setDevModeLiveReloadEnabled(true);
        deploymentConfiguration.setDevToolsEnabled(true);
        ApplicationConfiguration applicationConfiguration = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        Mockito.when((Object)applicationConfiguration.isProductionMode()).thenReturn((Object)false);
        VaadinContext context = service.getContext();
        context.setAttribute(ApplicationConfiguration.class, (Object)applicationConfiguration);
        BrowserLiveReload liveReload = PushHandlerTest.mockBrowserLiveReloadImpl(service.getLookup());
        AtomicReference res = new AtomicReference();
        this.runTest(service, (handler, resource) -> {
            AtmosphereRequest request = resource.getRequest();
            Mockito.when((Object)request.getParameter("debug_window")).thenReturn((Object)"");
            Mockito.when((Object)resource.transport()).thenReturn((Object)AtmosphereResource.TRANSPORT.WEBSOCKET);
            handler.onConnect(resource);
            res.set(resource);
        });
        ((MockVaadinServletService)((Object)Mockito.verify((Object)((Object)service), (VerificationMode)Mockito.times((int)0)))).requestStart((VaadinRequest)Mockito.any(), (VaadinResponse)Mockito.any());
        ((BrowserLiveReload)Mockito.verify((Object)liveReload)).onConnect((AtmosphereResource)res.get());
    }

    @Test
    public void onMessage_devMode_websocket_refreshConnection_callWithUIIsNotCalled() throws ServiceException {
        MockVaadinServletService service = (MockVaadinServletService)((Object)Mockito.spy(MockVaadinServletService.class));
        MockDeploymentConfiguration deploymentConfiguration = (MockDeploymentConfiguration)service.getDeploymentConfiguration();
        deploymentConfiguration.setProductionMode(false);
        deploymentConfiguration.setDevModeLiveReloadEnabled(true);
        deploymentConfiguration.setDevToolsEnabled(true);
        this.setProductionMode((VaadinService)service, false);
        PushHandlerTest.mockBrowserLiveReloadImpl(service.getLookup());
        AtomicReference res = new AtomicReference();
        this.runTest(service, (handler, resource) -> {
            AtmosphereRequest request = resource.getRequest();
            try {
                Mockito.when((Object)request.getReader()).thenReturn((Object)new BufferedReader(new StringReader("")));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Mockito.when((Object)request.getParameter("debug_window")).thenReturn((Object)"");
            Mockito.when((Object)resource.transport()).thenReturn((Object)AtmosphereResource.TRANSPORT.WEBSOCKET);
            try {
                Mockito.when((Object)request.getReader()).thenReturn((Object)new BufferedReader(new StringReader("{}")));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            handler.onMessage(resource);
            res.set(resource);
        });
        ((MockVaadinServletService)((Object)Mockito.verify((Object)((Object)service), (VerificationMode)Mockito.times((int)0)))).requestStart((VaadinRequest)Mockito.any(), (VaadinResponse)Mockito.any());
    }

    @Test
    public void onConnect_devMode_websocket_noRefreshConnection_delegteCallWithUI() throws ServiceException {
        MockVaadinServletService service = (MockVaadinServletService)((Object)Mockito.spy(MockVaadinServletService.class));
        MockDeploymentConfiguration deploymentConfiguration = (MockDeploymentConfiguration)service.getDeploymentConfiguration();
        deploymentConfiguration.setProductionMode(false);
        this.runTest(service, (handler, resource) -> {
            AtmosphereRequest request = resource.getRequest();
            Mockito.when((Object)request.getParameter("debug_window")).thenReturn(null);
            Mockito.when((Object)resource.transport()).thenReturn((Object)AtmosphereResource.TRANSPORT.WEBSOCKET);
            handler.onConnect(resource);
        });
        ((MockVaadinServletService)((Object)Mockito.verify((Object)((Object)service)))).requestStart((VaadinRequest)Mockito.any(), (VaadinResponse)Mockito.any());
    }

    @Test
    public void onConnect_devMode_notWebsocket_refreshConnection_delegteCallWithUI() throws ServiceException, SessionExpiredException {
        MockVaadinServletService service = (MockVaadinServletService)((Object)Mockito.spy(MockVaadinServletService.class));
        MockDeploymentConfiguration deploymentConfiguration = (MockDeploymentConfiguration)service.getDeploymentConfiguration();
        deploymentConfiguration.setProductionMode(false);
        this.runTest(service, (handler, resource) -> {
            AtmosphereRequest request = resource.getRequest();
            Mockito.when((Object)request.getParameter("debug_window")).thenReturn((Object)"");
            Mockito.when((Object)resource.transport()).thenReturn((Object)AtmosphereResource.TRANSPORT.AJAX);
            handler.onConnect(resource);
        });
        ((MockVaadinServletService)((Object)Mockito.verify((Object)((Object)service)))).findVaadinSession((VaadinRequest)Mockito.any());
    }

    @Test
    public void connectionLost_noSession_currentInstancesAreCleared() throws SessionExpiredException {
        try {
            this.mockConnectionLost(new MockVaadinSession(), false);
            Assert.assertNull((Object)VaadinSession.getCurrent());
        }
        finally {
            VaadinSession.setCurrent(null);
        }
    }

    @Test
    public void connectionLost_sessionIsSetViaCurrent_currentInstancesAreCleared() throws SessionExpiredException {
        try {
            this.mockConnectionLost(new MockVaadinSession(), true);
            Assert.assertNotNull((Object)VaadinSession.getCurrent());
        }
        finally {
            VaadinSession.setCurrent(null);
        }
    }

    @Test
    public void connect_noSession_sendNotification() {
        try {
            Assert.assertNull((Object)VaadinSession.getCurrent());
            AtomicReference res = new AtomicReference();
            this.runTest((handler, resource) -> {
                Mockito.when((Object)resource.transport()).thenReturn((Object)AtmosphereResource.TRANSPORT.WEBSOCKET);
                handler.onConnect(resource);
                res.set(resource);
            });
            Assert.assertNull((Object)VaadinSession.getCurrent());
            ((AtmosphereResource)Mockito.verify((Object)((AtmosphereResource)res.get()), (VerificationMode)Mockito.times((int)2))).getResponse();
        }
        finally {
            VaadinSession.setCurrent(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void connectionLost_connectWithoutSession_doNotSendNotification() {
        try {
            AtmosphereResource resource = (AtmosphereResource)Mockito.mock(AtmosphereResource.class);
            Mockito.when((Object)resource.uuid()).thenReturn((Object)"1");
            try {
                MockVaadinServletService service = new MockVaadinServletService(){

                    public VaadinSession findVaadinSession(VaadinRequest request) throws SessionExpiredException {
                        throw new SessionExpiredException();
                    }

                    public UI findUI(VaadinRequest request) {
                        return null;
                    }
                };
                this.setProductionMode((VaadinService)service, false);
                VaadinSession.setCurrent(null);
                PushHandler handler = new PushHandler((VaadinServletService)service);
                AtmosphereRequest request = (AtmosphereRequest)Mockito.mock(AtmosphereRequest.class);
                Mockito.when((Object)resource.getRequest()).thenReturn((Object)request);
                AtmosphereResourceEvent event = (AtmosphereResourceEvent)Mockito.mock(AtmosphereResourceEvent.class);
                Mockito.when((Object)event.getResource()).thenReturn((Object)resource);
                AtmosphereResponse response = (AtmosphereResponse)Mockito.mock(AtmosphereResponse.class);
                Mockito.when((Object)response.getWriter()).thenReturn((Object)((PrintWriter)Mockito.mock(PrintWriter.class)));
                Mockito.when((Object)resource.getResponse()).thenReturn((Object)response);
                Mockito.when((Object)resource.transport()).thenReturn((Object)AtmosphereResource.TRANSPORT.WEBSOCKET);
                handler.connectionLost(event);
                handler.onConnect(resource);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Assert.assertNull((Object)VaadinSession.getCurrent());
            ((AtmosphereResource)Mockito.verify((Object)resource, (VerificationMode)Mockito.times((int)0))).getResponse();
        }
        finally {
            VaadinSession.setCurrent(null);
        }
    }

    @Test
    public void debugWindowConnection_productionMode_mustNeverBeConnected() throws Exception {
        MockVaadinServletService service = (MockVaadinServletService)((Object)Mockito.spy(MockVaadinServletService.class));
        this.setProductionMode((VaadinService)service, true);
        this.runTest(service, (handler, resource) -> {
            Mockito.when((Object)resource.transport()).thenReturn((Object)AtmosphereResource.TRANSPORT.WEBSOCKET);
            Mockito.when((Object)resource.getRequest().getParameter("debug_window")).thenReturn((Object)"");
            ((PushHandler)Mockito.doNothing().when(handler)).callWithServiceAndSession((AtmosphereResource)Mockito.any(), (Consumer)Mockito.any());
            handler.onConnect(resource);
            ((PushHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).callWithServiceAndSession((AtmosphereResource)Mockito.any(), (Consumer)Mockito.any());
            ((PushHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).callWithUi((AtmosphereResource)Mockito.any(), (PushHandler.PushEventCallback)Mockito.any());
        });
    }

    private void setProductionMode(VaadinService service, boolean productionMode) {
        ApplicationConfiguration applicationConfiguration = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        Mockito.when((Object)applicationConfiguration.isProductionMode()).thenReturn((Object)productionMode);
        VaadinContext context = service.getContext();
        context.setAttribute(ApplicationConfiguration.class, (Object)applicationConfiguration);
    }

    private MockVaadinServletService mockConnectionLost(final VaadinSession session, boolean setSession) {
        final AtomicBoolean sessionIsSet = new AtomicBoolean();
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinSession findVaadinSession(VaadinRequest request) throws SessionExpiredException {
                VaadinSession.setCurrent((VaadinSession)session);
                sessionIsSet.set(true);
                if (session == null) {
                    throw new SessionExpiredException();
                }
                Assert.assertNotNull((Object)VaadinSession.getCurrent());
                return session;
            }

            public UI findUI(VaadinRequest request) {
                return null;
            }
        };
        this.setProductionMode((VaadinService)service, false);
        if (setSession) {
            VaadinSession.setCurrent((VaadinSession)session);
        }
        PushHandler handler = new PushHandler((VaadinServletService)service);
        AtmosphereResource resource = (AtmosphereResource)Mockito.mock(AtmosphereResource.class);
        AtmosphereRequest request = (AtmosphereRequest)Mockito.mock(AtmosphereRequest.class);
        Mockito.when((Object)resource.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)resource.uuid()).thenReturn((Object)"1");
        AtmosphereResourceEvent event = (AtmosphereResourceEvent)Mockito.mock(AtmosphereResourceEvent.class);
        Mockito.when((Object)event.getResource()).thenReturn((Object)resource);
        handler.connectionLost(event);
        Assert.assertTrue((boolean)sessionIsSet.get());
        return service;
    }

    private VaadinServletService runTest(VaadinServletService service, BiConsumer<PushHandler, AtmosphereResource> testExec) throws ServiceException {
        try {
            PushHandler handler = (PushHandler)Mockito.spy((Object)new PushHandler(service));
            AtmosphereResource resource = (AtmosphereResource)Mockito.mock(AtmosphereResource.class);
            AtmosphereRequest request = (AtmosphereRequest)Mockito.mock(AtmosphereRequest.class);
            AtmosphereResponse response = (AtmosphereResponse)Mockito.mock(AtmosphereResponse.class);
            Mockito.when((Object)response.getWriter()).thenReturn((Object)((PrintWriter)Mockito.mock(PrintWriter.class)));
            Mockito.when((Object)resource.getRequest()).thenReturn((Object)request);
            Mockito.when((Object)resource.getResponse()).thenReturn((Object)response);
            Mockito.when((Object)resource.uuid()).thenReturn((Object)"1");
            testExec.accept(handler, resource);
            return service;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private VaadinServletService runTest(BiConsumer<PushHandler, AtmosphereResource> testExec) {
        MockVaadinServletService service = (MockVaadinServletService)((Object)Mockito.spy(MockVaadinServletService.class));
        try {
            this.runTest(service, testExec);
            return service;
        }
        catch (ServiceException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static BrowserLiveReload mockBrowserLiveReloadImpl(Lookup lookup) {
        BrowserLiveReload liveReload = (BrowserLiveReload)Mockito.mock(BrowserLiveReload.class);
        Mockito.when((Object)((BrowserLiveReloadAccessor)lookup.lookup(BrowserLiveReloadAccessor.class))).thenReturn(context -> liveReload);
        return liveReload;
    }
}

