/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.menu.MenuRegistry;
import com.vaadin.flow.router.Layout;
import com.vaadin.flow.router.ParentLayout;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RoutePrefix;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.AbstractRouteRegistry;
import com.vaadin.flow.router.internal.ConfiguredRoutes;
import com.vaadin.flow.router.internal.RouteTarget;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.SessionRouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.menu.AvailableViewInfo;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class RouteUtilTest {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void route_path_should_contain_parent_prefix() {
        String routePath = RouteUtil.getRoutePath((VaadinContext)new MockVaadinContext(), BaseRouteWithParentPrefixAndRouteAlias.class);
        Assert.assertEquals((String)"Expected path should only have been parent RoutePrefix", (Object)"parent", (Object)routePath);
    }

    @Test
    public void absolute_route_should_not_contain_parent_prefix() {
        String routePath = RouteUtil.getRoutePath((VaadinContext)new MockVaadinContext(), AbsoluteRoute.class);
        Assert.assertEquals((String)"No parent prefix should have been added.", (Object)"single", (Object)routePath);
    }

    @Test
    public void absolute_middle_parent_route_should_not_contain_parent_prefix() {
        String routePath = RouteUtil.getRoutePath((VaadinContext)new MockVaadinContext(), AbsoluteCenterRoute.class);
        Assert.assertEquals((String)"No parent prefix should have been added.", (Object)"absolute/child", (Object)routePath);
    }

    @Test
    public void absolute_route_alias_should_not_contain_parent_prefix() {
        String routePath = RouteUtil.getRouteAliasPath(AbsoluteRoute.class, (RouteAlias)AbsoluteRoute.class.getAnnotation(RouteAlias.class));
        Assert.assertEquals((String)"No parent prefix should have been added.", (Object)"alias", (Object)routePath);
    }

    @Test
    public void absolute_middle_parent_for_route_alias_should_not_contain_parent_prefix() {
        String routePath = RouteUtil.getRouteAliasPath(AbsoluteRoute.class, (RouteAlias)AbsoluteCenterRoute.class.getAnnotation(RouteAlias.class));
        Assert.assertEquals((String)"No parent prefix should have been added.", (Object)"absolute/alias", (Object)routePath);
    }

    @Test
    public void route_path_should_contain_route_and_parent_prefix() {
        String routePath = RouteUtil.getRoutePath((VaadinContext)new MockVaadinContext(), RouteWithParentPrefixAndRouteAlias.class);
        Assert.assertEquals((String)"Expected path should only have been parent RoutePrefix", (Object)"parent/flow", (Object)routePath);
    }

    @Test
    public void route_alias_path_should_not_contain_parent_prefix() {
        String routePath = RouteUtil.getRouteAliasPath(BaseRouteWithParentPrefixAndRouteAlias.class, (RouteAlias)BaseRouteWithParentPrefixAndRouteAlias.class.getAnnotation(RouteAlias.class));
        Assert.assertEquals((String)"Expected path should only have been parent RoutePrefix", (Object)"alias", (Object)routePath);
        routePath = RouteUtil.getRouteAliasPath(RouteWithParentPrefixAndRouteAlias.class, (RouteAlias)RouteWithParentPrefixAndRouteAlias.class.getAnnotation(RouteAlias.class));
        Assert.assertEquals((String)"Expected path should only have been parent RoutePrefix", (Object)"alias", (Object)routePath);
    }

    @Test
    public void route_alias_should_contain_parent_prefix() {
        String routePath = RouteUtil.getRouteAliasPath(RouteAliasWithParentPrefix.class, (RouteAlias)RouteAliasWithParentPrefix.class.getAnnotation(RouteAlias.class));
        Assert.assertEquals((String)"Expected path should only have been parent RoutePrefix", (Object)"aliasparent/alias", (Object)routePath);
    }

    @Test
    public void top_parent_layout_should_be_found_for_base_route() {
        Class parent = RouteUtil.getTopParentLayout((VaadinContext)new MockVaadinContext(), BaseRouteWithParentPrefixAndRouteAlias.class, (String)"parent");
        Assert.assertNotNull((String)"Didn't find any parent for route", (Object)parent);
        Assert.assertEquals((String)"Received wrong parent class.", RoutePrefixParent.class, (Object)parent);
    }

    @Test
    public void top_parent_layout_should_be_found_for_non_base_route() {
        Class parent = RouteUtil.getTopParentLayout((VaadinContext)new MockVaadinContext(), RouteWithParentPrefixAndRouteAlias.class, (String)"parent/flow");
        Assert.assertNotNull((String)"Didn't find any parent for route", (Object)parent);
        Assert.assertEquals((String)"Received wrong parent class.", RoutePrefixParent.class, (Object)parent);
    }

    @Test
    public void no_top_parent_layout_for_route_alias() {
        Class parent = RouteUtil.getTopParentLayout((VaadinContext)new MockVaadinContext(), BaseRouteWithParentPrefixAndRouteAlias.class, (String)"alias");
        Assert.assertNull((String)"Found parent for RouteAlias without parent.", (Object)parent);
    }

    @Test
    public void top_parent_layout_for_route_alias() {
        Class parent = RouteUtil.getTopParentLayout((VaadinContext)new MockVaadinContext(), RouteAliasWithParentPrefix.class, (String)"aliasparent/alias");
        Assert.assertNotNull((String)"Didn't find any parent for route", (Object)parent);
        Assert.assertEquals((String)"Received wrong parent class.", RouteAliasPrefixParent.class, (Object)parent);
    }

    @Test
    public void top_parent_layout_for_absolute_route() {
        Class parent = RouteUtil.getTopParentLayout((VaadinContext)new MockVaadinContext(), AbsoluteRoute.class, (String)"single");
        Assert.assertNotNull((String)"Didn't find any parent for route", (Object)parent);
        Assert.assertEquals((String)"Received wrong parent class.", RoutePrefixParent.class, (Object)parent);
    }

    @Test
    public void top_parent_layout_for_absolute_route_parent() {
        Class parent = RouteUtil.getTopParentLayout((VaadinContext)new MockVaadinContext(), AbsoluteCenterRoute.class, (String)"absolute/child");
        Assert.assertNotNull((String)"Didn't find any parent for route", (Object)parent);
        Assert.assertEquals((String)"Received wrong parent class.", RoutePrefixParent.class, (Object)parent);
    }

    @Test
    public void top_parent_layout_for_absolute_route_alias() {
        Class parent = RouteUtil.getTopParentLayout((VaadinContext)new MockVaadinContext(), AbsoluteRoute.class, (String)"alias");
        Assert.assertNotNull((String)"Didn't find any parent for route", (Object)parent);
        Assert.assertEquals((String)"Received wrong parent class.", RoutePrefixParent.class, (Object)parent);
    }

    @Test
    public void top_parent_layout_for_absolute_route_alias_parent() {
        Class parent = RouteUtil.getTopParentLayout((VaadinContext)new MockVaadinContext(), AbsoluteCenterRoute.class, (String)"absolute/alias");
        Assert.assertNotNull((String)"Didn't find any parent for route", (Object)parent);
        Assert.assertEquals((String)"Received wrong parent class.", RoutePrefixParent.class, (Object)parent);
    }

    @Test
    public void automaticLayoutShouldBeAvailableForDefaultRoute() {
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                return new MockVaadinContext();
            }
        };
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)service.getContext());
        registry.setLayout(AutoLayout.class);
        List parentLayouts = RouteUtil.getParentLayouts((RouteRegistry)registry, AutoLayoutView.class, (String)"auto");
        Assert.assertEquals((String)"Route with no layout should not get automatic layout", (long)0L, (long)parentLayouts.size());
        Assert.assertTrue((boolean)RouteUtil.isAutolayoutEnabled(AutoLayoutView.class, (String)"auto"));
    }

    @Test
    public void routeAliasForAutoLayoutRoute_correctAliasIsSelectedForRoute() {
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                return new MockVaadinContext();
            }
        };
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)service.getContext());
        registry.setLayout(AutoLayout.class);
        Assert.assertTrue((boolean)RouteUtil.isAutolayoutEnabled(AutoLayoutView.class, (String)"auto"));
        Assert.assertFalse((String)"'alias' route has autolayout false", (boolean)RouteUtil.isAutolayoutEnabled(AutoLayoutView.class, (String)"alias"));
        Assert.assertFalse((String)"'mainLayout' has a defined layout", (boolean)RouteUtil.isAutolayoutEnabled(AutoLayoutView.class, (String)"mainLayout"));
        Assert.assertTrue((boolean)RouteUtil.isAutolayoutEnabled(AutoLayoutView.class, (String)"autoAlias"));
    }

    @Test
    public void expected_parent_layouts_are_found_for_route() {
        List parentLayouts = RouteUtil.getParentLayouts((VaadinContext)new MockVaadinContext(), BaseRouteWithParentPrefixAndRouteAlias.class, (String)"parent");
        MatcherAssert.assertThat((String)"Get parent layouts for route \"\" with parent prefix \"parent\" gave wrong result.", (Object)parentLayouts, (Matcher)IsIterableContainingInOrder.contains((Object[])new Class[]{RoutePrefixParent.class}));
        parentLayouts = RouteUtil.getParentLayouts((VaadinContext)new MockVaadinContext(), RootWithParents.class, (String)"");
        MatcherAssert.assertThat((String)"Expected to receive MiddleParent and Parent classes as parents.", (Object)parentLayouts, (Matcher)IsIterableContainingInOrder.contains((Object[])new Class[]{MiddleParent.class, Parent.class}));
    }

    @Test
    public void expected_to_get_parent_layout() {
        List parentLayouts = RouteUtil.getParentLayoutsForNonRouteTarget(NonRouteTargetWithParents.class);
        Assert.assertEquals((String)"Expected one parent layout", (long)1L, (long)parentLayouts.size());
        MatcherAssert.assertThat((String)"Get parent layouts for route \"\" with parent prefix \"parent\" gave wrong result.", (Object)parentLayouts, (Matcher)IsIterableContainingInOrder.contains((Object[])new Class[]{Parent.class}));
    }

    @Test
    public void expected_parent_layouts_are_found_for_route_alias() {
        List parentLayouts = RouteUtil.getParentLayouts((VaadinContext)new MockVaadinContext(), RouteAliasWithParentPrefix.class, (String)"aliasparent/alias");
        MatcherAssert.assertThat((String)"Get parent layouts for route \"\" with parent prefix \"parent\" gave wrong result.", (Object)parentLayouts, (Matcher)IsIterableContainingInOrder.contains((Object[])new Class[]{RouteAliasPrefixParent.class}));
    }

    @Test
    public void absolute_route_gets_expected_parent_layouts() {
        List parentLayouts = RouteUtil.getParentLayouts((VaadinContext)new MockVaadinContext(), AbsoluteRoute.class, (String)"single");
        MatcherAssert.assertThat((String)"Get parent layouts for route \"\" with parent prefix \"parent\" gave wrong result.", (Object)parentLayouts, (Matcher)IsIterableContainingInOrder.contains((Object[])new Class[]{RoutePrefixParent.class}));
        parentLayouts = RouteUtil.getParentLayouts((VaadinContext)new MockVaadinContext(), AbsoluteCenterRoute.class, (String)"absolute/child");
        MatcherAssert.assertThat((String)"Expected to receive MiddleParent and Parent classes as parents.", (Object)parentLayouts, (Matcher)IsIterableContainingInOrder.contains((Object[])new Class[]{AbsoluteCenterParent.class, RoutePrefixParent.class}));
    }

    @Test
    public void abolute_route_alias_gets_expected_parent_layouts() {
        List parentLayouts = RouteUtil.getParentLayouts((VaadinContext)new MockVaadinContext(), AbsoluteRoute.class, (String)"alias");
        MatcherAssert.assertThat((String)"Get parent layouts for route \"\" with parent prefix \"parent\" gave wrong result.", (Object)parentLayouts, (Matcher)IsIterableContainingInOrder.contains((Object[])new Class[]{RoutePrefixParent.class}));
        parentLayouts = RouteUtil.getParentLayouts((VaadinContext)new MockVaadinContext(), AbsoluteCenterRoute.class, (String)"absolute/alias");
        MatcherAssert.assertThat((String)"Expected to receive MiddleParent and Parent classes as parents.", (Object)parentLayouts, (Matcher)IsIterableContainingInOrder.contains((Object[])new Class[]{AbsoluteCenterParent.class, RoutePrefixParent.class}));
    }

    @Test
    public void also_non_routes_can_be_used_to_get_top_parent_layout() {
        Class topParentLayout = RouteUtil.getTopParentLayout((VaadinContext)new MockVaadinContext(), MiddleParent.class, null);
        Assert.assertEquals((String)"Middle parent should have gotten Parent as top parent layout", Parent.class, (Object)topParentLayout);
    }

    @Test
    public void top_layout_resolves_correctly_for_route_parent() {
        Class topParentLayout = RouteUtil.getTopParentLayout((VaadinContext)new MockVaadinContext(), MultiTarget.class, (String)"");
        Assert.assertEquals((String)"@Route path should have gotten Parent as top parent layout", Parent.class, (Object)topParentLayout);
        topParentLayout = RouteUtil.getTopParentLayout((VaadinContext)new MockVaadinContext(), MultiTarget.class, (String)"alias");
        Assert.assertEquals((String)"@RouteAlias path should have gotten Parent as top parent layout", Parent.class, (Object)topParentLayout);
        topParentLayout = RouteUtil.getTopParentLayout((VaadinContext)new MockVaadinContext(), SubLayout.class, (String)"parent/sub");
        Assert.assertEquals((String)"SubLayout using MultiTarget as parent should have gotten RoutePrefixParent as top parent layout", RoutePrefixParent.class, (Object)topParentLayout);
    }

    @Test
    public void parent_layouts_resolve_correctly_for_route_parent() {
        List parentLayouts = RouteUtil.getParentLayouts((VaadinContext)new MockVaadinContext(), MultiTarget.class, (String)"");
        MatcherAssert.assertThat((String)"Get parent layouts for route \"\" gave wrong result.", (Object)parentLayouts, (Matcher)IsIterableContainingInOrder.contains((Object[])new Class[]{Parent.class}));
        parentLayouts = RouteUtil.getParentLayouts((VaadinContext)new MockVaadinContext(), MultiTarget.class, (String)"alias");
        MatcherAssert.assertThat((String)"Get parent layouts for routeAlias \"alias\" gave wrong result.", (Object)parentLayouts, (Matcher)IsIterableContainingInOrder.contains((Object[])new Class[]{MiddleParent.class, Parent.class}));
        parentLayouts = RouteUtil.getParentLayouts((VaadinContext)new MockVaadinContext(), SubLayout.class, (String)"parent/sub");
        MatcherAssert.assertThat((String)"Get parent layouts for route \"parent/sub\" with parent Route + ParentLayout gave wrong result.", (Object)parentLayouts, (Matcher)IsIterableContainingInOrder.contains((Object[])new Class[]{MultiTarget.class, RoutePrefixParent.class}));
    }

    @Test
    public void newRouteAnnotatedClass_updateRouteRegistry_routeIsAddedToRegistry() {
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                return new MockVaadinContext();
            }
        };
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)service.getContext());
        @Route(value="a")
        class A
        extends Component {
            A() {
            }
        }
        RouteUtil.updateRouteRegistry((RouteRegistry)registry, Collections.singleton(A.class), Collections.emptySet(), Collections.emptySet());
        Assert.assertTrue((boolean)registry.getConfiguration().hasRoute("a"));
    }

    @Test
    public void newRouteAnnotatedClass_sessionRegistry_updateRouteRegistry_routeIsNotAddedToRegistry() {
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                return new MockVaadinContext();
            }
        };
        SessionRouteRegistry registry = (SessionRouteRegistry)SessionRouteRegistry.getSessionRegistry((VaadinSession)new AlwaysLockedVaadinSession((VaadinService)service));
        @Route(value="a")
        class A
        extends Component {
            A() {
            }
        }
        RouteUtil.updateRouteRegistry((RouteRegistry)registry, Collections.singleton(A.class), Collections.emptySet(), Collections.emptySet());
        Assert.assertFalse((boolean)registry.getConfiguration().hasRoute("a"));
    }

    @Test
    public void newComponentClass_sessionRegistry_updateRouteRegistry_routeIsNotAddedToRegistry() {
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                return new MockVaadinContext();
            }
        };
        SessionRouteRegistry registry = (SessionRouteRegistry)SessionRouteRegistry.getSessionRegistry((VaadinSession)new AlwaysLockedVaadinSession((VaadinService)service));
        class A
        extends Component {
            A() {
            }
        }
        RouteUtil.updateRouteRegistry((RouteRegistry)registry, Collections.singleton(A.class), Collections.emptySet(), Collections.emptySet());
        Assert.assertFalse((boolean)registry.getConfiguration().hasRoute("a"));
    }

    @Test
    public void newLazyRouteAnnotatedClass_updateRouteRegistry_routeIsNotAddedToRegistry() {
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                return new MockVaadinContext();
            }
        };
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)service.getContext());
        @Route(value="a", registerAtStartup=false)
        class A
        extends Component {
            A() {
            }
        }
        RouteUtil.updateRouteRegistry((RouteRegistry)registry, Collections.singleton(A.class), Collections.emptySet(), Collections.emptySet());
        Assert.assertFalse((boolean)registry.getConfiguration().hasRoute("a"));
    }

    @Test
    public void newLazyRouteAnnotatedClass_sessionRegistry_updateRouteRegistry_routeIsNotAddedToRegistry() {
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                return new MockVaadinContext();
            }
        };
        SessionRouteRegistry registry = (SessionRouteRegistry)SessionRouteRegistry.getSessionRegistry((VaadinSession)new AlwaysLockedVaadinSession((VaadinService)service));
        @Route(value="a", registerAtStartup=false)
        class A
        extends Component {
            A() {
            }
        }
        RouteUtil.updateRouteRegistry((RouteRegistry)registry, Collections.singleton(A.class), Collections.emptySet(), Collections.emptySet());
        Assert.assertFalse((boolean)registry.getConfiguration().hasRoute("a"));
    }

    @Test
    public void newRouteComponentWithoutRouteAnnotation_updateRouteRegistry_routeIsNotAddedToRegistry() {
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                return new MockVaadinContext();
            }
        };
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)service.getContext());
        class A
        extends Component {
            A() {
            }
        }
        RouteUtil.updateRouteRegistry((RouteRegistry)registry, Collections.singleton(A.class), Collections.emptySet(), Collections.emptySet());
        Assert.assertFalse((boolean)registry.getConfiguration().hasRoute("a"));
    }

    @Test
    public void deletedRouteAnnotatedClass_updateRouteRegistry_routeIsRemovedFromRegistry() {
        MockVaadinServletService service = new MockVaadinServletService();
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)service.getContext());
        @Route(value="a")
        class A
        extends Component {
            A() {
            }
        }
        registry.setRoute("a", A.class, Collections.emptyList());
        Assert.assertTrue((boolean)registry.getConfiguration().hasRoute("a"));
        RouteUtil.updateRouteRegistry((RouteRegistry)registry, Collections.emptySet(), Collections.emptySet(), Collections.singleton(A.class));
        Assert.assertFalse((boolean)registry.getConfiguration().hasRoute("a"));
    }

    @Test
    public void deletedNotAnnotatedRouteClass_updateRouteRegistry_routeIsRemovedFromRegistry() {
        MockVaadinServletService service = new MockVaadinServletService();
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)service.getContext());
        class A
        extends Component {
            A() {
            }
        }
        registry.setRoute("a", A.class, Collections.emptyList());
        Assert.assertTrue((boolean)registry.getConfiguration().hasRoute("a"));
        RouteUtil.updateRouteRegistry((RouteRegistry)registry, Collections.emptySet(), Collections.emptySet(), Collections.singleton(A.class));
        Assert.assertFalse((boolean)registry.getConfiguration().hasRoute("a"));
    }

    @Test
    public void deletedRouteAnnotatedClass_sessionRegistry_updateRouteRegistry_routeIsRemovedFromRegistry() {
        MockVaadinServletService service = new MockVaadinServletService();
        SessionRouteRegistry registry = (SessionRouteRegistry)SessionRouteRegistry.getSessionRegistry((VaadinSession)new AlwaysLockedVaadinSession((VaadinService)service));
        @Route(value="a")
        class A
        extends Component {
            A() {
            }
        }
        registry.setRoute("a", A.class, Collections.emptyList());
        Assert.assertTrue((boolean)registry.getConfiguration().hasRoute("a"));
        RouteUtil.updateRouteRegistry((RouteRegistry)registry, Collections.emptySet(), Collections.emptySet(), Collections.singleton(A.class));
        Assert.assertFalse((boolean)registry.getConfiguration().hasRoute("a"));
    }

    @Test
    public void deletedNotAnnotatedRouteClass_sessionRegistry_updateRouteRegistry_routeIsRemovedFromRegistry() {
        MockVaadinServletService service = new MockVaadinServletService();
        SessionRouteRegistry registry = (SessionRouteRegistry)SessionRouteRegistry.getSessionRegistry((VaadinSession)new AlwaysLockedVaadinSession((VaadinService)service));
        class A
        extends Component {
            A() {
            }
        }
        registry.setRoute("a", A.class, Collections.emptyList());
        Assert.assertTrue((boolean)registry.getConfiguration().hasRoute("a"));
        RouteUtil.updateRouteRegistry((RouteRegistry)registry, Collections.emptySet(), Collections.emptySet(), Collections.singleton(A.class));
        Assert.assertFalse((boolean)registry.getConfiguration().hasRoute("a"));
    }

    @Test
    public void renamedRouteAnnotatedClass_updateRouteRegistry_routeIsUpdatedInRegistry() {
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                return new MockVaadinContext();
            }
        };
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)service.getContext());
        @Route(value="aa")
        class A
        extends Component {
            A() {
            }
        }
        registry.setRoute("a", A.class, Collections.emptyList());
        Assert.assertTrue((boolean)registry.getConfiguration().hasRoute("a"));
        RouteUtil.updateRouteRegistry((RouteRegistry)registry, Collections.emptySet(), Collections.singleton(A.class), Collections.emptySet());
        Assert.assertFalse((boolean)registry.getConfiguration().hasRoute("a"));
        Assert.assertTrue((boolean)registry.getConfiguration().hasRoute("aa"));
    }

    @Test
    public void changedAliasesRouteAnnotatedClass_updateRouteRegistry_routeIsUpdatedInRegistry() {
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                return new MockVaadinContext();
            }
        };
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)service.getContext());
        @Route(value="a")
        @RouteAlias(value="alias-new")
        class A
        extends Component {
            A() {
            }
        }
        registry.setRoute("a", A.class, Collections.emptyList());
        Assert.assertTrue((boolean)registry.getConfiguration().hasRoute("a"));
        registry.setRoute("alias", A.class, Collections.emptyList());
        Assert.assertTrue((boolean)registry.getConfiguration().hasRoute("alias"));
        RouteUtil.updateRouteRegistry((RouteRegistry)registry, Collections.emptySet(), Collections.singleton(A.class), Collections.emptySet());
        Assert.assertTrue((boolean)registry.getConfiguration().hasRoute("a"));
        Assert.assertTrue((boolean)registry.getConfiguration().hasRoute("alias-new"));
        Assert.assertFalse((boolean)registry.getConfiguration().hasRoute("alias"));
    }

    @Test
    public void changedToLazyRouteAnnotatedClass_updateRouteRegistry_routeIsRemovedInRegistry() {
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                return new MockVaadinContext();
            }
        };
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)service.getContext());
        @Route(value="a", registerAtStartup=false)
        class A
        extends Component {
            A() {
            }
        }
        registry.setRoute("a", A.class, Collections.emptyList());
        RouteUtilTest.mutableRoutesMap((AbstractRouteRegistry)registry);
        registry.getConfiguration().getRoutesMap().computeIfPresent("a", (path, routeTarget) -> new MockRouteTarget((RouteTarget)routeTarget, true));
        Assert.assertTrue((boolean)registry.getConfiguration().hasRoute("a"));
        RouteUtil.updateRouteRegistry((RouteRegistry)registry, Collections.emptySet(), Collections.singleton(A.class), Collections.emptySet());
        Assert.assertFalse((boolean)registry.getConfiguration().hasRoute("a"));
    }

    @Test
    public void changedFromLazyRouteAnnotatedClass_updateRouteRegistry_routeIsRemovedInRegistry() {
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                return new MockVaadinContext();
            }
        };
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)service.getContext());
        @Route(value="a")
        class A
        extends Component {
            A() {
            }
        }
        registry.setRoute("a", A.class, Collections.emptyList());
        RouteUtilTest.mutableRoutesMap((AbstractRouteRegistry)registry);
        registry.getConfiguration().getRoutesMap().computeIfPresent("a", (path, routeTarget) -> new MockRouteTarget((RouteTarget)routeTarget, false));
        Assert.assertTrue((boolean)registry.getConfiguration().hasRoute("a"));
        RouteUtil.updateRouteRegistry((RouteRegistry)registry, Collections.emptySet(), Collections.singleton(A.class), Collections.emptySet());
        Assert.assertTrue((boolean)registry.getConfiguration().hasRoute("a"));
    }

    @Test
    public void modifiedLazyRouteAnnotatedClass_updateRouteRegistry_existingRoutesArePreserved() {
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                return new MockVaadinContext();
            }
        };
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)service.getContext());
        @Route(value="a", registerAtStartup=false)
        class A
        extends Component {
            A() {
            }
        }
        registry.setRoute("a", A.class, Collections.emptyList());
        RouteUtilTest.mutableRoutesMap((AbstractRouteRegistry)registry);
        registry.getConfiguration().getRoutesMap().computeIfPresent("a", (path, routeTarget) -> new MockRouteTarget((RouteTarget)routeTarget, false));
        Assert.assertTrue((boolean)registry.getConfiguration().hasRoute("a"));
        RouteUtil.updateRouteRegistry((RouteRegistry)registry, Collections.emptySet(), Collections.singleton(A.class), Collections.emptySet());
        Assert.assertTrue((boolean)registry.getConfiguration().hasRoute("a"));
    }

    @Test
    public void deannotatedRouteClass_updateRouteRegistry_routeIsRemovedFromRegistry() {
        MockVaadinServletService service = new MockVaadinServletService();
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)service.getContext());
        class A
        extends Component {
            A() {
            }
        }
        registry.setRoute("a", A.class, Collections.emptyList());
        RouteUtilTest.mutableRoutesMap((AbstractRouteRegistry)registry);
        registry.getConfiguration().getRoutesMap().computeIfPresent("a", (path, routeTarget) -> new MockRouteTarget((RouteTarget)routeTarget, true));
        Assert.assertTrue((boolean)registry.getConfiguration().hasRoute("a"));
        RouteUtil.updateRouteRegistry((RouteRegistry)registry, Collections.emptySet(), Collections.singleton(A.class), Collections.emptySet());
        Assert.assertFalse((boolean)registry.getConfiguration().hasRoute("a"));
    }

    @Test
    public void routeAnnotatedClassAddedModifiedAndRemoved_updateRouteRegistry_routeIsAddedToRegistry() {
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                return new MockVaadinContext();
            }
        };
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)service.getContext());
        @Route(value="a")
        class A
        extends Component {
            A() {
            }
        }
        RouteUtil.updateRouteRegistry((RouteRegistry)registry, Collections.singleton(A.class), Collections.singleton(A.class), Collections.singleton(A.class));
        Assert.assertTrue((boolean)registry.getConfiguration().hasRoute("a"));
    }

    @Test
    public void newLayoutAnnotatedComponent_updateRouteRegistry_routeIsUpdated() {
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                return new MockVaadinContext();
            }
        };
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)service.getContext());
        registry.update((Command & Serializable)() -> {
            RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)registry);
            routeConfiguration.setAnnotatedRoute(AutoLayoutView.class);
        });
        Assert.assertFalse((String)"AutoLayout should not be available", (boolean)registry.hasLayout("auto"));
        RouteUtil.updateRouteRegistry((RouteRegistry)registry, Collections.singleton(AutoLayout.class), Collections.emptySet(), Collections.emptySet());
        Assert.assertTrue((String)"AutoLayout should be available", (boolean)registry.hasLayout("auto"));
    }

    @Test
    public void removeAnnotationsFromLayoutAnnotatedComponent_updateRouteRegistry_routeIsUpdated() {
        class A
        extends Component
        implements RouterLayout {
            A() {
            }
        }
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                return new MockVaadinContext();
            }
        };
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)service.getContext());
        this.tamperLayouts(registry, layouts -> layouts.put("/", A.class));
        registry.update((Command & Serializable)() -> RouteConfiguration.forRegistry((RouteRegistry)registry).setAnnotatedRoute(AutoLayoutView.class));
        Assert.assertTrue((String)"AutoLayout should be available", (boolean)registry.hasLayout("auto"));
        RouteUtil.updateRouteRegistry((RouteRegistry)registry, Collections.singleton(A.class), Collections.emptySet(), Collections.emptySet());
        Assert.assertFalse((String)"AutoLayout should not be available anymore", (boolean)registry.hasLayout("auto"));
    }

    @Test
    public void layoutAnnotatedComponent_modifiedValue_updateRouteRegistry_routeIsUpdated() {
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                return new MockVaadinContext();
            }
        };
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)service.getContext());
        this.tamperLayouts(registry, layouts -> layouts.put("/hey", AutoLayout.class));
        registry.update((Command & Serializable)() -> {
            RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)registry);
            routeConfiguration.setAnnotatedRoute(AutoLayoutView.class);
            @Route(value="hey/view")
            class View
            extends Component {
                View() {
                }
            }
            routeConfiguration.setAnnotatedRoute(View.class);
        });
        Assert.assertTrue((String)"AutoLayout should be available for /hey/view path", (boolean)registry.hasLayout("hey/view"));
        Assert.assertFalse((String)"AutoLayout should not be available for /auto path", (boolean)registry.hasLayout("auto"));
        RouteUtil.updateRouteRegistry((RouteRegistry)registry, Collections.singleton(AutoLayout.class), Collections.emptySet(), Collections.emptySet());
        Assert.assertTrue((String)"AutoLayout should still be available anymore for /hey/view path because path matches", (boolean)registry.hasLayout("hey/view"));
        Assert.assertTrue((String)"AutoLayout should now be available for /auto path", (boolean)registry.hasLayout("auto"));
    }

    @Test
    public void clientHasMappedLayout_validateNoClientRouteCollisions() {
        HashMap<String, AvailableViewInfo> clientRoutes = new HashMap<String, AvailableViewInfo>();
        clientRoutes.put("", new AvailableViewInfo("public", null, false, "", false, false, null, null, null, false, null));
        clientRoutes.put("/flow", new AvailableViewInfo("public", null, false, "", false, false, null, Arrays.asList(new AvailableViewInfo("child", null, false, "", false, false, null, null, null, false, null)), null, false, null));
        clientRoutes.put("/hilla/components", new AvailableViewInfo("public", null, false, "", false, false, null, null, null, false, null));
        clientRoutes.put("/hilla", new AvailableViewInfo("public", null, false, "", false, false, null, null, null, false, null));
        try (MockedStatic registry = Mockito.mockStatic(MenuRegistry.class, (Answer)Mockito.CALLS_REAL_METHODS);
             MockedStatic frontendUtils = Mockito.mockStatic(FrontendUtils.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
            DeploymentConfiguration conf = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
            Mockito.when((Object)service.getDeploymentConfiguration()).thenReturn((Object)conf);
            Mockito.when((Object)conf.isProductionMode()).thenReturn((Object)false);
            Mockito.when((Object)conf.getFrontendFolder()).thenReturn((Object)((File)Mockito.mock(File.class)));
            registry.when(() -> MenuRegistry.collectClientMenuItems((boolean)false, (AbstractConfiguration)conf)).thenReturn(clientRoutes);
            frontendUtils.when(() -> FrontendUtils.isHillaUsed((File)((File)Mockito.any()))).thenReturn((Object)true);
            RouteUtil.checkForClientRouteCollisions((VaadinService)service, (String[])new String[]{"flow", "flow/hello-world", "hilla/flow"});
        }
    }

    @Test
    public void clientHasOverlappingTarget_validateClientRouteCollision() {
        this.expectedEx.expect(InvalidRouteConfigurationException.class);
        this.expectedEx.expectMessage(CoreMatchers.containsString((String)"Invalid route configuration. The following Hilla route(s) conflict with configured Flow routes: 'flow'"));
        HashMap<String, AvailableViewInfo> clientRoutes = new HashMap<String, AvailableViewInfo>();
        clientRoutes.put("", new AvailableViewInfo("public", null, false, "", false, false, null, null, null, false, null));
        clientRoutes.put("/flow", new AvailableViewInfo("public", null, false, "", false, false, null, null, null, false, null));
        clientRoutes.put("/hilla/components", new AvailableViewInfo("public", null, false, "", false, false, null, null, null, false, null));
        clientRoutes.put("/hilla", new AvailableViewInfo("public", null, false, "", false, false, null, null, null, false, null));
        try (MockedStatic registry = Mockito.mockStatic(MenuRegistry.class, (Answer)Mockito.CALLS_REAL_METHODS);
             MockedStatic frontendUtils = Mockito.mockStatic(FrontendUtils.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
            DeploymentConfiguration conf = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
            Mockito.when((Object)service.getDeploymentConfiguration()).thenReturn((Object)conf);
            Mockito.when((Object)conf.isProductionMode()).thenReturn((Object)false);
            Mockito.when((Object)conf.getFrontendFolder()).thenReturn((Object)new File("/tmp/folder"));
            registry.when(() -> MenuRegistry.collectClientMenuItems((boolean)false, (AbstractConfiguration)conf)).thenReturn(clientRoutes);
            frontendUtils.when(() -> FrontendUtils.isHillaUsed((File)((File)Mockito.any()))).thenReturn((Object)true);
            RouteUtil.checkForClientRouteCollisions((VaadinService)service, (String[])new String[]{"flow", "flow/hello-world", "hilla/flow"});
        }
    }

    private void tamperLayouts(ApplicationRouteRegistry registry, Consumer<Map<String, Class<? extends RouterLayout>>> consumer) {
        try {
            Field layoutsField = AbstractRouteRegistry.class.getDeclaredField("layouts");
            Map layouts = (Map)ReflectTools.getJavaFieldValue((Object)registry, (Field)layoutsField);
            consumer.accept(layouts);
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    private static void mutableRoutesMap(AbstractRouteRegistry registry) {
        ConfiguredRoutes configuration = registry.getConfiguration();
        try {
            Field routeMapField = ConfiguredRoutes.class.getDeclaredField("routeMap");
            routeMapField.setAccessible(true);
            Map routeMap = (Map)routeMapField.get(configuration);
            routeMapField.set(configuration, new HashMap(routeMap));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Route(value="", layout=RoutePrefixParent.class)
    @RouteAlias(value="alias")
    @Tag(value="div")
    public static class BaseRouteWithParentPrefixAndRouteAlias
    extends Component {
    }

    @Route(value="single", layout=RoutePrefixParent.class, absolute=true)
    @RouteAlias(value="alias", layout=RoutePrefixParent.class, absolute=true)
    public static class AbsoluteRoute
    extends Component {
    }

    @Route(value="child", layout=AbsoluteCenterParent.class)
    @RouteAlias(value="alias", layout=AbsoluteCenterParent.class)
    public static class AbsoluteCenterRoute
    extends Component {
    }

    @Route(value="flow", layout=RoutePrefixParent.class)
    @RouteAlias(value="alias")
    @Tag(value="div")
    public static class RouteWithParentPrefixAndRouteAlias
    extends Component {
    }

    @Route(value="flow", layout=RoutePrefixParent.class)
    @RouteAlias(value="alias", layout=RouteAliasPrefixParent.class)
    @Tag(value="div")
    public static class RouteAliasWithParentPrefix
    extends Component {
    }

    @Tag(value="div")
    @RoutePrefix(value="parent")
    public static class RoutePrefixParent
    extends Component
    implements RouterLayout {
    }

    @Tag(value="div")
    @RoutePrefix(value="aliasparent")
    public static class RouteAliasPrefixParent
    extends Component
    implements RouterLayout {
    }

    @Tag(value="div")
    @Layout
    private static class AutoLayout
    extends Component
    implements RouterLayout {
        private AutoLayout() {
        }
    }

    @Route(value="auto")
    @RouteAlias.Container(value={@RouteAlias(value="alias", autoLayout=false), @RouteAlias(value="mainLayout", layout=AutoLayout.class), @RouteAlias(value="autoAlias")})
    @Tag(value="div")
    public static class AutoLayoutView
    extends Component {
    }

    @Route(value="", layout=MiddleParent.class)
    @Tag(value="div")
    public static class RootWithParents
    extends Component {
    }

    @Tag(value="div")
    @ParentLayout(value=Parent.class)
    public static class MiddleParent
    extends Component
    implements RouterLayout {
    }

    @Tag(value="div")
    public static class Parent
    extends Component
    implements RouterLayout {
    }

    @Tag(value="div")
    @ParentLayout(value=Parent.class)
    public static class NonRouteTargetWithParents
    extends Component {
    }

    @Tag(value="div")
    @ParentLayout(value=RoutePrefixParent.class)
    @RoutePrefix(value="absolute", absolute=true)
    public static class AbsoluteCenterParent
    extends Component
    implements RouterLayout {
    }

    @Route(value="", layout=Parent.class)
    @RouteAlias(value="alias", layout=MiddleParent.class)
    @Tag(value="div")
    @ParentLayout(value=RoutePrefixParent.class)
    public static class MultiTarget
    extends Component
    implements RouterLayout {
    }

    @Route(value="sub", layout=MultiTarget.class)
    @Tag(value="div")
    public static class SubLayout
    extends Component {
    }

    private static class MockRouteTarget
    extends RouteTarget {
        private final Boolean registerAtStartup;

        private MockRouteTarget(RouteTarget target, Boolean registerAtStartup) {
            super(target.getTarget(), target.getParentLayouts());
            this.registerAtStartup = registerAtStartup;
        }

        boolean isAnnotatedRoute() {
            return this.registerAtStartup != null;
        }

        boolean isRegisteredAtStartup() {
            return this.registerAtStartup != null && this.registerAtStartup != false;
        }
    }
}

