/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.InternalServerError;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.server.VaadinService;
import net.jcip.annotations.NotThreadSafe;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

@NotThreadSafe
public class InternalServerErrorTest {
    private BeforeEnterEvent event = (BeforeEnterEvent)Mockito.mock(BeforeEnterEvent.class);
    private VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
    private DeploymentConfiguration configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);

    @Before
    public void setUp() {
        VaadinService.setCurrent((VaadinService)this.service);
        Mockito.when((Object)this.service.getDeploymentConfiguration()).thenReturn((Object)this.configuration);
        Location location = new Location("bar");
        Mockito.when((Object)this.event.getLocation()).thenReturn((Object)location);
    }

    @After
    public void tearDown() {
        VaadinService.setCurrent(null);
    }

    @Test
    public void productionMode_noWarningAndStacktrace() {
        Mockito.when((Object)this.configuration.isProductionMode()).thenReturn((Object)true);
        InternalServerError testInstance = new InternalServerError();
        testInstance.setErrorParameter(this.event, new ErrorParameter(Exception.class, (Exception)new NullPointerException("foo")));
        Assert.assertEquals((String)"Only a text node with exception message should be shown", (long)1L, (long)testInstance.getElement().getChildCount());
    }

    @Test
    public void nonProductionMode_noLogBinding_showWaringAndStacktrace() {
        Mockito.when((Object)this.configuration.isProductionMode()).thenReturn((Object)false);
        InternalServerError testInstance = new InternalServerError(){

            protected boolean hasLogBinding() {
                return false;
            }
        };
        testInstance.setErrorParameter(this.event, new ErrorParameter(Exception.class, (Exception)new NullPointerException("foo")));
        Assert.assertEquals((String)"3 elements should be shown: exception text, warning about log binding absence and exception stacktrace", (long)3L, (long)testInstance.getElement().getChildCount());
        Element warning = testInstance.getElement().getChild(1);
        Assert.assertEquals((Object)"div", (Object)warning.getTag());
        Assert.assertTrue((boolean)warning.getText().contains("SLF4J"));
        Element stacktrace = testInstance.getElement().getChild(2);
        Assert.assertEquals((Object)"pre", (Object)stacktrace.getTag());
        Assert.assertTrue((boolean)stacktrace.getText().contains(NullPointerException.class.getName()));
        Assert.assertTrue((boolean)stacktrace.getText().contains("foo"));
    }

    @Test
    public void nonProductionMode_hasLogBinding_showStacktraceAndNoWarning() {
        Mockito.when((Object)this.configuration.isProductionMode()).thenReturn((Object)false);
        InternalServerError testInstance = new InternalServerError(){

            protected boolean hasLogBinding() {
                return true;
            }
        };
        testInstance.setErrorParameter(this.event, new ErrorParameter(Exception.class, (Exception)new NullPointerException("foo")));
        Assert.assertEquals((String)"2 elements should be shown: exception text and exception stacktrace", (long)2L, (long)testInstance.getElement().getChildCount());
        Element stacktrace = testInstance.getElement().getChild(1);
        Assert.assertEquals((Object)"pre", (Object)stacktrace.getTag());
        Assert.assertTrue((boolean)stacktrace.getText().contains(NullPointerException.class.getName()));
        Assert.assertTrue((boolean)stacktrace.getText().contains("foo"));
    }
}

