/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.EmptyChange;
import com.vaadin.flow.internal.change.MapPutChange;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.NodeMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NodeMapEmptyRequiredFeatureTest {
    private StateNode node;
    private NodeMap nodeMap;

    @Before
    public void setUp() {
        this.node = new StateNode(Arrays.asList(ElementPropertyMap.class), new Class[0]){

            public boolean isAttached() {
                return true;
            }
        };
        this.nodeMap = (NodeMap)this.node.getFeature(ElementPropertyMap.class);
    }

    @Test
    public void generateChangesFromEmpty_featureHasChangesToCollect() {
        this.nodeMap.generateChangesFromEmpty();
        AtomicReference change = new AtomicReference();
        this.node.collectChanges(change::set);
        Assert.assertTrue((boolean)(change.get() instanceof EmptyChange));
        this.nodeMap.generateChangesFromEmpty();
        change.set(null);
        this.node.collectChanges(change::set);
        Assert.assertNull(change.get());
    }

    @Test
    public void generateChangesFromEmpty_noEmptyChange() {
        this.nodeMap.put("foo", (Serializable)((Object)"bar"));
        this.node.clearChanges();
        this.nodeMap.generateChangesFromEmpty();
        ArrayList changes = new ArrayList();
        this.node.collectChanges(changes::add);
        Assert.assertEquals((long)1L, (long)changes.size());
        Assert.assertTrue((boolean)(changes.get(0) instanceof MapPutChange));
    }

    @Test
    public void collectChanges_featureHasEmptyChange() {
        AtomicReference change = new AtomicReference();
        this.nodeMap.collectChanges(change::set);
        Assert.assertTrue((boolean)(change.get() instanceof EmptyChange));
        change.set(null);
        this.nodeMap.collectChanges(change::set);
        Assert.assertNull(change.get());
    }

    @Test
    public void collectChanges_noEmptyChange() {
        this.nodeMap.put("foo", (Serializable)((Object)"bar"));
        ArrayList changes = new ArrayList();
        this.node.collectChanges(changes::add);
        Assert.assertEquals((long)1L, (long)changes.size());
        Assert.assertTrue((boolean)(changes.get(0) instanceof MapPutChange));
    }
}

