/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.signals.BindingActiveException;
import com.vaadin.signals.Signal;
import com.vaadin.signals.ValueSignal;
import com.vaadin.tests.util.MockUI;
import java.util.LinkedList;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class ElementBindAttributeTest {
    private static MockVaadinServletService service;
    private MockedStatic<FeatureFlags> featureFlagStaticMock;
    private LinkedList<ErrorEvent> events;

    @BeforeClass
    public static void init() {
        MockedStatic featureFlagStaticMock = Mockito.mockStatic(FeatureFlags.class);
        ElementBindAttributeTest.featureFlagEnabled((MockedStatic<FeatureFlags>)featureFlagStaticMock);
        service = new MockVaadinServletService();
        ElementBindAttributeTest.close((MockedStatic<FeatureFlags>)featureFlagStaticMock);
    }

    @AfterClass
    public static void clean() {
        CurrentInstance.clearAll();
        service.destroy();
    }

    @Before
    public void before() {
        this.featureFlagStaticMock = Mockito.mockStatic(FeatureFlags.class);
        ElementBindAttributeTest.featureFlagEnabled(this.featureFlagStaticMock);
        this.events = this.mockLockedSessionWithErrorHandler();
    }

    @After
    public void after() {
        ElementBindAttributeTest.close(this.featureFlagStaticMock);
        this.events = null;
    }

    private static void featureFlagEnabled(MockedStatic<FeatureFlags> featureFlagStaticMock) {
        FeatureFlags flags = (FeatureFlags)Mockito.mock(FeatureFlags.class);
        Mockito.when((Object)flags.isEnabled(FeatureFlags.FLOW_FULLSTACK_SIGNALS.getId())).thenReturn((Object)true);
        featureFlagStaticMock.when(() -> FeatureFlags.get((VaadinContext)((VaadinContext)ArgumentMatchers.any()))).thenReturn((Object)flags);
    }

    private static void close(MockedStatic<FeatureFlags> featureFlagStaticMock) {
        CurrentInstance.clearAll();
        featureFlagStaticMock.close();
    }

    @Test
    public void bindAttribute_nullAttribute_throwException() {
        Element element = new Element("foo");
        ValueSignal signal = new ValueSignal((Object)"bar");
        Assert.assertThrows(IllegalArgumentException.class, () -> element.bindAttribute(null, (Signal)signal));
    }

    @Test
    public void bindAttribute_illegalAttribute_throwException() {
        Element element = new Element("foo");
        ValueSignal signal = new ValueSignal((Object)"bar");
        Assert.assertThrows(IllegalArgumentException.class, () -> element.bindAttribute("\"foo\"", (Signal)signal));
    }

    @Test
    public void bindAttribute_notComponent_doNotThrowException() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"bar");
        element.bindAttribute("foobar", (Signal)signal);
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_componentNotAttached_bindingIgnored() {
        TestComponent component = new TestComponent();
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindAttribute("foo", (Signal)signal);
        Assert.assertNull((Object)component.getElement().getAttribute("foo"));
    }

    @Test
    public void bindAttribute_componentDetached_bindingIgnored() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindAttribute("foo", (Signal)signal);
        component.removeFromParent();
        signal.value((Object)"baz");
        Assert.assertTrue((boolean)this.events.isEmpty());
        Assert.assertEquals((Object)"bar", (Object)component.getElement().getAttribute("foo"));
    }

    @Test
    public void bindAttribute_componentAttached_bindingActive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindAttribute("foo", (Signal)signal);
        Assert.assertEquals((Object)"bar", (Object)component.getElement().getAttribute("foo"));
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_componentReAttached_bindingSynced() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindAttribute("foo", (Signal)signal);
        Assert.assertEquals((Object)"bar", (Object)component.getElement().getAttribute("foo"));
        component.removeFromParent();
        signal.value((Object)"baz");
        Assert.assertEquals((Object)"baz", (Object)signal.peek());
        Assert.assertEquals((Object)"bar", (Object)component.getElement().getAttribute("foo"));
        UI.getCurrent().add(new Component[]{component});
        Assert.assertEquals((Object)"baz", (Object)component.getElement().getAttribute("foo"));
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_setAttributeWhileBindingIsActive_throwException() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindAttribute("foo", (Signal)signal);
        Assert.assertThrows(BindingActiveException.class, () -> component.getElement().setAttribute("foo", "baz"));
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_removeAttributeWhileBindingIsActive_throwException() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindAttribute("foo", (Signal)signal);
        Assert.assertThrows(BindingActiveException.class, () -> component.getElement().removeAttribute("foo"));
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_updateSignal_attributeChanged() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindAttribute("foo", (Signal)signal);
        signal.value((Object)"baz");
        Assert.assertEquals((Object)"baz", (Object)component.getElement().getAttribute("foo"));
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_withNullBinding_removesBinding() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindAttribute("foo", (Signal)signal);
        Assert.assertEquals((Object)"bar", (Object)component.getElement().getAttribute("foo"));
        component.getElement().bindAttribute("foo", null);
        signal.value((Object)"baz");
        Assert.assertEquals((Object)"bar", (Object)component.getElement().getAttribute("foo"));
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_withTwoAttributesWithSameSignal_attributesChanged() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"foo");
        component.getElement().bindAttribute("attr1", (Signal)signal);
        component.getElement().bindAttribute("attr2", (Signal)signal);
        Assert.assertEquals((Object)"foo", (Object)component.getElement().getAttribute("attr1"));
        Assert.assertEquals((Object)"foo", (Object)component.getElement().getAttribute("attr2"));
        signal.value((Object)"foobar");
        Assert.assertEquals((Object)"foobar", (Object)component.getElement().getAttribute("attr1"));
        Assert.assertEquals((Object)"foobar", (Object)component.getElement().getAttribute("attr2"));
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_withTwoAttributesAndSignals_attributesChanged() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal1 = new ValueSignal((Object)"foo");
        ValueSignal signal2 = new ValueSignal((Object)"bar");
        component.getElement().bindAttribute("attr1", (Signal)signal1);
        component.getElement().bindAttribute("attr2", (Signal)signal2);
        Assert.assertEquals((Object)"foo", (Object)component.getElement().getAttribute("attr1"));
        Assert.assertEquals((Object)"bar", (Object)component.getElement().getAttribute("attr2"));
        signal1.value((Object)"foobar");
        signal2.value((Object)"barfoo");
        Assert.assertEquals((Object)"foobar", (Object)component.getElement().getAttribute("attr1"));
        Assert.assertEquals((Object)"barfoo", (Object)component.getElement().getAttribute("attr2"));
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_simpleComputedSignal_bindingActive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindAttribute("foo", signal.map(v -> "mapped-" + v));
        Assert.assertEquals((Object)"mapped-bar", (Object)component.getElement().getAttribute("foo"));
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_computedSignal_bindingActive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        Signal signal = Signal.computed(() -> "bar");
        Signal computedSignal = Signal.computed(() -> "computed-" + (String)signal.value());
        component.getElement().bindAttribute("foo", computedSignal);
        Assert.assertEquals((Object)"computed-bar", (Object)component.getElement().getAttribute("foo"));
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_nullAttributeValue_attributeRemoved() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.getElement().bindAttribute("foo", signal.map(value -> value != false ? "" : null));
        Assert.assertEquals((Object)"", (Object)component.getElement().getAttribute("foo"));
        signal.value((Object)false);
        Assert.assertNull((Object)component.getElement().getAttribute("foo"));
        Assert.assertFalse((boolean)component.getElement().hasAttribute("foo"));
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    private LinkedList<ErrorEvent> mockLockedSessionWithErrorHandler() {
        VaadinService.setCurrent((VaadinService)service);
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        MockUI ui = new MockUI(session);
        LinkedList<ErrorEvent> events = new LinkedList<ErrorEvent>();
        session.setErrorHandler(events::add);
        return events;
    }

    @Tag(value="div")
    private static class TestComponent
    extends Component {
        private TestComponent() {
        }
    }
}

