/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.di;

import com.vaadin.flow.di.Lookup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class LookupTest {
    @Test(expected=NullPointerException.class)
    public void of_nullServiceObject_throws() {
        Lookup.of(null, (Class[])new Class[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void of_serviceNotExtendingType_throws() {
        String service = "";
        Class<List> type = List.class;
        Lookup.of((Object)service, (Class[])new Class[]{type});
    }

    @Test
    public void of_serviceIsFoundByProvidedTypes_serviceIsNotFoundByNotProvidedTypes() {
        ArrayList service = new ArrayList();
        Lookup lookup = Lookup.of(service, (Class[])new Class[]{Collection.class});
        Assert.assertEquals(service, (Object)lookup.lookup(Collection.class));
        Assert.assertEquals((long)1L, (long)lookup.lookupAll(Collection.class).size());
        Assert.assertEquals(service, lookup.lookupAll(Collection.class).iterator().next());
        Assert.assertNull((Object)lookup.lookup(List.class));
        Assert.assertEquals((long)0L, (long)lookup.lookupAll(List.class).size());
    }

    @Test
    public void compose_bothLookupsHasService_resultingLookupReturnsServiceFromFirstLookup() {
        ArrayList service = new ArrayList();
        Lookup lookup1 = Lookup.of(service, (Class[])new Class[]{Collection.class});
        Lookup lookup2 = Lookup.of(new LinkedList(), (Class[])new Class[]{Collection.class});
        Lookup compose = Lookup.compose((Lookup)lookup1, (Lookup)lookup2);
        Assert.assertSame(service, (Object)compose.lookup(Collection.class));
    }

    @Test
    public void compose_firstLookupHasNoService_resultingLookupReturnsServiceFromSecondLookup() {
        Lookup lookup1 = Lookup.of(new LinkedList(), (Class[])new Class[]{List.class});
        ArrayList service = new ArrayList();
        Lookup lookup2 = Lookup.of(service, (Class[])new Class[]{Collection.class});
        Lookup compose = Lookup.compose((Lookup)lookup1, (Lookup)lookup2);
        Assert.assertSame(service, (Object)compose.lookup(Collection.class));
    }

    @Test
    public void compose_differentServicesForSameType_resultingLookupAllReturnsAllServices() {
        LinkedList service1 = new LinkedList();
        Lookup lookup1 = Lookup.of(service1, (Class[])new Class[]{List.class});
        ArrayList service2 = new ArrayList();
        Lookup lookup2 = Lookup.of(service2, (Class[])new Class[]{List.class, Collection.class});
        Lookup compose = Lookup.compose((Lookup)lookup1, (Lookup)lookup2);
        Collection lookupAll = compose.lookupAll(List.class);
        Assert.assertEquals((long)2L, (long)lookupAll.size());
        Assert.assertTrue((boolean)lookupAll.contains(service1));
        Assert.assertTrue((boolean)lookupAll.contains(service2));
    }
}

