/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.signals.BindingActiveException;
import com.vaadin.signals.Signal;
import com.vaadin.signals.ValueSignal;
import org.junit.Assert;
import org.junit.Test;

public class HasValueBindReadOnlyTest
extends SignalsUnitTest {
    @Test
    public void bindReadOnly_elementAttachedBefore_bindingActive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        Assert.assertFalse((boolean)component.isReadOnly());
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindReadOnly((Signal)signal);
        Assert.assertTrue((boolean)component.isReadOnly());
    }

    @Test
    public void bindReadOnly_elementAttachedAfter_bindingActive() {
        TestComponent component = new TestComponent();
        Assert.assertFalse((boolean)component.isReadOnly());
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindReadOnly((Signal)signal);
        UI.getCurrent().add(new Component[]{component});
        Assert.assertTrue((boolean)component.isReadOnly());
    }

    @Test
    public void bindReadOnly_elementAttached_bindingActive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindReadOnly((Signal)signal);
        Assert.assertTrue((boolean)component.isReadOnly());
        signal.value((Object)false);
        Assert.assertFalse((boolean)component.isReadOnly());
        signal.value((Object)true);
        Assert.assertTrue((boolean)component.isReadOnly());
    }

    @Test
    public void bindReadOnly_elementNotAttached_bindingInactive() {
        TestComponent component = new TestComponent();
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindReadOnly((Signal)signal);
        signal.value((Object)false);
        Assert.assertFalse((boolean)component.isReadOnly());
    }

    @Test
    public void bindReadOnly_elementDetached_bindingInactive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindReadOnly((Signal)signal);
        component.removeFromParent();
        signal.value((Object)false);
        Assert.assertTrue((boolean)component.isReadOnly());
    }

    @Test
    public void bindReadOnly_elementReAttached_bindingActivate() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindReadOnly((Signal)signal);
        component.removeFromParent();
        signal.value((Object)false);
        UI.getCurrent().add(new Component[]{component});
        Assert.assertFalse((boolean)component.isReadOnly());
    }

    @Test
    public void bindReadOnly_bindOrSetReadOnlyWhileBindingIsActive_throwException() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        component.bindReadOnly((Signal)new ValueSignal((Object)true));
        Assert.assertThrows(BindingActiveException.class, () -> component.bindReadOnly((Signal)new ValueSignal((Object)false)));
        Assert.assertThrows(BindingActiveException.class, () -> component.setReadOnly(false));
        Assert.assertTrue((boolean)component.isReadOnly());
    }

    @Test
    public void bindReadOnly_withNullBinding_removesBinding() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindReadOnly((Signal)signal);
        Assert.assertTrue((boolean)component.isReadOnly());
        component.bindReadOnly(null);
        signal.value((Object)false);
        Assert.assertTrue((boolean)component.isReadOnly());
        component.setReadOnly(false);
        Assert.assertFalse((boolean)component.isReadOnly());
    }

    @Test
    public void bindReadOnly_withNullBinding_allowsSetReadOnly() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindReadOnly((Signal)signal);
        Assert.assertTrue((boolean)component.isReadOnly());
        component.bindReadOnly(null);
        component.setReadOnly(false);
        Assert.assertFalse((boolean)component.isReadOnly());
    }

    @Test
    public void bindReadOnly_nullSignalValue_setsReadOnlyToFalse() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindReadOnly((Signal)signal);
        Assert.assertTrue((boolean)component.isReadOnly());
        signal.value(null);
        Assert.assertFalse((boolean)component.isReadOnly());
    }

    @Test
    public void bindReadOnly_toggleSignalValue_readOnlyUpdates() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)false);
        component.bindReadOnly((Signal)signal);
        Assert.assertFalse((boolean)component.isReadOnly());
        signal.value((Object)true);
        Assert.assertTrue((boolean)component.isReadOnly());
        signal.value((Object)false);
        Assert.assertFalse((boolean)component.isReadOnly());
        signal.value((Object)true);
        Assert.assertTrue((boolean)component.isReadOnly());
    }

    @Tag(value="input")
    private static class TestComponent
    extends AbstractField<TestComponent, String> {
        public TestComponent() {
            super((Object)"");
        }

        protected void setPresentationValue(String newPresentationValue) {
        }
    }
}

