/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.component.webcomponent.WebComponent;
import org.hamcrest.CoreMatchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DefaultWebComponentExporterFactoryTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test(expected=NullPointerException.class)
    public void ctor_nullArg_throws() {
        new WebComponentExporterFactory.DefaultWebComponentExporterFactory(null);
    }

    @Test
    public void createInnerClass_throws() {
        this.exception.expect(RuntimeException.class);
        this.exception.expectCause(CoreMatchers.instanceOf(IllegalArgumentException.class));
        this.exception.expectMessage(CoreMatchers.containsString((String)InnerClass.class.getName()));
        this.exception.expectMessage(CoreMatchers.containsString((String)"inner"));
        WebComponentExporterFactory.DefaultWebComponentExporterFactory factory = new WebComponentExporterFactory.DefaultWebComponentExporterFactory(InnerClass.class);
        factory.create();
    }

    @Test
    public void create_exporterHasNoTag_throws() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage(CoreMatchers.containsString((String)NoSpecifiedTagClass.class.getCanonicalName()));
        this.exception.expectMessage(CoreMatchers.containsString((String)"give null value to super(String)"));
        WebComponentExporterFactory.DefaultWebComponentExporterFactory factory = new WebComponentExporterFactory.DefaultWebComponentExporterFactory(NoSpecifiedTagClass.class);
        factory.create();
    }

    private class InnerClass
    extends WebComponentExporter<Component> {
        protected InnerClass() {
            super("a-b");
        }

        protected void configureInstance(WebComponent<Component> webComponent, Component component) {
        }
    }

    public static class NoSpecifiedTagClass
    extends WebComponentExporter<Component> {
        public NoSpecifiedTagClass() {
            super(null);
        }

        protected void configureInstance(WebComponent<Component> webComponent, Component component) {
        }
    }
}

