/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.shared.util;

import com.vaadin.flow.shared.util.SharedUtil;
import java.util.Locale;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class SharedUtilTests {
    private static final String[] URIS = new String[]{"http://demo.vaadin.com/", "https://demo.vaadin.com/", "http://demo.vaadin.com/foo", "http://demo.vaadin.com/foo?f", "http://demo.vaadin.com/foo?f=1", "http://demo.vaadin.com:1234/foo?a", "http://demo.vaadin.com:1234/foo#frag?fakeparam", "http://localhost:8080/jetspeed/portal/_ns:Z3RlbXBsYXRlLXRvcDJfX3BhZ2UtdGVtcGxhdGVfX2RwLTFfX1AtMTJjNTRkYjdlYjUtMTAwMDJ8YzB8ZDF8aVVJREx8Zg__", "http://vaadin.com/directory?p_p_id=Directory_WAR_Directory&p_p_lifecycle=2&p_p_state=normal&p_p_mode=view&p_p_resource_id=UIDL&p_p_cacheability=cacheLevelPage&p_p_col_id=row-1&p_p_col_count=1"};

    @Test
    public void trailingSlashIsTrimmed() {
        MatcherAssert.assertThat((Object)SharedUtil.trimTrailingSlashes((String)"/path/"), (Matcher)CoreMatchers.is((Object)"/path"));
    }

    @Test
    public void noTrailingSlashForTrimming() {
        MatcherAssert.assertThat((Object)SharedUtil.trimTrailingSlashes((String)"/path"), (Matcher)CoreMatchers.is((Object)"/path"));
    }

    @Test
    public void trailingSlashesAreTrimmed() {
        MatcherAssert.assertThat((Object)SharedUtil.trimTrailingSlashes((String)"/path///"), (Matcher)CoreMatchers.is((Object)"/path"));
    }

    @Test
    public void emptyStringIsHandled() {
        MatcherAssert.assertThat((Object)SharedUtil.trimTrailingSlashes((String)""), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void rootSlashIsTrimmed() {
        MatcherAssert.assertThat((Object)SharedUtil.trimTrailingSlashes((String)"/"), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void camelCaseToHumanReadable() {
        Assert.assertEquals((Object)"First Name", (Object)SharedUtil.camelCaseToHumanFriendly((String)"firstName"));
        Assert.assertEquals((Object)"First Name", (Object)SharedUtil.camelCaseToHumanFriendly((String)"first name"));
        Assert.assertEquals((Object)"First Name2", (Object)SharedUtil.camelCaseToHumanFriendly((String)"firstName2"));
        Assert.assertEquals((Object)"First", (Object)SharedUtil.camelCaseToHumanFriendly((String)"first"));
        Assert.assertEquals((Object)"First", (Object)SharedUtil.camelCaseToHumanFriendly((String)"First"));
        Assert.assertEquals((Object)"Some XYZ Abbreviation", (Object)SharedUtil.camelCaseToHumanFriendly((String)"SomeXYZAbbreviation"));
        Assert.assertEquals((Object)"My Bean Container", (Object)SharedUtil.camelCaseToHumanFriendly((String)"MyBeanContainer"));
        Assert.assertEquals((Object)"Awesome URL Factory", (Object)SharedUtil.camelCaseToHumanFriendly((String)"AwesomeURLFactory"));
        Assert.assertEquals((Object)"Some Uri Action", (Object)SharedUtil.camelCaseToHumanFriendly((String)"SomeUriAction"));
    }

    @Test
    public void splitCamelCase() {
        this.assertCamelCaseSplit("firstName", "first", "Name");
        this.assertCamelCaseSplit("fooBar", "foo", "Bar");
        this.assertCamelCaseSplit("fooBar", "foo", "Bar");
        this.assertCamelCaseSplit("fBar", "f", "Bar");
        this.assertCamelCaseSplit("FBar", "F", "Bar");
        this.assertCamelCaseSplit("MYCdi", "MY", "Cdi");
        this.assertCamelCaseSplit("MyCDIUI", "My", "CDIUI");
        this.assertCamelCaseSplit("MyCDIUITwo", "My", "CDIUI", "Two");
        this.assertCamelCaseSplit("first name", "first", "name");
    }

    private void assertCamelCaseSplit(String camelCaseString, String ... parts) {
        Object[] splitParts = SharedUtil.splitCamelCase((String)camelCaseString);
        Assert.assertArrayEquals((Object[])parts, (Object[])splitParts);
    }

    @Test
    public void join() {
        String s1 = "foo-bar-baz";
        String s2 = "foo--bar";
        Assert.assertEquals((Object)"foobarbaz", (Object)SharedUtil.join((String[])s1.split("-"), (String)""));
        Assert.assertEquals((Object)"foo!bar!baz", (Object)SharedUtil.join((String[])s1.split("-"), (String)"!"));
        Assert.assertEquals((Object)"foo!!bar!!baz", (Object)SharedUtil.join((String[])s1.split("-"), (String)"!!"));
        Assert.assertEquals((Object)"foo##bar", (Object)SharedUtil.join((String[])s2.split("-"), (String)"#"));
    }

    @Test
    public void dashSeparatedToCamelCase() {
        Assert.assertEquals(null, (Object)SharedUtil.dashSeparatedToCamelCase(null));
        Assert.assertEquals((Object)"", (Object)SharedUtil.dashSeparatedToCamelCase((String)""));
        Assert.assertEquals((Object)"foo", (Object)SharedUtil.dashSeparatedToCamelCase((String)"foo"));
        Assert.assertEquals((Object)"fooBar", (Object)SharedUtil.dashSeparatedToCamelCase((String)"foo-bar"));
        Assert.assertEquals((Object)"fooBar", (Object)SharedUtil.dashSeparatedToCamelCase((String)"foo--bar"));
        Assert.assertEquals((Object)"fooBarBaz", (Object)SharedUtil.dashSeparatedToCamelCase((String)"foo-bar-baz"));
        Assert.assertEquals((Object)"fooBarBaz", (Object)SharedUtil.dashSeparatedToCamelCase((String)"foo-Bar-Baz"));
    }

    @Test
    public void camelCaseToDashSeparated() {
        Assert.assertEquals(null, (Object)SharedUtil.camelCaseToDashSeparated(null));
        Assert.assertEquals((Object)"", (Object)SharedUtil.camelCaseToDashSeparated((String)""));
        Assert.assertEquals((Object)"foo", (Object)SharedUtil.camelCaseToDashSeparated((String)"foo"));
        Assert.assertEquals((Object)"foo-bar", (Object)SharedUtil.camelCaseToDashSeparated((String)"fooBar"));
        Assert.assertEquals((Object)"foo--bar", (Object)SharedUtil.camelCaseToDashSeparated((String)"foo--bar"));
        Assert.assertEquals((Object)"foo-bar-baz", (Object)SharedUtil.camelCaseToDashSeparated((String)"fooBarBaz"));
        Assert.assertEquals((Object)"-my-bean-container", (Object)SharedUtil.camelCaseToDashSeparated((String)"MyBeanContainer"));
        Assert.assertEquals((Object)"-awesome-uRL-factory", (Object)SharedUtil.camelCaseToDashSeparated((String)"AwesomeURLFactory"));
        Assert.assertEquals((Object)"some-uri-action", (Object)SharedUtil.camelCaseToDashSeparated((String)"someUriAction"));
    }

    @Test
    public void upperCamelCaseToDashSeparatedLowerCase() {
        Assert.assertEquals(null, (Object)SharedUtil.upperCamelCaseToDashSeparatedLowerCase(null));
        Assert.assertEquals((Object)"", (Object)SharedUtil.upperCamelCaseToDashSeparatedLowerCase((String)""));
        Assert.assertEquals((Object)"foo", (Object)SharedUtil.upperCamelCaseToDashSeparatedLowerCase((String)"foo"));
        Assert.assertEquals((Object)"foo-bar", (Object)SharedUtil.upperCamelCaseToDashSeparatedLowerCase((String)"fooBar"));
        Assert.assertEquals((Object)"foo--bar", (Object)SharedUtil.upperCamelCaseToDashSeparatedLowerCase((String)"foo--bar"));
        Assert.assertEquals((Object)"foo-bar-baz", (Object)SharedUtil.upperCamelCaseToDashSeparatedLowerCase((String)"fooBarBaz"));
        Assert.assertEquals((Object)"my-bean-container", (Object)SharedUtil.upperCamelCaseToDashSeparatedLowerCase((String)"MyBeanContainer"));
        Assert.assertEquals((Object)"awesome-url-factory", (Object)SharedUtil.upperCamelCaseToDashSeparatedLowerCase((String)"AwesomeURLFactory"));
        Assert.assertEquals((Object)"some-uri-action", (Object)SharedUtil.upperCamelCaseToDashSeparatedLowerCase((String)"someUriAction"));
    }

    @Test
    public void methodUppercaseWithTurkishLocale() {
        Locale defaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(new Locale("tr", "TR"));
            Assert.assertEquals((Object)"Integer", (Object)SharedUtil.capitalize((String)"integer"));
            Assert.assertEquals((Object)"I", (Object)SharedUtil.capitalize((String)"i"));
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
    }

    @Test
    public void testParameterAdding() {
        String[] urisWithAbcdParam = new String[]{"http://demo.vaadin.com/?a=b&c=d", "https://demo.vaadin.com/?a=b&c=d", "http://demo.vaadin.com/foo?a=b&c=d", "http://demo.vaadin.com/foo?f&a=b&c=d", "http://demo.vaadin.com/foo?f=1&a=b&c=d", "http://demo.vaadin.com:1234/foo?a&a=b&c=d", "http://demo.vaadin.com:1234/foo?a=b&c=d#frag?fakeparam", "http://localhost:8080/jetspeed/portal/_ns:Z3RlbXBsYXRlLXRvcDJfX3BhZ2UtdGVtcGxhdGVfX2RwLTFfX1AtMTJjNTRkYjdlYjUtMTAwMDJ8YzB8ZDF8aVVJREx8Zg__?a=b&c=d", "http://vaadin.com/directory?p_p_id=Directory_WAR_Directory&p_p_lifecycle=2&p_p_state=normal&p_p_mode=view&p_p_resource_id=UIDL&p_p_cacheability=cacheLevelPage&p_p_col_id=row-1&p_p_col_count=1&a=b&c=d"};
        String[] urisWithAbcdParamAndFragment = new String[]{"http://demo.vaadin.com/?a=b&c=d#fragment", "https://demo.vaadin.com/?a=b&c=d#fragment", "http://demo.vaadin.com/foo?a=b&c=d#fragment", "http://demo.vaadin.com/foo?f&a=b&c=d#fragment", "http://demo.vaadin.com/foo?f=1&a=b&c=d#fragment", "http://demo.vaadin.com:1234/foo?a&a=b&c=d#fragment", "", "http://localhost:8080/jetspeed/portal/_ns:Z3RlbXBsYXRlLXRvcDJfX3BhZ2UtdGVtcGxhdGVfX2RwLTFfX1AtMTJjNTRkYjdlYjUtMTAwMDJ8YzB8ZDF8aVVJREx8Zg__?a=b&c=d#fragment", "http://vaadin.com/directory?p_p_id=Directory_WAR_Directory&p_p_lifecycle=2&p_p_state=normal&p_p_mode=view&p_p_resource_id=UIDL&p_p_cacheability=cacheLevelPage&p_p_col_id=row-1&p_p_col_count=1&a=b&c=d#fragment"};
        for (int i = 0; i < URIS.length; ++i) {
            Assert.assertEquals((Object)URIS[i], (Object)SharedUtil.addGetParameters((String)URIS[i], (String)""));
            Assert.assertEquals((Object)urisWithAbcdParam[i], (Object)SharedUtil.addGetParameters((String)URIS[i], (String)"a=b&c=d"));
            if (urisWithAbcdParamAndFragment[i].length() <= 0) continue;
            Assert.assertEquals((Object)urisWithAbcdParamAndFragment[i], (Object)SharedUtil.addGetParameters((String)(URIS[i] + "#fragment"), (String)"a=b&c=d"));
            Assert.assertEquals((Object)urisWithAbcdParamAndFragment[i].replace("#fragment", "#"), (Object)SharedUtil.addGetParameters((String)(URIS[i] + "#"), (String)"a=b&c=d"));
        }
    }
}

