/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.streams.FileFactory;
import com.vaadin.flow.server.streams.FileUploadCallback;
import com.vaadin.flow.server.streams.FileUploadHandler;
import com.vaadin.flow.server.streams.InMemoryUploadCallback;
import com.vaadin.flow.server.streams.InMemoryUploadHandler;
import com.vaadin.flow.server.streams.TemporaryFileUploadHandler;
import com.vaadin.flow.server.streams.TransferContext;
import com.vaadin.flow.server.streams.TransferProgressListener;
import com.vaadin.flow.server.streams.UploadEvent;
import com.vaadin.flow.server.streams.UploadHandler;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class UploadTransferProgressTest {
    private static final int DUMMY_CONTENT_LENGTH = 160000;
    public static final String DUMMY_FILE_NAME = "test.tmp";
    private MockVaadinSession session;
    private VaadinServletRequest request;
    private VaadinResponse response;
    private StreamResourceRegistry streamResourceRegistry;
    private UI ui;
    private Element element;
    private UploadEvent uploadEvent;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void setUp() throws ServletException, ServiceException {
        MockVaadinServletService service = new MockVaadinServletService();
        this.session = new AlwaysLockedVaadinSession((VaadinService)service){

            public StreamResourceRegistry getResourceRegistry() {
                return UploadTransferProgressTest.this.streamResourceRegistry;
            }
        };
        this.streamResourceRegistry = new StreamResourceRegistry((VaadinSession)this.session);
        this.request = (VaadinServletRequest)Mockito.mock(VaadinServletRequest.class);
        ServletContext servletContext = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)servletContext.getMimeType(Mockito.anyString())).thenReturn(null);
        Mockito.when((Object)this.request.getServletContext()).thenReturn((Object)servletContext);
        this.element = (Element)Mockito.mock(Element.class);
        this.response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        this.uploadEvent = (UploadEvent)Mockito.mock(UploadEvent.class);
        ((UploadEvent)Mockito.doReturn((Object)DUMMY_FILE_NAME).when((Object)this.uploadEvent)).getFileName();
        Mockito.when((Object)this.uploadEvent.getContentType()).thenReturn((Object)"application/octet-stream");
        Mockito.when((Object)this.uploadEvent.getFileSize()).thenReturn((Object)160000L);
        Mockito.when((Object)this.uploadEvent.getInputStream()).thenReturn((Object)this.createRandomBytes(160000));
        Mockito.when((Object)this.uploadEvent.getResponse()).thenReturn((Object)this.response);
        Mockito.when((Object)this.uploadEvent.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.uploadEvent.getOwningElement()).thenReturn((Object)this.element);
        Mockito.when((Object)this.uploadEvent.getRequest()).thenReturn((Object)this.request);
        Component componentOwner = (Component)Mockito.mock(Component.class);
        Mockito.when((Object)this.element.getComponent()).thenReturn(Optional.of(componentOwner));
        this.ui = (UI)Mockito.mock(UI.class);
        ((UI)Mockito.doAnswer(invocation -> {
            Command command = (Command)invocation.getArgument(0);
            command.execute();
            return null;
        }).when((Object)this.ui)).access((Command)Mockito.any(Command.class));
        Mockito.when((Object)this.uploadEvent.getUI()).thenReturn((Object)this.ui);
        Mockito.when((Object)componentOwner.getUI()).thenReturn(Optional.of(this.ui));
        Mockito.when((Object)this.uploadEvent.getOwningComponent()).thenReturn((Object)componentOwner);
    }

    @Test
    public void transferProgressListener_toFile_addListener_listenersInvoked() throws URISyntaxException, IOException {
        AtomicReference actualFile = new AtomicReference();
        AtomicReference expectedFile = new AtomicReference();
        ArrayList<String> invocations = new ArrayList<String>();
        ArrayList<Long> transferredBytesRecords = new ArrayList<Long>();
        FileUploadHandler handler = UploadHandler.toFile((FileUploadCallback & Serializable)(meta, file) -> actualFile.set(file), (FileFactory & Serializable)uploadMetadata -> {
            try {
                File file = this.temporaryFolder.newFile(DUMMY_FILE_NAME);
                expectedFile.set(file);
                return file;
            }
            catch (IOException e) {
                Assert.fail((String)("Failed to create temp file: " + e.getMessage()));
                return null;
            }
        }, (TransferProgressListener)UploadTransferProgressTest.createTransferProgressListener(invocations, transferredBytesRecords));
        handler.handleUploadRequest(this.uploadEvent);
        UploadTransferProgressTest.assertListenersInvoked(invocations, transferredBytesRecords);
        Assert.assertEquals(expectedFile.get(), actualFile.get());
    }

    @Test
    public void transferProgressListener_toFile_addListener_errorOccured_errorlistenerInvoked() throws URISyntaxException {
        ArrayList<String> invocations = new ArrayList<String>();
        FileUploadHandler handler = UploadHandler.toFile((FileUploadCallback & Serializable)(meta, file) -> {}, (FileFactory & Serializable)uploadMetadata -> {
            throw new IOException("Test exception");
        }, (TransferProgressListener)UploadTransferProgressTest.createErrorTransferProgressListener(invocations));
        try {
            handler.handleUploadRequest(this.uploadEvent);
            Assert.fail((String)"Expected an IOException to be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals(List.of("onError"), invocations);
    }

    @Test
    public void transferProgressListener_toTempFile_addListener_listenersInvoked() throws URISyntaxException, IOException {
        ArrayList<String> invocations = new ArrayList<String>();
        ArrayList<Long> transferredBytesRecords = new ArrayList<Long>();
        TemporaryFileUploadHandler handler = UploadHandler.toTempFile((FileUploadCallback & Serializable)(meta, file) -> {}, (TransferProgressListener)UploadTransferProgressTest.createTransferProgressListener(invocations, transferredBytesRecords));
        handler.handleUploadRequest(this.uploadEvent);
        UploadTransferProgressTest.assertListenersInvoked(invocations, transferredBytesRecords);
    }

    @Test
    public void transferProgressListener_toTempFile_addListener_errorOccured_errorlistenerInvoked() throws URISyntaxException, IOException {
        ArrayList<String> invocations = new ArrayList<String>();
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        ((InputStream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Test exception")}).when((Object)inputStream)).read((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt());
        Mockito.when((Object)this.uploadEvent.getInputStream()).thenReturn((Object)inputStream);
        TemporaryFileUploadHandler handler = UploadHandler.toTempFile((FileUploadCallback & Serializable)(meta, file) -> {}, (TransferProgressListener)UploadTransferProgressTest.createErrorTransferProgressListener(invocations));
        try {
            handler.handleUploadRequest(this.uploadEvent);
            Assert.fail((String)"Expected an IOException to be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals(List.of("onStart", "onError"), invocations);
    }

    @Test
    public void transferProgressListener_inMemory_addListener_listenersInvoked() throws URISyntaxException, IOException {
        ArrayList<String> invocations = new ArrayList<String>();
        ArrayList<Long> transferredBytesRecords = new ArrayList<Long>();
        InMemoryUploadHandler handler = UploadHandler.inMemory((InMemoryUploadCallback & Serializable)(meta, bytes) -> {}, (TransferProgressListener)UploadTransferProgressTest.createTransferProgressListener(invocations, transferredBytesRecords));
        handler.handleUploadRequest(this.uploadEvent);
        UploadTransferProgressTest.assertListenersInvoked(invocations, transferredBytesRecords);
    }

    @Test
    public void transferProgressListener_inMemory_addListener_errorOccured_errorlistenerInvoked() throws URISyntaxException, IOException {
        ArrayList<String> invocations = new ArrayList<String>();
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        ((InputStream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Test exception")}).when((Object)inputStream)).read((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt());
        Mockito.when((Object)this.uploadEvent.getInputStream()).thenReturn((Object)inputStream);
        InMemoryUploadHandler handler = UploadHandler.inMemory((InMemoryUploadCallback & Serializable)(meta, bytes) -> {}, (TransferProgressListener)UploadTransferProgressTest.createErrorTransferProgressListener(invocations));
        try {
            handler.handleUploadRequest(this.uploadEvent);
            Assert.fail((String)"Expected an IOException to be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals(List.of("onStart", "onError"), invocations);
    }

    private ByteArrayInputStream createRandomBytes(int size) {
        byte[] bytes = new byte[size];
        new Random().nextBytes(bytes);
        return new ByteArrayInputStream(bytes);
    }

    private static TransferProgressListener createTransferProgressListener(final List<String> invocations, final List<Long> transferredBytesRecords) {
        return new TransferProgressListener(){

            public void onStart(TransferContext context) {
                Assert.assertEquals((long)160000L, (long)context.contentLength());
                Assert.assertEquals((Object)UploadTransferProgressTest.DUMMY_FILE_NAME, (Object)context.fileName());
                invocations.add("onStart");
            }

            public void onProgress(TransferContext context, long transferredBytes, long totalBytes) {
                transferredBytesRecords.add(transferredBytes);
                Assert.assertEquals((long)160000L, (long)totalBytes);
                Assert.assertEquals((Object)UploadTransferProgressTest.DUMMY_FILE_NAME, (Object)context.fileName());
                invocations.add("onProgress");
            }

            public void onComplete(TransferContext context, long transferredBytes) {
                Assert.assertEquals((long)160000L, (long)context.contentLength());
                Assert.assertEquals((long)160000L, (long)transferredBytes);
                Assert.assertEquals((Object)UploadTransferProgressTest.DUMMY_FILE_NAME, (Object)context.fileName());
                invocations.add("onComplete");
            }

            public void onError(TransferContext context, IOException reason) {
                invocations.add("onError");
            }
        };
    }

    private static TransferProgressListener createErrorTransferProgressListener(final List<String> invocations) {
        return new TransferProgressListener(){

            public void onStart(TransferContext context) {
                invocations.add("onStart");
            }

            public void onProgress(TransferContext context, long transferredBytes, long totalBytes) {
                invocations.add("onProgress");
            }

            public void onComplete(TransferContext context, long transferredBytes) {
                invocations.add("onComplete");
            }

            public void onError(TransferContext context, IOException reason) {
                invocations.add("onError");
                Assert.assertEquals((Object)"Test exception", (Object)reason.getMessage());
            }
        };
    }

    private static void assertListenersInvoked(List<String> invocations, List<Long> transferredBytesRecords) {
        Assert.assertEquals(List.of("onStart", "onProgress", "onProgress", "onComplete"), invocations);
        Assert.assertArrayEquals((long[])new long[]{65536L, 131072L}, (long[])transferredBytesRecords.stream().mapToLong(Long::longValue).toArray());
    }
}

