/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.DefaultDeploymentConfiguration;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.SynchronizedRequestHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.CommunicationUtil;
import com.vaadin.flow.server.communication.ServerRpcHandler;
import com.vaadin.flow.server.communication.UidlRequestHandler;
import com.vaadin.flow.server.dau.DauEnforcementException;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.pro.licensechecker.dau.EnforcementException;
import com.vaadin.tests.util.MockUI;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class UidlRequestHandlerTest {
    private VaadinRequest request;
    private VaadinResponse response;
    private OutputStream outputStream;
    private UidlRequestHandler handler;

    @Before
    public void setup() throws IOException {
        this.request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        this.response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        this.outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)this.outputStream);
        this.handler = new UidlRequestHandler();
    }

    @Test
    public void writeSessionExpired() throws Exception {
        ApplicationConfiguration config = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        Mockito.when((Object)config.getPropertyNames()).thenReturn(Collections.emptyEnumeration());
        Mockito.when((Object)config.getBuildFolder()).thenReturn((Object)".");
        MockVaadinContext context = new MockVaadinContext();
        Mockito.when((Object)config.getContext()).thenReturn((Object)context);
        VaadinServletService service = new VaadinServletService(null, (DeploymentConfiguration)new DefaultDeploymentConfiguration(config, this.getClass(), new Properties()));
        Mockito.when((Object)this.request.getService()).thenReturn((Object)service);
        Mockito.when((Object)this.request.getParameter("v-r")).thenReturn((Object)HandlerHelper.RequestType.UIDL.getIdentifier());
        boolean result = this.handler.handleSessionExpired(this.request, this.response);
        Assert.assertTrue((String)"Result should be true", (boolean)result);
        String responseContent = CommunicationUtil.getStringWhenWriteBytesOffsetLength(this.outputStream);
        Assert.assertEquals((String)"Invalid response", (Object)"{\"meta\":{\"sessionExpired\":true}}", (Object)responseContent);
    }

    @Test
    public void writeSessionExpired_whenUINotFound() throws IOException {
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        Mockito.when((Object)session.getService()).thenReturn((Object)service);
        Mockito.when((Object)service.findUI(this.request)).thenReturn(null);
        Optional result = this.handler.synchronizedHandleRequest(session, this.request, this.response, null);
        Assert.assertTrue((String)"ResponseWriter should be present", (boolean)result.isPresent());
        ((SynchronizedRequestHandler.ResponseWriter)result.get()).writeResponse();
        String responseContent = CommunicationUtil.getStringWhenWriteString(this.outputStream);
        Assert.assertEquals((String)"Invalid response", (Object)"{\"meta\":{\"sessionExpired\":true}}", (Object)responseContent);
    }

    @Test
    public void clientRequestsPreviousIdAndPayload_resendPreviousResponse() throws IOException {
        UI ui = UidlRequestHandlerTest.getUi();
        VaadinSession session = ui.getSession();
        VaadinService service = session.getService();
        DeploymentConfiguration conf = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)service.getDeploymentConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)conf.isRequestTiming()).thenReturn((Object)false);
        String requestBody = "{\n   \"csrfToken\": \"d1f44a6f-bbe5-4493-a8a9-3f5f234a2a93\",\n   \"rpc\": [\n     {\n       \"type\": \"mSync\",\n       \"node\": 12,\n       \"feature\": 1,\n       \"property\": \"value\",\n       \"value\": \"a\"\n     },\n     {\n       \"type\": \"event\",\n       \"node\": 12,\n       \"event\": \"change\",\n       \"data\": {}\n     }\n   ],\n   \"syncId\": 0,\n   \"clientId\": 0\n }\n";
        Mockito.when((Object)this.request.getService()).thenReturn((Object)service);
        Mockito.when((Object)conf.isSyncIdCheckEnabled()).thenReturn((Object)true);
        Optional result = this.handler.synchronizedHandleRequest(session, this.request, this.response, requestBody);
        Assert.assertTrue((String)"ResponseWriter should be present", (boolean)result.isPresent());
        ((SynchronizedRequestHandler.ResponseWriter)result.get()).writeResponse();
        String responseContent = CommunicationUtil.getStringWhenWriteString(this.outputStream);
        this.response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        this.outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)this.outputStream);
        result = this.handler.synchronizedHandleRequest(session, this.request, this.response, requestBody);
        Assert.assertTrue((String)"ResponseWriter should be present", (boolean)result.isPresent());
        ((SynchronizedRequestHandler.ResponseWriter)result.get()).writeResponse();
        String resendResponseContent = CommunicationUtil.getStringWhenWriteString(this.outputStream);
        Assert.assertEquals((String)"Server should send same content again", (Object)responseContent, (Object)resendResponseContent);
    }

    @Test
    public void should_modifyUidl_when_MPR() throws Exception {
        UI ui = UidlRequestHandlerTest.getUi();
        this.handler = (UidlRequestHandler)Mockito.spy((Object)new UidlRequestHandler());
        StringWriter writer = new StringWriter();
        ObjectNode uidl = this.generateUidl(true, true);
        ((UidlRequestHandler)Mockito.doReturn((Object)uidl).when((Object)this.handler)).createUidl(ui, false);
        this.handler.writeUidl(ui, (Writer)writer, false);
        String out = writer.toString();
        uidl = JacksonUtils.readTree((String)out);
        String v7Uidl = uidl.get("execute").get(2).get(1).textValue();
        Assert.assertFalse((boolean)v7Uidl.contains("http://localhost:9998/#!away"));
        Assert.assertTrue((boolean)v7Uidl.contains("http://localhost:9998/"));
        Assert.assertFalse((boolean)v7Uidl.contains("window.location.hash = '!away';"));
    }

    @Test
    public void should_changeURL_when_v7LocationProvided() throws Exception {
        UI ui = UidlRequestHandlerTest.getUi();
        this.handler = (UidlRequestHandler)Mockito.spy((Object)new UidlRequestHandler());
        StringWriter writer = new StringWriter();
        ObjectNode uidl = this.generateUidl(true, true);
        ((UidlRequestHandler)Mockito.doReturn((Object)uidl).when((Object)this.handler)).createUidl(ui, false);
        this.handler.writeUidl(ui, (Writer)writer, false);
        String out = writer.toString();
        uidl = JacksonUtils.readTree((String)out);
        Assert.assertEquals((Object)"setTimeout(() => history.pushState(null, null, 'http://localhost:9998/#!away'));", (Object)uidl.get("execute").get(1).get(1).textValue());
    }

    @Test
    public void should_updateHash_when_v7LocationNotProvided() throws Exception {
        UI ui = UidlRequestHandlerTest.getUi();
        this.handler = (UidlRequestHandler)Mockito.spy((Object)new UidlRequestHandler());
        StringWriter writer = new StringWriter();
        ObjectNode uidl = this.generateUidl(false, true);
        ((UidlRequestHandler)Mockito.doReturn((Object)uidl).when((Object)this.handler)).createUidl(ui, false);
        this.handler.writeUidl(ui, (Writer)writer, false);
        String out = writer.toString();
        uidl = JacksonUtils.readTree((String)out);
        Assert.assertEquals((Object)"setTimeout(() => history.pushState(null, null, location.pathname + location.search + '#!away'));", (Object)uidl.get("execute").get(1).get(1).textValue());
    }

    @Test
    public void should_not_modify_non_MPR_Uidl() throws Exception {
        UI ui = UidlRequestHandlerTest.getUi();
        this.handler = (UidlRequestHandler)Mockito.spy((Object)new UidlRequestHandler());
        StringWriter writer = new StringWriter();
        ObjectNode uidl = this.generateUidl(true, true);
        ((ArrayNode)uidl.get("execute").get(2)).remove(1);
        ((UidlRequestHandler)Mockito.doReturn((Object)uidl).when((Object)this.handler)).createUidl(ui, false);
        this.handler.writeUidl(ui, (Writer)writer, false);
        String expected = uidl.toString();
        String out = writer.toString();
        uidl = JacksonUtils.readTree((String)out);
        String actual = uidl.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void should_not_update_browser_history_if_no_hash_in_location() throws Exception {
        UI ui = UidlRequestHandlerTest.getUi();
        this.handler = (UidlRequestHandler)Mockito.spy((Object)new UidlRequestHandler());
        StringWriter writer = new StringWriter();
        ObjectNode uidl = this.getUidlWithNoHashInLocation();
        ((UidlRequestHandler)Mockito.doReturn((Object)uidl).when((Object)this.handler)).createUidl(ui, false);
        this.handler.writeUidl(ui, (Writer)writer, false);
        String out = writer.toString();
        Assert.assertFalse((boolean)out.contains("history.pushState"));
    }

    @Test
    public void synchronizedHandleRequest_DauEnforcementException_setsStatusCode503() throws IOException {
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        Mockito.when((Object)session.getService()).thenReturn((Object)service);
        UI ui = (UI)Mockito.mock(UI.class);
        Mockito.when((Object)service.findUI(this.request)).thenReturn((Object)ui);
        final ServerRpcHandler serverRpcHandler = new ServerRpcHandler(){

            public void handleRpc(UI ui, String requestBody, VaadinRequest request) {
                throw new DauEnforcementException(new EnforcementException("test"));
            }
        };
        this.handler = new UidlRequestHandler(){

            protected ServerRpcHandler createRpcHandler() {
                return serverRpcHandler;
            }
        };
        this.handler.synchronizedHandleRequest(session, this.request, this.response, "");
        ((VaadinResponse)Mockito.verify((Object)this.response)).setHeader("Vaadin-DAU-Status-Code", "503");
    }

    private ObjectNode generateUidl(boolean withLocation, boolean withHash) {
        ObjectNode uidl = JacksonUtils.readTree((String)"{  \"syncId\": 3,  \"clientId\": 3,  \"changes\": [],  \"execute\": [   [\"\", \"document.title = $0\"],   [\"\", \"setTimeout(() => window.history.pushState(null, '', $0))\"],   [[0, 16], \"___PLACE_FOR_V7_UIDL___\", \"$0.firstElementChild.setResponse($1)\"],   [1,null,[0, 16], \"return (function() { this.$server['}p']($0, true, $1)}).apply($2)\"]  ],  \"timings\": []}");
        String v7String = "\"syncId\": 2,\"clientId\": 2,\"changes\": [  [],[\"___PLACE_FOR_LOCATION_CHANGE___\"]],\"state\": {},\"types\": {},\"hierarchy\": {},\"rpc\": [ [],[  \"11\",  \"com.vaadin.shared.extension.javascriptmanager.ExecuteJavaScriptRpc\",  \"executeJavaScript\", [ \"___PLACE_FOR_HASH_RPC___\" ] ],[  \"12\",  \"com.example.FooRpc\",  \"barMethod\", [{}, {}] ],[]],\"meta\": {}, \"resources\": {},\"typeMappings\": {},\"typeInheritanceMap\": {}, \"timings\": []";
        String locationChange = "\"change\", {\"pid\": \"0\"}, [\"0\", {\"id\": \"0\", \"location\": \"http://localhost:9998/#!away\"}]";
        String hashRpc = "window.location.hash = '!away';";
        if (withLocation) {
            v7String = v7String.replace("\"___PLACE_FOR_LOCATION_CHANGE___\"", locationChange);
        }
        if (withHash) {
            v7String = v7String.replace("___PLACE_FOR_HASH_RPC___", hashRpc);
        }
        ((ArrayNode)uidl.get("execute").get(2)).set(1, v7String);
        return uidl;
    }

    private ObjectNode getUidlWithNoHashInLocation() {
        return JacksonUtils.readTree((String)"{  \"syncId\": 3,  \"clientId\": 3,  \"changes\": [],  \"execute\": [    [      [        0,        9      ],      \"'syncId': 1, 'clientId': 0, 'changes' : [['change',{'pid':'0'},['0',{'id':'0','location':'http://localhost:8080/','v':{'action':''}},['actions',{}]]]], 'state':{'1':{'componentSettings':[]}}, 'types':{'0':'0','1':'2'}, 'hierarchy':{'0':['1']}, 'rpc' : [], 'meta' : {'async':true}, 'resources' : {}, 'timings':[113, 113]\",      \"ROOT\"    ]  ],  \"timings\": [    20880,    18181  ]}");
    }

    private static UI getUi() {
        final VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        VaadinSession session = new VaadinSession(service){

            public boolean hasLock() {
                return true;
            }

            public VaadinService getService() {
                return service;
            }
        };
        MockUI ui = new MockUI(session);
        Mockito.when((Object)service.findUI((VaadinRequest)Mockito.any())).thenReturn((Object)ui);
        return ui;
    }
}

