/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.auth;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.RouteNotFoundError;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.auth.AccessAnnotationCheckerTest;
import com.vaadin.flow.server.auth.AccessCheckDecision;
import com.vaadin.flow.server.auth.AccessCheckResult;
import com.vaadin.flow.server.auth.AccessControlTestClasses;
import com.vaadin.flow.server.auth.AnnotatedViewAccessChecker;
import com.vaadin.flow.server.auth.NavigationContext;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AnnotatedViewAccessCheckerTest {
    private final AnnotatedViewAccessChecker viewAccessChecker = new AnnotatedViewAccessChecker();

    @Test
    public void anonymousAccessToAnonymousViewAllowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedView.class, null);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void anonymousAccessToNoAnnotationViewDenied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationView.class, null);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void anonymousAccessToPermitAllViewDenied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.PermitAllView.class, null);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void anonymousAccessToDenyAllViewDenied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.DenyAllView.class, null);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void anonymousAccessToRolesAllowedUserViewDenied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.RolesAllowedUserView.class, null);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void anonymousAccessToRolesAllowedAdminViewDenied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.RolesAllowedAdminView.class, null);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInNoRolesAccessToAnonymousViewAllowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedView.class, User.USER_NO_ROLES);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void loggedInNoRolesAccessToNoAnnotationViewDenied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationView.class, User.USER_NO_ROLES);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInNoRolesAccessToPermitAllViewAllowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.PermitAllView.class, User.USER_NO_ROLES);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void loggedInNoRolesAccessToPermitAllViewWithNonAnnotatedParentDenied() {
        NavigationContext context = AnnotatedViewAccessCheckerTest.setupNavigationContext(AccessControlTestClasses.PermitAllWithEmptyParentView.class, User.USER_NO_ROLES);
        RouteData data = new RouteData(Collections.singletonList(AccessControlTestClasses.NoPermitParent.class), "permitall", Collections.emptyMap(), AccessControlTestClasses.PermitAllWithEmptyParentView.class, Collections.emptyList());
        Router router = context.getRouter();
        RouteRegistry registry = router.getRegistry();
        Mockito.when((Object)registry.getRegisteredRoutes()).thenReturn(Collections.singletonList(data));
        AccessCheckResult result = this.viewAccessChecker.check(context);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInNoRolesAccessToDenyAllViewDenied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.DenyAllView.class, User.USER_NO_ROLES);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInNoRolesAccessToRolesAllowedUserViewDenied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.RolesAllowedUserView.class, User.USER_NO_ROLES);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInNoRolesAccessToRolesAllowedAdminViewDenied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.RolesAllowedAdminView.class, User.USER_NO_ROLES);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInUserRoleAccessToAnonymousViewAllowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedView.class, User.NORMAL_USER);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void loggedInUserRoleAccessToNoAnnotationViewDenied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationView.class, User.NORMAL_USER);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInUserRoleAccessToPermitAllViewAllowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.PermitAllView.class, User.NORMAL_USER);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void loggedInUserRoleAccessToDenyAllViewDenied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.DenyAllView.class, User.NORMAL_USER);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInUserRoleAccessToRolesAllowedUserViewAllowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.RolesAllowedUserView.class, User.NORMAL_USER);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void loggedInUserRoleAccessToRolesAllowedAdminViewDenied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.RolesAllowedAdminView.class, User.NORMAL_USER);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInAdminRoleAccessToAnonymousViewAllowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedView.class, User.ADMIN);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void loggedInAdminRoleAccessToNoAnnotationViewDenied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationView.class, User.ADMIN);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInAdminRoleAccessToPermitAllViewAllowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.PermitAllView.class, User.ADMIN);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void loggedInAdminRoleAccessToDenyAllViewDenied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.DenyAllView.class, User.ADMIN);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInAdminRoleAccessToRolesAllowedUserViewDenied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.RolesAllowedUserView.class, User.ADMIN);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInAdminRoleAccessToRolesAllowedAdminViewAllowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.RolesAllowedAdminView.class, User.ADMIN);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void openingNoAnnotationViewShowsReasonAndHint() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationView.class, User.NORMAL_USER);
        Assert.assertEquals((Object)AccessCheckResult.deny((String)"Consider adding one of the following annotations to make the view accessible: @AnonymousAllowed, @PermitAll, @RolesAllowed."), (Object)result);
    }

    @Test
    public void anonymousAccess_to_noAnnotationAnonymousAllowedByParent_allowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationAnonymousAllowedByParentView.class, null);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void anonymousAccess_to_noAnnotationAnonymousAllowedByGrandParent_allowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationAnonymousAllowedByGrandParentView.class, null);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void anonymousAccess_to_noAnnotationPermitAllByGrandParentView_denied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationPermitAllByGrandParentView.class, null);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void anonymousAccess_to_noAnnotationDenyAllByGrandParentView_denied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationDenyAllByGrandParentView.class, null);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void anonymousAccess_to_noAnnotationRolesAllowedUserByGrandParentView_denied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationRolesAllowedUserByGrandParentView.class, null);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void anonymousAccess_to_noAnnotationRolesAllowedAdminByGrandParentView_denied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationRolesAllowedAdminByGrandParentView.class, null);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInNoRolesAccess_to_noAnnotationAnonymousAllowedByGrandParentView_allowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationAnonymousAllowedByGrandParentView.class, User.USER_NO_ROLES);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void loggedInNoRolesAccess_to_noAnnotationPermitAllByGrandParentView_allowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationPermitAllByGrandParentView.class, User.USER_NO_ROLES);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void loggedInNoRolesAccess_to_noAnnotationDenyAllByGrandParentView_denied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationDenyAllByGrandParentView.class, User.USER_NO_ROLES);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInNoRolesAccess_to_noAnnotationRolesAllowedUserByGrandParentView_denied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationRolesAllowedUserByGrandParentView.class, User.USER_NO_ROLES);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInNoRolesAccess_to_noAnnotationRolesAllowedAdminByGrandParentView_denied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationRolesAllowedAdminByGrandParentView.class, User.USER_NO_ROLES);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInUserRoleAccess_to_noAnnotationAnonymousAllowedByGrandParentView_allowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationAnonymousAllowedByGrandParentView.class, User.NORMAL_USER);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void loggedInUserRoleAccess_to_noAnnotationPermitAllByGrandParentView_allowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationPermitAllByGrandParentView.class, User.NORMAL_USER);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void loggedInUserRoleAccess_to_noAnnotationDenyAllByGrandParentView_denied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationDenyAllByGrandParentView.class, User.NORMAL_USER);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInUserRoleAccess_to_noAnnotationRolesAllowedUserByGrandParentView_allowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationRolesAllowedUserByGrandParentView.class, User.NORMAL_USER);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void loggedInUserRoleAccess_to_noAnnotationRolesAllowedAdminByGrandParentView_denied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationRolesAllowedAdminByGrandParentView.class, User.NORMAL_USER);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInAdminRoleAccess_to_noAnnotationAnonymousAllowedByGrandParentView_allowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationAnonymousAllowedByGrandParentView.class, User.ADMIN);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void loggedInAdminRoleAccess_to_noAnnotationPermitAllByGrandParentView_allowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationPermitAllByGrandParentView.class, User.ADMIN);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void loggedInAdminRoleAccess_to_noAnnotationDenyAllByGrandParentView_denied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationDenyAllByGrandParentView.class, User.ADMIN);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInAdminRoleAccess_to_noAnnotationRolesAllowedUserByGrandParentView_denied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationRolesAllowedUserByGrandParentView.class, User.ADMIN);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInAdminRoleAccess_To_noAnnotationRolesAllowedAdminByGrandParentView_allowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationRolesAllowedAdminByGrandParentView.class, User.ADMIN);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void anyAccess_to_noAnnotationDenyAllAsInterfacesIgnoredView_denied() {
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)this.checkAccess(AccessControlTestClasses.NoAnnotationDenyAllAsInterfacesIgnoredView.class, null).decision());
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)this.checkAccess(AccessControlTestClasses.NoAnnotationDenyAllAsInterfacesIgnoredView.class, User.USER_NO_ROLES).decision());
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)this.checkAccess(AccessControlTestClasses.NoAnnotationDenyAllAsInterfacesIgnoredView.class, User.NORMAL_USER).decision());
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)this.checkAccess(AccessControlTestClasses.NoAnnotationDenyAllAsInterfacesIgnoredView.class, User.ADMIN).decision());
    }

    @Test
    public void anonymousAccess_to_noAnnotationPermitAllByGrandParentAsInterfacesIgnoredView_denied() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationPermitAllByGrandParentAsInterfacesIgnoredView.class, null);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void loggedInNoRolesAccess_to_noAnnotationPermitAllByGrandParentAsInterfacesIgnoredView_allowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationPermitAllByGrandParentAsInterfacesIgnoredView.class, User.USER_NO_ROLES);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void rerouteToError_defaultErrorHandler_allowed() {
        AccessCheckResult result = this.checkAccess(RouteNotFoundError.class, null);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void rerouteToError_customAnonymousErrorHandler_allowed() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.CustomErrorView.class, null);
        Assert.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
    }

    @Test
    public void rerouteToError_customNotAnnotatedErrorHandler_deny() {
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NotAnnotatedCustomErrorView.class, null);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void routeWithNoAnnotationLayout_deny() {
        NavigationContext context = AnnotatedViewAccessCheckerTest.setupNavigationContext(AccessControlTestClasses.AnonymousAllowedView.class, null);
        RouteRegistry registry = context.getRouter().getRegistry();
        Mockito.when((Object)registry.hasLayout("anon")).thenReturn((Object)true);
        Mockito.when((Object)registry.getLayout("anon")).thenAnswer(invocation -> AccessControlTestClasses.NoAuthLayout.class);
        AccessCheckResult result = this.viewAccessChecker.check(context);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    @Test
    public void routeWithNoAnnotationsAllowedLayout_allowed() {
        NavigationContext context = AnnotatedViewAccessCheckerTest.setupNavigationContext(AccessControlTestClasses.AnonymousAllowedView.class, null);
        RouteRegistry registry = context.getRouter().getRegistry();
        Mockito.when((Object)registry.hasLayout("anon")).thenReturn((Object)true);
        Mockito.when((Object)registry.getLayout("anon")).thenAnswer(invocation -> AccessControlTestClasses.AnonymousAllowedLayout.class);
        AccessCheckResult result = this.viewAccessChecker.check(context);
        Assert.assertEquals((Object)AccessCheckDecision.ALLOW, (Object)result.decision());
    }

    @Test
    public void routeWithNoAnnotationsAllowed_LayoutWithAllowed_denied() {
        NavigationContext context = AnnotatedViewAccessCheckerTest.setupNavigationContext(AccessControlTestClasses.NoAnnotationView.class, null);
        RouteRegistry registry = context.getRouter().getRegistry();
        Mockito.when((Object)registry.hasLayout("noannotation")).thenReturn((Object)true);
        Mockito.when((Object)registry.getLayout("noannotation")).thenAnswer(invocation -> AccessControlTestClasses.AnonymousAllowedLayout.class);
        AccessCheckResult result = this.viewAccessChecker.check(context);
        Assert.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
    }

    private AccessCheckResult checkAccess(Class<?> viewClass, User user) {
        NavigationContext context = AnnotatedViewAccessCheckerTest.setupNavigationContext(viewClass, user);
        return this.viewAccessChecker.check(context);
    }

    static NavigationContext setupNavigationContext(Class<?> navigationTarget, User user) {
        Principal principal;
        CurrentInstance.clearAll();
        HashSet<String> roles = new HashSet<String>();
        if (user == User.USER_NO_ROLES) {
            principal = AccessAnnotationCheckerTest.USER_PRINCIPAL;
        } else if (user == User.NORMAL_USER) {
            principal = AccessAnnotationCheckerTest.USER_PRINCIPAL;
            roles.add("user");
        } else if (user == User.ADMIN) {
            principal = AccessAnnotationCheckerTest.USER_PRINCIPAL;
            roles.add("admin");
        } else {
            principal = null;
        }
        Router router = (Router)Mockito.mock(Router.class);
        UI ui = (UI)Mockito.mock(UI.class);
        Location location = new Location(AnnotatedViewAccessCheckerTest.getRoute(navigationTarget));
        NavigationEvent navigationEvent = new NavigationEvent(router, location, ui, NavigationTrigger.ROUTER_LINK);
        BeforeEnterEvent event = new BeforeEnterEvent(navigationEvent, navigationTarget, new ArrayList());
        RouteRegistry routeRegistry = (RouteRegistry)Mockito.mock(RouteRegistry.class);
        Mockito.when((Object)router.getRegistry()).thenReturn((Object)routeRegistry);
        return new NavigationContext(event, principal, roles::contains);
    }

    static String getRoute(Class<?> navigationTarget) {
        if (navigationTarget.getAnnotation(Route.class) == null && HasErrorParameter.class.isAssignableFrom(navigationTarget)) {
            return "mock-path";
        }
        return RouteUtil.getRoutePath((VaadinContext)new MockVaadinContext(), navigationTarget);
    }

    static enum User {
        USER_NO_ROLES,
        NORMAL_USER,
        ADMIN;

    }
}

